<?php
require_once __DIR__ . '/config.php';

$unsubscribed = false;
$error = false;

if (isset($_GET['email']) && isset($_GET['token'])) {
    $email = trim($_GET['email']);
    $token = $_GET['token'];
    
    // Verify token
    $expected_token = md5($email . 'wsplcloud_secret');
    
    if ($token === $expected_token) {
        try {
            $db = get_db();
            
            $stmt = $db->prepare('UPDATE newsletter_subscribers SET status = "unsubscribed", unsubscribed_at = NOW() WHERE email = :email');
            $stmt->execute(['email' => $email]);
            
            if ($stmt->rowCount() > 0) {
                $unsubscribed = true;
            } else {
                $error = "Email not found in our system.";
            }
        } catch (Exception $e) {
            $error = "An error occurred. Please try again later.";
            error_log("Unsubscribe error: " . $e->getMessage());
        }
    } else {
        $error = "Invalid unsubscribe link.";
    }
} else {
    $error = "Missing required parameters.";
}

// Set page variables
$page_title = 'Unsubscribe - WsplCloud Newsletter';
$page_description = 'Unsubscribe from WsplCloud newsletter';
$custom_css = [];

require_once BASE_PATH . '/partial/header_meta.php';
require_once BASE_PATH . '/partial/header.php';
?>

<section class="sub-banner-main-con w-100 float-left">
    <div class="container">
        <div class="sub-banner-inner-con wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
            <h1>Newsletter</h1>
            <span class="d-block position-relative"></span>
            <h6>
                <a href="<?= url('') ?>" style="color: #fff;">Home</a>
                <span style="color: #fff;"> | </span>
                <span style="color: #fff;">Unsubscribe</span>
            </h6>
        </div>
    </div>
</section>

<section class="unsubscribe-section padding-top padding-bottom">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-6">
                <div class="unsubscribe-card">
                    <?php if ($unsubscribed): ?>
                        <div class="success-icon">
                            <i class="fas fa-check-circle"></i>
                        </div>
                        <h2>Successfully Unsubscribed</h2>
                        <p>You have been removed from our newsletter mailing list.</p>
                        <p class="text-muted">We're sorry to see you go! You will no longer receive emails from us.</p>
                        
                        <div class="feedback-section">
                            <h5>Before you go...</h5>
                            <p class="small">Help us improve by telling us why you unsubscribed:</p>
                            <form action="<?= url('feedback.php') ?>" method="POST">
                                <input type="hidden" name="type" value="unsubscribe_feedback">
                                <input type="hidden" name="email" value="<?= htmlspecialchars($email ?? '') ?>">
                                <select name="reason" class="form-select mb-3">
                                    <option value="">Select a reason...</option>
                                    <option value="too_many">Too many emails</option>
                                    <option value="not_relevant">Content not relevant</option>
                                    <option value="never_signed">I never signed up</option>
                                    <option value="spam">Emails look like spam</option>
                                    <option value="other">Other</option>
                                </select>
                                <textarea name="comments" class="form-control mb-3" rows="3" placeholder="Additional comments (optional)"></textarea>
                                <button type="submit" class="btn btn-secondary btn-sm">Submit Feedback</button>
                            </form>
                        </div>

                        <div class="mt-4">
                            <p class="small text-muted">Changed your mind?</p>
                            <a href="<?= url('blog') ?>" class="btn btn-primary">
                                <i class="fas fa-redo"></i> Resubscribe
                            </a>
                        </div>
                    <?php elseif ($error): ?>
                        <div class="error-icon">
                            <i class="fas fa-exclamation-circle"></i>
                        </div>
                        <h2>Oops!</h2>
                        <p><?= htmlspecialchars($error) ?></p>
                        <p class="text-muted">If you continue to have issues, please contact our support team.</p>
                    <?php endif; ?>

                    <div class="mt-5">
                        <a href="<?= url('') ?>" class="btn btn-outline-primary">
                            <i class="fas fa-home"></i> Back to Home
                        </a>
                        <a href="<?= url('contact') ?>" class="btn btn-outline-secondary">
                            <i class="fas fa-envelope"></i> Contact Us
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<style>
.unsubscribe-section {
    background: #f8f9fa;
    min-height: 60vh;
}

.unsubscribe-card {
    background: white;
    padding: 60px 40px;
    border-radius: 20px;
    box-shadow: 0 10px 40px rgba(0,0,0,0.1);
    text-align: center;
}

.success-icon {
    font-size: 5rem;
    color: #28a745;
    margin-bottom: 30px;
    animation: scaleIn 0.5s ease;
}

.error-icon {
    font-size: 5rem;
    color: #dc3545;
    margin-bottom: 30px;
    animation: shake 0.5s ease;
}

@keyframes scaleIn {
    from {
        transform: scale(0);
        opacity: 0;
    }
    to {
        transform: scale(1);
        opacity: 1;
    }
}

@keyframes shake {
    0%, 100% { transform: translateX(0); }
    25% { transform: translateX(-10px); }
    75% { transform: translateX(10px); }
}

.unsubscribe-card h2 {
    color: #333;
    font-size: 2rem;
    font-weight: 700;
    margin-bottom: 20px;
}

.unsubscribe-card p {
    color: #666;
    font-size: 1.1rem;
    margin-bottom: 15px;
}

.feedback-section {
    background: #f8f9fa;
    padding: 30px;
    border-radius: 15px;
    margin: 30px 0;
}

.feedback-section h5 {
    color: #0000ff;
    margin-bottom: 15px;
}

.btn {
    margin: 5px;
    padding: 12px 30px;
    font-weight: 600;
    border-radius: 25px;
}

.form-select, .form-control {
    border-radius: 10px;
}
</style>

<?php require_once BASE_PATH . '/partial/footer.php'; ?>
<?php require_once BASE_PATH . '/partial/footer_scripts.php'; ?>
