<?php
/**
 * Script to ensure the database and its schema are set up.
 */

// Include the main configuration file which contains DB logic
require_once __DIR__ . '/config.php';

echo "Attempting to ensure database schema...\n";

// Check if the function exists and call it
if (function_exists('ensure_db_schema')) {
    if (ensure_db_schema()) {
        echo "Database schema check/creation completed successfully.\n";
    } else {
        echo "Failed to ensure database schema. Please check your database connection details in config.php and ensure the MySQL server is running.\n";
    }
} else {
    echo "Error: The 'ensure_db_schema' function was not found. Please verify that config.php is correctly included and contains the function.\n";
}
?>
