<?php
/**
 * Migration: 001_initial_schema
 * Creates the initial database schema for users, blogs, offers, contacts, and hosting_plans.
 */

function up(PDO $db) {
    // users
    $db->exec("CREATE TABLE IF NOT EXISTS `users` (
        `id` INT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,
        `username` VARCHAR(191) NOT NULL UNIQUE,
        `password` VARCHAR(255) NOT NULL,
        `role` VARCHAR(50) DEFAULT 'admin',
        `created` DATETIME DEFAULT CURRENT_TIMESTAMP
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;");

    // blogs
    $db->exec("CREATE TABLE IF NOT EXISTS `blogs` (
        `id` INT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,
        `uuid` VARCHAR(50) NOT NULL DEFAULT (UUID()),
        `title` VARCHAR(255) NOT NULL,
        `content` LONGTEXT NOT NULL,
        `image` VARCHAR(255) NULL,
        `created` DATETIME DEFAULT CURRENT_TIMESTAMP,
        `status` VARCHAR(50) NOT NULL DEFAULT 'draft'
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;");

    // offers
    $db->exec("CREATE TABLE IF NOT EXISTS `offers` (
        `id` INT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,
        `title` VARCHAR(255) NULL,
        `description` TEXT NULL,
        `discount` VARCHAR(100) NULL,
        `valid_until` DATE NULL,
        `image` VARCHAR(255) NULL,
        `status` VARCHAR(50) DEFAULT 'active',
        `created` DATETIME DEFAULT CURRENT_TIMESTAMP,
        `updated` DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;");

    // contacts
    $db->exec("CREATE TABLE IF NOT EXISTS `contacts` (
        `id` INT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,
        `fname` VARCHAR(191) NULL,
        `lname` VARCHAR(191) NULL,
        `email` VARCHAR(255) NULL,
        `phone` VARCHAR(50) NULL,
        `message` TEXT NULL,
        `is_read` TINYINT(1) NOT NULL DEFAULT 0,
        `created` DATETIME DEFAULT CURRENT_TIMESTAMP
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;");

    // hosting_plans
    $db->exec("CREATE TABLE IF NOT EXISTS `hosting_plans` (
        `id` INT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,
        `plan_type` VARCHAR(50) NOT NULL,
        `plan_name` VARCHAR(100) NOT NULL,
        `slug` VARCHAR(100) NOT NULL UNIQUE,
        `description` TEXT NULL,
        `icon_image` VARCHAR(255) NULL,
        `monthly_price` DECIMAL(10,2) NOT NULL DEFAULT 0.00,
        `yearly_price` DECIMAL(10,2) NOT NULL DEFAULT 0.00,
        `storage` VARCHAR(50) NULL,
        `bandwidth` VARCHAR(50) NULL,
        `domains` VARCHAR(50) NULL,
        `databases` VARCHAR(50) NULL,
        `emails` VARCHAR(50) NULL,
        `backup` VARCHAR(50) NULL,
        `features` JSON NULL,
        `developer_features` JSON NULL,
        `technical_details` JSON NULL,
        `display_order` INT DEFAULT 0,
        `status` VARCHAR(50) DEFAULT 'active',
        `created` DATETIME DEFAULT CURRENT_TIMESTAMP,
        `updated` DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        INDEX `idx_plan_type` (`plan_type`),
        INDEX `idx_status` (`status`),
        INDEX `idx_display_order` (`display_order`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;");

    // Create migrations table
    $db->exec("CREATE TABLE IF NOT EXISTS `migrations` (
        `id` INT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,
        `migration` VARCHAR(255) NOT NULL UNIQUE,
        `batch` INT NOT NULL,
        `migrated_at` DATETIME DEFAULT CURRENT_TIMESTAMP
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;");
}

function down(PDO $db) {
    // Drop tables in reverse order of creation
    $db->exec("DROP TABLE IF EXISTS `hosting_plans`;");
    $db->exec("DROP TABLE IF EXISTS `contacts`;");
    $db->exec("DROP TABLE IF EXISTS `offers`;");
    $db->exec("DROP TABLE IF EXISTS `blogs`;");
    $db->exec("DROP TABLE IF EXISTS `users`;");
    $db->exec("DROP TABLE IF EXISTS `migrations`;");
}
