<?php
// preloader.php
?>
<style>
  /* ===== Preloader Container ===== */
  #preloader {
    position: fixed;
    top: 0; left: 0;
    width: 100%; height: 100%;
    background-color: #000FFF;
    background-image: url('<?= asset('images/bannerR-flowers-img.png') ?>'), url('<?= asset('images/footer-bg-img.png') ?>');
    background-position: center top, left bottom;
    background-repeat: no-repeat, no-repeat;
    background-size: contain, cover;
    z-index: 9999;
    display: flex;
    align-items: center;
    justify-content: center;
    overflow: hidden;
    transition: opacity 0.6s ease, visibility 0.6s ease;
  }
  #preloader.hidden {
    opacity: 0;
    visibility: hidden;
  }

  /* ===== Bubble Layer ===== */
  .bubbles {
    position: absolute;
    width: 100%; height: 100%;
    left: 0; top: 0;
    pointer-events: none;
    overflow: hidden;
  }
  .bubble {
    position: absolute;
    bottom: -50px;
    border-radius: 50%;
    background-color: rgba(255,255,255,0.7);
    animation: bubbleMove linear infinite;
    will-change: transform, opacity;
  }
  @keyframes bubbleMove {
    0%   { transform: translateY(0) translateX(0); opacity: 0.7; }
    50%  { transform: translateY(-50vh) translateX(15px); }
    100% { transform: translateY(-100vh) translateX(0); opacity: 0; }
  }

  /* ===== Center Text Content ===== */
  .center-content {
    position: relative;
    z-index: 2;
    text-align: center;
    color: #fff;
  }
  .center-content h1 {
    font-size: 2.2rem;
    margin: 0;
  }
  .center-content h6 a {
    color: #fff;
    transition: color 0.3s;
    text-decoration: none;
  }
  .center-content h6 a:hover {
    color: #FFD700;
  }
</style>

<div id="preloader">
  <div class="center-content">
    <div class="container">
      <div class="sub-banner-inner-con">
     <figure class="mb-0">
            <img src="<?= asset('images/WsplCloud.png') ?>" alt="header-logo" loading="lazy" width="250">
          </figure>
        
        <span class="d-block position-relative"></span>
   
      </div>
    </div>
  </div>
  <div class="bubbles" id="bubbles-container"></div>
</div>

<script>
  (() => {
    const bubblesContainer = document.getElementById('bubbles-container');
    const bubbleCount = 1000; // ✅ Optimized count (instead of 1000)

    for (let i = 0; i < bubbleCount; i++) {
      const bubble = document.createElement('span');
      bubble.className = 'bubble';

      // Random size
      const size = Math.random() * 14 + 8;
      bubble.style.width = `${size}px`;
      bubble.style.height = `${size}px`;

      // Random horizontal position
      bubble.style.left = `${Math.random() * 100}%`;

      // Random animation speed/delay
      bubble.style.animationDuration = `${Math.random() * 2 + 1}s`;
      bubble.style.animationDelay = `${Math.random() * 3}s`;

      bubblesContainer.appendChild(bubble);
    }

    // Hide preloader when page fully loads
    window.addEventListener("load", () => {
      const preloader = document.getElementById("preloader");
      if (preloader) {
        setTimeout(() => {
          preloader.classList.add("hidden");
        }, 800); // smooth fade-out delay
      }
    });
  })();
</script>
