   <!-- FOOTER SECTION START -->
<footer class="footer-main-con custom-footer w-100 float-left py-5 text-light">
  <div class="container">

    <!-- Top Section: CTA -->
   <div class="row align-items-center mb-5">
    <!-- Right: CTA -->
    <div class="col-lg-12 col-md-12 text-center">
        <!-- Headline -->
        <h2 class="mb-2 text-white">
         Ride the Hosting Wave with WsplCloud
        </h2>
        <!-- SEO-friendly Subtext -->
       <p class="mb-3 text-white-50">
      From ambitious startups to thriving global enterprises, WsplCloud delivers lightning-fast, secure, and reliable cloud hosting that powers your website 24/7. Enjoy 99.9% uptime, seamless scalability, and expert support whenever you need it — your success is our mission.
    </p>
        <!-- CTA Button -->
        <a href="<?= url('contact') ?>" 
           class="btn" 
           style="background-color: #FFD200; color: #000; border: none; padding: 10px 20px; text-decoration: none; transition: all 0.3s;" 
           onmouseover="this.style.backgroundColor='black'; this.style.color='white';" 
           onmouseout="this.style.backgroundColor='#FFD200'; this.style.color='black';"
        >
            Ride the Hosting Wave <i class="fas fa-arrow-right"></i>
        </a>
    </div>
</div>


    <!-- Bottom Section: 4s Columns -->
    <div class="row mt-4">

        <!-- Column 1: Logo + Company Intro -->
        <div class="col-lg-3 col-md-6 mb-4 text-center">
          <div class="footer-logo mb-3">
            <img src="<?= asset('images/WsplCloud.png') ?>" alt="WsplCloud Logo" style="max-width:200px;">
          </div>
          <p class="small">
            WsplCloud is a trusted web solutions provider in India, delivering innovative hosting and development
             services with a customer-first approach.
          </p>
          <ul class="list-unstyled d-flex mt-3 justify-content-center" style="gap: 5px;">
            <li>
              <a href="https://www.facebook.com/wsploffi" target="_blank"
                 style="display:inline-flex; align-items:center; justify-content:center; width:35px; height:35px; border-radius:50%; border:2px solid #FFD200; color:#FFD200; text-decoration:none; transition:all 0.3s;"
                 onmouseover="this.style.backgroundColor='#FFD200'; this.style.color='black';"
                 onmouseout="this.style.backgroundColor='transparent'; this.style.color='#FFD200';">
                <i class="fab fa-facebook-f"></i>
              </a>
            </li>
            <li>
              <a href="https://www.instagram.com/wsploffi?igsh=MTQ4dGtrczZtM2dpeg==" target="_blank"
                 style="display:inline-flex; align-items:center; justify-content:center; width:35px; height:35px; border-radius:50%; border:2px solid #FFD200; color:#FFD200; text-decoration:none; transition:all 0.3s;"
                 onmouseover="this.style.backgroundColor='#FFD200'; this.style.color='black';"
                 onmouseout="this.style.backgroundColor='transparent'; this.style.color='#FFD200';">
                 <i class="fab fa-instagram"></i>
              </a>
            </li>
            <li>
              <a href="https://www.linkedin.com/company/wsploffi/" target="_blank"
                 style="display:inline-flex; align-items:center; justify-content:center; width:35px; height:35px; border-radius:50%; border:2px solid #FFD200; color:#FFD200; text-decoration:none; transition:all 0.3s;"
                 onmouseover="this.style.backgroundColor='#FFD200'; this.style.color='black';"
                 onmouseout="this.style.backgroundColor='transparent'; this.style.color='#FFD200';">
                <i class="fab fa-linkedin-in"></i>
              </a>
            </li>
          </ul>
        </div>

        <!-- Column 2 -->
        <div class="col-lg-3 col-md-6 mb-4 text-center">
          <h6 class="mb-3 footer-heading">Our Services</h6>
          <ul class="list-unstyled footer-links">
            <li><a href="<?= url('shared-hosting') ?>">Shared Hosting</a></li>
            <li><a href="<?= url('reseller') ?>">Reseller Hosting</a></li>
            <li><a href="<?= url('vps') ?>">VPS</a></li>
            <li><a href="<?= url('cloud-hosting') ?>">Cloud Hosting</a></li>
            <li><a href="<?= url('domain') ?>">Domain Registration</a></li>
          </ul>
        </div>

        <!-- Column 3 -->
        <div class="col-lg-3 col-md-6 mb-4 text-center">
          <h6 class="mb-3 footer-heading">Community</h6>
          <ul class="list-unstyled footer-links">
            <li><a href="<?= url('about') ?>">Knowledge Base</a></li>
            <li><a href="<?= url('Policy') ?>">Privacy Policy</a></li>
            <li><a href="<?= url('term') ?>">Terms of Service</a></li>
            <li><a href="<?= url('blog') ?>">News</a></li>
          </ul>
        </div>

        <!-- Column 4 -->
        <div class="col-lg-3 col-md-6 mb-4 text-center">
          <h6 class="mb-3 footer-heading">Mailing Address</h6>
          <ul class="list-unstyled footer-contact">
            <li>
              <a href="https://maps.app.goo.gl/C288MmZTQDghyudZ7" target="_blank">
                <i class="fas fa-map-marker-alt"></i> 107/2, Sankari Main Road, Seetharampalayam Post, Tiruchengode – 637211
              </a>
            </li>
            <li><a href="tel:+917339202005"><i class="fas fa-phone-alt"></i> +91 733 920 2005</a></li>
            <li><a href="mailto:info@wsplcloud.com"><i class="fas fa-envelope"></i> info@wsplcloud.com</a></li>
          </ul>
        </div>

      </div>   <!-- Copyright -->
    <div class="row mt-4">
      <div class="col-12 text-center">
        <p class="mb-0 small">Copyright © 2025 WsplCloud. All Rights Reserved. WsplCloud is a subsidiary of Wspl Hosting Solution OPC Private Limited.</p>
      </div>
    </div>

  </div>
</footer>
<!-- FOOTER SECTION END -->

<!-- WHATSAPP CHAT WIDGET -->
<div class="whatsapp-widget" id="whatsappWidget">
    <!-- WhatsApp Button -->
    <div class="whatsapp-btn" id="whatsappBtn">
        <div class="whatsapp-icon">
            <svg width="24" height="24" viewBox="0 0 24 24" fill="none">
                <path d="M17.472 14.382c-.297-.149-1.758-.867-2.03-.967-.273-.099-.471-.148-.67.15-.197.297-.767.966-.94 1.164-.173.199-.347.223-.644.075-.297-.15-1.255-.463-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.298-.347.446-.52.149-.174.198-.298.298-.497.099-.198.05-.371-.025-.52-.075-.149-.669-1.612-.916-2.207-.242-.579-.487-.5-.669-.51-.173-.008-.371-.01-.57-.01-.198 0-.52.074-.792.372-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.625.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.694.248-1.289.173-1.413-.074-.124-.272-.198-.57-.347m-5.421 7.403h-.004a9.87 9.87 0 01-5.031-1.378l-.361-.214-3.741.982.998-3.648-.235-.374a9.86 9.86 0 01-1.51-5.26c.001-5.45 4.436-9.884 9.888-9.884 2.64 0 5.122 1.03 6.988 2.898a9.825 9.825 0 012.893 6.994c-.003 5.45-4.437 9.884-9.885 9.884m8.413-18.297A11.815 11.815 0 0012.05 0C5.495 0 .16 5.335.157 11.892c0 2.096.547 4.142 1.588 5.945L.057 24l6.305-1.654a11.882 11.882 0 005.683 1.448h.005c6.554 0 11.89-5.335 11.893-11.893c0-3.189-1.248-6.189-3.515-8.452" fill="currentColor"/>
            </svg>
        </div>
        <span class="whatsapp-pulse"></span>
    </div>

    <!-- Chat Box -->
    <div class="whatsapp-chat-box" id="whatsappChatBox">
        <!-- Chat Header -->
        <div class="chat-header">
            <div class="chat-avatar">
                <img src="<?= asset('images/whatsapp-avatar.png') ?>" alt="WsplCloud Support" onerror="this.src='data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDAiIGhlaWdodD0iNDAiIHZpZXdCb3g9IjAgMCA0MCA0MCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPGNpcmNsZSBjeD0iMjAiIGN5PSIyMCIgcj0iMjAiIGZpbGw9IiMyNUM2NDYiLz4KPHBhdGggZD0iTTI4LjI1IDE2LjVWMjUuMjVDMjguMjUgMjUuNjY0MiAyOC4wODU4IDI2LjA0OTIgMjcuNzk1NSAyNi4zMzk1QzI3LjUwNTIgMjYuNjI5OCAyNy4xMjAyIDI2Ljc5NDEgMjYuNzUgMjYuNzk0MUgxMy4yNUMyMi44NTc5IDI2Ljc5NDEgMTMuMTY0MiAyNi42Mjk4IDEyLjg3MzkgMjYuMzM5NUMyMi41ODA1IDI2LjA0OTIgMTIuNzUgMjUuNjY0MiAxMi43NSAyNS4yNVYxNi41QzEyLjc1IDE2LjEwNzggMTIuOTE0MiAxNS43MjI4IDEzLjIwNDUgMTUuNDMyNUMxMy40OTQ4IDE1LjE0MjIgMTMuODc5OCAxNC45NzggMTQuMjUgMTQuOTc4SDI1Ljc1QzI2LjE0MjIgMTQuOTc4IDI2LjUyNzIgMTUuMTQyMiAyNi44MTc1IDE1LjQzMjVDMjcuMTA3OCAxNS43MjI4IDI3LjI3MiAxNi4xMDc4IDI3LjI3MiAxNi41SDI4LjI1WiIgZmlsbD0id2hpdGUiLz4KPC9zdmc+Cg=='">
            </div>
            <div class="chat-info">
                <h4>WsplCloud Support</h4>
                <p>Typically replies within 30 minutes</p>
            </div>
            <button class="close-chat" id="closeChat">
                <svg width="16" height="16" viewBox="0 0 16 16" fill="currentColor">
                    <path d="M13.707 2.293a1 1 0 010 1.414L9.414 8l4.293 4.293a1 1 0 01-1.414 1.414L8 9.414l-4.293 4.293a1 1 0 01-1.414-1.414L6.586 8 2.293 3.707a1 1 0 011.414-1.414L8 6.586l4.293-4.293a1 1 0 011.414 0z"/>
                </svg>
            </button>
        </div>

        <!-- Chat Messages -->
        <div class="chat-messages">
            <div class="message received">
                <div class="message-content">
                    <p>Hello! 👋</p>
                    <p>Welcome to WsplCloud! How can we help you today?</p>
                </div>
                <span class="message-time">10:30 AM</span>
            </div>
            
            <div class="message received">
                <div class="message-content">
                    <p>We're here to assist you with:</p>
                    <ul>
                        <li>🌐 Web Hosting Plans</li>
                        <li>☁️ Cloud Services</li>
                        <li>🔧 Technical Support</li>
                        <li>💳 Billing Questions</li>
                    </ul>
                </div>
                <span class="message-time">10:31 AM</span>
            </div>
        </div>

        <!-- Chat Input -->
        <div class="chat-input">
            <div class="input-group">
                <input type="text" id="whatsappMessage" placeholder="Type your message here..." aria-label="Type your message">
                <button type="button" id="sendWhatsApp" aria-label="Send message">
                    <svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                        <path d="M2.01 21L23 12 2.01 3 2 10l15 2-15 2z"/>
                    </svg>
                </button>
            </div>
            <p class="chat-note">Click send to open WhatsApp with your message</p>
        </div>
    </div>
</div>

<!-- Custom Footer Style -->
<style>
  .custom-footer {
    background-color: #000FFF !important;
  }
  .custom-footer .footer-heading {
    color: #FFD200 !important;
  }
  .custom-footer .footer-links a,
  .custom-footer .footer-contact a {
    color: #fff;
    text-decoration: none;
  }
  .custom-footer .footer-links a:hover,
  .custom-footer .footer-contact a:hover {
    color: #FFD200;
  }

  /* WhatsApp Widget Styles */
  .whatsapp-widget {
      position: fixed;
      bottom: 100px;
      right: 30px;
      z-index: 10000;
      font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
  }

  /* WhatsApp Button */
  .whatsapp-btn {
      position: relative;
      width: 50px;
      height: 50px;
      background: linear-gradient(135deg, #25D366, #128C7E);
      border-radius: 50%;
      display: flex;
      align-items: center;
      justify-content: center;
      cursor: pointer;
      box-shadow: 0 4px 20px rgba(37, 211, 102, 0.4);
      transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
      animation: float 3s ease-in-out infinite;
  }

  .whatsapp-btn:hover {
      transform: scale(1.1);
      box-shadow: 0 6px 25px rgba(37, 211, 102, 0.6);
  }

  .whatsapp-icon {
      color: white;
      width: 28px;
      height: 28px;
  }

  .whatsapp-pulse {
      position: absolute;
      width: 100%;
      height: 100%;
      background: #25D366;
      border-radius: 50%;
      opacity: 0.6;
      animation: pulse 2s infinite;
  }

  /* Chat Box */
  .whatsapp-chat-box {
      position: absolute;
      bottom: 80px;
      right: 0;
      width: 350px;
      height: 450px;
      background: white;
      border-radius: 16px;
      box-shadow: 0 10px 40px rgba(0, 0, 0, 0.15);
      display: none;
      flex-direction: column;
      overflow: hidden;
      transform: translateY(20px);
      opacity: 0;
      transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
  }

  .whatsapp-chat-box.active {
      display: flex;
      transform: translateY(0);
      opacity: 1;
  }

  /* Chat Header */
  .chat-header {
      background: linear-gradient(135deg, #25D366, #128C7E);
      padding: 16px;
      display: flex;
      align-items: center;
      color: white;
      position: relative;
  }

  .chat-avatar {
      width: 40px;
      height: 40px;
      border-radius: 50%;
      overflow: hidden;
      margin-right: 12px;
      border: 2px solid rgba(255, 255, 255, 0.3);
  }

  .chat-avatar img {
      width: 100%;
      height: 100%;
      object-fit: cover;
  }

  .chat-info h4 {
      margin: 0;
      font-size: 16px;
      font-weight: 600;
      color: white;
  }

  .chat-info p {
      margin: 2px 0 0 0;
      font-size: 12px;
      opacity: 0.9;
      color: white;
  }

  .close-chat {
      position: absolute;
      top: 16px;
      right: 16px;
      background: none;
      border: none;
      color: white;
      cursor: pointer;
      opacity: 0.8;
      transition: opacity 0.2s;
      padding: 4px;
      border-radius: 4px;
  }

  .close-chat:hover {
      opacity: 1;
      background: rgba(255, 255, 255, 0.1);
  }

  /* Chat Messages */
  .chat-messages {
      flex: 1;
      padding: 16px;
      overflow-y: auto;
      background: #f0f0f0;
  }

  .message {
      margin-bottom: 16px;
      max-width: 85%;
  }

  .message.received {
      align-self: flex-start;
  }
  
  .message.sent {
      align-self: flex-end;
      text-align: right;
  }

  .message-content {
      background: white;
      padding: 12px 16px;
      border-radius: 16px 16px 16px 4px;
      box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
  }

  .message.received .message-content {
      background: white;
  }
  
  .message.sent .message-content {
      background: linear-gradient(135deg, #25D366, #128C7E);
      color: white;
      border-radius: 16px 16px 4px 16px;
  }
  
  .message.sent .message-content p {
      color: white;
  }
  
  .message.sent .message-time {
      text-align: right;
      color: #666;
  }

  .message-content p {
      margin: 0 0 8px 0;
      font-size: 14px;
      line-height: 1.4;
      color: #333;
  }

  .message-content p:last-child {
      margin-bottom: 0;
  }

  .message-content ul {
      margin: 8px 0;
      padding-left: 16px;
  }

  .message-content li {
      font-size: 13px;
      margin-bottom: 4px;
      color: #333;
  }

  .message-time {
      display: block;
      font-size: 11px;
      color: #666;
      margin-top: 4px;
      text-align: right;
  }

  /* Chat Input */
  .chat-input {
      padding: 16px;
      background: white;
      border-top: 1px solid #e0e0e0;
  }

  .input-group {
      display: flex;
      gap: 8px;
      margin-bottom: 8px;
  }

  #whatsappMessage {
      flex: 1;
      padding: 12px 16px;
      border: 1px solid #e0e0e0;
      border-radius: 24px;
      font-size: 14px;
      outline: none;
      transition: border-color 0.2s;
  }

  #whatsappMessage:focus {
      border-color: #25D366;
  }

  #sendWhatsApp {
      background: #25D366;
      color: white;
      border: none;
      border-radius: 50%;
      width: 44px;
      height: 44px;
      cursor: pointer;
      display: flex;
      align-items: center;
      justify-content: center;
      transition: all 0.2s;
  }

  #sendWhatsApp:hover {
      background: #128C7E;
      transform: scale(1.05);
  }

  .chat-note {
      font-size: 11px;
      color: #666;
      text-align: center;
      margin: 0;
  }

  /* Animations */
  @keyframes float {
      0%, 100% { transform: translateY(0); }
      50% { transform: translateY(-5px); }
  }

  @keyframes pulse {
      0% {
          transform: scale(1);
          opacity: 0.6;
      }
      70% {
          transform: scale(1.5);
          opacity: 0;
      }
      100% {
          transform: scale(1.5);
          opacity: 0;
      }
  }

  /* Responsive Design */
  @media (max-width: 768px) {
      .whatsapp-widget {
          bottom: 90px;
          right: 20px;
      }

      .whatsapp-btn {
          width: 56px;
          height: 56px;
      }

      .whatsapp-chat-box {
          width: 320px;
          height: 420px;
          right: -10px;
      }

      .whatsapp-icon {
          width: 24px;
          height: 24px;
      }
  }

  @media (max-width: 480px) {
      .whatsapp-widget {
          bottom: 85px;
          right: 15px;
      }

      .whatsapp-btn {
          width: 52px;
          height: 52px;
      }

      .whatsapp-chat-box {
          width: 300px;
          height: 400px;
          right: -20px;
      }
  }

  /* Scrollbar Styling */
  .chat-messages::-webkit-scrollbar {
      width: 4px;
  }

  .chat-messages::-webkit-scrollbar-track {
      background: #f1f1f1;
  }

  .chat-messages::-webkit-scrollbar-thumb {
      background: #c1c1c1;
      border-radius: 2px;
  }

  .chat-messages::-webkit-scrollbar-thumb:hover {
      background: #a8a8a8;
  }
</style>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const whatsappBtn = document.getElementById('whatsappBtn');
        const whatsappChatBox = document.getElementById('whatsappChatBox');
        const closeChat = document.getElementById('closeChat');
        const sendWhatsApp = document.getElementById('sendWhatsApp');
        const whatsappMessage = document.getElementById('whatsappMessage');

        // Toggle chat box
        whatsappBtn.addEventListener('click', function(e) {
            e.stopPropagation();
            whatsappChatBox.classList.toggle('active');
        });

        // Close chat box
        closeChat.addEventListener('click', function(e) {
            e.stopPropagation();
            whatsappChatBox.classList.remove('active');
        });

        // Close chat when clicking outside
        document.addEventListener('click', function(e) {
            if (!whatsappChatBox.contains(e.target) && !whatsappBtn.contains(e.target)) {
                whatsappChatBox.classList.remove('active');
            }
        });

        // Function to add user message to chat
        function addUserMessage(message) {
            const messagesContainer = document.querySelector('.chat-messages');
            const currentTime = new Date().toLocaleTimeString([], {hour: '2-digit', minute:'2-digit'});
            
            const userMessageHtml = `
                <div class="message sent">
                    <div class="message-content user-message">
                        <p>${message}</p>
                    </div>
                    <span class="message-time">${currentTime}</span>
                </div>
            `;
            
            messagesContainer.insertAdjacentHTML('beforeend', userMessageHtml);
            messagesContainer.scrollTop = messagesContainer.scrollHeight;
        }
        
        // Function to add bot reply
        function addBotReply() {
            const messagesContainer = document.querySelector('.chat-messages');
            const currentTime = new Date().toLocaleTimeString([], {hour: '2-digit', minute:'2-digit'});
            
            const botReplyHtml = `
                <div class="message received">
                    <div class="message-content">
                        <p>Thank you for your message! 🙏</p>
                        <p>We're redirecting you to WhatsApp where our support team will assist you shortly. Please wait a moment...</p>
                    </div>
                    <span class="message-time">${currentTime}</span>
                </div>
            `;
            
            messagesContainer.insertAdjacentHTML('beforeend', botReplyHtml);
            messagesContainer.scrollTop = messagesContainer.scrollHeight;
        }

        // Send message to WhatsApp
        function sendToWhatsApp() {
            const message = whatsappMessage.value.trim();
            const phoneNumber = '917339202005'; // Your WhatsApp number
            
            try {
                if (message) {
                    // Add user message to chat first
                    addUserMessage(message);
                    
                    // Clear input immediately
                    whatsappMessage.value = '';
                    
                    // Add bot reply after a short delay
                    setTimeout(() => {
                        addBotReply();
                    }, 800);
                    
                    // Open WhatsApp after showing the reply
                    setTimeout(() => {
                        const encodedMessage = encodeURIComponent(message);
                        const whatsappUrl = `https://wa.me/${phoneNumber}?text=${encodedMessage}`;
                        
                        // Try to open WhatsApp
                        const opened = window.open(whatsappUrl, '_blank');
                        
                        // If popup was blocked, try direct navigation
                        if (!opened || opened.closed || typeof opened.closed == 'undefined') {
                            window.location.href = whatsappUrl;
                        }
                    }, 1500);
                    
                    // Close chat after everything is done
                    setTimeout(() => {
                        whatsappChatBox.classList.remove('active');
                    }, 2500);
                } else {
                    // If no message, show default reply and open WhatsApp
                    addBotReply();
                    
                    setTimeout(() => {
                        const whatsappUrl = `https://wa.me/${phoneNumber}`;
                        
                        const opened = window.open(whatsappUrl, '_blank');
                        
                        // If popup was blocked, try direct navigation
                        if (!opened || opened.closed || typeof opened.closed == 'undefined') {
                            window.location.href = whatsappUrl;
                        }
                    }, 1000);
                    
                    // Close chat after delay
                    setTimeout(() => {
                        whatsappChatBox.classList.remove('active');
                    }, 2000);
                }
            } catch (error) {
                console.error('Error opening WhatsApp:', error);
                // Show error message to user
                const messagesContainer = document.querySelector('.chat-messages');
                const currentTime = new Date().toLocaleTimeString([], {hour: '2-digit', minute:'2-digit'});
                
                const errorMessageHtml = `
                    <div class="message received">
                        <div class="message-content">
                            <p>We're having trouble opening WhatsApp automatically. Please click the link below:</p>
                            <a href="https://wa.me/917339202005${message ? '?text=' + encodeURIComponent(message) : ''}" target="_blank" style="color: #25D366; font-weight: bold;">Open WhatsApp</a>
                        </div>
                        <span class="message-time">${currentTime}</span>
                    </div>
                `;
                
                messagesContainer.insertAdjacentHTML('beforeend', errorMessageHtml);
                messagesContainer.scrollTop = messagesContainer.scrollHeight;
            }
        }

        // Send button click
        sendWhatsApp.addEventListener('click', function(e) {
            e.preventDefault();
            
            // Visual feedback
            sendWhatsApp.style.transform = 'scale(0.95)';
            sendWhatsApp.innerHTML = '<svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor"><circle cx="12" cy="12" r="3"><animate attributeName="r" values="3;5;3" dur="0.5s" repeatCount="1"/></circle></svg>';
            
            // Execute send function
            sendToWhatsApp();
            
            // Reset button after delay
            setTimeout(() => {
                sendWhatsApp.style.transform = 'scale(1)';
                sendWhatsApp.innerHTML = '<svg width="20" height="20" viewBox="0 0 24 24" fill="currentColor"><path d="M2.01 21L23 12 2.01 3 2 10l15 2-15 2z"/></svg>';
            }, 1000);
        });

        // Enter key to send
        whatsappMessage.addEventListener('keypress', function(e) {
            if (e.key === 'Enter') {
                e.preventDefault();
                sendToWhatsApp();
            }
        });

        // Prevent chat box from closing when clicking inside
        whatsappChatBox.addEventListener('click', function(e) {
            e.stopPropagation();
        });
    });
</script>

<!-- Scroll-to-top Button -->
<button id="scrollToTopBtn" aria-label="Scroll to top">
        <i class="fas fa-arrow-up"></i>
</button>

<style>
    /* Scroll-to-top button styled to match footer WhatsApp: yellow circular */
    #scrollToTopBtn {
        position: fixed;
        bottom: 30px;
        right: 30px;
        width: 50px;
        height: 50px;
        background: #FFD200;
        color: #000;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        cursor: pointer;
        box-shadow: 0 6px 25px rgba(0,0,0,0.12);
        border: none;
        z-index: 10001;
        transition: transform 0.18s ease, box-shadow 0.18s ease, opacity 0.2s ease;
        opacity: 0;
        pointer-events: none;
    }

    #scrollToTopBtn.show {
        opacity: 1;
        pointer-events: auto;
    }

    #scrollToTopBtn:hover {
        transform: translateY(-4px) scale(1.03);
        box-shadow: 0 8px 30px rgba(0,0,0,0.18);
    }

    #scrollToTopBtn i {
        font-size: 18px;
    }

    @media (max-width: 768px) {
        /* place the scroll-to-top below the WhatsApp widget on mobile */
        /* WhatsApp sits around bottom:90px; put scroll button closer to bottom edge */
        #scrollToTopBtn { bottom: 20px; right: 30px; width:56px; height:56px; }
    }

    @media (max-width: 480px) {
        /* slightly smaller and lower on very small screens */
        #scrollToTopBtn { bottom: 16px; right: 20px; width:52px; height:52px; }
    }
</style>

<script>
    (function(){
        const btn = document.getElementById('scrollToTopBtn');
        if(!btn) return;

        // Show after scrolling down 300px
        const showAfter = 300;
        let ticking = false;

        function onScroll(){
            if (!ticking) {
                window.requestAnimationFrame(function() {
                    if(window.scrollY > showAfter){
                        btn.classList.add('show');
                    } else {
                        btn.classList.remove('show');
                    }
                    ticking = false;
                });
                ticking = true;
            }
        }

        // Smooth scroll to top
        function scrollToTop(){
            window.scrollTo({ top: 0, behavior: 'smooth' });
            btn.blur();
        }

        // Attach events
        window.addEventListener('scroll', onScroll, { passive: true });
        btn.addEventListener('click', scrollToTop);

        // Keyboard accessibility: Enter/Space
        btn.addEventListener('keydown', function(e){
            if(e.key === 'Enter' || e.key === ' '){
                e.preventDefault();
                scrollToTop();
            }
        });

        // Initialize visibility
        onScroll();
    })();
</script>
