<?php 
require_once __DIR__ . '/../config.php';

// Fetch VPS hosting plans from database
$db = get_db();
$stmt = $db->prepare("SELECT * FROM hosting_plans WHERE plan_type = 'vps' AND status = 'active' ORDER BY display_order ASC");
$stmt->execute();
$vps_plans = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Set page-specific variables
$page_title = 'VPS Hosting | WsplCloud - Web Hosting & Cloud Services';
$page_description = 'Virtual Private Server hosting with dedicated resources, complete control, and high performance for growing businesses.';
$page_keywords = 'vps hosting, virtual private server, dedicated resources, root access, scalable vps';

// Add page-specific CSS if needed
$custom_css = ['priceslider.css'];

// Include header meta (DOCTYPE, <head>, opening <body> tag)
require_once BASE_PATH . '/partial/header_meta.php';

// Include the navigation header
require_once BASE_PATH . '/partial/header.php';
?>
    <link rel="stylesheet" href="<?= asset('css/custom.css') ?>">
    <link rel="stylesheet" href="<?= asset('css/mobile.css') ?>">
  <style>
    @media only screen and (max-width: 767px) {
    .banner-main-con,
    .sub-banner-main-con,
    .hosting-pages-sub-banner,
    .banner-main-con .sub-banner-inner-con,
    .sub-banner-main-con .container {
        padding-top: 100px !important;
        padding-bottom: 100px !important;
        max-height: 400px !important;
        display: flex !important;
        align-items: center !important;
        justify-content: center !important;
        text-align: center !important;
    }
    /* Ensure headings remain readable and centered */
    .banner-main-con h1,
    .sub-banner-main-con h1,
    .hosting-pages-sub-banner h1 {
        font-size: 28px !important;
        line-height: 1.15 !important;
        margin: 0 auto !important;
        max-width: 92% !important;
    }
}
  .shared-hosting-intro {
        background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
        position: relative;
        overflow: hidden;
    }
    
    .shared-hosting-intro::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: url('data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100" width="100" height="100" opacity="0.05"><defs><pattern id="grid" width="10" height="10" patternUnits="userSpaceOnUse"><path d="M 10 0 L 0 0 0 10" fill="none" stroke="%23000fff" stroke-width="0.5"/></pattern></defs><rect width="100" height="100" fill="url(%23grid)"/></svg>');
        z-index: 0;
    }
    
    .intro-content-con {
        position: relative;
        z-index: 1;
    }
    
    .intro-text-con h3 {
        color: #000fff;
        font-size: 2rem;
        margin-bottom: 1.5rem;
        font-weight: 700;
    }
    
    .intro-text-con p {
        font-size: 1.1rem;
        line-height: 1.7;
        margin-bottom: 2rem;
        color: #555;
    }
    
    .intro-features-list {
        margin-bottom: 2.5rem;
    }
    
    .intro-features-list li {
        padding: 0.5rem 0;
        font-size: 1.05rem;
        color: #444;
    }
    
    .intro-features-list i {
        color: #000fff;
        margin-right: 10px;
        font-size: 1.2rem;
    }
    
    .intro-stats-con {
        display: flex;
        justify-content: space-between;
        margin-top: 2rem;
        flex-wrap: wrap;
    }
    
    .stat-box {
        text-align: center;
        padding: 1rem;
        background: white;
        border-radius: 10px;
        box-shadow: 0 5px 15px rgba(0, 15, 255, 0.1);
        flex: 1;
        margin: 0 10px;
        min-width: 100px;
    }
    
    .stat-box h4 {
        color: #000fff;
        font-size: 2rem;
        margin-bottom: 0.5rem;
        font-weight: 700;
    }
    
    .stat-box span {
        font-size: 0.9rem;
        color: #666;
    }
    .gif-caption {
        margin-top: 1rem;
        font-style: italic;
        color: #666;
        font-size: 0.9rem;
    }
    
    /* Who Should Use Section */
    .who-should-use-con {
        margin-top: 4rem;
        padding-top: 3rem;
        border-top: 1px solid #ddd;
    }
    
    .user-type-box {
        text-align: center;
        padding: 2rem 1.5rem;
        background: white;
        border-radius: 10px;
        box-shadow: 0 5px 15px rgba(0, 15, 255, 0.1);
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        height: 100%;
    }
    
    .user-type-box:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 25px rgba(0, 15, 255, 0.15);
    }
    
    .user-icon {
        width: 80px;
        height: 80px;
        background: linear-gradient(135deg, #000fff, #4d5dfb);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        margin: 0 auto 1.5rem;
    }
    
    .user-icon i {
        font-size: 2rem;
        color: white;
    }
    
    .user-type-box h4 {
        color: #000fff;
        margin-bottom: 1rem;
        font-weight: 600;
    }
    
    .user-type-box p {
        color: #666;
        line-height: 1.6;
    }
    
       
    
    
    /* Responsive Styles */
    @media (max-width: 991px) {
        .intro-stats-con {
            justify-content: center;
        }
        
        .stat-box {
            margin: 10px;
            flex: 0 0 calc(50% - 20px);
        }
        
        .user-type-box {
            margin-bottom: 2rem;
        }
    }
    
    @media (max-width: 767px) {
        .intro-text-con h3 {
            font-size: 1.7rem;
        }
        
        .stat-box {
            flex: 0 0 100%;
            margin: 5px 0;
        }
        
        .intro-gif-con {
            margin-top: 2rem;
        }
    }
    .plan-icon{
        width: 38px;
        height: 38px;
    }

    /* Plan features list styling */
    .hosting-type-content-con ul {
        margin-top: 8px;
    }

    .hosting-type-content-con ul li {
        padding: 8px 0;
        font-size: 1.05rem;
        color: #444;
        display: flex;
        align-items: center;
    }

    .hosting-type-content-con ul li i {
        color: #000fff;
        margin-right: 10px;
        font-size: 0.9rem;
        width: 18px;
        text-align: center;
    }

    .hosting-type-content-con ul li span { color: inherit; }

    /* Plan features list styling to match other pages */
    .plan-features { margin-top: 12px; }
    .plan-features li { padding: 10px 0; color: #444; font-size: 1.05rem; }
    .plan-features li i { color: #000fff; margin-right: 10px; }

    /* view-more button removed - extra feature items are visible by default */

    /* Styles for the single 'View More Features' control */
    #view-more-features {
        display: inline-block;
        min-width: 160px;
        padding: 10px 18px;
        background: #000fff; /* site blue */
        color: #ffffff;
        border: none;
        border-radius: 6px;
        font-weight: 700;
        font-size: 0.95rem;
        line-height: 1;
        cursor: pointer;
        box-shadow: 0 6px 18px rgba(0,0,0,0.08);
        transition: background 160ms ease, transform 120ms ease, box-shadow 120ms ease;
        text-decoration: none;
        margin-top: 52px;
    }
    #view-more-features:hover { background: #0056d6; transform: translateY(-1px); }
    #view-more-features:active { transform: translateY(0); }
    #view-more-features[aria-expanded="true"] { background: #003d9a; }
    #view-more-features:focus {
        outline: 3px solid rgba(0,95,255,0.18);
        outline-offset: 2px;
    }
    @media (max-width: 576px) {
        #view-more-features { width: 100%; box-sizing: border-box; }
    }

  </style>
    <!-- HEADER SECTION END HERE -->
    <!-- BANNER SECTION START HERE -->
    <section class="hosting-pages-sub-banner sub-banner-main-con w-100 float-left">
        <div class="container">
            <div class="sub-banner-inner-con wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
                <h1>Choose Your VPS Plan</h1>
                    <span class="d-block position-relative"></span>
            <h6>
                <a href="<?= url('') ?>" style="color: #fff; transition: color 0.2s;" onmouseover="this.style.color='#FFD700'" onmouseout="this.style.color='#fff'">Home</a>
               <span style="color: #fff;"> | </span>
              
                <a href="<?= url('pages/vps') ?>" style="color: #fff; transition: color 0.2s;" onmouseover="this.style.color='#FFD700'" onmouseout="this.style.color='#fff'">VPS</a>
            </h6>
               
            </div>
        </div>
    </section>
    <!-- BANNER SECTION END HERE -->
<section class="vps-intro w-100 float-left padding-top padding-bottom">
    <div class="container">
        <div class="generic-title text-center wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
            <h2>What is VPS Hosting?</h2>
            <p>Private-like performance with cloud flexibility — ideal for apps, growing sites, and technical users.</p>
        </div>
        
        <div class="intro-content-con wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.5s">
            <div class="row align-items-center">
                <div class="col-lg-6 col-md-6">
                    <div class="intro-text-con">
                        <h3>Powerful, Scalable Virtual Servers</h3>
                        <p>VPS (Virtual Private Server) gives you dedicated CPU, RAM and storage slices on a virtualized host — offering predictable performance, root access, and the ability to scale as your project grows.</p>
                        
                        <ul class="list-unstyled intro-features-list">
                            <li><i class="fas fa-microchip"></i> Dedicated CPU & RAM</li>
                            <li><i class="fas fa-memory"></i> SSD / NVMe Storage for fast I/O</li>
                            <li><i class="fas fa-server"></i> Full root/administrator access</li>
                            <li><i class="fas fa-sync-alt"></i> Easy vertical scaling</li>
                            <li><i class="fas fa-shield-alt"></i> Optional managed security & backups</li>
                            <li><i class="fas fa-headset"></i> 24/7 technical support</li>
                        </ul>
                        
                        <div class="intro-stats-con">
                            <div class="stat-box">
                                <h5 style="color:#0000ff;">Dedicated</h5>
                                <span>Resources per VPS</span>
                            </div>
                            <div class="stat-box">
                                <h4>Root</h4>
                                <span>Full Server Control</span>
                            </div>
                            <div class="stat-box">
                                <h4>Scale</h4>
                                <span>Grow On-Demand</span>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="col-lg-6 col-md-6">
                    <div class="intro-gif-con text-center">
                        <!-- Animated GIF showing VPS concept -->
                        <img src="<?= asset('images/vps.jpg') ?>" alt="VPS Hosting Animation" class="intro-gif" style="max-width: 100%; height: auto; border-radius: 12px;">
                        
                        <!-- Fallback static image if GIF doesn't load -->
                        <noscript>
                            <img src="<?= asset('images/vps-static.png') ?>" alt="VPS Diagram" class="intro-static-img">
                        </noscript>
                        
                        <div class="gif-caption">
                            <p>Virtualized servers delivering dedicated performance and cloud availability</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Who Should Use VPS Section -->
        <div class="who-should-use-con wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.7s">
            <div class="row">
                <div class="col-lg-4 col-md-4">
                    <div class="user-type-box">
                        <div class="user-icon">
                            <i class="fas fa-code"></i>
                        </div>
                        <h4>Developers</h4>
                        <p>Run custom stacks, Docker, CI/CD pipelines, and development tools with full server control.</p>
                    </div>
                </div>
                
                <div class="col-lg-4 col-md-4">
                    <div class="user-type-box">
                        <div class="user-icon">
                            <i class="fas fa-building"></i>
                        </div>
                        <h4>Growing Businesses</h4>
                        <p>Reliable performance and scalability for business sites, ecommerce stores, and SaaS apps.</p>
                    </div>
                </div>
                
                <div class="col-lg-4 col-md-4">
                    <div class="user-type-box">
                        <div class="user-icon">
                            <i class="fas fa-users-cog"></i>
                        </div>
                        <h4>Agencies & Teams</h4>
                        <p>Isolated environments to host client projects, staging servers, and production workloads securely.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
    <!-- VPS PLANS SECTION START HERE -->
    <style>
        /* VPS Plans Scrolling Layout */
        .vps-plans-row-section {
            padding: 15vh 0;
            position: relative;
       
            background-size: cover;
            background-position: center;
            background-attachment: fixed;
            background-repeat: no-repeat;
        }
        
        .vps-plans-row-section::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: 
                radial-gradient(circle at 20% 80%, rgba(0, 123, 255, 0.1) 0%, transparent 50%),
                radial-gradient(circle at 80% 20%, rgba(255, 193, 7, 0.1) 0%, transparent 50%),
                radial-gradient(circle at 40% 40%, rgba(0, 123, 255, 0.08) 0%, transparent 50%);
            pointer-events: none;
            z-index: 0;
        }
        
        .vps-plans-three-column {
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 2rem;
            max-width: 1100px;
            margin: 0 auto;
            padding: 0 20px;
            position: relative;
            z-index: 1;
        }
        
        .vps-plan-banner {
            position: sticky;
            top: 10vh;
            width: 100%;
            max-width: 1000px;
            min-height: 500px;
            border-radius: 25px;
            padding: 40px 50px;
            background: rgba(255, 255, 255, 0.98);
            backdrop-filter: blur(25px);
            box-shadow: 
                0 30px 60px rgba(0, 0, 0, 0.25),
                0 0 0 1px rgba(255, 255, 255, 0.3) inset,
                0 1px 0 rgba(255, 255, 255, 0.4) inset;
            transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
            border: 1px solid rgba(255, 255, 255, 0.4);
            overflow: hidden;
            display: flex;
            align-items: center;
            position: relative;
            z-index: 2;
        }
        
        .vps-plan-banner::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 5px;
            border-radius: 25px 25px 0 0;
            z-index: 1;
        }
        
        .vps-plan-banner.vps-spark::before {
            background: linear-gradient(90deg, #007bff, #0056b3, #004085);
            box-shadow: 0 2px 10px rgba(0, 123, 255, 0.3);
        }
        
        .vps-plan-banner.vps-blaze::before {
            background: linear-gradient(90deg, #ffc107, #ff8c00, #ff6b00);
            box-shadow: 0 2px 10px rgba(255, 193, 7, 0.3);
        }
        
        .vps-plan-banner.vps-inferno::before {
            background: linear-gradient(90deg, #007bff, #0056b3, #004085);
            box-shadow: 0 2px 10px rgba(0, 123, 255, 0.3);
        }
        
        .vps-plan-banner:hover {
            transform: translateY(-8px) scale(1.02);
            box-shadow: 
                0 35px 70px rgba(0, 0, 0, 0.2),
                0 0 0 1px rgba(255, 255, 255, 0.3) inset;
        }
        
        .vps-plan-banner.featured {
            border-color: #007bff;
            box-shadow: 0 8px 25px rgba(0, 123, 255, 0.15);
        }
        
        .vps-plan-banner.featured::before {
            background: #007bff;
        }
        
        .vps-plan-banner .banner-content-wrapper {
            display: grid;
            grid-template-columns: 1fr 2fr 1fr;
            gap: 40px;
            width: 100%;
            align-items: center;
        }

        .plan-banner-header {
            text-align: center;
            margin-bottom: 0;
            position: relative;
            z-index: 2;
        }
        
        .plan-banner-title {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 15px;
            margin-bottom: 20px;
            padding: 15px 20px;
            border-radius: 15px;
            transition: all 0.3s ease;
            position: relative;
            backdrop-filter: blur(10px);
        }
        
        .vps-plan-banner.vps-spark .plan-banner-title {
            background: linear-gradient(135deg, rgba(0, 123, 255, 0.1), rgba(0, 86, 179, 0.05));
            border: 1px solid rgba(0, 123, 255, 0.2);
        }
        
        .vps-plan-banner.vps-blaze .plan-banner-title {
            background: linear-gradient(135deg, rgba(255, 193, 7, 0.1), rgba(255, 140, 0, 0.05));
            border: 1px solid rgba(255, 193, 7, 0.2);
        }
        
        .vps-plan-banner.vps-inferno .plan-banner-title {
            background: linear-gradient(135deg, rgba(0, 123, 255, 0.1), rgba(0, 86, 179, 0.05));
            border: 1px solid rgba(0, 123, 255, 0.2);
        }
        
        .plan-banner-title:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
        }
        
        .plan-icon {
            width: 45px;
            height: 45px;
            object-fit: contain;
            filter: drop-shadow(0 3px 6px rgba(0, 0, 0, 0.15));
            transition: all 0.3s ease;
            border-radius: 8px;
            padding: 2px;
        }
        
        .plan-banner-title:hover .plan-icon {
            transform: scale(1.1) rotate(5deg);
            filter: drop-shadow(0 4px 8px rgba(0, 0, 0, 0.2));
        }
        
        .plan-banner-name {
            font-size: 28px;
            font-weight: 800;
            color: #2c3e50;
            margin-bottom: 0;
            text-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }
        
        .plan-banner-price {
            font-size: 40px;
            font-weight: 900;
            margin-bottom: 8px;
            text-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }
        
        .vps-plan-banner.vps-spark .plan-banner-price {
            color: #007bff;
        }
        
        .vps-plan-banner.vps-blaze .plan-banner-price {
            color: #ffc107;
        }
        
        .vps-plan-banner.vps-inferno .plan-banner-price {
            color: #007bff;
        }
        
        .plan-banner-price .currency {
            font-size: 24px;
            vertical-align: top;
        }
        
        .plan-banner-period {
            color: #6c757d;
            font-size: 16px;
            font-weight: 500;
        }
        
        .plan-banner-features {
            list-style: none;
            padding: 0;
            margin: 0;
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 20px;
        }
        
        .plan-banner-features li {
            background: rgba(248, 249, 250, 0.8);
            border-radius: 12px;
            padding: 15px;
            text-align: center;
            border: 1px solid rgba(0, 0, 0, 0.05);
            transition: all 0.3s ease;
            backdrop-filter: blur(10px);
        }
        
        .plan-banner-features li:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
            background: rgba(255, 255, 255, 0.9);
        }
        
        .feature-banner-label {
            font-weight: 500;
            color: #6c757d;
            font-size: 12px;
            display: block;
            margin-bottom: 5px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .feature-banner-value {
            font-weight: 700;
            color: #2c3e50;
            font-size: 16px;
            display: block;
        }
        
        .plan-banner-right-section {
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 20px;
        }

        .plan-banner-pricing-options {
            margin: 0;
            background: rgba(248, 249, 250, 0.8);
            border-radius: 15px;
            padding: 20px;
            border: 1px solid rgba(0, 0, 0, 0.1);
            backdrop-filter: blur(10px);
            width: 100%;
        }
        
        .pricing-option-banner {
            display: flex;
            justify-content: space-between;
            padding: 5px 0;
            font-size: 13px;
        }
        
        .pricing-option-banner .duration {
            color: #6c757d;
        }
        
        .pricing-option-banner .price {
            font-weight: 600;
            color: #2c3e50;
        }
        
        .plan-banner-cta {
            width: 100%;
            padding: 18px 30px;
            border: none;
            border-radius: 50px;
            font-size: 18px;
            font-weight: 700;
            cursor: pointer;
            transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
            text-transform: uppercase;
            letter-spacing: 1px;
            position: relative;
            overflow: hidden;
            margin-top: 0;
        }
        
        .vps-plan-banner.vps-spark .plan-banner-cta {
            background: linear-gradient(45deg, #007bff, #0056b3);
            color: white;
            box-shadow: 0 8px 25px rgba(0, 123, 255, 0.3);
        }
        
        .vps-plan-banner.vps-blaze .plan-banner-cta {
            background: linear-gradient(45deg, #ffc107, #ff8c00);
            color: #000;
            box-shadow: 0 8px 25px rgba(255, 193, 7, 0.3);
        }
        
        .vps-plan-banner.vps-inferno .plan-banner-cta {
            background: linear-gradient(45deg, #007bff, #0056b3);
            color: white;
            box-shadow: 0 8px 25px rgba(0, 123, 255, 0.3);
        }
        
        .plan-banner-cta:hover {
            transform: translateY(-3px) scale(1.02);
            filter: brightness(1.1);
        }
        
        .vps-plan-banner.vps-spark .plan-banner-cta:hover {
            box-shadow: 0 15px 35px rgba(0, 123, 255, 0.4);
        }
        
        .vps-plan-banner.vps-blaze .plan-banner-cta:hover {
            box-shadow: 0 15px 35px rgba(255, 193, 7, 0.4);
        }
        
        .vps-plan-banner.vps-inferno .plan-banner-cta:hover {
            box-shadow: 0 15px 35px rgba(0, 123, 255, 0.4);
        }
        
        .vps-plan-banner.vps-blaze .plan-banner-name {
            color: #ffc107;
        }
        
        .vps-plan-banner.vps-blaze .plan-banner-cta {
            background: #ffc107;
            color: #212529;
        }
        
        .vps-plan-banner.vps-blaze .plan-banner-cta:hover {
            background: #e0a800;
        }
        
        .vps-plan-banner.vps-inferno .plan-banner-price {
            color: #0000ff;
        }
        
        .vps-plan-banner.vps-inferno .plan-banner-cta {
            background: #0000ff;
        }
        
        .vps-plan-banner.vps-inferno .plan-banner-cta:hover {
            background: #0000ff;
        }
        
        @media (max-width: 1024px) {
            .vps-plan-banner .banner-content-wrapper {
                grid-template-columns: 1fr;
                gap: 30px;
                text-align: center;
            }
            
            .plan-banner-features {
                grid-template-columns: repeat(2, 1fr);
                gap: 15px;
            }
        }

        @media (max-width: 768px) {
            .vps-plans-row-section {
                padding: 10vh 0;
            }
            
            .vps-plans-three-column {
                max-width: 95%;
                gap: 1rem;
                padding: 0 15px;
            }
            
            .vps-plan-banner {
                padding: 25px 20px;
                max-width: 100%;
                min-height: 280px;
                position: relative;
                top: 0;
            }
            
            .vps-plan-banner .banner-content-wrapper {
                grid-template-columns: 1fr;
                gap: 20px;
            }
            
            .plan-banner-features {
                grid-template-columns: repeat(2, 1fr);
                gap: 10px;
            }
            
            .plan-banner-features li {
                padding: 12px;
            }
            
            .plan-banner-name {
                font-size: 22px;
                margin-bottom: 10px;
            }
            
            .plan-banner-price {
                font-size: 28px;
                margin-bottom: 15px;
            }
            
            .plan-banner-period {
                font-size: 14px;
            }
            
            .plan-banner-title {
                gap: 8px;
                margin-bottom: 10px;
            }
            
            .plan-icon {
                width: 32px;
                height: 32px;
            }
            
            /* Hide pricing options in mobile */
            .plan-banner-pricing-options {
                display: none;
            }
            
            .plan-banner-cta {
                padding: 12px 20px;
                font-size: 14px;
                margin-top: 10px;
            }
        }
    </style>

    <section class="vps-plans-row-section">
        <div class="container">
            
            <div class="vps-plans-three-column wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.5s">
                <?php if (!empty($vps_plans)): ?>
                    <?php 
                    $plan_classes = ['vps-spark', 'vps-blaze', 'vps-inferno', 'vps-ultra'];
                    foreach ($vps_plans as $index => $plan): 
                        $technical_details = json_decode($plan['technical_details'], true) ?? [];
                        $plan_class = $plan_classes[$index % 4];
                        
                        // Calculate pricing for different durations
                        $monthly = floatval($plan['monthly_price']);
                        $yearly = floatval($plan['yearly_price']);
                        $price_6m = $monthly * 6;
                        $price_24m = $yearly * 2;
                        $price_36m = $yearly * 3;
                    ?>
                    <div class="vps-plan-banner <?= htmlspecialchars($plan_class) ?>">
                        <div class="banner-content-wrapper">
                            <div class="plan-banner-header">
                                <div class="plan-banner-title">
                                    <img src="<?= asset($plan['icon_image']) ?>" alt="<?= htmlspecialchars($plan['plan_name']) ?> Icon" class="plan-icon">
                                    <h3 class="plan-banner-name"><?= htmlspecialchars($plan['plan_name']) ?></h3>
                                </div>
                                <div class="plan-banner-price">
                                    <span class="currency">₹</span><?= number_format($monthly, 0) ?>
                                </div>
                                <div class="plan-banner-period">/month</div>
                            </div>
                            
                            <ul class="plan-banner-features">
                                <?php foreach ($technical_details as $detail): ?>
                                    <?php if ($detail['available']): ?>
                                        <li>
                                            <span class="feature-banner-label"><?= htmlspecialchars($detail['name']) ?></span>
                                            <span class="feature-banner-value"><?= htmlspecialchars($detail['value']) ?></span>
                                        </li>
                                    <?php endif; ?>
                                <?php endforeach; ?>
                            </ul>
                            
                            <div class="plan-banner-right-section">
                                <div class="plan-banner-pricing-options">
                                    <div class="pricing-option-banner">
                                        <span class="duration">1 Month</span>
                                        <span class="price">₹<?= number_format($monthly, 2) ?></span>
                                    </div>
                                    <div class="pricing-option-banner">
                                        <span class="duration">6 Months</span>
                                        <span class="price">₹<?= number_format($price_6m, 2) ?></span>
                                    </div>
                                    <div class="pricing-option-banner">
                                        <span class="duration">12 Months</span>
                                        <span class="price">₹<?= number_format($yearly, 2) ?></span>
                                    </div>
                                    <div class="pricing-option-banner">
                                        <span class="duration">24 Months</span>
                                        <span class="price">₹<?= number_format($price_24m, 2) ?></span>
                                    </div>
                                    <div class="pricing-option-banner">
                                        <span class="duration">36 Months</span>
                                        <span class="price">₹<?= number_format($price_36m, 2) ?></span>
                                    </div>
                                </div>
                                
                                <button class="plan-banner-cta">Get Started</button>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <div class="col-12 text-center">
                        <p class="lead">No VPS hosting plans available at the moment. Please check back soon!</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </section>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // VPS Plans Banner Functionality
            const bannerCtaButtons = document.querySelectorAll('.plan-banner-cta');
            
            // Enhanced CTA button interactions for banner plans
            bannerCtaButtons.forEach(button => {
                button.addEventListener('click', function(e) {
                    const planCard = this.closest('.vps-plan-banner');
                    const planName = planCard.querySelector('.plan-banner-name').textContent;
                    
                    // Create ripple effect
                    const ripple = document.createElement('span');
                    const rect = this.getBoundingClientRect();
                    const size = Math.max(rect.width, rect.height);
                    const x = e.clientX - rect.left - size / 2;
                    const y = e.clientY - rect.top - size / 2;
                    
                    ripple.style.cssText = `
                        position: absolute;
                        width: ${size}px;
                        height: ${size}px;
                        left: ${x}px;
                        top: ${y}px;
                        background: rgba(255, 255, 255, 0.4);
                        border-radius: 50%;
                        transform: scale(0);
                        animation: bannerRipple 0.6s ease-out;
                        pointer-events: none;
                    `;
                    
                    this.style.position = 'relative';
                    this.appendChild(ripple);
                    
                    setTimeout(() => {
                        ripple.remove();
                    }, 600);
                    
                    // Show notification
                    showBannerNotification(`Thank you for choosing ${planName}! Our team will contact you shortly.`);
                });
                
                // Add hover effects
                button.addEventListener('mouseenter', function() {
                    this.style.transform = 'translateY(-1px) scale(1.02)';
                });
                
                button.addEventListener('mouseleave', function() {
                    this.style.transform = 'translateY(0) scale(1)';
                });
            });
            
            // Notification system for banner plans
            function showBannerNotification(message) {
                const notification = document.createElement('div');
                notification.style.cssText = `
                    position: fixed;
                    top: 20px;
                    right: 20px;
                    background: linear-gradient(135deg, #007bff, #0056b3);
                    color: white;
                    padding: 15px 20px;
                    border-radius: 10px;
                    box-shadow: 0 10px 25px rgba(0, 123, 255, 0.3);
                    z-index: 10000;
                    transform: translateX(400px);
                    transition: all 0.3s ease;
                    max-width: 300px;
                    font-weight: 500;
                `;
                notification.textContent = message;
                document.body.appendChild(notification);
                
                setTimeout(() => {
                    notification.style.transform = 'translateX(0)';
                }, 100);
                
                setTimeout(() => {
                    notification.style.transform = 'translateX(400px)';
                    setTimeout(() => {
                        notification.remove();
                    }, 300);
                }, 4000);
            }
        });
        
        // CSS for banner ripple animation
        if (!document.getElementById('banner-ripple-styles')) {
            const bannerStyle = document.createElement('style');
            bannerStyle.id = 'banner-ripple-styles';
            bannerStyle.textContent = `
                @keyframes bannerRipple {
                    0% {
                        transform: scale(0);
                        opacity: 1;
                    }
                    100% {
                        transform: scale(2);
                        opacity: 0;
                    }
                }
            `;
            document.head.appendChild(bannerStyle);
        }
    </script>
    <!-- VPS PLANS SECTION END HERE -->
    
    <!-- DEDICATED FEATURES SECTION START HERE -->
    <section class="dedicated-features-con w-100 float-left p-100">
        <div class="container">
            <div class="generic-title text-center wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
                <h2>VPS Hosting Features</h2>
                <p>Intrinsicly actualize out-of-the-box niche markets for backward-compatible web services.</p>
            </div>
            <div class="dedicated-features-inner-con wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
                <div class="dedicated-features-box">
                    <figure>
                        <img src="<?= asset('images/reason-img1.png') ?>" alt="reason-img1">
                    </figure>
                    <h5> Optimized<br>Performance</h5>
                    <p>Get blazing-fast speed and seamless responsiveness with VPS hosting optimized for peak performance. Powered by SSD storage, advanced caching, and robust infrastructure — your site loads instantly, every time.</p>
                </div>
                <div class="dedicated-features-box">
                    <figure>
                        <img src="<?= asset('images/reason-img4.png') ?>" alt="reason-img2">
                    </figure>
                    <h5>SSD/NVMe<br>Storage</h5>
                    <p>Storage of SSD/NVMe delivers ultra-fast read/write speeds for blazing performance and quicker data access. Boost website load times, handle high-traffic demands, and ensure smoother server operations effortlessly.
</p>
                </div>
                <div class="dedicated-features-box">
                    <figure>
                        <img src="<?= asset('images/reason-img3.png') ?>" alt="reason-img3">
                    </figure>
                    <h5>Enhanced<br>Protection</h5>
                    <p>Build your VPS on a foundation of advanced security with real-time threat monitoring, firewalls, and DDoS protection. Safeguard your data, applications, and users with enterprise-grade defense — 24/7.
</p>
                </div>
                <div class="dedicated-features-box">
                    <figure>
                        <img src="<?= asset('images/reason-img2.png') ?>" alt="reason-img4">
                    </figure>
                    <h5>Flexible <br> Panel Choices</h5>
                    <p>Choose from powerful control panels like cPanel, Plesk, or DirectAdmin to manage your VPS with ease. Enjoy intuitive dashboards, one-click installations, and full server control — no technical expertise required.</p>
                </div>
            </div>
        </div>
    </section>
    
    <!-- DEDICATED FEATURES SECTION END HERE -->
    <!-- SECURITY FEATURES SECTION START HERE -->
    <section class="vps-management-main-con w-100 float-left padding-top padding-bottom bg-shape">
        <div class="container">
            <div class="generic-title text-center wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
                <h2>Choose Your VPS plan</h2>
            </div>
            <div class="vps-management-inner-con wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
                <div class="security-feature-video-outer-con">
                    <div class="security-feature-video-con">
                        <h5>Cyclone VPS</h5>
                        <p class="mb-0">Boost your business with lightning-fast VPS.</p>
                    </div>
                    <div class="dedicated-security-features-list">
                        <ul class="list-unstyled">
                            <li>Cyclone VPS - 4 CPU Core</li>
                            <li>Memory space - 32 GB</li>
                            <li>No downtime needed for scaling</li>
                            <li>Alerts for unusual activities</li>
                        </ul>
                        <div class="generic-btn">
                            <a href="vps.php">GET VPS <i class="fas fa-arrow-right"></i></a>
                        </div>
                    </div>
                    <div class="security-shape3">
                        <figure class="mb-0">
                            <img src="<?= asset('images/security-feature-shape3.png') ?>" alt="security-feature-shape3">
                        </figure>
                    </div>
                </div>
                <div class="security-feature-video-outer-con">
                    <div class="security-feature-video-con">
                        <h5>Tsunami VPS</h5>
                        <p class="mb-0">Optimized for speed, built for success.</p>
                    </div>
                    <div class="dedicated-security-features-list">
                        <ul class="list-unstyled">
                            <li>Tsunami VPS - 8 CPU Core</li>
                            <li>Memory space - 64 GB</li>
                            <li>24/7 Live Technical Support</li>
                            <li>Managed Server Security</li>
                        </ul>
                        <div class="generic-btn">
                            <a href="vps.php">GET VPS <i class="fas fa-arrow-right"></i></a>
                        </div>
                    </div>
                    <div class="security-shape2">
                        <figure class="mb-0">
                            <img src="<?= asset('images/security-feature-shape2.png') ?>" alt="security-feature-shape2">
                        </figure>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- SECURITY FEATURES SECTION END HERE -->
    <!-- FAQ SECTION START HERE -->
    <section class="faq-main-con w-100 float-left padding-bottom pt-100">
        <div class="container">
            <div class="generic-title text-center wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
                <h2>Frequently Asked Questions</h2>
                <p>Do you have any questions? We have your answers!</p>
            </div>
            <div class="faq-inner-con wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
                <div id="accordion1">
                    <div class="card">
                        <div class="card-header" id="headingOne">
                            <h5 class="mb-0">
                                <button class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapseOne" aria-expanded="false" aria-controls="collapseOne">
                                What is a VPS hosting?
                                </button>
                            </h5>
                        </div>
                        <div id="collapseOne" class="collapse" aria-labelledby="headingOne" data-parent="#accordion1">
                            <div class="card-body">VPS (Virtual Private Server) hosting is a type of web hosting that provides you with a dedicated portion of server resources within a larger physical server. Unlike shared hosting, where multiple websites share the same resources, VPS hosting gives you isolated resources, including CPU, RAM, and storage, for better performance and stability.</div>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-header" id="headingTwo">
                            <h5 class="mb-0">
                                <button class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                    What are the advantages of VPS hosting ?
                                </button>
                            </h5>
                        </div>
                        <div id="collapseTwo" class="collapse" aria-labelledby="headingTwo" data-parent="#accordion1">
                            <div class="card-body">
VPS hosting offers dedicated resources, full control over server settings, and root access for custom configurations. It’s more flexible and powerful than shared hosting, allowing you to run advanced applications and software. This makes it ideal for growing websites, developers, or businesses needing more control and scalability.
</div>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-header" id="headingThree">
                            <h5 class="mb-0">
                                <button class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                                   Who should use VPS hosting?
                                </button>
                            </h5>
                        </div>
                        <div id="collapseThree" class="collapse" aria-labelledby="headingThree" data-parent="#accordion1">
                            <div class="card-body">VPS hosting is ideal for people who need more power, control, and flexibility than shared hosting can offer. Here’s who should use it:
VPS is perfect for tech-savvy users, growing businesses, or anyone needing more control and performance than shared hosting

</div>
                        </div>
                    </div>
                </div>
                <div id="accordion2">
                    <div class="card">
                        <div class="card-header" id="headingfour">
                            <h5 class="mb-0">
                                <button class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapsefour" aria-expanded="false" aria-controls="collapsefour">
                                   What is Cloud VPS hosting?
                                </button>
                            </h5>
                        </div>
                        <div id="collapsefour" class="collapse" aria-labelledby="headingfour" data-parent="#accordion2">
                            <div class="card-body">Cloud VPS Hosting is a type of Virtual Private Server hosting that runs on a cloud infrastructure rather than a single physical server.
It's like traditional VPS hosting, but instead of being hosted on one physical machine, your VPS runs on a network (cluster) of servers—also called the cloud.
</div>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-header" id="headingfive">
                            <h5 class="mb-0">
                                <button class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapsefive" aria-expanded="false" aria-controls="collapsefive">
                                    How does Cloud VPS hosting work?
                                </button>
                            </h5>
                        </div>
                        <div id="collapsefive" class="collapse" aria-labelledby="headingfive" data-parent="#accordion2">
                            <div class="card-body">Cloud VPS hosting uses virtualization + cloud computing to create fast, scalable, and reliable virtual servers. <br>
In simple words: <br>
 Cloud VPS = VPS + Cloud Power = Faster, safer, and more flexible than regular VPS.
</div>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-header" id="headingsix">
                            <h5 class="mb-0">
                                <button class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapsesix" aria-expanded="false" aria-controls="collapsesix">
                                   How much does VPS hosting cost?
                                </button>
                            </h5>
                        </div>
                        <div id="collapsesix" class="collapse" aria-labelledby="headingsix" data-parent="#accordion2">
                            <div class="card-body">Managed vs Unmanaged VPS (managed is more expensive) <br>

Linux or Windows OS <br>

Additional features like backups, control panels, or extra security</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- FAQ SECTION END HERE -->
    <!-- FOOTER SECTION START HERE -->
<?php require_once BASE_PATH . '/partial/footer.php'; ?>
<!-- Back-to-top removed -->
    <!-- FOOTER SECTION END HERE -->
     
    <!-- GSAP Scrolling Animation Scripts -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.5/gsap.min.js" integrity="sha512-7eHRwcbYkK4d9g/6tD/mhkf++eoTHwpNM9woBxtPUBWm67zeAfFC+HrdoE2GanKeocly/VxeLvIqwvCdk7qScg==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.5/ScrollTrigger.min.js" integrity="sha512-onMTRKJBKz8M1TnqqDuGBlowlH0ohFzMXYRNebz+yOcc5TQr/zAKsthzhuv0hiyUKEiQEQXEynnXCvNTOk50dg==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>

    <script>
        gsap.registerPlugin(ScrollTrigger);

        // VPS Plans Scrolling Animation
        gsap.to(".vps-plan-banner.vps-spark", {
            scale: 0.7,
            opacity: 0,
            scrollTrigger: {
                trigger: ".vps-plan-banner.vps-spark",
                start: "top 15%",
                end: "bottom 15%",
                scrub: true
            }
        })

        gsap.to(".vps-plan-banner.vps-blaze", {
            scale: 0.7,
            opacity: 0,
            scrollTrigger: {
                trigger: ".vps-plan-banner.vps-blaze",
                start: "top 15%",
                end: "bottom 15%",
                scrub: true
            }
        })

        gsap.to(".vps-plan-banner.vps-inferno", {
            scale: 0.7,
            opacity: 0,
            scrollTrigger: {
                trigger: ".vps-plan-banner.vps-inferno",
                start: "top 15%",
                end: "bottom 15%",
                scrub: true
            }
        })

        // Entrance animation for the plans
        gsap.from([".vps-plan-banner.vps-spark", ".vps-plan-banner.vps-blaze", ".vps-plan-banner.vps-inferno"], {
            y: 100,
            opacity: 0,
            scale: 0.8,
            duration: 1.2,
            ease: "back.out(1.7)",
            stagger: 0.3,
            scrollTrigger: {
                trigger: ".vps-plans-three-column",
                start: "top 80%",
                toggleActions: "play none none reverse"
            }
        })
    </script>

    <!-- js start -->
<!-- Include footer -->
<?php require_once BASE_PATH . '/partial/footer.php'; ?>

<!-- Include footer scripts -->
<?php 
// Add page-specific scripts if needed
$page_scripts = ['jquery.min.js', 'jquery-ui.js', 'vps_slider.js'];
require_once BASE_PATH . '/partial/footer_scripts.php'; 
?>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const planTabs = document.querySelectorAll('.plan-tab');
        const planDetails = document.querySelectorAll('.plan-details');
        
        // Initialize first plan as active
        activatePlan('spark');
        
        // Add click event listeners to tabs
        planTabs.forEach(tab => {
            tab.addEventListener('click', function() {
                const planType = this.getAttribute('data-plan');
                activatePlan(planType);
            });
            
            // Add keyboard support
            tab.addEventListener('keydown', function(e) {
                if (e.key === 'Enter' || e.key === ' ') {
                    e.preventDefault();
                    const planType = this.getAttribute('data-plan');
                    activatePlan(planType);
                }
            });
        });
        
        function activatePlan(planType) {
            // Remove active class from all tabs and details
            planTabs.forEach(tab => {
                tab.classList.remove('active');
                tab.setAttribute('aria-selected', 'false');
            });
            planDetails.forEach(detail => {
                detail.classList.remove('active');
                detail.setAttribute('aria-hidden', 'true');
            });
            
            // Add active class to selected tab and detail
            const activeTab = document.querySelector(`.plan-tab[data-plan="${planType}"]`);
            const activeDetail = document.querySelector(`.plan-details[data-plan="${planType}"]`);
            
            if (activeTab && activeDetail) {
                activeTab.classList.add('active');
                activeTab.setAttribute('aria-selected', 'true');
                activeTab.focus();
                
                // Add slight delay for smooth animation
                setTimeout(() => {
                    activeDetail.classList.add('active');
                    activeDetail.setAttribute('aria-hidden', 'false');
                }, 50);
            }
        }
        
        // Touch swipe support for mobile
        let touchStartX = 0;
        let touchEndX = 0;
        const planTypes = ['spark', 'blaze', 'inferno'];
        
        const planContainer = document.querySelector('.plan-details-container');
        if (planContainer) {
            planContainer.addEventListener('touchstart', e => {
                touchStartX = e.changedTouches[0].screenX;
            }, { passive: true });
            
            planContainer.addEventListener('touchend', e => {
                touchEndX = e.changedTouches[0].screenX;
                handleSwipe();
            }, { passive: true });
        }
        
        function handleSwipe() {
            const swipeThreshold = 50;
            const diff = touchStartX - touchEndX;
            
            if (Math.abs(diff) > swipeThreshold) {
                const currentPlan = document.querySelector('.plan-tab.active')?.getAttribute('data-plan');
                const currentIndex = planTypes.indexOf(currentPlan);
                
                if (diff > 0 && currentIndex < planTypes.length - 1) {
                    // Swipe left - next plan
                    activatePlan(planTypes[currentIndex + 1]);
                } else if (diff < 0 && currentIndex > 0) {
                    // Swipe right - previous plan
                    activatePlan(planTypes[currentIndex - 1]);
                }
            }
        }
    });
</script>