<?php 
require_once __DIR__ . '/../config.php';

// Fetch Reseller hosting plans from database
$db = get_db();
$stmt = $db->prepare("SELECT * FROM hosting_plans WHERE plan_type = 'reseller' AND status = 'active' ORDER BY display_order ASC");
$stmt->execute();
$reseller_plans = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Set page-specific variables
$page_title = 'Reseller Hosting | WsplCloud - Web Hosting & Cloud Services';
$page_description = 'Start your own web hosting business with our reseller hosting packages. White-label solutions with billing integration and support.';
$page_keywords = 'reseller hosting, web hosting business, white-label hosting, hosting reseller plans, start hosting business';
$custom_css = ['priceslider.css']; // Add pricing specific CSS

// Include header meta (DOCTYPE, <head>, opening <body> tag)
require_once BASE_PATH . '/partial/header_meta.php';
?>
    <!-- Additional CSS files if needed -->
    <link rel="stylesheet" href="<?= asset('css/custom.css') ?>">
    <link rel="stylesheet" href="<?= asset('css/mobile.css') ?>">
      <style>
        /* Toggle Switch Styles */
        .billing-toggle-container {
            display: flex;
            justify-content: center;
            align-items: center;
            margin-bottom: 40px;
        }
        
        .billing-toggle {
            display: flex;
            align-items: center;
            background-color: #f5f5f5;
            border-radius: 30px;
            padding: 5px;
            margin:40px;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        }
        
        .billing-option {
            padding: 10px 20px;
            cursor: pointer;
            border-radius: 25px;
            transition: all 0.3s ease;
            font-weight: 600;
        }
        
        .billing-option.active {
            background-color: #000fff;
            color: white;
        }
        
        .yearly-saving {
            color: #28a745;
            font-size: 14px;
            margin-left: 10px;
            font-weight: 600;
        }
        
        .plan-price {
            transition: all 0.3s ease;
            font-weight: 600;
        }
        .plan-icon{
            height: 38px;
            width: 38px;
        }
      
    </style>

<style>  .shared-hosting-intro {
        background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
        position: relative;
        overflow: hidden;
    }
    
    .shared-hosting-intro::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: #fff;
        z-index: 0;
    }
    
    .intro-content-con {
        position: relative;
        z-index: 1;
    }
    
    .intro-text-con h3 {
        color: #000fff;
        font-size: 2rem;
        margin-bottom: 1.5rem;
        font-weight: 700;
    }
    
    .intro-text-con p {
        font-size: 1.1rem;
        line-height: 1.7;
        margin-bottom: 2rem;
        color: #555;
    }
    
    .intro-features-list {
        margin-bottom: 2.5rem;
    }
    
    .intro-features-list li {
        padding: 0.5rem 0;
        font-size: 1.05rem;
        color: #444;
    }
    
    .intro-features-list i {
        color: #000fff;
        margin-right: 10px;
        font-size: 1.2rem;
    }
    
    .intro-stats-con {
        display: flex;
        justify-content: space-between;
        margin-top: 2rem;
        flex-wrap: wrap;
    }
    
    .stat-box {
        text-align: center;
        padding: 1rem;
        background: white;
        border-radius: 10px;
        box-shadow: 0 5px 15px rgba(0, 15, 255, 0.1);
        flex: 1;
        margin: 0 10px;
        min-width: 100px;
    }
    
    .stat-box h4 {
        color: #000fff;
        font-size: 2rem;
        margin-bottom: 0.5rem;
        font-weight: 700;
    }
    
    .stat-box span {
        font-size: 0.9rem;
        color: #666;
    }
    .gif-caption {
        margin-top: 1rem;
        font-style: italic;
        color: #666;
        font-size: 0.9rem;
    }
    
    /* Who Should Use Section */
    .who-should-use-con {
        margin-top: 4rem;
        padding-top: 3rem;
        border-top: 1px solid #ddd;
    }
    
    .user-type-box {
        text-align: center;
        padding: 2rem 1.5rem;
        background: white;
        border-radius: 10px;
        box-shadow: 0 5px 15px rgba(0, 15, 255, 0.1);
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        height: 100%;
    }
    
    .user-type-box:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 25px rgba(0, 15, 255, 0.15);
    }
    
    .user-icon {
        width: 80px;
        height: 80px;
        background: linear-gradient(135deg, #000fff, #4d5dfb);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        margin: 0 auto 1.5rem;
    }
    
    .user-icon i {
        font-size: 2rem;
        color: white;
    }
    
    .user-type-box h4 {
        color: #000fff;
        margin-bottom: 1rem;
        font-weight: 600;
    }
    
    .user-type-box p {
        color: #666;
        line-height: 1.6;
    }
    
       
    
    
    /* Responsive Styles */
    @media (max-width: 991px) {
        .intro-stats-con {
            justify-content: center;
        }
        
        .stat-box {
            margin: 10px;
            flex: 0 0 calc(50% - 20px);
        }
        
        .user-type-box {
            margin-bottom: 2rem;
        }
    }
    
    @media (max-width: 767px) {
        .intro-text-con h3 {
            font-size: 1.7rem;
        }
        
        .stat-box {
            flex: 0 0 100%;
            margin: 5px 0;
        }
        
        .intro-gif-con {
            margin-top: 2rem;
        }
    }
    .plan-icon{
        width: 38px;
        height: 38px;
    }

    /* Plan features list styling */
    .hosting-type-content-con ul {
        margin-top: 8px;
    }

    .hosting-type-content-con ul li {
        padding: 8px 0;
        font-size: 1.05rem;
        color: #444;
        display: flex;
        align-items: center;
    }

    .hosting-type-content-con ul li i {
        color: #000fff;
        margin-right: 10px;
        font-size: 0.9rem;
        width: 18px;
        text-align: center;
    }

    .hosting-type-content-con ul li span { color: inherit; }

    /* Plan features list styling to match other pages */
    .plan-features { margin-top: 12px; }
    .plan-features li { padding: 10px 0; color: #444; font-size: 1.05rem; }
    .plan-features li i { color: #000fff; margin-right: 10px; }

    /* view-more button removed - extra feature items are visible by default */

    /* Styles for the single 'View More Features' control */
    #view-more-features {
        display: inline-block;
        min-width: 160px;
        padding: 10px 18px;
        background: #000fff; /* site blue */
        color: #ffffff;
        border: none;
        border-radius: 6px;
        font-weight: 700;
        font-size: 0.95rem;
        line-height: 1;
        cursor: pointer;
        box-shadow: 0 6px 18px rgba(0,0,0,0.08);
        transition: background 160ms ease, transform 120ms ease, box-shadow 120ms ease;
        text-decoration: none;
        margin-top: 52px;
    }
    #view-more-features:hover { background: #0056d6; transform: translateY(-1px); }
    #view-more-features:active { transform: translateY(0); }
    #view-more-features[aria-expanded="true"] { background: #003d9a; }
    #view-more-features:focus {
        outline: 3px solid rgba(0,95,255,0.18);
        outline-offset: 2px;
    }
    @media (max-width: 576px) {
        #view-more-features { width: 100%; box-sizing: border-box; }
    }
</style>
    <?php require_once BASE_PATH . '/partial/preloader.php'; ?>
    <!-- HEADER SECTION START HERE -->
    <?php require_once BASE_PATH . '/partial/header.php'; ?>
    <!-- HEADER SECTION END HERE -->
    
    <!-- BANNER SECTION START HERE -->
    <section class="hosting-pages-sub-banner sub-banner-main-con w-100 float-left">
        <div class="container">
            <div class="sub-banner-inner-con wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
                <h1>Reseller Hosting</h1>
                     <span class="d-block position-relative"></span>
            <h6>
                <a href="<?= url('') ?>" style="color: #fff; transition: color 0.2s;" onmouseover="this.style.color='#FFD700'" onmouseout="this.style.color='#fff'">Home</a>
               <span style="color: #fff;"> | </span>
              
                  <a href="<?= url('pages/reseller') ?>" style="color: #fff; transition: color 0.2s;" onmouseover="this.style.color='#FFD700'" onmouseout="this.style.color='#fff'">Reseller Hosting</a>
            
            
                </h6>
                    </div>
        </div>
    </section>
    <!-- BANNER SECTION END HERE -->

  
<section class="vps-intro w-100 float-left padding-top padding-bottom">
    <div class="container">
        <div class="generic-title text-center wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
            <h2>What is Reseller Hosting?</h2>
            <p>White‑label reseller hosting lets you build and sell hosting under your brand — complete with WHM/WHMCS, billing automation, and scalable resources.</p>
        </div>

        <div class="intro-content-con wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.5s">
            <div class="row align-items-center">
                <div class="col-lg-6 col-md-6">
                    <div class="intro-text-con">
                        <h3>Start Your Own Hosting Business</h3>
                        <p>Our reseller platform includes WHM for account management, WHMCS for billing & automation, white‑label branding, one‑click cPanel provisioning, and expert 24/7 support — everything needed to run a profitable hosting business.</p>

                        <ul class="list-unstyled intro-features-list">
                            <li><i class="fas fa-ship"></i> White‑label branding & client-facing control panels</li>
                            <li><i class="fas fa-cogs"></i> WHM & WHMCS integration for automated provisioning & billing</li>
                            <li><i class="fas fa-server"></i> SSD storage, unlimited bandwidth options, and scalable resources</li>
                            <li><i class="fas fa-shield-alt"></i> SSL support, malware scanning & automated backups</li>
                            <li><i class="fas fa-user-friends"></i> Bulk cPanel account creation & granular resource limits</li>
                            <li><i class="fas fa-headset"></i> 24/7 reseller‑trained support and onboarding</li>
                        </ul>

                        <div class="intro-stats-con">
                            <div class="stat-box">
                                <h6 style="color:#0000ff;"> White‑Label</h4>
                                <span>Brand every customer touchpoint</span>
                            </div>
                            <div class="stat-box">
                                <h6 style="color:#0000ff;">Automated</h4>
                                <span>Billing, provisioning & invoicing</span>
                            </div>
                            <div class="stat-box">
                                <h6 style="color:#0000ff;"> Scalable</h4>
                                <span>Upgrade resources as your fleet grows</span>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-6 col-md-6">
                    <div class="intro-gif-con text-center">
                        <img src="<?= asset('images/reseller-hosting.jpg') ?>" alt="Reseller Hosting Illustration" class="intro-gif" style="max-width: 100%; height: auto; border-radius: 12px;">

                        <noscript>
                            <img src="<?= asset('images/reseller-hosting-static.png') ?>" alt="Reseller Hosting Diagram" class="intro-static-img">
                        </noscript>

                        <div class="gif-caption">
                            <p>Full reseller stack: WHM + WHMCS, white‑labeling, backups, and 24/7 support to help you sell hosting confidently.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Who Should Use Reseller Hosting -->
        <div class="who-should-use-con wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.7s">
            <div class="row">
                <div class="col-lg-4 col-md-4">
                    <div class="user-type-box">
                        <div class="user-icon">
                            <i class="fas fa-store"></i>
                        </div>
                        <h4>Agencies & Designers</h4>
                        <p>Sell hosting to your clients under your brand with per‑client cPanel access and managed support.</p>
                    </div>
                </div>

                <div class="col-lg-4 col-md-4">
                    <div class="user-type-box">
                        <div class="user-icon">
                            <i class="fas fa-user-tie"></i>
                        </div>
                        <h4>Freelancers & Entrepreneurs</h4>
                        <p>Low startup cost and turnkey billing make it easy to add recurring revenue to your services.</p>
                    </div>
                </div>

                <div class="col-lg-4 col-md-4">
                    <div class="user-type-box">
                        <div class="user-icon">
                            <i class="fas fa-server"></i>
                        </div>
                        <h4>IT Consultants & Resellers</h4>
                        <p>Scale with dedicated resources, advanced account controls, and priority support for your clients.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
    <!-- BANNER SECTION END HERE -->
    
    <!-- DOMAINS SECTION START HERE -->
  
    <div class="banner-sub-sec w-100 float-left">
        <div class="billing-toggle-container wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
            <div class="billing-toggle">
                <div class="billing-option active" data-period="monthly">Monthly</div>
                <div class="billing-option" data-period="yearly">Yearly</div>
            </div>
        </div>
           
        <!-- Move the container below the toggle for better visibility -->
        <div class="container" style="margin-top: 200px;">
            <div class="banner-sub-outer-con wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
            <div class="hosting-types-inner-con web-hosting-inner-con">
                <?php if (!empty($reseller_plans)): ?>
                    <?php 
                    $plan_classes = ['plan1-flower', 'plan2-flower', 'plan3-flower', 'plan4-flower'];
                    foreach ($reseller_plans as $index => $plan): 
                        $features = json_decode($plan['features'], true) ?? [];
                        $developer_features = json_decode($plan['developer_features'], true) ?? [];
                        $technical_details = json_decode($plan['technical_details'], true) ?? [];
                        $plan_class = $plan_classes[$index % 4];
                        
                        $monthly = floatval($plan['monthly_price']);
                        $yearly = floatval($plan['yearly_price']);
                    ?>
                    <div class="hosting-type-box">
                        <div class="hosting-type-content-con <?= htmlspecialchars($plan_class) ?>">
                            <figure>
                                <img class="plan-icon" src="<?= asset($plan['icon_image']) ?>" alt="<?= htmlspecialchars($plan['plan_name']) ?>">
                            </figure>
                            <h5><?= htmlspecialchars($plan['plan_name']) ?></h5>
                            <p><?= htmlspecialchars($plan['description']) ?></p>
                            <div class="hosting-price-box">
                                <span class="dollar">₹</span>
                                <span class="numeric1 plan-price" data-monthly="<?= number_format($monthly, 0) ?>" data-yearly="<?= number_format($yearly, 0) ?>"><?= number_format($monthly, 0) ?></span>
                                <div class="month-title">
                                    <br>
                                    <small class="billing-period">/month</small>
                                </div>
                            </div>
                            <div class="primary-btn blue-btn">
                                <a href="#">ORDER NOW <i class="fas fa-arrow-right"></i></a>
                            </div>
                            <ul class="mb-0 list-unstyled plan-features">
                                <li class="position-relative"><i class="fas fa-check" style="color:#28a745"></i> <span>Domains</span> <?= htmlspecialchars($plan['domains']) ?></li>
                                <li class="position-relative"><i class="fas fa-check" style="color:#28a745"></i> <span>Space</span> <?= htmlspecialchars($plan['storage']) ?></li>
                                <li class="position-relative"><i class="fas fa-check" style="color:#28a745"></i> <span>Database</span> <?= htmlspecialchars($plan['databases']) ?></li>
                                <li class="position-relative"><i class="fas fa-check" style="color:#28a745"></i> <span>Email</span> <?= htmlspecialchars($plan['emails']) ?></li>
                                <li class="position-relative"><i class="fas fa-check" style="color:#28a745"></i> <span>Bandwidth</span> <?= htmlspecialchars($plan['bandwidth']) ?></li>
                                <li class="position-relative"><i class="fas fa-check" style="color:#28a745"></i> <span>Backup</span> <?= htmlspecialchars($plan['backup']) ?></li>
                                <li class="position-relative"><i class="fas fa-check" style="color:#28a745"></i> <span>Support</span> 24/7/365</li>
                                <li class="position-relative"><i class="fas fa-check" style="color:#28a745"></i> <span>Uptime</span> 99.90%</li>
                                <li class="position-relative"><i class="fas fa-check" style="color:#28a745"></i> <span>Server Location</span> India</li>

                                <!-- Developer Features (hidden by default) -->
                                <li class="position-relative extra-item plan-subheading" style="margin-top:12px; font-weight:700;color:#0000ff;"><i class="fas fa-code" style="margin-right:10px"></i>Developer's Feature</li>
                                <?php foreach ($developer_features as $dev_feature): ?>
                                    <li class="position-relative extra-item">
                                        <i class="<?= $dev_feature['available'] ? 'fas fa-check' : 'fas fa-times' ?>" style="color:<?= $dev_feature['available'] ? '#28a745' : '#dc3545' ?>"></i> 
                                        <span><?= htmlspecialchars($dev_feature['name']) ?></span>
                                    </li>
                                <?php endforeach; ?>

                                <!-- Technical Details (hidden by default) -->
                                <li class="position-relative extra-item plan-subheading" style="margin-top:12px; font-weight:700;color:#0000ff;"><i class="fas fa-cogs" style="margin-right:10px"></i>Technical Details</li>
                                <?php foreach ($technical_details as $tech_detail): ?>
                                    <li class="position-relative extra-item">
                                        <i class="<?= $tech_detail['available'] ? 'fas fa-check' : 'fas fa-times' ?>" style="color:<?= $tech_detail['available'] ? '#28a745' : '#dc3545' ?>"></i> 
                                        <span><?= htmlspecialchars($tech_detail['name']) ?></span>
                                        <?php if (!empty($tech_detail['value'])): ?>
                                            <?= htmlspecialchars($tech_detail['value']) ?>
                                        <?php endif; ?>
                                    </li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <div class="col-12 text-center">
                        <p class="lead">No reseller hosting plans available at the moment. Please check back soon!</p>
                    </div>
                <?php endif; ?>
            </div>
                <!-- Control button: View More Features (reveal extra features) -->
                <div class="text-center mt-4">
                    <button id="view-more-features" type="button" class="primary-btn blue-btn" aria-expanded="false">View More Features</button>
                </div>
            </div>
            </div>
        </div>
    </div>
    <!-- DOMAIN SECTION END HERE -->
    
    <!-- Rest of the content remains the same -->
    <!-- DEDICATED FEATURES SECTION START HERE -->
    <section class="dedicated-features-con advance-web-features-con w-100 float-left pt-100 padding-bottom">
        <div class="container">
            <div class="feature-main-con wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
                <div class="generic-title text-center">
                    <h2>Navigate Your Hosting Business to Success</h2>
                    <p>From Captain to Commander, our naval-themed reseller plans provide <span class="d-inline-block">complete business tools, white-label branding, automated billing,</span> and dedicated support to help you command your hosting empire.</p>
                    <a class="arrow-btn" href="<?= url('pages/contact') ?>">Set Sail Today <i class="fas fa-arrow-right"></i></a>
                </div>
                <div class="feature-inner-con">
                    <div class="feature-box">
                      
                        <div class="feature-side-txt-con">
                            <h5>Captain Plan - Chart Your Course</h5>
                            <p>Set sail with 15GB SSD storage and command up to 10 cPanel accounts. Perfect for new captains entering the hosting waters. Unlimited bandwidth, databases, and weekly backups included to keep your fleet secure and running smoothly.</p>
                            <a class="arrow-btn" href="<?= url('pages/contact') ?>">Start Your Journey <i class="fas fa-arrow-right"></i></a>
                        </div>
                    </div>
                    <div class="feature-box">
                       
                        <div class="feature-side-txt-con">
                            <h5>Admiral Plan - Expand Your Fleet</h5>
                            <p>Command the seas with 30GB SSD storage and manage up to 20 cPanel accounts. Ideal for experienced navigators scaling their operations. Advanced tools, priority support, and complete white-label solutions for growing your empire.</p>
                            <a class="arrow-btn" href="<?= url('pages/contact') ?>">Expand Fleet <i class="fas fa-arrow-right"></i></a>
                        </div>
                    </div>
                    <div class="feature-box">
                        
                        <div class="feature-side-txt-con">
                            <h5>Commander Plan - Rule the Waters</h5>
                            <p>Lead with authority using 50GB SSD storage and oversee up to 35 cPanel accounts. Maximum capacity for established hosting commanders. Custom branding, dedicated account management, and enterprise-grade tools for your hosting armada.</p>
                            <a class="arrow-btn" href="<?= url('pages/contact') ?>">Command Now <i class="fas fa-arrow-right"></i></a>
                        </div>
                    </div>
                    <div class="feature-box">
                       
                        <div class="feature-side-txt-con">
                            <h5>Admiral-Grade Business Support</h5>
                            <p>All plans include flagship features: WHM control panel, WHMCS billing system, SSL certificates for security, automated weekly backups, and 24/7 technical crew support. Everything needed to navigate the hosting business waters successfully.</p>
                            <a class="arrow-btn" href="<?= url('pages/contact') ?>">Get Support <i class="fas fa-arrow-right"></i></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- DEDICATED FEATURES SECTION END HERE -->
    <!-- SECURITY FEATURES SECTION START HERE -->
    <section class="shared-hosting-content w-100 float-left padding-top padding-bottom bg-shape">
        <div class="container">
            <div class="generic-title text-center wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
                <h2>Your Naval Reseller Command Center</h2>
                <p>Every Captain, Admiral, and Commander gets flagship tools and maritime-grade security to navigate their hosting business to success</p>
            </div>
            <div class="shared-hosting-content-inner-con wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
               
                <div class="shared-hosting-content-right-con">
                    <h5>Admiral-Grade Command Features</h5>
                    <ul class="mb-0 list-unstyled">
                        <li><i class="fas fa-check-circle circle-chk"></i><span class="d-inline-block"><small class="free-item d-inline-block">FREE</small> WHM Command Bridge & cPanel Navigation</span> <i class="fas fa-check"></i></li>
                        <li><i class="fas fa-check-circle circle-chk"></i><span class="d-inline-block"><small class="free-item d-inline-block">FREE</small> WHMCS Fleet Management System</span> <i class="fas fa-check"></i></li>
                        <li><i class="fas fa-check-circle circle-chk"></i>Complete White-Label Naval Branding <i class="fas fa-check"></i></li>
                        <li><i class="fas fa-check-circle circle-chk"></i>Premium SSL Security for All Vessels <i class="fas fa-check"></i></li>
                        <li><i class="fas fa-check-circle circle-chk"></i><span class="d-inline-block"><small class="free-item d-inline-block">Weekly</small> Automated Fleet Backups</span> <i class="fas fa-check"></i></li>
                        <li><i class="fas fa-check-circle circle-chk"></i>Unlimited Bandwidth & Database Arsenal <i class="fas fa-check"></i></li>
                       
                        <li><i class="fas fa-check-circle circle-chk"></i><span class="d-inline-block"><small class="free-item d-inline-block">24/7</small> Technical Crew Support & Navigation Training</span> <i class="fas fa-check"></i></li>
                       
                    </ul>
                </div>

                <div class="shared-hosting-content-left-con">
                    <figure>
                        <img src="<?= asset('images/Cloud hosting-amico.svg') ?>" alt="reseller-hosting-features">
                    </figure>
            </div>
        </div>
    </section>
    <!-- SECURITY FEATURES SECTION END HERE -->
    <!-- FAQ SECTION START HERE -->
    <section class="faq-main-con w-100 float-left padding-bottom pt-100">
        <div class="container">
            <div class="generic-title text-center wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
                <h2>Naval Reseller Command FAQ</h2>
                <p>Chart your course to hosting business success with answers to captain-level questions</p>
            </div>
            <div class="faq-inner-con wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
                <div id="accordion1">
                    <div class="card">
                        <div class="card-header" id="headingOne">
                            <h5 class="mb-0">
                                <button class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapseOne" aria-expanded="false" aria-controls="collapseOne">
                                    Which naval rank should I choose for my hosting fleet?
                                </button>
                            </h5>
                        </div>
                        <div id="collapseOne" class="collapse" aria-labelledby="headingOne" data-parent="#accordion1">
                            <div class="card-body"><strong>Captain (₹799/month)</strong> - Perfect for new captains with 15GB SSD storage commanding up to 10 cPanel account ports. Ideal for starting your hosting voyage.<br>
                            <strong>Admiral (₹1,599/month)</strong> - Expand your fleet with 30GB SSD storage and manage up to 20 cPanel ports. Great for experienced navigators scaling operations.<br>
                            <strong>Commander (₹2,899/month)</strong> - Rule the waters with 50GB SSD storage and oversee up to 35 cPanel ports. Maximum capacity for established hosting commanders.
</div>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-header" id="headingTwo">
                            <h5 class="mb-0">
                                <button class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                   Do you provide fleet management tools for my reseller armada?
                                </button>
                            </h5>
                        </div>
                        <div id="collapseTwo" class="collapse" aria-labelledby="headingTwo" data-parent="#accordion1">
                            <div class="card-body">Absolutely! Every naval rank includes free WHMCS Fleet Management System and WHM Command Bridge. These flagship tools allow you to navigate client billing, manage your hosting ports, process payments, and handle support communications. We also provide admiral-grade setup assistance and navigation training.</div>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-header" id="headingThree">
                            <h5 class="mb-0">
                                <button class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                                    Can I fly my own flag and brand my hosting fleet?
                                </button>
                            </h5>
                        </div>
                        <div id="collapseThree" class="collapse" aria-labelledby="headingThree" data-parent="#accordion1">
                            <div class="card-body">Yes, Captain! Our complete white-label naval branding allows you to fly your own colors throughout your hosting empire. Use your own domain names, company branding, and fleet identity. Your clients will see only your brand across their entire hosting voyage - from Captain to Commander level.
</div>
                        </div>
                    </div>
                </div>
                <div id="accordion2">
                    <div class="card">
                        <div class="card-header" id="headingfour">
                            <h5 class="mb-0">
                                <button class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapsefour" aria-expanded="false" aria-controls="collapsefour">
                       What kind of technical crew support do I get?

                                </button>
                            </h5>
                        </div>
                        <div id="collapsefour" class="collapse" aria-labelledby="headingfour" data-parent="#accordion2">
                            <div class="card-body">You get 24/7 admiral-grade technical crew support including server fleet management, account port setup, and training on WHM Command Bridge navigation. We also provide business strategy guidance, marketing materials, and assistance with client technical issues. Every rank gets full access to our technical crew expertise.
</div>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-header" id="headingfive">
                            <h5 class="mb-0">
                                <button class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapsefive" aria-expanded="false" aria-controls="collapsefive">
                                   Can I get promoted as my hosting fleet expands?
                                </button>
                            </h5>
                        </div>
                        <div id="collapsefive" class="collapse" aria-labelledby="headingfive" data-parent="#accordion2">
                            <div class="card-body">Certainly! You can seamlessly get promoted from Captain (10 ports) to Admiral (20 ports) or Commander (35 ports) as your client fleet grows. Promotions are instant with zero downtime, and you'll immediately command additional storage capacity, more cPanel account ports, and advanced fleet management features.
</div>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-header" id="headingsix">
                            <h5 class="mb-0">
                                <button class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapsesix" aria-expanded="false" aria-controls="collapsesix">
                                    How profitable can my hosting empire become?

                                </button>
                            </h5>
                        </div>
                        <div id="collapsesix" class="collapse" aria-labelledby="headingsix" data-parent="#accordion2">
                            <div class="card-body">Your hosting empire can be highly profitable! Starting as Captain (₹799/month), you can serve 10 clients at ₹200-500 each, potentially earning ₹2,000-5,000 monthly. As Admiral (₹1,599/month), manage 20 clients for ₹4,000-10,000 revenue. Commander level (₹2,899/month) with 35 clients can generate ₹7,000-17,500. Profit margins typically range 50-70% depending on your fleet strategy.
</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- FAQ SECTION END HERE -->
    <!-- FOOTER SECTION START HERE -->
    <?php include BASE_PATH . '/partial/footer.php'; ?>
    <!-- Back-to-top removed -->
    <!-- FOOTER SECTION END HERE -->
     
    <!-- js start -->
    <script src="<?= asset('js/jquery.min.js') ?>"></script>
    <script src="<?= asset('js/popper.min.js') ?>"></script>
    <script src="<?= asset('js/bootstrap.min.js') ?>"></script>
    <script src="<?= asset('js/owl.carousel.js') ?>"></script>
    <script src="<?= asset('js/wow.js') ?>"></script>
    <script src="<?= asset('js/custom.js') ?>"></script>
    
    <script>
        $(document).ready(function() {
            // Billing toggle functionality
            $('.billing-option').click(function() {
                // Remove active class from all options
                $('.billing-option').removeClass('active');
                
                // Add active class to clicked option
                $(this).addClass('active');
                
                // Get the selected period
                var period = $(this).data('period');
                
                // Update all plan prices
                $('.plan-price').each(function() {
                    var monthlyPrice = $(this).data('monthly');
                    var yearlyPrice = $(this).data('yearly');
                    
                    if (period === 'monthly') {
                        $(this).text(monthlyPrice);
                        $('.billing-period').text('/month');
                    } else {
                        $(this).text(yearlyPrice);
                        $('.billing-period').text('/year');
                    }
                });
            });

            // Hide extra feature items on load and wire the View More Features button
            var $extras = $('.plan-features li.extra-item');
            $extras.hide();

            var $btn = $('#view-more-features');
            if ($btn.length) {
                $btn.on('click', function(e){
                    e.preventDefault();
                    var isOpen = $btn.attr('aria-expanded') === 'true';
                    if(isOpen){
                        $extras.slideUp(250);
                        $btn.attr('aria-expanded','false').text('View More Features');
                        $('html, body').animate({ scrollTop: $btn.offset().top - 20 }, 300);
                    } else {
                        $extras.slideDown(300);
                        $btn.attr('aria-expanded','true').text('Show Less Features');
                        var $firstExtra = $extras.first();
                        if($firstExtra.length){
                            var top = $firstExtra.closest('.hosting-type-content-con').offset().top - 20;
                            $('html, body').animate({ scrollTop: top }, 350);
                        }
                    }
                });
            }


        });
    </script>
