
<!-- Offers Popup Modal -->
<?php
// Get active offers for popup
$db = get_db();
$popup_offers = [];
if ($db) {
    try {
        $stmt = $db->prepare("
            SELECT * FROM offers 
            WHERE status = 'active' 
            AND (valid_until IS NULL OR valid_until >= CURDATE())
            ORDER BY created DESC 
            LIMIT 5
        ");
        $stmt->execute();
        $popup_offers = $stmt->fetchAll(PDO::FETCH_ASSOC);
    } catch (PDOException $e) {
        error_log('Offers popup error: ' . $e->getMessage());
    }
}

// Only show popup if there are active offers
if (!empty($popup_offers)):
?>
<div id="offersPopupModal" class="offers-popup-modal">
    <div class="offers-popup-overlay"></div>
    <div class="offers-popup-container">
        <button class="offers-popup-close" aria-label="Close offers popup">
            <i class="fas fa-times"></i>
        </button>
        
        <div class="offers-popup-content">
            <div class="offers-popup-header">
                <i class="fas fa-gift"></i>
                <h2>Special Offers Just for You!</h2>
                <p>Don't miss out on these amazing deals</p>
            </div>
            
            <div class="offers-popup-slider">
                <?php foreach ($popup_offers as $index => $offer): 
                    $imagePath = !empty($offer['image']) ? $offer['image'] : 'images/offers/default-offer.jpg';
                    $imageUrl = url($imagePath);
                ?>
                    <div class="popup-offer-slide <?= $index === 0 ? 'active' : '' ?>">
                        <div class="popup-offer-image">
                            <img src="<?= $imageUrl ?>" alt="<?= htmlspecialchars($offer['title']) ?>"
                                 onerror="this.src='<?= asset('images/offers/default-offer.jpg') ?>'"
                                 loading="lazy">
                            <div class="popup-offer-badge">
                                <i class="fas fa-star"></i> LIMITED OFFER
                            </div>
                        </div>
                        
                        <div class="popup-offer-details">
                            <h3 class="popup-offer-title"><?= htmlspecialchars($offer['title']) ?></h3>
                            <p class="popup-offer-description"><?= htmlspecialchars($offer['description']) ?></p>
                            
                            <?php if (!empty($offer['discount_percentage']) || !empty($offer['discount_amount'])): ?>
                                <div class="popup-offer-discount">
                                    <span class="discount-label">Save</span>
                                    <span class="discount-value">
                                        <?php if (!empty($offer['discount_percentage'])): ?>
                                            <?= htmlspecialchars($offer['discount_percentage']) ?>% OFF
                                        <?php elseif (!empty($offer['discount_amount'])): ?>
                                            ₹<?= number_format($offer['discount_amount'], 0) ?> OFF
                                        <?php endif; ?>
                                    </span>
                                </div>
                            <?php endif; ?>
                            
                            <?php if (!empty($offer['valid_until'])): ?>
                                <div class="popup-offer-validity">
                                    <i class="far fa-clock"></i>
                                    Valid until <?= date('M d, Y', strtotime($offer['valid_until'])) ?>
                                </div>
                            <?php endif; ?>
                            
                            <a href="#" class="popup-offer-cta">
                                Claim Offer Now <i class="fas fa-arrow-right"></i>
                            </a>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
            
        </div>
    </div>
</div>

<style>
/* Offers Popup Modal - Matching Hero Banner Style */
.offers-popup-modal {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    z-index: 9999;
    display: none;
    align-items: center;
    justify-content: center;
    opacity: 0;
    transition: opacity 0.4s cubic-bezier(0.4, 0, 0.2, 1);
}

.offers-popup-modal.show {
    display: flex;
    opacity: 1;
}

.offers-popup-modal.closing {
    opacity: 0;
}

@keyframes fadeIn {
    from { opacity: 0; }
    to { opacity: 1; }
}

.offers-popup-overlay {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(0, 0, 0, 0.7);
    backdrop-filter: blur(20px) saturate(180%);
    -webkit-backdrop-filter: blur(20px) saturate(180%);
}

.offers-popup-container {
    position: relative;
    max-width: 1000px;
    width: 92%;
    max-height: 85vh;
    background: #000;
    border: none;
    border-radius: 30px;
    box-shadow: 0 50px 120px rgba(0, 0, 255, 0.5), 
                0 0 100px rgba(255, 210, 0, 0.2);
    overflow: hidden;
    animation: slideUpScale 0.6s cubic-bezier(0.34, 1.56, 0.64, 1);
    z-index: 10000;
    transform-origin: center;
}

.offers-popup-modal.closing .offers-popup-container {
    animation: slideDownScale 0.4s cubic-bezier(0.4, 0, 1, 1) forwards;
}

@keyframes slideUpScale {
    from {
        opacity: 0;
        transform: translateY(40px) scale(0.9);
    }
    to {
        opacity: 1;
        transform: translateY(0) scale(1);
    }
}

@keyframes slideDownScale {
    from {
        opacity: 1;
        transform: translateY(0) scale(1);
    }
    to {
        opacity: 0;
        transform: translateY(40px) scale(0.95);
    }
}

.offers-popup-close {
    position: absolute;
    top: 20px;
    right: 20px;
    width: 44px;
    height: 44px;
    border-radius: 50%;
    background: rgba(255, 255, 255, 0.15);
    backdrop-filter: blur(10px);
    border: 1px solid rgba(255, 255, 255, 0.3);
    color: white;
    font-size: 1.2rem;
    cursor: pointer;
    display: flex;
    align-items: center;
    justify-content: center;
    transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
    z-index: 10001;
}

.offers-popup-close:hover {
    background: rgba(255, 255, 255, 0.25);
    transform: rotate(90deg) scale(1.1);
    box-shadow: 0 8px 20px rgba(0, 0, 0, 0.3);
}

.offers-popup-close:active {
    transform: rotate(90deg) scale(0.95);
}

.offers-popup-content {
    position: relative;
}

.offers-popup-header {
    display: none;
}

.offers-popup-slider {
    position: relative;
    min-height: 550px;
}

.popup-offer-slide {
    display: none;
    animation: fadeInSlide 0.7s cubic-bezier(0.4, 0, 0.2, 1);
    position: relative;
}

.popup-offer-slide.active {
    display: grid;
    grid-template-columns: 60% 40%;
    gap: 0;
    min-height: 550px;
}

@keyframes fadeInSlide {
    from {
        opacity: 0;
        transform: scale(0.9) rotateY(10deg);
    }
    to {
        opacity: 1;
        transform: scale(1) rotateY(0deg);
    }
}

.popup-offer-image {
    position: relative;
    width: 100%;
    height: 100%;
    overflow: hidden;
    z-index: 1;
    background: #000;
}

.popup-offer-image img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    object-position: center;
    transition: transform 0.8s cubic-bezier(0.4, 0, 0.2, 1);
}

.popup-offer-slide.active .popup-offer-image img {
    animation: zoomPan 1s cubic-bezier(0.4, 0, 0.2, 1);
}

@keyframes zoomPan {
    from { 
        transform: scale(1.05);
    }
    to { 
        transform: scale(1);
    }
}

.popup-offer-badge {
    position: absolute;
    top: 30px;
    left: 30px;
    background: #000;
    color: #ffd200;
    padding: 10px 20px;
    border-radius: 8px;
    font-weight: 900;
    font-size: 0.65rem;
    box-shadow: 0 0 30px rgba(255, 210, 0, 0.8),
                0 0 60px rgba(255, 210, 0, 0.4),
                inset 0 0 20px rgba(255, 210, 0, 0.2);
    display: flex;
    align-items: center;
    gap: 6px;
    z-index: 20;
    border: 2px solid #ffd200;
    text-transform: uppercase;
    letter-spacing: 2px;
    animation: neonPulse 2s ease-in-out infinite;
}

@keyframes neonPulse {
    0%, 100% { 
        box-shadow: 0 0 30px rgba(255, 210, 0, 0.8),
                    0 0 60px rgba(255, 210, 0, 0.4),
                    inset 0 0 20px rgba(255, 210, 0, 0.2);
    }
    50% { 
        box-shadow: 0 0 40px rgba(255, 210, 0, 1),
                    0 0 80px rgba(255, 210, 0, 0.6),
                    inset 0 0 30px rgba(255, 210, 0, 0.3);
    }
}

.popup-offer-details {
    position: relative;
    padding: 60px 50px;
    display: flex;
    flex-direction: column;
    justify-content: center;
    align-items: center;
    text-align: center;
    background: linear-gradient(135deg, #000 0%, #001a33 100%);
    z-index: 10;
}

.popup-offer-details::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    width: 2px;
    height: 100%;
    background: linear-gradient(180deg, transparent 0%, #ffd200 50%, transparent 100%);
    animation: lineMove 3s ease-in-out infinite;
}

@keyframes lineMove {
    0%, 100% { opacity: 0.3; transform: scaleY(0.5); }
    50% { opacity: 1; transform: scaleY(1); }
}

.popup-offer-title {
    color: white;
    font-size: 2.5rem;
    font-weight: 900;
    margin: 0 0 20px 0;
    line-height: 1.1;
    text-shadow: 0 0 30px rgba(255, 210, 0, 0.5);
    animation: slideInRight 0.7s cubic-bezier(0.4, 0, 0.2, 1) 0.2s backwards;
    letter-spacing: -1px;
    text-transform: uppercase;
}

@keyframes slideInRight {
    from {
        opacity: 0;
        transform: translateX(50px);
    }
    to {
        opacity: 1;
        transform: translateX(0);
    }
}

.popup-offer-description {
    color: rgba(255, 255, 255, 0.8);
    font-size: 1.1rem;
    line-height: 1.7;
    margin-bottom: 30px;
    animation: slideInRight 0.7s cubic-bezier(0.4, 0, 0.2, 1) 0.3s backwards;
    font-weight: 400;
}

.popup-offer-discount {
    background: transparent;
    border: 3px solid #ffd200;
    border-radius: 10px;
    padding: 18px 30px;
    margin-bottom: 30px;
    display: inline-flex;
    align-items: baseline;
    gap: 15px;
    animation: slideInRight 0.7s cubic-bezier(0.4, 0, 0.2, 1) 0.4s backwards;
    box-shadow: 0 0 40px rgba(255, 210, 0, 0.4),
                inset 0 0 20px rgba(255, 210, 0, 0.1);
    align-self: center;
    position: relative;
    overflow: hidden;
}

.popup-offer-discount::before {
    content: '';
    position: absolute;
    top: 0;
    left: -100%;
    width: 100%;
    height: 100%;
    background: linear-gradient(90deg, transparent, rgba(255, 210, 0, 0.2), transparent);
    animation: shimmer 3s infinite;
}

.discount-label {
    color: rgba(255, 210, 0, 0.8);
    font-size: 0.9rem;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 2px;
}

.discount-value {
    color: #ffd200;
    font-size: 2.2rem;
    font-weight: 900;
    text-shadow: 0 0 20px rgba(255, 210, 0, 0.8);
    letter-spacing: 2px;
    line-height: 1;
}

.popup-offer-validity {
    color: rgba(255, 255, 255, 0.6);
    font-size: 0.95rem;
    margin-bottom: 35px;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 10px;
    font-weight: 500;
    animation: slideInRight 0.7s cubic-bezier(0.4, 0, 0.2, 1) 0.5s backwards;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.popup-offer-cta {
    display: inline-flex;
    align-items: center;
    gap: 10px;
    padding: 12px 30px;
    background: #ffd200;
    color: #000;
    border-radius: 0;
    font-weight: 900;
    font-size: 0.85rem;
    text-decoration: none;
    text-transform: uppercase;
    letter-spacing: 1.5px;
    transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
    align-self: center;
    box-shadow: 0 0 50px rgba(255, 210, 0, 0.6);
    position: relative;
    overflow: hidden;
    animation: slideInRight 0.7s cubic-bezier(0.4, 0, 0.2, 1) 0.6s backwards;
    clip-path: polygon(8% 0%, 100% 0%, 92% 100%, 0% 100%);
}

.popup-offer-cta::before {
    content: '';
    position: absolute;
    top: 0;
    left: -100%;
    width: 100%;
    height: 100%;
    background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.6), transparent);
    transition: left 0.6s;
}

.popup-offer-cta:hover::before {
    left: 100%;
}

.popup-offer-cta:hover {
    transform: translateX(10px);
    box-shadow: 0 0 80px rgba(255, 210, 0, 1);
    color: #000;
}

.popup-offer-cta:active {
    transform: translateX(5px) scale(0.98);
}

/* Responsive Design */
@media (max-width: 968px) {
    .popup-offer-slide.active {
        grid-template-columns: 1fr;
    }
    
    .popup-offer-image {
        min-height: 300px;
    }
    
    .popup-offer-details {
        min-height: auto;
    }
}

@media (max-width: 768px) {
    .offers-popup-container {
        width: 95%;
        max-width: 500px;
        max-height: 90vh;
        border-radius: 20px;
    }
    
    .offers-popup-slider {
        min-height: auto;
    }
    
    .popup-offer-slide.active {
        min-height: auto;
    }
    
    .popup-offer-image {
        min-height: 250px;
    }
    
    .popup-offer-details {
        padding: 35px 25px;
    }
    
    .popup-offer-title {
        font-size: 2rem;
    }
    
    .popup-offer-description {
        font-size: 0.95rem;
    }
    
    .discount-value {
        font-size: 2rem;
    }
    
    .popup-offer-cta {
        padding: 16px 35px;
        font-size: 0.95rem;
        letter-spacing: 2px;
    }
    
    .popup-offer-badge {
        top: 25px;
        left: 25px;
        padding: 10px 18px;
        font-size: 0.65rem;
    }
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const modal = document.getElementById('offersPopupModal');
    const closeBtn = document.querySelector('.offers-popup-close');
    const overlay = document.querySelector('.offers-popup-overlay');
    const slides = document.querySelectorAll('.popup-offer-slide');
    
    let currentSlide = 0;
    const totalSlides = slides.length;
    
    // Show popup after 2 seconds
    setTimeout(() => {
        if (!sessionStorage.getItem('offersPopupShown')) {
            modal.classList.add('show');
            document.body.style.overflow = 'hidden';
        }
    }, 2000);
    
    // Close popup
    function closePopup() {
        modal.classList.add('closing');
        setTimeout(() => {
            modal.classList.remove('show', 'closing');
            document.body.style.overflow = '';
            sessionStorage.setItem('offersPopupShown', 'true');
        }, 400);
    }
    
    closeBtn.addEventListener('click', closePopup);
    overlay.addEventListener('click', closePopup);
    
    // Close on ESC key
    document.addEventListener('keydown', (e) => {
        if (e.key === 'Escape' && modal.classList.contains('show')) {
            closePopup();
        }
    });
    
    // Show specific slide
    function showSlide(index) {
        slides.forEach(slide => slide.classList.remove('active'));
        
        if (index >= totalSlides) currentSlide = 0;
        if (index < 0) currentSlide = totalSlides - 1;
        
        slides[currentSlide].classList.add('active');
    }
    
    // Auto slide every 5 seconds
    if (totalSlides > 1) {
        setInterval(() => {
            if (modal.classList.contains('show')) {
                currentSlide++;
                showSlide(currentSlide);
            }
        }, 5000);
    }
});
</script>
<?php endif; ?>

<!-- Include footer scripts -->
<?php 
// Add page-specific scripts if needed
$page_scripts = ['home.js'];
require_once BASE_PATH . '/partial/footer_scripts.php'; 
?>
