<?php 
require_once __DIR__ . '/../config.php';

// Set page-specific variables
$page_title = 'Domain Registration | WsplCloud - Web Hosting & Cloud Services';
$page_description = 'Register, transfer, or renew domain names at competitive prices. Wide range of TLDs available with free WHOIS privacy.';
$page_keywords = 'domain registration, domain names, domain transfer, domain renewal, buy domain, TLD, domain price';
$custom_css = ['priceslider.css']; // Add domain specific CSS

// Include header meta (DOCTYPE, <head>, opening <body> tag)
require_once BASE_PATH . '/partial/header_meta.php';
?>
<?php
// Include the navigation header
require_once BASE_PATH . '/partial/header.php';
?>

<style>
    @media only screen and (max-width: 767px) {
    .banner-main-con,
    .sub-banner-main-con,
    .hosting-pages-sub-banner,
    .banner-main-con .sub-banner-inner-con,
    .sub-banner-main-con .container {
        padding-top: 100px !important;
        padding-bottom: 100px !important;
        max-height: 400px !important;
        display: flex !important;
        align-items: center !important;
        justify-content: center !important;
        text-align: center !important;
    }
    /* Ensure headings remain readable and centered */
    .banner-main-con h1,
    .sub-banner-main-con h1,
    .hosting-pages-sub-banner h1 {
        font-size: 28px !important;
        line-height: 1.15 !important;
        margin: 0 auto !important;
        max-width: 92% !important;
    }
}
/* ===============================================
   DOMAIN PAGE - SIMPLE & CLEAN STYLES
   =============================================== */

/* TLD Types Section */
.tld-types-main-con {
    padding: 80px 0;
    position: relative;
    overflow: hidden;
}

/* Add Custom Network SVG Background */
.tld-types-main-con::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='200' height='200' viewBox='0 0 800 800'%3E%3Crect fill='%23FFFFFF' width='800' height='800' fill-opacity='0.1'/%3E%3Cg fill='none' stroke='%2300059C' stroke-width='1.5' stroke-opacity='0.3'%3E%3Cpath d='M769 229L1037 260.9M927 880L731 737 520 660 309 538 40 599 295 764 126.5 879.5 40 599-197 493 102 382-31 229 126.5 79.5-69-63'/%3E%3Cpath d='M-31 229L237 261 390 382 603 493 308.5 537.5 101.5 381.5M370 905L295 764'/%3E%3Cpath d='M520 660L578 842 731 737 840 599 603 493 520 660 295 764 309 538 390 382 539 269 769 229 577.5 41.5 370 105 295 -36 126.5 79.5 237 261 102 382 40 599 -69 737 127 880'/%3E%3Cpath d='M520-140L578.5 42.5 731-63M603 493L539 269 237 261 370 105M902 382L539 269M390 382L102 382'/%3E%3Cpath d='M-222 42L126.5 79.5 370 105 539 269 577.5 41.5 927 80 769 229 902 382 603 493 731 737M295-36L577.5 41.5M578 842L295 764M40-201L127 80M102 382L-261 269'/%3E%3C/g%3E%3Cg fill='%23000AFF' fill-opacity='0.4'%3E%3Ccircle cx='769' cy='229' r='6'/%3E%3Ccircle cx='539' cy='269' r='6'/%3E%3Ccircle cx='603' cy='493' r='6'/%3E%3Ccircle cx='731' cy='737' r='6'/%3E%3Ccircle cx='520' cy='660' r='6'/%3E%3Ccircle cx='309' cy='538' r='6'/%3E%3Ccircle cx='295' cy='764' r='6'/%3E%3Ccircle cx='40' cy='599' r='6'/%3E%3Ccircle cx='102' cy='382' r='6'/%3E%3Ccircle cx='127' cy='80' r='6'/%3E%3Ccircle cx='370' cy='105' r='6'/%3E%3Ccircle cx='578' cy='42' r='6'/%3E%3Ccircle cx='237' cy='261' r='6'/%3E%3Ccircle cx='390' cy='382' r='6'/%3E%3C/g%3E%3C/svg%3E");
    background-size: 200px 200px;
    background-repeat: repeat;
    background-position: 0 0;
    animation: networkMove 30s ease-in-out infinite;
    pointer-events: none;
    z-index: 0;
    opacity: 0.6;
}

/* Add subtle overlay pattern */
.tld-types-main-con::after {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
   
    background-size: 60px 60px;
    background-repeat: repeat;
    animation: overlayDrift 30s linear infinite reverse;
    pointer-events: none;
    z-index: 0;
}

/* Animation for network background movement */
@keyframes networkMove {
    0%, 100% {
        transform: translateX(0) translateY(0) scale(1);
    }
    25% {
        transform: translateX(-20px) translateY(-10px) scale(1.02);
    }
    50% {
        transform: translateX(10px) translateY(-20px) scale(1.01);
    }
    75% {
        transform: translateX(-10px) translateY(10px) scale(1.02);
    }
}

/* Overlay drift animation */
@keyframes overlayDrift {
    0% {
        transform: translateX(0) translateY(0);
    }
    100% {
        transform: translateX(60px) translateY(60px);
    }
}

.tld-types-main-con .generic-title h2 {
    color: #000000ff;
    font-size: 2.5rem;
    font-weight: 700;
    margin-bottom: 20px;
    position: relative;
    z-index: 1;
   
}

.tld-types-main-con .generic-title p {
    color: #000000ff;
    font-size: 1.2rem;
    margin-bottom: 0;
    position: relative;
    z-index: 1;
    
}

/* Simple Grid Layout */
.tld-types-inner-con {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(350px, 1fr));
    gap: 30px;
    margin: 60px 0;
    position: relative;
    z-index: 1;
}

/* Clean Card Design */
.tld-type-box {
    background: #fff;
    border-radius: 15px;
    padding: 40px 30px;
    box-shadow: 0 5px 20px rgba(0, 0, 0, 0.08);
    transition: all 0.3s ease;
    border: 2px solid transparent;
}

.tld-type-box:hover {
    transform: translateY(-8px);
    box-shadow: 0 15px 40px rgba(0, 15, 255, 0.12);
    border-color: rgba(0, 15, 255, 0.1);
}

/* Simple Header */
.tld-type-header {
    display: flex;
    align-items: center;
    margin-bottom: 25px;
    gap: 20px;
}

.tld-icon {
    width: 70px;
    height: 70px;
    background: linear-gradient(45deg, #000FFF, #0066CC);
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.8rem;
    transition: all 0.3s ease;
}

.tld-type-box:hover .tld-icon {
    transform: scale(1.1);
    background: linear-gradient(45deg, #FFD200, #FFA500);
    color: #000;
}

.tld-type-header h3 {
    color: #000FFF;
    font-size: 1.8rem;
    font-weight: 700;
    margin: 0;
}

/* Content Styling */
.tld-type-content p {
    color: #555;
    line-height: 1.7;
    font-size: 1rem;
    margin-bottom: 25px;
}

.tld-type-content strong {
    color: #000FFF;
    font-weight: 600;
}

/* Examples Box */
.tld-examples {
    background: #f8f9fa;
    padding: 20px;
    border-radius: 10px;
    margin-bottom: 25px;
    border-left: 4px solid #000FFF;
}

.example-label {
    font-weight: 600;
    color: #000FFF;
    display: block;
    margin-bottom: 10px;
    font-size: 0.9rem;
    text-transform: uppercase;
}

.example-domains {
    font-size: 1rem;
    color: #333;
    display: flex;
    align-items: center;
    gap: 10px;
    flex-wrap: wrap;
}

.domain-tag {
    background: #000FFF;
    color: white;
    padding: 4px 12px;
    border-radius: 20px;
    font-weight: 600;
    font-size: 0.9rem;
    transition: all 0.3s ease;
}

.domain-tag:hover {
    background: #FFD200;
    color: #000;
    transform: scale(1.05);
}

.separator {
    color: #999;
    font-weight: 500;
}

/* Benefits List */
.tld-benefits ul {
    list-style: none;
    padding: 0;
    margin: 0;
}

.tld-benefits li {
    display: flex;
    align-items: center;
    gap: 12px;
    padding: 8px 0;
    color: #555;
    font-size: 0.95rem;
    transition: color 0.3s ease;
}

.tld-benefits li:hover {
    color: #000FFF;
}

.tld-benefits .fas.fa-check-circle {
    color: #28a745;
    font-size: 1rem;
}

/* Simple CTA */
.tld-cta-section {
    margin: 60px 0 0;
    padding: 50px 30px;
    background: #fff;
    border-radius: 15px;
    box-shadow: 0 5px 20px rgba(0, 0, 0, 0.08);
    text-align: center;
}

.tld-cta-section h4 {
    color: #000FFF;
    font-size: 1.8rem;
    font-weight: 700;
    margin-bottom: 15px;
}

.tld-cta-section p {
    color: #666;
    font-size: 1.1rem;
    margin-bottom: 30px;
}

.tld-search-btn {
    background: linear-gradient(45deg, #000FFF, #0066CC);
    color: white;
    padding: 15px 35px;
    border-radius: 25px;
    text-decoration: none;
    font-weight: 600;
    font-size: 1.1rem;
    transition: all 0.3s ease;
    display: inline-flex;
    align-items: center;
    gap: 10px;
    border: none;
}

.tld-search-btn:hover {
    background: linear-gradient(45deg, #FFD200, #FFA500);
    color: #000;
    text-decoration: none;
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(0, 15, 255, 0.2);
}

/* ===============================================
   EASY STEPS SECTION - CLEAN & PROFESSIONAL
   =============================================== */

/* Easy Steps Section */
.easy-steps-main-con {
    background: #fff;
    padding: 80px 0;
    position: relative;
}

.easy-steps-main-con .generic-title h2 {
    color: #000FFF;
    font-size: 2.5rem;
    font-weight: 700;
    margin-bottom: 20px;
}

.easy-steps-main-con .generic-title p {
    color: #666;
    font-size: 1.2rem;
    margin-bottom: 0;
}

/* Steps Grid Layout */
.easy-steps-inner-con {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(350px, 1fr));
    gap: 30px;
    margin: 60px 0;
}

/* Step Box Design */
.step-box {
    background: #f8f9fa;
    border-radius: 15px;
    padding: 40px 30px;
    transition: all 0.3s ease;
    border: 2px solid transparent;
    text-align: center;
    position: relative;
    overflow: hidden;
}

.step-box:hover {
    transform: translateY(-8px);
    box-shadow: 0 15px 40px rgba(0, 15, 255, 0.12);
    border-color: rgba(0, 15, 255, 0.1);
    background: #fff;
}

/* Step Header */
.step-header {
    display: flex;
    flex-direction: column;
    align-items: center;
    margin-bottom: 25px;
    gap: 15px;
}

/* Step Number */
.step-number {
    width: 50px;
    height: 50px;
    background: linear-gradient(45deg, #000FFF, #0066CC);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.5rem;
    font-weight: 700;
    position: relative;
    z-index: 2;
}

.step-box:hover .step-number {
    background: linear-gradient(45deg, #FFD200, #FFA500);
    color: #000;
    transform: scale(1.1);
}

/* Step Icon */
.step-icon {
    width: 80px;
    height: 80px;
    background: rgba(0, 15, 255, 0.1);
    border-radius: 20px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: #000FFF;
    font-size: 2rem;
    transition: all 0.3s ease;
}

.step-box:hover .step-icon {
    background: rgba(255, 210, 0, 0.2);
    color: #FFA500;
    transform: scale(1.05);
}

.step-header h3 {
    color: #000FFF;
    font-size: 1.5rem;
    font-weight: 700;
    margin: 0;
}

/* Step Content */
.step-content {
    text-align: left;
}

.step-content p {
    color: #555;
    line-height: 1.7;
    font-size: 1rem;
    margin-bottom: 25px;
}

/* Step Benefits */
.step-benefits ul {
    list-style: none;
    padding: 0;
    margin: 0;
}

.step-benefits ul li {
    display: flex;
    align-items: center;
    gap: 12px;
    margin-bottom: 12px;
    color: #555;
    font-size: 0.95rem;
}

.step-benefits ul li i {
    color: #28a745;
    font-size: 1rem;
    flex-shrink: 0;
}

/* Call to Action */
.steps-cta {
    background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
    border-radius: 20px;
    padding: 50px 40px;
    margin-top: 40px;
    border: 2px solid rgba(0, 15, 255, 0.1);
}

.steps-cta h3 {
    color: #000FFF;
    font-size: 2rem;
    font-weight: 700;
    margin-bottom: 15px;
}

.steps-cta p {
    color: #666;
    font-size: 1.1rem;
    margin-bottom: 30px;
}

.steps-cta .btn {
    background: linear-gradient(45deg, #000FFF, #0066CC);
    color: white;
    padding: 15px 40px;
    font-size: 1.1rem;
    font-weight: 600;
    border-radius: 30px;
    text-decoration: none;
    display: inline-flex;
    align-items: center;
    gap: 10px;
    border: none;
    transition: all 0.3s ease;
}

.steps-cta .btn:hover {
    background: linear-gradient(45deg, #FFD200, #FFA500);
    color: #000;
    text-decoration: none;
    transform: translateY(-2px);
    box-shadow: 0 10px 30px rgba(0, 15, 255, 0.3);
}

/* Responsive Design */
@media (max-width: 992px) {
    .tld-types-inner-con {
        grid-template-columns: 1fr;
        gap: 25px;
    }
    
    .tld-type-box {
        padding: 35px 25px;
    }
}

@media (max-width: 768px) {
    .tld-types-main-con {
        padding: 60px 0;
    }
    
    .tld-types-main-con .generic-title h2 {
        font-size: 2rem;
    }
    
    .tld-type-header {
        flex-direction: column;
        text-align: center;
        gap: 15px;
    }
    
    .tld-icon {
        width: 60px;
        height: 60px;
        font-size: 1.5rem;
    }
    
    .tld-type-header h3 {
        font-size: 1.5rem;
    }
    
    .example-domains {
        flex-direction: column;
        align-items: flex-start;
        gap: 8px;
    }
    
    .separator {
        display: none;
    }
    
    .tld-cta-section {
        padding: 40px 20px;
    }
    
    .tld-search-btn {
        padding: 12px 25px;
        font-size: 1rem;
    }
}

@media (max-width: 576px) {
    .tld-type-box {
        padding: 30px 20px;
    }
    
    .tld-type-header h3 {
        font-size: 1.3rem;
    }
    
    .tld-examples {
        padding: 15px;
    }
    
    .tld-cta-section h4 {
        font-size: 1.5rem;
    }
}

/* Easy Steps Section Responsive */
@media (max-width: 992px) {
    .easy-steps-inner-con {
        grid-template-columns: 1fr;
        gap: 25px;
    }
    
    .step-box {
        padding: 35px 25px;
    }
    
    .steps-cta {
        padding: 40px 25px;
    }
}

@media (max-width: 768px) {
    .easy-steps-main-con {
        padding: 60px 0;
    }
    
    .easy-steps-main-con .generic-title h2 {
        font-size: 2rem;
    }
    
    .step-icon {
        width: 70px;
        height: 70px;
        font-size: 1.7rem;
    }
    
    .step-number {
        width: 45px;
        height: 45px;
        font-size: 1.3rem;
    }
    
    .step-header h3 {
        font-size: 1.3rem;
    }
    
    .steps-cta h3 {
        font-size: 1.7rem;
    }
    
    .steps-cta .btn {
        padding: 12px 30px;
        font-size: 1rem;
    }
}

@media (max-width: 576px) {
    .step-box {
        padding: 25px 20px;
    }
    
    .step-header {
        gap: 12px;
    }
    
    .step-icon {
        width: 60px;
        height: 60px;
        font-size: 1.5rem;
    }
    
    .steps-cta {
        padding: 30px 20px;
    }
    
    .steps-cta h3 {
        font-size: 1.5rem;
    }
}

/* ===============================================
   STEPS TO FOLLOW SECTION - FISH & SEA THEME
   =============================================== */

/* Main Steps Follow Section */
.steps-follow-main-con {
    background: #0000ff;
    padding: 80px 0;
    position: relative;
    overflow: hidden;
}

.steps-follow-main-con::before {
    content: '';
    position: absolute;
    bottom: 0;
    left: 0;
    width: 100%;
    height: 100px;
    background: url('<?= asset("images/water.gif") ?>') repeat-x;
    background-size: cover;
    opacity: 0.3;
    pointer-events: none;
}

.steps-follow-main-con .generic-title h2 {
    color: #fff;
    font-size: 2.5rem;
    font-weight: 700;
    margin-bottom: 15px;
    position: relative;
    text-shadow: 2px 2px 4px rgba(0,0,0,0.3);
}

.steps-follow-main-con .generic-title h2::after {
    content: '';
    position: absolute;
    bottom: -8px;
    left: 50%;
    width: 60px;
    height: 3px;
    background: #FFD700;
    border-radius: 2px;
    transform: translateX(-50%);
}

.steps-follow-main-con .generic-title p {
    color: #E0F6FF;
    font-size: 1.1rem;
    margin-bottom: 0;
}

/* Sea Wave Background */
.sea-wave-bg {
    position: absolute;
    bottom: 0;
    left: 0;
    width: 100%;
    height: 150px;
    background: repeating-linear-gradient(
        90deg,
        rgba(255,255,255,0.1) 0px,
        rgba(255,255,255,0.05) 50px,
        rgba(255,255,255,0.1) 100px
    );
    animation: wave 3s ease-in-out infinite;
}

@keyframes wave {
    0%, 100% { transform: translateY(0px); }
    50% { transform: translateY(-10px); }
}

/* Bubbles */
.bubbles-container {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    pointer-events: none;
    z-index: 1;
}

.bubble {
    position: absolute;
    background: rgba(255,255,255,0.6);
    border-radius: 50%;
    animation: float-up 4s infinite ease-in-out;
}

.bubble-1 {
    width: 20px;
    height: 20px;
    left: 20%;
    animation-delay: 0s;
}

.bubble-2 {
    width: 15px;
    height: 15px;
    left: 40%;
    animation-delay: 1s;
}

.bubble-3 {
    width: 25px;
    height: 25px;
    left: 60%;
    animation-delay: 2s;
}

.bubble-4 {
    width: 12px;
    height: 12px;
    left: 80%;
    animation-delay: 0.5s;
}

.bubble-5 {
    width: 18px;
    height: 18px;
    left: 10%;
    animation-delay: 1.5s;
}

@keyframes float-up {
    0% {
        bottom: -50px;
        opacity: 0;
    }
    50% {
        opacity: 1;
    }
    100% {
        bottom: 100%;
        opacity: 0;
    }
}

/* Roadmap Container */
.roadmap-container {
    position: relative;
    display: flex;
    justify-content: space-between;
    align-items: flex-start;
    margin: 80px 0 60px 0;
    padding: 0 50px;
}

/* Roadmap Connecting Line */
.roadmap-line {
    position: absolute;
    top: 60px;
    left: 50px;
    right: 50px;
    height: 4px;
    background: rgba(255,255,255,0.3);
    border-radius: 2px;
    z-index: 1;
}

.progress-line {
    position: absolute;
    top: 0;
    left: 0;
    height: 100%;
    width: 0%;
    background: #FFD700;
    border-radius: 2px;
    transition: width 2s ease-in-out;
    animation: progressAnimation 3s ease-in-out infinite;
}

@keyframes progressAnimation {
    0% { width: 0%; }
    33% { width: 33%; }
    66% { width: 66%; }
    100% { width: 100%; }
}

/* Individual Roadmap Steps */
.roadmap-step {
    flex: 1;
    display: flex;
    flex-direction: column;
    align-items: center;
    position: relative;
    z-index: 2;
    opacity: 0;
    transform: translateY(30px);
    animation: stepFadeIn 0.8s ease-out forwards;
}

.roadmap-step.step-1 {
    animation-delay: 0.5s;
}

.roadmap-step.step-2 {
    animation-delay: 1s;
}

.roadmap-step.step-3 {
    animation-delay: 1.5s;
}

@keyframes stepFadeIn {
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

/* Step Circle */
.step-circle {
    position: relative;
    width: 120px;
    height: 120px;
    background: #fff;
    border: 4px solid #FFD700;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-bottom: 30px;
    box-shadow: 0 10px 30px rgba(0,0,0,0.2);
    transition: all 0.4s ease;
    cursor: pointer;
}

.step-circle:hover {
    transform: scale(1.1);
    border-color: #FFA500;
    box-shadow: 0 15px 40px rgba(255,165,0,0.3);
}

.step-number {
    font-size: 2.5rem;
    font-weight: 800;
    color: #ffffffff;
    transition: all 0.3s ease;
}

.step-circle:hover .step-number {
    color: #fff200ff;
    transform: scale(1.1);
}

/* Water Ripple Animation */
.water-ripple {
    position: absolute;
    top: -8px;
    left: -8px;
    right: -8px;
    bottom: -8px;
    border: 2px solid rgba(255,215,0,0.6);
    border-radius: 50%;
    opacity: 0;
    animation: ripple 2s ease-out infinite;
}

.step-circle:hover .water-ripple {
    border-color: rgba(255,165,0,0.8);
    animation-duration: 1s;
}

@keyframes ripple {
    0% {
        opacity: 1;
        transform: scale(1);
    }
    100% {
        opacity: 0;
        transform: scale(1.3);
    }
}

/* Step Content */
.step-content {
    text-align: center;
    background: rgba(255,255,255,0.95);
    padding: 25px 20px;
    border-radius: 15px;
    box-shadow: 0 8px 25px rgba(0,0,0,0.2);
    transition: all 0.3s ease;
    max-width: 280px;
    position: relative;
    backdrop-filter: blur(5px);
}

.step-content:hover {
    transform: translateY(-5px);
    box-shadow: 0 15px 35px rgba(0,0,0,0.3);
    background: rgba(255,255,255,1);
}

.step-content::before {
    content: '';
    position: absolute;
    top: -10px;
    left: 50%;
    width: 20px;
    height: 20px;
    background: rgba(255,255,255,0.95);
    border: 2px solid #E0F6FF;
    transform: translateX(-50%) rotate(45deg);
    border-radius: 3px;
}

.step-image {
    margin-bottom: 20px;
    transition: all 0.3s ease;
}

.step-image img {
    width: 80px;
    height: 80px;
    object-fit: contain;
    transition: all 0.3s ease;
    filter: drop-shadow(0 4px 8px rgba(0,0,0,0.1));
}

.step-content:hover .step-image img {
    transform: scale(1.1);
    filter: drop-shadow(0 6px 12px rgba(0,0,0,0.2));
}

.step-content h3 {
    color: #4682B4;
    font-size: 1.3rem;
    font-weight: 700;
    margin-bottom: 12px;
    transition: all 0.3s ease;
}

.step-content:hover h3 {
    color: #FF6347;
}

.step-content p {
    color: #555;
    font-size: 0.95rem;
    line-height: 1.6;
    margin-bottom: 0;
}

/* Enhanced Action Button */
.generic-btn {
    background: #FFD700;
    color: #4682B4;
    padding: 18px 40px;
    border-radius: 30px;
    text-decoration: none;
    font-weight: 700;
    font-size: 1.1rem;
    transition: all 0.4s ease;
    position: relative;
    overflow: hidden;
    margin-top: 30px;
    display: inline-block;
    box-shadow: 0 8px 20px rgba(255,215,0,0.3);
}

.generic-btn::before {
    content: '';
    position: absolute;
    top: 0;
    left: -100%;
    width: 100%;
    height: 100%;
    background: linear-gradient(90deg, transparent, rgba(255,255,255,0.3), transparent);
    transition: all 0.5s ease;
}

.generic-btn:hover {
    background: #FFA500;
    color: #fff;
    text-decoration: none;
    transform: translateY(-3px);
    box-shadow: 0 12px 30px rgba(255,165,0,0.4);
}

.generic-btn:hover::before {
    left: 100%;
}

/* Responsive Design */
@media (max-width: 992px) {
    .roadmap-container {
        flex-direction: column;
        align-items: center;
        padding: 0 20px;
    }
    
    .roadmap-line {
        top: 60px;
        left: 50%;
        right: auto;
        width: 4px;
        height: 500px;
        transform: translateX(-50%);
        background: rgba(255,255,255,0.3);
    }
    
    .progress-line {
        width: 100%;
        height: 0%;
        background: #FFD700;
        animation: progressAnimationVertical 3s ease-in-out infinite;
    }
    
    @keyframes progressAnimationVertical {
        0% { height: 0%; }
        33% { height: 33%; }
        66% { height: 66%; }
        100% { height: 100%; }
    }
    
    .roadmap-step {
        margin-bottom: 80px;
        width: 100%;
        max-width: 350px;
    }
    
    .roadmap-step:last-child {
        margin-bottom: 0;
    }
}

@media (max-width: 768px) {
    .steps-follow-main-con {
        padding: 60px 0;
    }
    
    .steps-follow-main-con .generic-title h2 {
        font-size: 2rem;
    }
    
    .roadmap-container {
        margin: 60px 0 40px 0;
    }
    
    .step-circle {
        width: 100px;
        height: 100px;
    }
    
    .step-number {
        font-size: 2rem;
    }
    
    .step-content {
        padding: 20px 15px;
        max-width: 250px;
    }
    
    .step-content h3 {
        font-size: 1.1rem;
    }
    
    .step-image img {
        width: 60px;
        height: 60px;
    }
    
    .roadmap-line {
        height: 400px;
    }
    
    .fish-1, .fish-2 {
        display: none;
    }
}

@media (max-width: 576px) {
    .roadmap-container {
        padding: 0 10px;
    }
    
    .step-circle {
        width: 80px;
        height: 80px;
    }
    
    .step-number {
        font-size: 1.5rem;
    }
    
    .step-content {
        max-width: 520px;
        padding: 18px 12px;
    }
    
    .step-content h3 {
        font-size: 1rem;
    }
    
    .step-content p {
        font-size: 0.9rem;
    }
    
    .step-image img {
        width: 50px;
        height: 50px;
    }
    
    .generic-btn {
        padding: 15px 30px;
        font-size: 1rem;
    }
    
    .bubble {
        display: none;
    }
}
</style>
    <!-- BANNER SECTION START HERE -->
    <section class="hosting-pages-sub-banner sub-banner-main-con w-100 float-left">
        <div class="container">
            <div class="sub-banner-inner-con wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
                <h1>Most Popular Domains</h1>
                <span class="d-block position-relative"></span>
            <h6>
                <a href="<?= url('') ?>" style="color: #fff; transition: color 0.2s;" onmouseover="this.style.color='#FFD700'" onmouseout="this.style.color='#fff'">Home</a>
                <span style="color: #fff;"> | </span>
                <a href="<?= url('domain') ?>" style="color: #fff; transition: color 0.2s;" onmouseover="this.style.color='#FFD700'" onmouseout="this.style.color='#fff'">Domain</a>
            </h6>
               
            </div>
        </div>
    </section>
    <!-- BANNER SECTION END HERE -->
     
    <!-- SEARCH DOMAIN SECTION START HERE -->
    <section class="search-domain-con w-100 float-left p-100">
        <div class="container">
            <div class="generic-title text-center wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
                <h2>Register Your Domain</h2>
                <p>Your domain helps people find you online and makes a first impression. <br> Find one that represents you perfectly.</p>
            </div>
            <div class="search-domain-outer-con wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
                <div class="domain-top-shape">
                    <figure class="mb-0">
                        <img src="<?= asset('images/domain-top-shape.png') ?>" alt="domain-top-shape">
                    </figure>
                </div>
                <div class="search-domain-inner-con">
                    <div class="search-domain-box">
                        <h2>Get Flat <span class="d-inline-block">20% OFF</span> on All New Domain TLD Registration</h2>
                        <div class="domain-serach-con">
                            <input type="text" placeholder="Search domain name...">
                            <button class="search-btn"><i class="fas fa-search"></i> Search</button>
                        </div>
                    </div>
                </div>
                <div class="domain-bottom-shape">
                    <figure class="mb-0">
                        <img src="<?= asset('images/domain-bottom-shape.png') ?>" alt="domain-bottom-shape">
                    </figure>
                </div>
            </div>
        </div>
    </section>
   
    <section class="reasons-main-con w-100 float-left pb-100">
        <div class="container">
            <div class="generic-title text-center wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
                <h2>
The Reasons Behind Best Choosing To Our Hosting</h2>
                
            </div>
            <div class="reasons-inner-con wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
                <div class="reason-box">
                    <div class="reason-heading">
                        <figure class="mb-0">
                            <img src="<?= asset('images/reason-img1.png') ?>" alt="reason-img1">
                        </figure>
                        <h5>100% Uptime <br> Guaranteed</h5>
                    </div>
                    <p>
We understand that your website the backbone of your online presence, which is why we offer 100%</p>
                </div>
                <div class="reason-box">
                    <div class="reason-heading">
                        <figure class="mb-0">
                            <img src="<?= asset('images/reason-img2.png') ?>" alt="reason-img2">
                        </figure>
                        <h5>Embrace Open Source</h5>
                    </div>
                    <p>Open source is more than just a technology—it's a philosophy that fosters innovation, collaboration.

</p>
                </div>
                <div class="reason-box">
                    <div class="reason-heading">
                        <figure class="mb-0">
                            <img src="<?= asset('images/reason-img3.png') ?>" alt="reason-img3">
                            </figure>
                        <h5>Commitment <br> To Security</h5>
                    </div>
                    <p>
Your security is our top priority. In an ever evolving digital landscape, we understand the importance.
</p>
                </div>
            </div>
        </div>
    </section>
    <!-- REASONS SECTION END HERE -->
    <!-- DOMAIN PRICE SECTION START HERE -->
    <section class="domain-main-con w-100 float-left padding-top padding-bottom">
        <div class="container">
            <div class="generic-title text-center wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
                <h2>Find the ideal domain name for your business</h2>
                <p>Choosing the perfect domain name is crucial in establishing your online presence. Your domain name is more important than hosting.</p>
            </div>
            <div class="domain-price-inner-con wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
                <?php
                    // Fetch domains from database
                    try {
                        $db = get_db();
                        $stmt = $db->query("SELECT * FROM domains WHERE is_active = 1 ORDER BY display_order ASC, tld ASC");
                        $domains = $stmt->fetchAll(PDO::FETCH_ASSOC);
                        
                        // Generate table rows
                        $allRows = [];
                        foreach ($domains as $domain) {
                            $badge = '';
                            if ($domain['badge']) {
                                $badgeClass = strtolower($domain['badge']);
                                $badge = ' <span class="' . $badgeClass . '">' . htmlspecialchars($domain['badge']) . '</span>';
                            }
                            
                            $transferPrice = $domain['transfer_price'] ? '₹' . number_format($domain['transfer_price'], 0) : '-';
                            
                            $row = '<tr>';
                            $row .= '<td data-label="TLDs"><i class="fas fa-check-circle"></i> ' . htmlspecialchars($domain['tld']) . $badge . '</td>';
                            $row .= '<td data-label="Register">₹' . number_format($domain['register_price'], 0) . '</td>';
                            $row .= '<td data-label="Renew">₹' . number_format($domain['renew_price'], 0) . '</td>';
                            $row .= '<td data-label="Transfer">' . $transferPrice . '</td>';
                            $row .= '</tr>';
                            
                            $allRows[] = $row;
                        }
                    } catch (Exception $e) {
                        error_log("Error fetching domains: " . $e->getMessage());
                        $allRows = ['<tr><td colspan="4">Error loading domains. Please contact administrator.</td></tr>'];
                    }
                ?>
                <table id="domain-price-table">
                    <thead>
                        <tr>
                            <th scope="col">TLDs</th>
                            <th scope="col">Register</th>
                            <th scope="col">Renew</th>
                            <th scope="col">Transfer</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                            // Show only first 10 rows initially
                            for ($i = 0; $i < 10 && $i < count($allRows); $i++) {
                                echo $allRows[$i];
                            }
                        ?>
                    </tbody>
                </table>
                <div class="domain-btn-con text-center">
                    <a href="javascript:void(0);" id="view-all-domains">VIEW ALL DOMAIN NAMES <i class="fas fa-arrow-right"></i></a>
                </div>
                <script>
                    document.addEventListener('DOMContentLoaded', function() {
                        var allRows = <?php echo json_encode($allRows); ?>;
                        var tableBody = document.querySelector('#domain-price-table tbody');
                        var viewAllBtn = document.getElementById('view-all-domains');
                        var showingAll = false;
                        viewAllBtn.addEventListener('click', function() {
                            if (!showingAll) {
                                tableBody.innerHTML = allRows.map(function(row){return row;}).join('');
                                viewAllBtn.textContent = 'SHOW LESS DOMAIN NAMES';
                                showingAll = true;
                            } else {
                                tableBody.innerHTML = allRows.slice(0,10).join('');
                                viewAllBtn.innerHTML = 'VIEW ALL DOMAIN NAMES <i class="fas fa-arrow-right"></i>';
                                showingAll = false;
                            }
                        });
                    });
                </script>
               
            </div>
        </div>
    </section>
    <!-- DOMAIN PRICE SECTION END HERE -->
    
    
    <!-- EASY STEPS SECTION START HERE -->
    <section class="easy-steps-main-con w-100 float-left padding-top padding-bottom">
        <div class="container">
            <div class="generic-title text-center wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
                <h2>Get Your Business Online in 3 Easy Steps</h2>
                <p>Follow these simple steps to launch your website and establish your online presence today.</p>
            </div>
            <div class="easy-steps-inner-con wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
                <!-- Step 1 -->
                <div class="step-box">
                    <div class="step-header">
                       
                        <div class="step-icon">
                            <i class="fas fa-globe"></i>
                        </div>
                        <h3>Select a Domain Name</h3>
                    </div>
                    <div class="step-content">
                        <p>Pick the right domain name extension from a range, including .com, .in, .org, and others.</p>
                        <div class="step-benefits">
                            <ul>
                                <li><i class="fas fa-check-circle"></i> Choose from 100+ TLD options</li>
                                <li><i class="fas fa-check-circle"></i> Free WHOIS privacy protection</li>
                                <li><i class="fas fa-check-circle"></i> Instant domain availability check</li>
                            </ul>
                        </div>
                    </div>
                </div>

                <!-- Step 2 -->
                <div class="step-box">
                    <div class="step-header">
                        
                        <div class="step-icon">
                            <i class="fas fa-server"></i>
                        </div>
                        <h3>Select Hosting Plan</h3>
                    </div>
                    <div class="step-content">
                        <p>Choose the best web hosting price from MilesWeb, that's competitive with the market.</p>
                        <div class="step-benefits">
                            <ul>
                                <li><i class="fas fa-check-circle"></i> 99.9% uptime guarantee</li>
                                <li><i class="fas fa-check-circle"></i> 24/7 technical support</li>
                                <li><i class="fas fa-check-circle"></i> Free SSL certificates</li>
                            </ul>
                        </div>
                    </div>
                </div>

                <!-- Step 3 -->
                <div class="step-box">
                    <div class="step-header">
                        
                        <div class="step-icon">
                            <i class="fas fa-rocket"></i>
                        </div>
                        <h3>Launch Your Website</h3>
                    </div>
                    <div class="step-content">
                        <p>Setup your website and get the instant account from us to launch your website immediately.</p>
                        <div class="step-benefits">
                            <ul>
                                <li><i class="fas fa-check-circle"></i> One-click install for CMS</li>
                                <li><i class="fas fa-check-circle"></i> Free website migration</li>
                                <li><i class="fas fa-check-circle"></i> Instant account activation</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
            
          
        </div>
    </section>
    <!-- EASY STEPS SECTION END HERE -->
    
    <!-- STEPS TO FOLLOW SECTION START HERE -->
    <section class="steps-follow-main-con w-100 float-left padding-top padding-bottom">
        <div class="container">
            <div class="generic-title text-center">
                <h2>Get Your Business Online in 3 Easy Steps</h2>
                <p>Steps to follow</p>
            </div>
            
            <!-- Roadmap Container -->
            <div class="roadmap-container">
              
                
                <div class="roadmap-line">
                    <div class="progress-line" id="progressLine"></div>
                </div>
                
                <!-- Step 1 -->
                <div class="roadmap-step step-1">
                    <div class="step-circle">
                        <div class="step-number">1</div>
                        <div class="water-ripple"></div>
                    </div>
                    <div class="step-content">
                        <div class="step-image">
                            <img src="<?= asset('images/com-img.png') ?>" alt="Select Domain Name">
                        </div>
                        <h3>Select a Domain Name</h3>
                        <p>Pick the right domain name extension from a range, including .com, .in, .org, and others.</p>
                    </div>
                </div>
                
                <!-- Step 2 -->
                <div class="roadmap-step step-2">
                    <div class="step-circle">
                        <div class="step-number">2</div>
                        <div class="water-ripple"></div>
                    </div>
                    <div class="step-content">
                        <div class="step-image">
                            <img src="<?= asset('images/hosting-solution-img.png') ?>" alt="Select Hosting Plan">
                        </div>
                        <h3>Select Hosting Plan</h3>
                        <p>Choose the best web hosting price from MilesWeb, that's competitive with the market.</p>
                    </div>
                </div>
                
                <!-- Step 3 -->
                <div class="roadmap-step step-3">
                    <div class="step-circle">
                        <div class="step-number">3</div>
                        <div class="water-ripple"></div>
                    </div>
                    <div class="step-content">
                        <div class="step-image">
                            <img src="<?= asset('images/feature-img1.png') ?>" alt="Launch Your Website">
                        </div>
                        <h3>Launch Your Website</h3>
                        <p>Setup your website and get the instant account from us to launch your website immediately.</p>
                    </div>
                </div>
            </div>
            
          
        </div>
    </section>
    <!-- STEPS TO FOLLOW SECTION END HERE -->
    
     
    
    <!-- FAQ SECTION START HERE -->
    <section class="faq-main-con w-100 float-left padding-bottom pt-100">
        <div class="container">
            <div class="generic-title text-center wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
                <h2>Frequently Asked Questions</h2>
                <p>Do you have any questions? We have your answers!</p>
            </div>
            <div class="faq-inner-con wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
                <div id="accordion1">
                    <div class="card">
                        <div class="card-header" id="headingOne">
                            <h5 class="mb-0">
                                <button class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapseOne" aria-expanded="false" aria-controls="collapseOne">
                                    What is a domain name?
                                </button>
                            </h5>
                        </div>
                        <div id="collapseOne" class="collapse" aria-labelledby="headingOne" data-parent="#accordion1">
                            <div class="card-body">A domain name is the web address people use to find your website online. <br>
For example, in www.yourbusiness.com, the domain name is yourbusiness.com.
It’s like your digital address — just like a physical store needs a street address, your website needs a domain name so customers can find you online.
</div>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-header" id="headingTwo">
                            <h5 class="mb-0">
                                <button class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                    What is a TLD?
                                </button>
                            </h5>
                        </div>
                        <div id="collapseTwo" class="collapse" aria-labelledby="headingTwo" data-parent="#accordion1">
                            <div class="card-body">TLD stands for Top-Level Domain. <br>
A TLD is the ending of a website address, like .com, .in, or .org.
It tells users something about the website — for example, .com is usually for businesses, .in is for Indian websites, and .org is often used by non-profits.
</div>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-header" id="headingThree">
                            <h5 class="mb-0">
                                <button class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                                    What are parked domains?
                                </button>
                            </h5>
                        </div>
                        <div id="collapseThree" class="collapse" aria-labelledby="headingThree" data-parent="#accordion1">
                            <div class="card-body">A parked domain is a domain name you’ve bought, but haven’t built a website on yet. <br>
It’s like buying land and putting up a “Coming Soon” sign — you own the name, but there’s no website running on it yet.
</div>
                        </div>
                    </div>
                </div>
                <div id="accordion2">
                    <div class="card">
                        <div class="card-header" id="headingfour">
                            <h5 class="mb-0">
                                <button class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapsefour" aria-expanded="false" aria-controls="collapsefour">
                                    What are subdomains and how are they used?
                                </button>
                            </h5>
                        </div>
                        <div id="collapsefour" class="collapse" aria-labelledby="headingfour" data-parent="#accordion2">
                            <div class="card-body">A subdomain is like a room inside your main website building. It lets you create different sections like blog.example.com or shop.example.com without buying a new domain.
It’s a great way to organize your website and keep things neat and user-friendly.
</div>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-header" id="headingfive">
                            <h5 class="mb-0">
                                <button class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapsefive" aria-expanded="false" aria-controls="collapsefive">
                                    What is an IP address?
                                </button>
                            </h5>
                        </div>
                        <div id="collapsefive" class="collapse" aria-labelledby="headingfive" data-parent="#accordion2">
                            <div class="card-body">An IP address is like your device’s home address on the internet.
It helps websites, servers, and other devices find and communicate with each other online.

</div>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-header" id="headingsix">
                            <h5 class="mb-0">
                                <button class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapsesix" aria-expanded="false" aria-controls="collapsesix">
                                    What is a DNS?
                                </button>
                            </h5>
                        </div>
                        <div id="collapsesix" class="collapse" aria-labelledby="headingsix" data-parent="#accordion2">
                            <div class="card-body">DNS stands for Domain Name System.
It’s like the phonebook of the internet — it translates domain names (like example.com) into IP addresses (like 192.168.1.1) that computers understand.
</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- FAQ SECTION END HERE -->
    
    <!-- FOOTER SECTION START HERE -->
    <?php require_once BASE_PATH . '/partial/footer.php'; ?>
    <!-- FOOTER SECTION END HERE -->
    <!-- Back-to-top removed -->

<!-- Include footer scripts -->
<?php 
// Add page-specific scripts if needed
$page_scripts = [];
require_once BASE_PATH . '/partial/footer_scripts.php'; 
?>