<?php 
require_once __DIR__ . '/../config.php';

// Set page-specific variables
$page_title = '500 Internal Server Error | WsplCloud - Web Hosting & Cloud Services';
$page_description = 'An internal server error has occurred. Our team is working to resolve the issue.';
$page_keywords = '500 error, server error, internal error, technical problem';

// Set custom CSS for this page
$custom_css = [];

// Include header meta (DOCTYPE, <head>, opening <body> tag)
require_once BASE_PATH . '/partial/header_meta.php';

// Include the navigation header
require_once BASE_PATH . '/partial/header.php';
?>

<style>
    .error-page {
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        min-height: 70vh;
        text-align: center;
        padding: 2rem;
    }
    
    .error-code {
        font-size: 8rem;
        font-weight: bold;
        color: #f8546a;
        margin-bottom: 1rem;
    }
    
    .error-message {
        font-size: 2rem;
        margin-bottom: 2rem;
    }
    
    .error-description {
        max-width: 600px;
        margin-bottom: 2rem;
    }
</style>
    
    <div class="error-page">
        <div class="error-code">500</div>
        <div class="error-message">Internal Server Error</div>
        <div class="error-description">
            <p>Something went wrong on our end. We're working to fix the issue.</p>
            <p>Please try again later or contact our support team if the problem persists.</p>
        </div>
        <div class="generic-btn">
            <a href="<?= url('') ?>">Go to Homepage <i class="fas fa-arrow-right"></i></a>
        </div>
    </div>
    
<!-- Include footer -->
<?php require_once BASE_PATH . '/partial/footer.php'; ?>

<!-- Include footer scripts -->
<?php 
// Add page-specific scripts if needed
$page_scripts = [];
require_once BASE_PATH . '/partial/footer_scripts.php'; 
?>