<?php 
require_once __DIR__ . '/../config.php';

// Set page-specific variables
$page_title = '404 | Page Not Found | WsplCloud';
$page_description = 'The page you are looking for could not be found.';
$page_keywords = '404 error, page not found, missing page, broken link';

// Set custom CSS for this page (if needed)
$custom_css = [];

// Include header meta (DOCTYPE, <head>, opening <body> tag)
require_once BASE_PATH . '/partial/header_meta.php';

// We don't include the main header for 404 pages
?>

<!-- 404 SECTION START HERE -->
<section class="error-section w-100 float-left">
    <div class="container">
        <div class="error-con wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
            <figure class="mb-0">
                <img src="<?= asset('images/404-1.png') ?>" alt="404 error image">
            </figure>
            <div class="generic-btn">
                <a href="<?= BASE_URL ?>"><i class="fas fa-arrow-left"></i> BACK TO HOMEPAGE</a>
            </div>
        </div>
    </div>
</section>
<!-- 404 SECTION END HERE -->

<!-- Include footer scripts -->
<?php 
// Add page-specific scripts if needed
$page_scripts = [];
require_once BASE_PATH . '/partial/footer_scripts.php'; 
?>
</body>
</html>