<?php
/**
 * Database Connection Handler for Admin Panel
 * This file now acts as a wrapper to the centralized database connection.
 * 
 * Usage: require_once __DIR__ . '/db.php';
 * Access connection via: $link (global variable from includes/db_connect.php)
 */

// Include the centralized database connection file
require_once __DIR__ . '/../includes/db_connect.php';

// For backward compatibility with existing code that might expect $db
// If the old code expects $db, it will now get the $link (PDO object)
global $db;
if (!isset($db) || $db === null) {
    $db = $link;
}

/**
 * Helper function to get database connection
 * For backward compatibility with existing code
 * 
 * @return PDO Database connection object
 */
function getDbConnection() {
    global $link; // Use the centralized $link
    return $link;
}

/**
 * Helper function to check if database connection is active
 * 
 * @return bool True if connected, false otherwise
 */
function isDatabaseConnected() {
    global $link; // Use the centralized $link
    try {
        if ($link instanceof PDO) {
            $link->query('SELECT 1');
            return true;
        }
    } catch (PDOException $e) {
        error_log('Database connection check failed: ' . $e->getMessage());
    }
    return false;
}
?>
