<?php
require_once __DIR__ . '/config.php';

function combine_and_minify_assets($assets, $type, $output_dir) {
    $content = '';
    foreach ($assets as $asset) {
        $file_path = BASE_PATH . '/assets/' . $type . '/' . $asset;
        if (file_exists($file_path)) {
            $content .= file_get_contents($file_path);
        }
    }

    if ($type === 'css') {
        // Basic CSS minification
        $content = preg_replace('!/\*[^*]*\*+([^/][^*]*\*+)*/!', '', $content);
        $content = str_replace(array("\r\n", "\r", "\n", "\t", '  ', '    ', '    '), '', $content);
        $content = str_replace('{ ', '{', $content);
        $content = str_replace(' }', '}', $content);
        $content = str_replace('; ', ';', $content);
        $content = str_replace(', ', ',', $content);
        $content = str_replace(' {', '{', $content);
        $content = str_replace('} ', '}', $content);
        $content = str_replace(': ', ':', $content);
        $content = str_replace(' ,', ',', $content);
        $content = str_replace(' ;', ';', $content);
    }

    $output_filename = md5($content) . '.' . $type;
    $output_path = $output_dir . '/' . $output_filename;

    if (!file_exists($output_path)) {
        file_put_contents($output_path, $content);
    }

    return asset($type . '/' . $output_filename);
}
?>
