<?php
// Common header file with all meta tags and CSS/JS includes
if (!defined('BASE_PATH')) {
    // If this file is accessed directly, include the config
    require_once __DIR__ . '/../config.php';
}
// Default title if not set
$page_title = $page_title ?? 'WsplCloud - Web Hosting & Cloud Services';
$page_description = $page_description ?? 'WsplCloud offers reliable web hosting, domain registration, and cloud services for businesses of all sizes. 24/7 support and guaranteed uptime.';
$page_keywords = $page_keywords ?? 'web hosting, cloud hosting, vps, wordpress hosting, domain registration, shared hosting, reseller hosting';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
    <!-- SEO Meta Tags -->
    <title><?= $page_title ?></title>
    <meta name="description" content="<?= $page_description ?>">
    <meta name="keywords" content="<?= $page_keywords ?>">
    <meta name="author" content="WsplCloud">
    <meta name="robots" content="index, follow">
    
    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:site_name" content="WsplCloud">
    <meta property="og:url" content="<?= htmlspecialchars(url($GLOBALS['current_path'] ?? '')) ?>">
    <meta property="og:title" content="<?= htmlspecialchars($page_title) ?>">
    <meta property="og:description" content="<?= htmlspecialchars($page_description) ?>">
    <meta property="og:image" content="<?= isset($page_image) ? htmlspecialchars(asset($page_image)) : asset('images/1024.png') ?>">
    
    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="<?= htmlspecialchars(url($GLOBALS['current_path'] ?? '')) ?>">
    <meta property="twitter:title" content="<?= htmlspecialchars($page_title) ?>">
    <meta property="twitter:description" content="<?= htmlspecialchars($page_description) ?>">
    <meta property="twitter:image" content="<?= isset($page_image) ? htmlspecialchars(asset($page_image)) : asset('images/1024.png') ?>">
    
    <!-- Canonical Tag -->
    <link rel="canonical" href="<?= htmlspecialchars(url($GLOBALS['current_path'] ?? '')) ?>">
    
    <!-- Favicon / Pinned Tab / App icons -->
    <link rel="apple-touch-icon" sizes="180x180" href="<?= asset('favicon_io/apple-touch-icon.png') ?>">
    <!-- Primary project favicon (48x48 PNG) -->
    <link rel="icon" href="<?= asset('favicon_io/fav.png') ?>" sizes="48x48" type="image/png">
    <link rel="icon" type="image/png" sizes="32x32" href="<?= asset('favicon_io/favicon-32x32.png') ?>">
    <link rel="icon" type="image/png" sizes="16x16" href="<?= asset('favicon_io/favicon-16x16.png') ?>">
    <link rel="manifest" href="<?= asset('favicon_io/site.webmanifest') ?>">
    <link rel="mask-icon" href="<?= asset('favicon_io/safari-pinned-tab.svg') ?>" color="#06b6d4">
    <link rel="shortcut icon" href="<?= asset('favicon_io/favicon.ico') ?>" type="image/x-icon">
    <meta name="msapplication-TileColor" content="#06b6d4">
    <meta name="msapplication-TileImage" content="<?= asset('favicon_io/mstile-150x150.png') ?>">
    <meta name="theme-color" content="#06b6d4">
    
    <!-- Schema.org Markup (JSON-LD) -->
    <script type="application/ld+json">
    {
      "@context": "https://schema.org",
      "@type": "Organization",
      "name": "<?= SITE_NAME ?>",
      "url": "<?= BASE_URL ?>",
      "logo": "<?= asset('images/WsplCloud.png') ?>",
      "description": "<?= SITE_TAGLINE ?>",
      "contactPoint": {
        "@type": "ContactPoint",
        "telephone": "<?= CONTACT_PHONE ?>",
        "contactType": "customer service",
        "email": "<?= CONTACT_EMAIL ?>"
      },
      "sameAs": [
        "<?= SOCIAL_FACEBOOK ?>",
        "<?= SOCIAL_TWITTER ?>",
        "<?= SOCIAL_INSTAGRAM ?>",
        "<?= SOCIAL_LINKEDIN ?>"
      ]
    }
    </script>
    
    <!-- Debugging URLs -->
    <!-- BASE_URL: <?= BASE_URL ?> -->
    <!-- ASSETS_URL: <?= ASSETS_URL ?> -->
    <!-- Load Inter font for consistent site typography. Prefer a self-hosted woff2 if present. -->
    <?php
    $localWoff = BASE_PATH . '/assets/fonts/Inter-Variable.woff2';
    if (file_exists($localWoff)) {
        // Preload local woff2 for best performance
        $localUrl = rtrim(BASE_URL, '/') . '/assets/fonts/Inter-Variable.woff2';
        echo '<link rel="preload" href="' . htmlspecialchars($localUrl) . '" as="font" type="font/woff2" crossorigin>'; 
    }
    ?>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link rel="preload" href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" as="style" onload="this.rel='stylesheet'">
    <noscript>
        <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    </noscript>
    
    <!-- CSS Libraries -->
    <?php
    if (ENVIRONMENT === 'production') {
        require_once BASE_PATH . '/minify.php';
        $css_files = [
            'bootstrap/bootstrap.min.css',
            'css/owl.carousel.css',
            'css/animate.css',
            'css/custom.css',
            'css/mobile.css',
            'css/mobile-extra.css'
        ];
        if (isset($custom_css) && !empty($custom_css)) {
            foreach ((array)$custom_css as $css) {
                $css_files[] = 'css/' . $css;
            }
        }
        echo '<link rel="stylesheet" href="' . combine_and_minify_assets($css_files, 'css', ASSETS_PATH . '/css') . '">';
    } else {
    ?>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <link rel="stylesheet" href="<?= asset('bootstrap/bootstrap.min.css') ?>">
    <link rel="stylesheet" href="<?= asset('css/owl.carousel.css') ?>">
    <link rel="stylesheet" href="<?= asset('css/animate.css') ?>">
    
    <!-- Custom CSS -->
    <link rel="stylesheet" href="<?= asset('css/custom.css') ?>">
    <link rel="stylesheet" href="<?= asset('css/mobile.css') ?>">
    <link rel="stylesheet" href="<?= asset('css/mobile-extra.css') ?>">
    
    <!-- Custom Styles Per Page -->
    <?php if (isset($custom_css) && !empty($custom_css)): ?>
        <?php foreach ((array)$custom_css as $css): ?>
            <link rel="stylesheet" href="<?= asset('css/' . $css) ?>">
        <?php endforeach; ?>
    <?php endif; ?>
    <?php } ?>
    
    <!-- Google Analytics or other tracking code can go here -->
</head>
<body>
    <?php require_once BASE_PATH . '/partial/preloader.php'; ?>
