<?php 
require_once __DIR__ . '/../config.php';

// Set page-specific variables
$page_title = 'Terms of Service | WsplCloud - Web Hosting & Cloud Services';
$page_description = 'Read our terms of service agreement that governs the use of WsplCloud web hosting services, cloud solutions, and domain registration.';
$page_keywords = 'terms of service, terms and conditions, legal agreement, service terms, acceptable use policy, hosting terms';

// Set custom CSS for this page
$custom_css = ['breadcrumbs.css'];

// Include header meta (DOCTYPE, <head>, opening <body> tag)
require_once BASE_PATH . '/partial/header_meta.php';

// Include the navigation header
require_once BASE_PATH . '/partial/header.php';
?>
    <style>
        body {
            font-family: "Segoe UI", sans-serif;
            line-height: 1.7;
            background: #f9fafc;
        }
        .terms-header {
            background: #0000ff;
            color: #fff;
            padding: 60px 20px;
            text-align: center;
            border-bottom-left-radius: 25px;
            border-bottom-right-radius: 25px;
        }
        .terms-header h1 {
            font-weight: 700;
        }
        .toc {
            position: sticky;
            top: 100px;
        }
        .toc .list-group-item {
            border: none;
            background: transparent;
            padding-left: 0;
            font-size: 0.95rem;
            transition: all 0.3s ease;
        }
        .toc .list-group-item:hover,
        .toc .list-group-item:focus {
            background-color: #f8f9fa;
            padding-left: 10px;
        }
        .terms-section {
            padding: 25px;
            background: #fff;
            border-radius: 15px;
            box-shadow: 0 4px 10px rgba(0,0,0,0.05);
            margin-bottom: 25px;
            scroll-margin-top: 30px;
        }
        .terms-section h3 {
            font-size: 1.3rem;
            font-weight: 600;
            color: #0000ff;
            margin-bottom: 15px;
        }
        html {
            scroll-behavior: smooth;
        }
   
        .breadcrumb-nav {
            color: #fff;
            margin-top: 15px;
        }
        .breadcrumb-nav a {
            color: #fff;
            text-decoration: none;
            transition: color 0.2s;
        }
        .breadcrumb-nav a:hover {
            color: #FFD700;
        }
        .active-section {
            background-color: #e9ecef !important;
            color: #0000ff !important;
            font-weight: 600;
            padding-left: 10px !important;
        }
        @media (max-width: 991px) {
            .toc {
                position: static;
                margin-bottom: 30px;
            }
        }
    </style>
</head>

<body>
    <?php require_once BASE_PATH . '/partial/preloader.php'; ?>
    
    <!-- HEADER SECTION START HERE -->
    <?php require_once BASE_PATH . '/partial/header.php'; ?>
    <!-- HEADER SECTION END HERE -->
    
    <!-- BANNER SECTION START HERE -->
    <section class="sub-banner-main-con w-100">
        <div class="container">
            <div class="sub-banner-inner-con wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
                <h1>Terms of Service</h1>
                <span class="d-block position-relative"></span>
                <div class="breadcrumb-nav">
                    <a href="<?= url('') ?>">Home</a> / 
                    <a href="<?= url('term') ?>">Terms of Service</a>
                </div>
            </div>
        </div>
    </section>

    <div class="container py-5">
        <div class="row">
            <!-- Sidebar TOC as Card -->
            <aside class="col-lg-3 mb-4">
                <div class="card shadow-sm border-0 rounded-3 sticky-top" style="top: 100px;">
                    <!-- Card Header -->
                    <div class="card-header bg-primary text-white fw-bold">
                        <i class="fas fa-list me-2"></i>Contents
                    </div>

                    <!-- Card Body -->
                    <div class="card-body p-0">
                        <div class="list-group list-group-flush" id="toc-links">
                            <a href="#cookies" class="list-group-item list-group-item-action">
                                <i class="fas fa-cookie-bite me-2 text-primary"></i>  Cookies
                            </a>
                            <a href="#license" class="list-group-item list-group-item-action">
                                <i class="fas fa-id-card me-2 text-primary"></i>  License
                            </a>
                            <a href="#must-not" class="list-group-item list-group-item-action">
                                <i class="fas fa-ban me-2 text-primary"></i>  You must not
                            </a>
                            <a href="#warranties" class="list-group-item list-group-item-action">
                                <i class="fas fa-file-signature me-2 text-primary"></i>  Warranties
                            </a>
                            <a href="#hyperlinking" class="list-group-item list-group-item-action">
                                <i class="fas fa-link me-2 text-primary"></i>  Hyperlinking
                            </a>
                            <a href="#links" class="list-group-item list-group-item-action">
                                <i class="fas fa-external-link-alt me-2 text-primary"></i>  Other Link Requests
                            </a>
                            <a href="#approved" class="list-group-item list-group-item-action">
                                <i class="fas fa-check-circle me-2 text-primary"></i> Approved Hyperlinks
                            </a>
                            <a href="#liability" class="list-group-item list-group-item-action">
                                <i class="fas fa-balance-scale me-2 text-primary"></i>  Content Liability
                            </a>
                            <a href="#rights" class="list-group-item list-group-item-action">
                                <i class="fas fa-shield-alt me-2 text-primary"></i> Reservation of Rights
                            </a>
                            <a href="#removal" class="list-group-item list-group-item-action">
                                <i class="fas fa-trash-alt me-2 text-primary"></i>  Removal of Links
                            </a>
                            <a href="#disclaimer" class="list-group-item list-group-item-action">
                                <i class="fas fa-exclamation-triangle me-2 text-primary"></i>  Disclaimer
                            </a>
                        </div>
                    </div>
                </div>
            </aside>

            <!-- Main Content -->
            <div class="col-lg-9">
                <div class="terms-section" id="cookies">
                    <h3>1. Cookies</h3>
                    <p>We employ the use of cookies. By accessing WsplCloud, you agreed to use cookies in agreement with the Wspl Hosting Solution (OPC) Private Limited's Privacy Policy.</p>
                    <p>Most interactive websites use cookies to let us retrieve the user's details for each visit. Cookies are used by our website to enable the functionality of certain areas to make it easier for people visiting our website. Some of our affiliate/advertising partners may also use cookies.</p>
                </div>

                <div class="terms-section" id="license">
                    <h3>2. License</h3>
                    <p>Unless otherwise stated, Wspl Hosting Solution (OPC) Private Limited and/or its licensors own the intellectual property rights for all material on WsplCloud. All intellectual property rights are reserved. You may access this from WsplCloud for your own personal use subjected to restrictions set in these terms and conditions.</p>
                    <p>You must not:</p>
                    <ul>
                        <li>Republish material from WsplCloud</li>
                        <li>Sell, rent or sub-license material from WsplCloud</li>
                        <li>Reproduce, duplicate or copy material from WsplCloud</li>
                        <li>Redistribute content from WsplCloud</li>
                    </ul>
                </div>

                <div class="terms-section" id="must-not">
                    <h3>3. You must not</h3>
                    <p>Certain areas of this Website are restricted from being access by you and Wspl Hosting Solution (OPC) Private Limited may further restrict access by you to any areas of this Website, at any time, in absolute discretion. Any user ID and password you may have for this Website are confidential and you must maintain confidentiality as well.</p>
                </div>

                <div class="terms-section" id="warranties">
                    <h3>4. Your Warranties</h3>
                    <p>You warrant and represent that:</p>
                    <ul>
                        <li>You are entitled to post the Comments on our website and have all necessary licenses and consents to do so;</li>
                        <li>The Comments do not invade any intellectual property right, including without limitation copyright, patent or trademark of any third party;</li>
                        <li>The Comments do not contain any defamatory, libelous, offensive, indecent or otherwise unlawful material which is an invasion of privacy</li>
                        <li>The Comments will not be used to solicit or promote business or custom or present commercial activities or unlawful activity.</li>
                    </ul>
                    <p>You hereby grant Wspl Hosting Solution (OPC) Private Limited a non-exclusive license to use, reproduce, edit and authorize others to use, reproduce and edit any of your Comments in any and all forms, formats or media.</p>
                </div>

                <div class="terms-section" id="hyperlinking">
                    <h3>5. Hyperlinking to our Content</h3>
                    <p>The following organizations may link to our Website without prior written approval:</p>
                    <ul>
                        <li>Government agencies;</li>
                        <li>Search engines;</li>
                        <li>News organizations;</li>
                        <li>Online directory distributors may link to our Website in the same manner as they hyperlink to the Websites of other listed businesses; and</li>
                        <li>System wide Accredited Businesses except soliciting non-profit organizations, charity shopping malls, and charity fundraising groups which may not hyperlink to our Web site.</li>
                    </ul>
                </div>

                <div class="terms-section" id="links">
                    <h3>6. Other Link Requests</h3>
                    <p>We may consider and approve other link requests from the following types of organizations:</p>
                    <ul>
                        <li>commonly-known consumer and/or business information sources;</li>
                        <li>dot.com community sites;</li>
                        <li>associations or other groups representing charities;</li>
                        <li>online directory distributors;</li>
                        <li>internet portals;</li>
                        <li>accounting, law and consulting firms; and</li>
                        <li>educational institutions and trade associations.</li>
                    </ul>
                </div>

                <div class="terms-section" id="approved">
                    <h3>7. Approved Hyperlinks</h3>
                    <p>Approved organizations may hyperlink to our Website as follows:</p>
                    <ul>
                        <li>By use of our corporate name; or</li>
                        <li>By use of the uniform resource locator being linked to; or</li>
                        <li>By use of any other description of our Website being linked to that makes sense within the context and format of content on the linking party's site.</li>
                    </ul>
                    <p>No use of Wspl Hosting Solution (OPC) Private Limited's logo or other artwork will be allowed for linking absent a trademark license agreement.</p>
                </div>

                <div class="terms-section" id="liability">
                    <h3>8. Content Liability</h3>
                    <p>We shall not be hold responsible for any content that appears on your Website. You agree to protect and defend us against all claims that is rising on your Website. No link(s) should appear on any Website that may be interpreted as libelous, obscene or criminal, or which infringes, otherwise violates, or advocates the infringement or other violation of, any third party rights.</p>
                </div>

                <div class="terms-section" id="rights">
                    <h3>9. Reservation of Rights</h3>
                    <p>We reserve the right to request that you remove all links or any particular link to our Website. You approve to immediately remove all links to our Website upon request. We also reserve the right to amen these terms and conditions and it's linking policy at any time. By continuously linking to our Website, you agree to be bound to and follow these linking terms and conditions.</p>
                </div>

                <div class="terms-section" id="removal">
                    <h3>10. Removal of Links</h3>
                    <p>If you find any link on our Website that is offensive for any reason, you are free to contact and inform us any moment. We will consider requests to remove links but we are not obligated to or so or to respond to you directly.</p>
                    <p>We do not ensure that the information on this website is correct, we do not warrant its completeness or accuracy; nor do we promise to ensure that the website remains available or that the material on the website is kept up to date.</p>
                </div>

                <div class="terms-section" id="disclaimer">
                    <h3>11. Disclaimer</h3>
                    <p>To the maximum extent permitted by applicable law, we exclude all representations, warranties and conditions relating to our website and the use of this website. Nothing in this disclaimer will:</p>
                    <ul>
                        <li>limit or exclude our or your liability for death or personal injury;</li>
                        <li>limit or exclude our or your liability for fraud or fraudulent misrepresentation;</li>
                        <li>limit any of our or your liabilities in any way that is not permitted under applicable law; or</li>
                        <li>exclude any of our or your liabilities that may not be excluded under applicable law.</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <?php require_once BASE_PATH . '/partial/footer.php'; ?>

    <?php
    // Include footer scripts with page-specific TOC functionality
    $page_scripts = [
        '<script>
            $(document).ready(function() {
                // Highlight active section in TOC
                $(window).scroll(function() {
                    var currentSection = "";
                    var scrollPos = $(window).scrollTop() + 100;
                    $(".terms-section").each(function() {
                        var sectionTop = $(this).offset().top;
                        var sectionBottom = sectionTop + $(this).outerHeight();

                        if (scrollPos >= sectionTop && scrollPos < sectionBottom) {
                            currentSection = $(this).attr("id");
                        }
                    });

                    $("#toc-links a").removeClass("active-section");
                    if (currentSection) {
                        $("#toc-links a[href=\"#" + currentSection + "\"]").addClass("active-section");
                    }
                });

                // Smooth scroll for TOC links
                $("#toc-links a").on("click", function(e) {
                    e.preventDefault();
                    var target = $(this).attr("href");
                    $("html, body").animate({
                        scrollTop: $(target).offset().top - 80
                    }, 800);
                });
            });
        </script>'
    ];
    require_once BASE_PATH . '/partial/footer_scripts.php';
    ?>
