<?php 
require_once __DIR__ . '/../config.php';
// Set page-specific variables
$page_title = 'Home | WsplCloud - Web Hosting & Cloud Services';
$page_description = 'WsplCloud offers reliable web hosting, domain registration, and cloud services for businesses of all sizes. 24/7 support and guaranteed uptime.';
$page_keywords = 'web hosting, cloud hosting, vps, wordpress hosting, domain registration, shared hosting, reseller hosting';
// Set custom CSS for this page (array of filenames, header_meta will include them)
$custom_css = ['priceslider.css', 'mobile.css', 'mobile-extra.css'];
// Include header meta (DOCTYPE, <head>, opening <body> tag)
require_once BASE_PATH . '/partial/header_meta.php';
// Include the navigation header
require_once BASE_PATH . '/partial/header.php'; 
?>
<style>
    
@media only screen and (max-width: 767px) {
    .banner-main-con,
    .sub-banner-main-con,
    .hosting-pages-sub-banner,
    .banner-main-con .sub-banner-inner-con,
    .sub-banner-main-con .container {
        padding-top: 100px !important;
        padding-bottom: 100px !important;
        min-height: 500px !important;
        display: flex !important;
        align-items: center !important;
        justify-content: center !important;
        text-align: center !important;
    }
    /* Ensure headings remain readable and centered */
    .banner-main-con h1,
    .sub-banner-main-con h1,
    .hosting-pages-sub-banner h1 {
        font-size: 28px !important;
        line-height: 1.15 !important;
        margin: 0 auto !important;
        max-width: 92% !important;
    }
}
</style>
    <!-- BANNER SECTION START HERE (use unified sub-banner style like other pages) -->
  <?php include BASE_PATH . '/partial/hero-ban.php'; ?>

    <!-- BANNER SECTION END HERE -->
    <!-- HOSTING TYPES SECTION START HERE -->
    <section class="hosting-types-main-con w-100 float-left padding-top padding-bottom">
        <div class="container">
            <div class="generic-title text-center wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
                <h2>Choose hosting plan for you needs</h2>
                <p >We provide premium website & <span class="d-inline-block">Fastest hosting</span> as well as offering our web development and administration services to our amazing customers.</p>
            </div>
            <div class="hosting-types-inner-con wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
                
                <div class="hosting-type-box">
                    <div class="hosting-top-img-con">
                        <figure>
                            <img src="<?= asset('images/plan-img1.jpg') ?>" alt="plan-img2">
                        </figure>
                    </div>
                    <div class="hosting-type-content-con plan2-flower">
                        <h5>Shared Hosting</h5>
                        <p>All-in-one shared hosting for growing websites. Fast, secure, and feature-rich.</p>
                        <div class="hosting-price-box">
                            <span class="dollar">₹</span> <span id="price_val2" class="numeric1">30</span>
                            <div class="month-title">
                                <span id="point_val2" class="numeric2"> </span>
                                <br>
                                <small>/month</small>
                            </div>
                        </div>
                        <ul class="list-unstyled">
                            <li class="position-relative"><i class="fas fa-check"></i> 1GB <span>SSD Web Space</span></li>
                            <li class="position-relative"><i class="fas fa-check"></i> 100 GB <span>Bandwidth</span></li>
                            <li class="position-relative"><i class="fas fa-check"></i> <span>Single Domain</span></li>
                            <li class="position-relative"><i class="fas fa-check"></i> 2 <span>Databases</span></li>
                            <li class="position-relative"><i class="fas fa-check"></i> 3 <span>Emails</span></li>
                            <li class="position-relative"><i class="fas fa-check"></i> <span>Extra Backup</span></li>
                        </ul>
                        <div class="primary-btn">
                            <a href="">DISCOVER PLAN <i class="fas fa-arrow-right"></i></a>
                        </div>
                    </div>
             </div>
             <div class="hosting-type-box">
                    <div class="hosting-top-img-con">
                        <figure>
                            <img src="<?= asset('images/plan-img2.jpg') ?>" alt="plan-img2">
                        </figure>
                    </div>
                    <div class="hosting-type-content-con plan2-flower">
                        <h5>Cloud Hosting</h5>
                        <p>Cloud hosting for high-traffic sites. Maximum speed, security, flexibility.</p>
                        <div class="hosting-price-box">
                            <span class="dollar">₹</span> <span id="price_val2" class="numeric1">199</span>
                            <div class="month-title">
                                <span id="point_val2" class="numeric2"> </span>
                                <br>
                                <small>/month</small>
                            </div>
                        </div>
                        <ul class="list-unstyled">
                            <li class="position-relative"><i class="fas fa-check"></i> 1<span>Cloud Websites</span></li>
                            <li class="position-relative"><i class="fas fa-check"></i> 2 <span>Core CPU</span></li>
                            <li class="position-relative"><i class="fas fa-check"></i> 50GB SSD<span> Storage</span></li>
                            <li class="position-relative"><i class="fas fa-check"></i> Unlimited <span>Bandwidth</span></li>
                            <li class="position-relative"><i class="fas fa-check"></i> Free <span>SSL Certificate</span></li>
                            <li class="position-relative"><i class="fas fa-check"></i> Daily <span>Backups</span></li>
                        </ul>
                        <div class="primary-btn">
                            <a href="">DISCOVER PLAN <i class="fas fa-arrow-right"></i></a>
                        </div>
                    </div>
                </div>
                <div class="hosting-type-box">
                    <div class="hosting-top-img-con">
                        <figure>
                            <img src="<?= asset('images/plan-img3.jpg') ?>" alt="plan-img3">
                        </figure>
                    </div>
                    <div class="hosting-type-content-con plan3-flower">
                        <h5>VPS Servers</h5>
                        <p>Experience the power of dedicated resources with our lightning-fast VPS.</p>
                        <div class="hosting-price-box">
                            <span class="dollar">₹</span> <span id="price_val2" class="numeric1">499</span>
                            <div class="month-title">
                                <span id="point_val2" class="numeric2"> </span>
                                <br>
                                <small>/Yr</small>
                            </div>
                        </div>
                        <ul class="list-unstyled">
                            <li class="position-relative"><i class="fas fa-check"></i> CPU Cores <span>2 Cores</span></li>
                            <li class="position-relative"><i class="fas fa-check"></i> RAM <span>16GB</span></li>
                            <li class="position-relative"><i class="fas fa-check"></i> Storage <span>200GB SSD</span></li>
                            <li class="position-relative"><i class="fas fa-check"></i> I/O Speed <span>200Mbps</span></li>
                            <li class="position-relative"><i class="fas fa-check"></i> Bandwidth <span>Unlimited</span></li>
                            <li class="position-relative"><i class="fas fa-check"></i> Backup <span>Extra</span></li>
                        </ul>
                        <div class="primary-btn">
                            <a href="">DISCOVER PLAN <i class="fas fa-arrow-right"></i></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- HOSTING TYPES SECTION END HERE -->
   
    <!-- SEARCH DOMAIN SECTION END HERE -->
    <section class="dedicated-features-con advance-web-features-con w-100 float-left pb-100">
        <div class="container">
            <div class="feature-main-con">
                <div class="generic-title text-center wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
                    <h2>Advanced Web Hosting Features</h2>
                    <p>Powerful Web Hosting Features to Elevate Your Online Presence <br>
Everything You Need for a Secure, Speedy, and Professional Website — At No Extra Cost!</p>
                    <a class="arrow-btn" href="shared-hosting.php">Explore all features <i class="fas fa-arrow-right"></i></a>
                </div>
                <div class="feature-inner-con wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
                    <div class="feature-box">
                        <figure>
                            <img src="<?= asset('images/feature-img1.png') ?>" alt="feature-img1">
                        </figure>
                        <div class="feature-side-txt-con">
                            <h5>Maximum Performance</h5>
                            <p>Experience lightning-fast website loading and unmatched performance with our SSD-powered servers. We optimize every server for speed, uptime, and reliability, ensuring your site stays online and performs at its best.</p>
                            <a class="arrow-btn" href="shared-hosting.php">Learn More <i class="fas fa-arrow-right"></i></a>
                        </div>
                    </div>
                    <div class="feature-box">
                        <figure>
                            <img src="<?= asset('images/feature-img2.png') ?>" alt="feature-img2">
                        </figure>
                        <div class="feature-side-txt-con">
                            <h5>WordPress Pre-Instaled</h5>
                            <p>Start building your WordPress website instantly — no setup required! Our hosting plans come with WordPress pre-installed so you can launch your blog, portfolio, or online store right away.</p>
                            <a class="arrow-btn" href="shared-hosting.php">Learn More <i class="fas fa-arrow-right"></i></a>
                        </div>
                    </div>
                    <div class="feature-box">
                        <figure>
                            <img src="<?= asset('images/feature-img3.png') ?>" alt="feature-img3">
                        </figure>
                        <div class="feature-side-txt-con">
                            <h5>Free Let’s Encrypt SSL</h5>
                            <p>Encrypt all traffic, boost your search rankings, and build trust with a secure HTTPS connection — included in all hosting plans.</p>
                            <a class="arrow-btn" href="shared-hosting.php">Learn More <i class="fas fa-arrow-right"></i></a>
                        </div>
                    </div>
                    <div class="feature-box">
                        <figure>
                            <img src="<?= asset('images/feature-img4.png') ?>" alt="feature-img4">
                        </figure>
                        <div class="feature-side-txt-con">
                            <h5>Advanced Management</h5>
                            <p>Manage your website like a pro with our user-friendly cPanel interface, advanced file manager, email tools, database access, and more — perfect for both beginners and developers.</p>
                            <a class="arrow-btn" href="shared-hosting.php">Learn More <i class="fas fa-arrow-right"></i></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- HOSTING SOLUTION SECTION START HERE -->
    <section class="hosting-solution-main-con w-100 float-left padding-top padding-bottom">
        <div class="container">
            <div class="hosting-solution-inner-con wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
                <div class="hosting-solution-img-con">
                    <figure class="mb-0">
                        <img src="<?= asset('images/hosting-solution-img.png') ?>" alt="hosting-solution-img">
                    </figure>
                </div>
                <div class="hosting-solution-content-con">
                    <span class="d-block">More Than Just Hosting — We Deliver Speed, Security & Simplicity</span>
                    <h2>WordPress Made <br>  Fast, Secure & Simple</h2>
                    <p>Launch, manage, and grow your WordPress site with ease. Our optimized WordPress hosting is designed to give you blazing-fast performance, rock-solid security, and tools that make building your website simple.</p>
                    <ul class="list-unstyled">
                        <li class="position-relative"><i class="fas fa-check-circle"></i>One-Click WordPress Installation</li>
                        <li class="position-relative"><i class="fas fa-check-circle"></i>Automatic Updates & Daily Backups</li>
                        <li class="position-relative"><i class="fas fa-check-circle"></i>Free SSL & Advanced Security Features
</li>
                         <li class="position-relative"><i class="fas fa-check-circle"></i>Optimized Servers for Lightning-Fast Load Times</li>
                    </ul>
                </div>
            </div>
        </div>
    </section>
    <!-- HOSTING SOLUTION SECTION END HERE -->
    <!-- SECURITY FEATURES SECTION START HERE -->
    <section class="security-feature-main-con w-100 float-left padding-top padding-bottom">
        <div class="container">
            <div class="security-feature-inner-con wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
                <div class="security-feature-left-con">
                    <span class="d-block">WEB HOSTING</span>
                    <h2>Smart & Reliable Hosting Solutions</h2>
                    <p>Get your website live in minutes with our seamless setup, powerful tools, and lightning-fast performance. Whether you’re building a personal blog or a professional business site, we make hosting effortless.</p>
                    <div class="primary-btn">
                        <a href="shared-hosting.php">LEARN MORE <i class="fas fa-arrow-right"></i></a>
                    </div>
                </div>
                <div class="security-feature-video-outer-con">
                    <div class="security-feature-video-con text-left">
                        <h5>Your website deserves speed, security, and stability.</h5>
                        <div class="security-features-video">
                            <div class="video-inner-con position-relative">
                                <div class="video-play-icon d-inline-block">
                                    <a href="javascript:void(0)" onclick="lightbox_open();">
                                        <figure class="mb-0">
                                            <img src="<?= asset('images/video-play-img.png') ?>" alt="video-play-img">
                                        </figure>
                                        <span class="d-block">Watch this quick video to learn more.</span>
                                    </a>
                                </div>
                            </div>
                            <div id="light">
                                <a class="boxclose" id="boxclose" onclick="lightbox_close();"></a>
                                <div id="VisaChipCardVideo">
                                    <iframe src="https://www.youtube.com/embed/mq508HXzccI?si=GSsq5WNpSIaHnRLn"
                                        title="YouTube video player"></iframe>
                                    <!--Browser does not support <video> tag -->
                                </div>
                            </div>
                
                            <div id="fade" onClick="lightbox_close();"></div>
                        </div>
                    </div>
                    <div class="security-feature-content-con">
                        <ul class="list-unstyled mb-0">
                            <li class="position-relative"><i class="fas fa-check-circle"></i>Free SSL certificates to keep your site secure.</li>
                            <li class="position-relative"><i class="fas fa-check-circle"></i>DDoS protection & advanced firewall for safe browsing.</li>
                            <li class="position-relative"><i class="fas fa-check-circle">

                            </i>99.9% uptime guarantee with high-performance servers.</li>
                        </ul>
                    </div>
                    <div class="security-shape1">
                        <figure class="mb-0">
                            <img src="<?= asset('images/security-feature-shape1.png') ?>" alt="security-feature-shape1">
                        </figure>
                    </div>
                    <div class="security-shape2">
                        <figure class="mb-0">
                            <img src="<?= asset('images/security-feature-shape2.png') ?>" alt="security-feature-shape2">
                        </figure>
                    </div>
                    <div class="security-shape3">
                        <figure class="mb-0">
                            <img src="<?= asset('images/security-feature-shape3.png') ?>" alt="security-feature-shape3">
                        </figure>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- SECURITY FEATURES SECTION END HERE -->
    <!-- SUPPORT BOXES START -->
     <section class="client-review-main-con w-100 float-left padding-top padding-bottom">
        <div class="container-fluid">
            <div class="client-review-inner-con wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
                <div class="generic-title text-center"><br>
                    <h2>Reliable Hosting Infrastructure and Support</h2>
                    <p>We are providing Your Foundation for Unshakeable Online Performance</p>
                </div><br>
    <div class="support-boxes-main-con w-100 float-left padding-bottom">
        <div class="container">
            <div class="support-boxes-inner-con wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
                    <div class="support-box">
                    <figure>
                        <img src="<?= asset('images/support-img1.png') ?>" alt="support-img1">
                    </figure>
                    <span class="d-block">Multiple Tier-4 data centers</span>
                </div>
                <div class="support-box">
                    <figure>
                        <img src="<?= asset('images/support-img2.png') ?>" alt="support-img2">
                    </figure>
                    <span class="d-block">Optimized routing & peering</span>
                </div>
                <div class="support-box">
                    <figure>
                        <img src="<?= asset('images/support-img3.png') ?>" alt="support-img3">
                    </figure>
                    <span class="d-block">99.99% Network uptime</span>
                </div>
                <div class="support-box">
                    <figure>
                        <img src="<?= asset('images/support-img4.png') ?>" alt="support-img4">
                    </figure>
                    <span class="d-block">24/7 Real-Time Expert Support</span>
                </div>
            </div>
        </div>
    </div>
</div>
                                    </div>
                                    </section>
    <!-- SUPPORT BOXES END -->
 
    <!-- PARTNER SECTION START HERE -->
    <section class="global-partners-main-con w-100 float-left pt-100 padding-bottom">
        <div class="container">
            <div class="generic-title text-center wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
                <h2 class="mb-0">Our Partners</h2>
            </div>
            <div class="global-partners-inner-con wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
                <ul class="list-unstyled mb-0">
                    <li>
                        <figure class="mb-0">
                            <img src="<?= asset('images/g-partner-img1.png') ?>" alt="g-partner-img1">
                        </figure>
                    </li>
                    <li>
                        <figure class="mb-0">
                            <img src="<?= asset('images/g-partner-img2.png') ?>" alt="g-partner-img2">
                        </figure>
                    </li>
                    <li>
                        <figure class="mb-0">
                            <img src="<?= asset('images/g-partner-img3.png') ?>" alt="g-partner-img3">
                        </figure>
                    </li>
                    <li>
                        <figure class="mb-0">
                            <img src="<?= asset('images/g-partner-img4.png') ?>" alt="g-partner-img4">
                        </figure>
                    </li>
                    <li>
                        <figure class="mb-0">
                            <img src="<?= asset('images/g-partner-img5.png') ?>" alt="g-partner-img5">
                        </figure>
                    </li>
                    <li>
                        <figure class="mb-0">
                            <img src="<?= asset('images/g-partner-img6.png') ?>" alt="g-partner-img6">
                        </figure>
                    </li>
                    <li>
                        <figure class="mb-0">
                            <img src="<?= asset('images/g-partner-img7.png') ?>" alt="g-partner-img7">
                        </figure>
                    </li>
                    <li>
                        <figure class="mb-0">
                            <img src="<?= asset('images/g-partner-img8.png') ?>" alt="g-partner-img8">
                        </figure>
                    </li> 
                </ul>
            </div>
        </div>
    </section>
    <!-- PARTNER SECTION END HERE -->
   
 

<!-- Include footer -->
<?php require_once BASE_PATH . '/partial/footer.php'; ?>

<!-- Include Offers Popup -->
<?php require_once BASE_PATH . '/pages/popup.php'; ?>
