<?php require_once __DIR__ . '/../config.php'; ?>
      <link rel="icon" type="image/png" sizes="16x16" href="<?= asset('favicon_io/fav.png') ?>">
    <meta name="msapplication-TileColor" content="#ffffff">
    <meta name="msapplication-TileImage" content="/ms-icon-144x144.png">
    <meta name="theme-color" content="#ffffff">
    <title>About WsplCloud: Company History, Mission & Expert Team</title>
    <meta name="description" content="Learn about WsplCloud's journey, our commitment to web hosting excellence, and our expert team. Discover our history, mission, and values as a leading cloud solutions provider.">
    <meta name="keywords" content="about WsplCloud, WsplCloud history, web hosting company, cloud solutions provider, company mission, team experts, web development, hosting excellence, reliable hosting, secure cloud, expert team">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.15.4/css/all.css">
    <link rel="stylesheet" href="<?= asset('bootstrap/bootstrap.min.css') ?>">
    <link rel="stylesheet" href="<?= asset('css/owl.carousel.css') ?>">
    <link rel="stylesheet" href="<?= asset('css/animate.css') ?>">
    <link rel="stylesheet" href="<?= asset('css/custom.css') ?>">
    <link rel="stylesheet" href="<?= asset('css/mobile.css') ?>">
    <style>

         :root {
            --primary-color: #fff;
            --secondary-color: #131329;
            --accent: #0000ff;
            --text-color: #4d5b6c;
            --border-color: #e4e4e4;
            --yellow-color: #ffd200;
            --timeline-gradient: rgba(255, 255, 255, 1) 0%, rgba(255, 255, 255, 1) 50%, rgba(255, 255, 255, 0) 100%;
        }
        
        *,
        *::before,
        *::after {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        button {
            background: transparent;
            border: none;
            cursor: pointer;
            outline: none;
        }
        
        a {
            color: inherit;
        }
        
        img {
            max-width: 100%;
            height: auto;
        }
        
        body {
            font: normal 16px/1.5 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
            background: var(--primary-color);
            color: var(--text-color);
            margin-bottom: 50px;
            position: relative;
            overflow-x: hidden;
        }
        /* Ocean background elements */
        
        .ocean-bg {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: -1;
            pointer-events: none;
        }
        
        .wave {
            position: absolute;
            bottom: 0;
            left: 0;
            width: 100%;
            height: 100px;
            background: url('data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1200 120" preserveAspectRatio="none"><path d="M0,0V46.29c47.79,22.2,103.59,32.17,158,28,70.36-5.37,136.33-33.31,206.8-37.5C438.64,32.43,512.34,53.67,583,72.05c69.27,18,138.3,24.88,209.4,13.08,36.15-6,69.85-17.84,104.45-29.34C989.49,25,1113-14.29,1200,52.47V0Z" opacity=".25" fill="%230000ff"/><path d="M0,0V15.81C13,36.92,27.64,56.86,47.69,72.05,99.41,111.27,165,111,224.58,91.58c31.15-10.15,60.09-26.07,89.67-39.8,40.92-19,84.73-46,130.83-49.67,36.26-2.85,70.9,9.42,98.6,31.56,31.77,25.39,62.32,62,103.63,73,40.44,10.79,81.35-6.69,119.13-24.28s75.16-39,116.92-43.05c59.73-5.85,113.28,22.88,168.9,38.84,30.2,8.66,59,6.17,87.09-7.5,22.43-10.89,48-26.93,60.65-49.24V0Z" opacity=".5" fill="%230000ff"/><path d="M0,0V5.63C149.93,59,314.09,71.32,475.83,42.57c43-7.64,84.23-20.12,127.61-26.46,59-8.63,112.48,12.24,165.56,35.4C827.93,77.22,886,95.24,951.2,90c86.53-7,172.46-45.71,248.8-84.81V0Z" fill="%230000ff"/></svg>');
            background-size: 1200px 100px;
            animation: wave 12s linear infinite;
        }
        
        .wave:nth-child(2) {
            bottom: 10px;
            opacity: 0.5;
            animation: wave 10s linear infinite reverse;
        }
        
        .wave:nth-child(3) {
            bottom: 15px;
            opacity: 0.7;
            animation: wave 15s linear infinite;
        }
        
        @keyframes wave {
            0% {
                background-position-x: 0;
            }
            100% {
                background-position-x: 1200px;
            }
        }
        
        .bubble {
            position: absolute;
            border-radius: 50%;
            background: rgba(0, 0, 255, 0.2);
            animation: float 15s infinite ease-in-out;
        }
        
        @keyframes float {
            0% {
                transform: translateY(0) translateX(0);
                opacity: 0;
            }
            10% {
                opacity: 1;
            }
            90% {
                opacity: 1;
            }
            100% {
                transform: translateY(-100vh) translateX(100px);
                opacity: 0;
            }
        }
        /* .section SECTION */
        
        .section {
            padding: 80px 0;
            background: var(--primary-color);
        }
        
        .section .container {
            width: 90%;
            max-width: 1200px;
            margin: 0 auto;
            text-align: center;
        }
        
        .section h1 {
            font-size: 2.5rem;
            line-height: 1.25;
            color: var(--secondary-color);
            font-weight: 700;
        }
        
        .section h2 {
            font-size: 1.8rem;
            color: var(--secondary-color);
            font-weight: 700;
        }

        /* Timeline Section Title */
        .timeline-header {
            text-align: center;
            margin-bottom: 60px;
            padding: 0 20px;
        }

        .timeline-header h1 {
            font-size: 3.5rem;
            font-weight: 700;
            color: var(--secondary-color);
            margin-bottom: 20px;
            position: relative;
            display: inline-block;
        }



        .timeline-header p {
            font-size: 1.2rem;
            color: var(--text-color);
            max-width: 600px;
            margin: 0 auto;
            line-height: 1.7;
        }

        @media screen and (max-width: 768px) {
            .timeline-header h1 {
                font-size: 2.5rem;
            }
            
            .timeline-header p {
                font-size: 1.1rem;
            }
        }
        
        /* TIMELINE */
        
        .timeline {
            position: relative;
            white-space: nowrap;
            max-width: 1400px;
            padding: 0 10px;
            margin: 0 auto;
            display: grid;
            grid-template-columns: 320px auto;
            grid-gap: 20px;
        }
        
        .timeline::before,
        .timeline::after {
            content: "";
            position: absolute;
            top: 0;
            bottom: 30px;
            width: 100px;
            z-index: 2;
        }
        
        .timeline::after {
            right: 0;
            background: linear-gradient(270deg, var(--timeline-gradient));
        }
        
        .timeline::before {
            left: 340px;
            background: linear-gradient(90deg, var(--timeline-gradient));
        }
        
        .timeline .info {
            display: flex;
            flex-direction: column;
            justify-content: center;
            padding: 40px;
            color: var(--primary-color);
            background: linear-gradient(135deg, var(--accent) 0%, var(--secondary-color) 100%);
            white-space: normal;
            border-radius: 15px;
            box-shadow: 0 20px 60px rgba(0, 0, 255, 0.15);
        }
        
        .timeline .info img {
            margin-bottom: 20px;
            border-radius: 50%;
        }
        
        .timeline .info h2 {
            color: var(--primary-color);
            font-size: 1.8rem;
            margin-bottom: 15px;
        }
        
        .timeline .info p {
            margin-top: 10px;
            color: rgba(255, 255, 255, 0.9);
            line-height: 1.6;
        }
        
        .timeline .info a {
            text-decoration: none;
            color: var(--yellow-color);
            font-weight: 600;
            transition: all 0.3s ease;
        }
        
        .timeline .info a:hover {
            color: var(--primary-color);
            text-decoration: underline;
        }
        
        .timeline ol::-webkit-scrollbar {
            height: 12px;
        }
        
        .timeline ol::-webkit-scrollbar-thumb,
        .timeline ol::-webkit-scrollbar-track {
            border-radius: 6px;
        }
        
        .timeline ol::-webkit-scrollbar-thumb {
            background: var(--accent);
        }
        
        .timeline ol::-webkit-scrollbar-track {
            background: var(--yellow-color);
        }
        
        .timeline ol {
            font-size: 0;
            padding: 250px 0;
            transition: all 1s;
            overflow-x: scroll;
            scroll-snap-type: x mandatory;
            scrollbar-color: var(--accent) var(--yellow-color);
        }
        
        .timeline ol li {
            position: relative;
            display: inline-block;
            list-style-type: none;
            width: 160px;
            height: 6px;
            background: linear-gradient(90deg, var(--accent), var(--secondary-color));
            scroll-snap-align: start;
            border-radius: 3px;
            box-shadow: 0 4px 15px rgba(0, 0, 255, 0.1);
        }
        
        .timeline ol li:last-child {
            width: 340px;
        }
        
        .timeline ol li:not(:first-child) {
            margin-left: 14px;
        }
        
        .timeline ol li:not(:last-child)::after {
            content: "";
            position: absolute;
            top: 50%;
            left: calc(100% + 1px);
            bottom: 0;
            width: 18px;
            height: 18px;
            transform: translateY(-50%);
            border-radius: 50%;
            background: var(--accent);
            border: 3px solid var(--primary-color);
            z-index: 1;
            box-shadow: 0 4px 15px rgba(0, 0, 255, 0.3);
        }
        
        .timeline ol li div {
            position: absolute;
            left: calc(100% + 7px);
            width: 300px;
            padding: 20px;
            font-size: 1rem;
            white-space: normal;
            color: var(--text-color);
            background: var(--primary-color);
            border-radius: 10px;
            border: 1px solid var(--border-color);
            box-shadow: 0 15px 40px rgba(0, 0, 0, 0.1);
        }
        
        .timeline ol li div::before {
            content: "";
            position: absolute;
            top: 100%;
            left: 0;
            width: 0;
            height: 0;
            border-style: solid;
        }
        
        .timeline ol li:nth-child(odd) div {
            top: -16px;
            transform: translateY(-100%);
            border-radius: 10px 10px 10px 0;
        }
        
        .timeline ol li:nth-child(odd) div::before {
            top: 100%;
            border-width: 10px 10px 0 0;
            border-color: var(--primary-color) transparent transparent transparent;
        }
        
        .timeline ol li:nth-child(even) div {
            top: calc(100% + 16px);
        }
        
        .timeline ol li:nth-child(even) div::before {
            top: -10px;
            border-width: 10px 0 0 10px;
            border-color: transparent transparent transparent var(--primary-color);
        }
        
        .timeline time {
            display: block;
            font-size: 1.5rem;
            font-weight: 700;
            margin-bottom: 10px;
            color: var(--accent);
        }
        /* Timeline content always visible */
        
        .timeline ol li div {
            opacity: 1;
            transform: scale(1);
            transition: none;
        }
        /* Animation for timeline items */
        
        .timeline ol li {
            opacity: 0;
            animation: slideInFromBottom 0.8s ease forwards;
        }
        
        .timeline ol li:nth-child(1) {
            animation-delay: 0.1s;
        }
        
        .timeline ol li:nth-child(2) {
            animation-delay: 0.2s;
        }
        
        .timeline ol li:nth-child(3) {
            animation-delay: 0.3s;
        }
        
        .timeline ol li:nth-child(4) {
            animation-delay: 0.4s;
        }
        
        .timeline ol li:nth-child(5) {
            animation-delay: 0.5s;
        }
        
        .timeline ol li:nth-child(6) {
            animation-delay: 0.6s;
        }
        
        .timeline ol li:nth-child(7) {
            animation-delay: 0.7s;
        }
        
        .timeline ol li:nth-child(8) {
            animation-delay: 0.8s;
        }
        
        .timeline ol li:nth-child(9) {
            animation-delay: 0.9s;
        }
        
        .timeline ol li:nth-child(10) {
            animation-delay: 1.0s;
        }
        
        .timeline ol li:nth-child(11) {
            animation-delay: 1.1s;
        }
        
        .timeline ol li:nth-child(12) {
            animation-delay: 1.2s;
        }
        
        @keyframes slideInFromBottom {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        /* MOBILE RESPONSIVE DESIGN */

        @media only screen and (max-width: 767px) {
    .banner-main-con,
    .sub-banner-main-con,
    .hosting-pages-sub-banner,
    .banner-main-con .sub-banner-inner-con,
    .sub-banner-main-con .container {
        padding-top: 100px !important;
        padding-bottom: 100px !important;
        max-height: 400px !important;
        display: flex !important;
        align-items: center !important;
        justify-content: center !important;
        text-align: center !important;
    }
    /* Ensure headings remain readable and centered */
    .banner-main-con h1,
    .sub-banner-main-con h1,
    .hosting-pages-sub-banner h1 {
        font-size: 28px !important;
        line-height: 1.15 !important;
        margin: 0 auto !important;
        max-width: 92% !important;
    }
}
        
        @media screen and (max-width: 1024px) {
            .timeline-header h1 {
                font-size: 3rem;
            }
            
            .timeline {
                grid-template-columns: 280px auto;
                grid-gap: 15px;
            }
            
            .timeline .info {
                padding: 30px;
                max-height: 400px;
            }
            
            .timeline ol li div {
                width: 280px;
                padding: 18px;
            }
        }
        
        @media screen and (max-width: 800px) {
            .timeline-header {
                margin-bottom: 40px;
                padding: 0 15px;
            }
            
            .timeline-header h1 {
                font-size: 2.5rem;
                margin-bottom: 15px;
            }
            
            .timeline-header p {
                font-size: 1.1rem;
            }
            
            .timeline {
                display: block;
                padding: 0 15px;
                position: relative;
            }
            
            .timeline::before,
            .timeline::after {
                display: none;
            }
            
            .timeline .info {
                margin-bottom: 30px;
                padding: 25px 20px;
                max-height: 450px;
                border-radius: 12px;
                text-align: left;
            }
            
            /* Back-to-top button removed site-wide per request */
            
            .timeline .info img {
                width: 50px;
                height: 50px;
                margin-bottom: 15px;
            }
            
            .timeline .info h2 {
                font-size: 1.6rem;
                margin-bottom: 12px;
            }
            
            .timeline .info h3 {
                font-size: 1.3rem !important;
                margin-top: 20px !important;
                margin-bottom: 12px !important;
            }
            
            .timeline .info p {
                font-size: 0.95rem;
                line-height: 1.5;
                margin-top: 8px;
            }
            
            .timeline .info ul li {
                font-size: 0.9rem !important;
                margin-bottom: 8px !important;
                line-height: 1.4;
            }
            
            /* Mobile Timeline Track */
            .timeline ol {
                padding: 80px 0;
                scroll-snap-type: x mandatory;
                overflow-x: auto;
                -webkit-overflow-scrolling: touch;
            }
            
            .timeline ol::-webkit-scrollbar {
                height: 8px;
            }
            
            .timeline ol li {
                width: 140px;
                height: 5px;
                margin-bottom: 0;
            }
            
            .timeline ol li:not(:first-child) {
                margin-left: 12px;
            }
            
            .timeline ol li:not(:last-child)::after {
                width: 15px;
                height: 15px;
                border: 2px solid var(--primary-color);
            }
            
            .timeline ol li div {
                width: 280px;
                padding: 15px;
                font-size: 0.9rem;
                border-radius: 8px;
                box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
            }
            
            .timeline time {
                font-size: 1.3rem;
                margin-bottom: 8px;
            }
        }
        
        @media screen and (max-width: 480px) {
            .timeline-header h1 {
                font-size: 2rem;
                line-height: 1.2;
            }
            
            .timeline-header p {
                font-size: 1rem;
                padding: 0 10px;
            }
            
            .timeline {
                padding: 0 10px;
            }
            
            .timeline .info {
                padding: 20px 15px;
                max-height: 400px;
                margin-bottom: 25px;
            }
            
            /* Back-to-top button removed site-wide per request */
            
            .timeline .info h2 {
                font-size: 1.4rem;
            }
            
            .timeline .info h3 {
                font-size: 1.2rem !important;
                margin-top: 15px !important;
                margin-bottom: 10px !important;
            }
            
            .timeline .info p {
                font-size: 0.9rem;
                line-height: 1.4;
            }
            
            .timeline .info ul li {
                font-size: 0.85rem !important;
                margin-bottom: 6px !important;
            }
            
            /* Extra Small Mobile Timeline */
            .timeline ol {
                padding: 60px 0;
            }
            
            .timeline ol li {
                width: 120px;
                height: 4px;
            }
            
            .timeline ol li:not(:first-child) {
                margin-left: 10px;
            }
            
            .timeline ol li:not(:last-child)::after {
                width: 12px;
                height: 12px;
            }
            
            .timeline ol li div {
                width: 260px;
                padding: 12px;
                font-size: 0.85rem;
                line-height: 1.4;
            }
            
            .timeline time {
                font-size: 1.2rem;
                margin-bottom: 6px;
            }
            
            /* Mobile Touch Indicators */
            .timeline ol::before {
                content: "← Swipe to explore our journey →";
                position: absolute;
                bottom: 20px;
                left: 50%;
                transform: translateX(-50%);
                background: rgba(0, 0, 255, 0.9);
                color: white;
                padding: 8px 15px;
                border-radius: 20px;
                font-size: 0.8rem;
                white-space: nowrap;
                z-index: 10;
                animation: fadeInOut 3s infinite;
            }
            
            @keyframes fadeInOut {
                0%, 100% { opacity: 0.7; }
                50% { opacity: 1; }
            }
        }
        
        /* Landscape Mobile */
        @media screen and (max-width: 800px) and (orientation: landscape) {
            .timeline-header h1 {
                font-size: 2.2rem;
            }
            
            .timeline .info {
                max-height: 250px;
                padding: 20px;
            }
            
            .timeline ol {
                padding: 50px 0;
            }
        }
        
        /* Mobile Scroll Behavior */
        @media screen and (max-width: 800px) {
            .timeline ol li div {
                opacity: 1;
                transform: scale(1);
            }
            
            /* Enhanced mobile scrollbar */
            .timeline ol::-webkit-scrollbar {
                height: 6px;
                background: rgba(255, 210, 0, 0.2);
                border-radius: 3px;
            }
            
            .timeline ol::-webkit-scrollbar-thumb {
                background: linear-gradient(90deg, var(--accent), var(--yellow-color));
                border-radius: 3px;
            }
            
            /* Mobile info section scrollbar */
            .timeline .info::-webkit-scrollbar {
                width: 6px;
            }
            
            .timeline .info::-webkit-scrollbar-thumb {
                background: rgba(255, 255, 255, 0.4);
                border-radius: 3px;
            }
            
            .timeline .info::-webkit-scrollbar-track {
                background: rgba(255, 255, 255, 0.1);
                border-radius: 3px;
            }
        }

        /* Cursor indicators */
        
        .timeline-active::before {
            content: "� Timeline Mode: Scroll to navigate • Page scroll disabled";
            position: fixed;
            top: 20px;
            right: 20px;
            background: var(--accent);
            color: var(--primary-color);
            padding: 12px 18px;
            border-radius: 25px;
            font-size: 0.85rem;
            font-weight: 600;
            z-index: 1000;
            animation: pulse 2s infinite;
            box-shadow: 0 4px 15px rgba(0, 0, 255, 0.3);
            max-width: 280px;
            text-align: center;
            line-height: 1.3;
        }
        
        @keyframes pulse {
            0%, 100% {
                transform: scale(1);
                opacity: 0.8;
            }
            50% {
                transform: scale(1.05);
                opacity: 1;
            }
        }

        /* Cursor indicators */
        .timeline-scrollable {
            cursor: grab;
        }
        
        .timeline-scrollable:active {
            cursor: grabbing;
        }
        
        /* Page Header - REMOVED */
        /* Hide visible scrollbars for timeline while preserving scrolling behavior */
        .timeline .info,
        .timeline ol {
            -ms-overflow-style: none; /* IE and Edge */
            scrollbar-width: none; /* Firefox */
        }

        .timeline .info::-webkit-scrollbar,
        .timeline ol::-webkit-scrollbar {
            display: none;
            width: 0;
            height: 0;
        }

        /* Ensure scrolling still works */
        .timeline .info { overflow-y: auto; -webkit-overflow-scrolling: touch; }
        .timeline ol { overflow-x: auto; -webkit-overflow-scrolling: touch; }

        /* UX improvements: enable stronger snap, smoother scrolling and focused item centering */
        .timeline ol {
            scroll-snap-type: x mandatory;
            scroll-padding: 40px;
            -webkit-overflow-scrolling: touch;
        }

        .timeline ol li {
            scroll-snap-align: center;
            will-change: transform, opacity;
            transition: transform 220ms cubic-bezier(.2,.8,.2,1), box-shadow 220ms ease, opacity 220ms ease;
        }

        .timeline .info {
            transition: transform 260ms cubic-bezier(.2,.8,.2,1), box-shadow 260ms ease;
            will-change: transform;
        }
    </style>
</head>

<body>
    <?php require_once BASE_PATH . '/partial/preloader.php'; ?>
        <!-- HEADER SECTION START HERE -->
<?php require_once BASE_PATH . '/partial/header.php'; ?>
    <!-- HEADER SECTION END HERE -->
    <!-- BANNER SECTION START HERE -->
    <section class="sub-banner-main-con w-100 float-left">
        <div class="container">
            <div class="sub-banner-inner-con wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
               
                <h1>About Us</h1>
                  <span class="d-block position-relative"></span>
            <h6>
                <a href="<?= url('') ?>" style="color: #fff; transition: color 0.2s;" onmouseover="this.style.color='#FFD700'" onmouseout="this.style.color='#fff'">Home</a>
                <span style="color: #fff;"> | </span>
                <a href="<?= url('about') ?>" style="color: #fff; transition: color 0.2s;" onmouseover="this.style.color='#FFD700'" onmouseout="this.style.color='#fff'">About</a>
            </h6>
            </div>
        </div>
    </section>
    <!-- BANNER SECTION END HERE -->
      <!-- HOSTING SOLUTION SECTION START HERE -->
    <section class="hosting-solution-main-con w-100 float-left padding-top padding-bottom">
        <div class="container">
            <div class="hosting-solution-inner-con wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
                <div class="hosting-solution-img-con">
                    <figure class="mb-0">
                        <img src="<?= asset('images/about-welcome-img.png') ?>" alt="about-welcome-img">
                    </figure>
                </div>
                <div class="hosting-solution-content-con">
                    <span class="d-block">ABOUT US</span>
                    <h2>Your Trusted Partner <br>in Web Hosting and Cloud Solutions</h2>
                    <p>At WsplCloud, we are committed to delivering powerful, secure, and scalable web hosting and cloud-based solutions tailored for businesses of all sizes. Our mission is to empower startups, entrepreneurs, and enterprises with cutting-edge technology that drives growth and performance.</p>
                    <ul class="list-unstyled">
                        <li class="position-relative"><i class="fas fa-check-circle"></i>Strong foundation in website development</li>
                        <li class="position-relative"><i class="fas fa-check-circle"></i>Services including shared hosting</li>
                        <li class="position-relative"><i class="fas fa-check-circle"></i>VPS and dedicated servers</li>
                    </ul>
                </div>
            </div>
        </div>
    </section>
    <!-- HOSTING SOLUTION SECTION END HERE -->
    <!-- SUPPORT BOXES START -->
    <div class="support-boxes-main-con w-100 float-left p-100">
        <div class="container">
            <div class="support-boxes-inner-con wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
                <div class="support-box">
                    <figure>
                        <img src="<?= asset('images/Hosting-web-icon.png') ?>" alt="support-img1">
                    </figure>
                    <span class="d-block">Web Hosting Provider</span>
                </div>
                <div class="support-box">
                    <figure>
                        <img src="<?= asset('images/support-img2.png') ?>" alt="support-img2">
                    </figure>
                    <span class="d-block">50+ Worldwide Datacenter</span>
                </div>
                <div class="support-box">
                    <figure>
                        <img src="<?= asset('images/support-img3.png') ?>" alt="support-img3">
                    </figure>
                    <span class="d-block">99.99% Network uptime</span>
                </div>
                <div class="support-box">
                    <figure>
                        <img src="<?= asset('images/support-img4.png') ?>" alt="support-img4">
                    </figure>
                    <span class="d-block">24/7 Real-Time Expert Support</span>
                </div>
            </div>
        </div>
    </div>
    <!-- SUPPORT BOXES END -->
    
    <!-- TIMELINE SECTION START HERE -->
    <section class="section">
        <div class="timeline-header">
            <h1>Our Journey Through Time</h1>
        </div>
        <div class="timeline">
            <div class="info">
                <img width="60" height="60" src="data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNjAiIGhlaWdodD0iNjAiIHZpZXdCb3g9IjAgMCA2MCA2MCIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPGNpcmNsZSBjeD0iMzAiIGN5PSIzMCIgcj0iMzAiIGZpbGw9IiNGRkQyMDAiLz4KPHN2ZyB4PSIxNSIgeT0iMTUiIHdpZHRoPSIzMCIgaGVpZ2h0PSIzMCIgdmlld0JveD0iMCAwIDI0IDI0IiBmaWxsPSJub25lIiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciPgo8cGF0aCBkPSJNMTIgMkMxNy41MjI4IDIgMjIgNi40NzcxNSAyMiAxMkMyMiAxNy41MjI4IDE3LjUyMjggMjIgMTIgMjJDNi40NzcxNSAyMiAyIDE3LjUyMjggMiAxMkMyIDYuNDc3MTUgNi40NzcxNSAyIDEyIDJaIiBzdHJva2U9IiMxMzEzMjkiIHN0cm9rZS13aWR0aD0iMiIgZmlsbD0ibm9uZSIvPgo8cGF0aCBkPSJNMTIgNlYxMkw4IDE0IiBzdHJva2U9IiMxMzEzMjkiIHN0cm9rZS13aWR0aD0iMiIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjwvc3ZnPgo8L3N2Zz4K"
                    alt="Timeline Icon" />
                <h2>Company History</h2>
                <p>From humble beginnings to industry leadership, explore the key moments that define our legacy and commitment to excellence in hosting solutions.</p>
            </div>
            <ol style="scroll-behavior: smooth;">
                <li>
                    <div>
                        <time>2010</time> Founded WSPL Cloud with a vision to provide reliable and affordable hosting solutions to businesses of all sizes worldwide.
                    </div>
                </li>
                <li>
                    <div>
                        <time>2012</time> Launched our first data center in Mumbai, India, establishing a strong foundation for our cloud infrastructure services.
                    </div>
                </li>
                <li>
                    <div>
                        <time>2014</time> Expanded our services to include VPS hosting and dedicated servers, serving over 10,000 customers globally.
                    </div>
                </li>
                <li>
                    <div>
                        <time>2016</time> Introduced advanced cloud hosting solutions with 99.9% uptime guarantee and 24/7 technical support services.
                    </div>
                </li>
                <li>
                    <div>
                        <time>2018</time> Opened international data centers in Singapore and Germany, enhancing global reach and performance optimization.
                    </div>
                </li>
                <li>
                    <div>
                        <time>2020</time> Achieved ISO 27001 certification for information security management and launched managed WordPress hosting services.
                    </div>
                </li>
                <li>
                    <div>
                        <time>2021</time> Introduced AI-powered server monitoring and automated backup solutions, revolutionizing customer experience.
                    </div>
                </li>
                <li>
                    <div>
                        <time>2022</time> Reached 100,000+ satisfied customers milestone and launched green hosting initiative with renewable energy commitment.
                    </div>
                </li>
                <li>
                    <div>
                        <time>2023</time> Expanded to USA and Australia markets, offering specialized reseller hosting programs and enterprise solutions.
                    </div>
                </li>
                <li>
                    <div>
                        <time>2024</time> Launched next-generation cloud infrastructure with edge computing capabilities and enhanced security protocols.
                    </div>
                </li>
                <li>
                    <div>
                        <time>2025</time> Pioneering the future of web hosting with quantum-ready infrastructure and innovative domain management solutions.
                    </div>
                </li>
                <li></li>
            </ol>
        </div>
    </section>
    <!-- TIMELINE SECTION END HERE -->
    <script>

    <!-- Timeline UX: smooth wheel momentum + snap + prev/next controls -->
    <script>
        (function(){
            // run after DOM ready
            function initTimelineUX(){
                var track = document.querySelector('.timeline ol');
                if(!track) return;

                // create simple prev/next controls
                var ctrlPrev = document.createElement('button');
                var ctrlNext = document.createElement('button');
                ctrlPrev.className = 'timeline-ctrl timeline-prev';
                ctrlNext.className = 'timeline-ctrl timeline-next';
                ctrlPrev.setAttribute('aria-label','Previous');
                ctrlNext.setAttribute('aria-label','Next');
                ctrlPrev.innerHTML = '&#9664;';
                ctrlNext.innerHTML = '&#9654;';

                // style controls (minimal inline so no extra CSS file needed)
                var ctrlStyle = 'position:absolute;top:50%;transform:translateY(-50%);background:rgba(0,0,0,0.6);color:#fff;border-radius:50%;width:40px;height:40px;border:none;cursor:pointer;z-index:30;display:flex;align-items:center;justify-content:center;';
                ctrlPrev.style.cssText = ctrlStyle + 'left:8px;';
                ctrlNext.style.cssText = ctrlStyle + 'right:8px;';

                var container = document.querySelector('.timeline');
                if(container){
                    container.style.position = container.style.position || 'relative';
                    container.appendChild(ctrlPrev);
                    container.appendChild(ctrlNext);
                }

                var items = Array.prototype.slice.call(track.querySelectorAll('li'));
                var maxScroll = function(){ return track.scrollWidth - track.clientWidth; };

                // Smooth momentum scrolling (rAF lerp)
                var target = track.scrollLeft;
                var current = track.scrollLeft;
                var rafId = null;

                function animate(){
                    current += (target - current) * 0.15;
                    if(Math.abs(target - current) < 0.5){
                        current = target;
                    }
                    track.scrollLeft = current;
                    if(current !== target){
                        rafId = requestAnimationFrame(animate);
                    } else {
                        rafId = null;
                    }
                }

                var wheelTimeout;
                track.addEventListener('wheel', function(e){
                    e.preventDefault();
                    var delta = e.deltaY || e.detail || e.wheelDelta;
                    target = Math.max(0, Math.min(maxScroll(), target + delta * 2));
                    if(!rafId) rafId = requestAnimationFrame(animate);

                    // snap to nearest after idle
                    clearTimeout(wheelTimeout);
                    wheelTimeout = setTimeout(function(){ snapToNearest(); }, 120);
                }, { passive:false });

                // Snap helper: center nearest item
                function snapToNearest(){
                    var trackRect = track.getBoundingClientRect();
                    var trackCenter = trackRect.left + trackRect.width / 2;
                    var closest = null;
                    var closestDist = Infinity;
                    items.forEach(function(li){
                        var r = li.getBoundingClientRect();
                        var c = r.left + r.width/2;
                        var d = Math.abs(c - trackCenter);
                        if(d < closestDist){ closestDist = d; closest = li; }
                    });
                    if(closest){
                        var left = closest.offsetLeft - (track.clientWidth/2) + (closest.offsetWidth/2);
                        target = Math.max(0, Math.min(maxScroll(), left));
                        if(!rafId) rafId = requestAnimationFrame(animate);
                    }
                }

                // Prev/Next handlers
                ctrlPrev.addEventListener('click', function(){
                    // find current center item and go previous
                    var idx = items.findIndex(function(li){ return li.classList.contains('active'); });
                    if(idx <= 0) idx = 0; else idx--;
                    if(items[idx]){
                        var left = items[idx].offsetLeft - (track.clientWidth/2) + (items[idx].offsetWidth/2);
                        target = Math.max(0, Math.min(maxScroll(), left));
                        if(!rafId) rafId = requestAnimationFrame(animate);
                    }
                });

                ctrlNext.addEventListener('click', function(){
                    var idx = items.findIndex(function(li){ return li.classList.contains('active'); });
                    if(idx === -1) idx = 0; else idx++;
                    if(idx >= items.length) idx = items.length - 1;
                    if(items[idx]){
                        var left = items[idx].offsetLeft - (track.clientWidth/2) + (items[idx].offsetWidth/2);
                        target = Math.max(0, Math.min(maxScroll(), left));
                        if(!rafId) rafId = requestAnimationFrame(animate);
                    }
                });

                // Update active class on scroll (throttled)
                var scrollTick;
                track.addEventListener('scroll', function(){
                    if(scrollTick) return;
                    scrollTick = setTimeout(function(){
                        var center = track.getBoundingClientRect().left + track.clientWidth/2;
                        var closestIdx = 0; var closestDist = Infinity;
                        items.forEach(function(li, i){
                            var r = li.getBoundingClientRect();
                            var c = r.left + r.width/2;
                            var d = Math.abs(c - center);
                            if(d < closestDist){ closestDist = d; closestIdx = i; }
                        });
                        items.forEach(function(li,i){ li.classList.toggle('active', i === closestIdx); });
                        scrollTick = null;
                    }, 80);
                });

                // initial snap to first
                        setTimeout(snapToNearest, 200);
                        window.addEventListener('resize', function(){ if(!rafId) rafId = requestAnimationFrame(animate); setTimeout(snapToNearest,250); });
                    }

                    if(document.readyState === 'loading') document.addEventListener('DOMContentLoaded', initTimelineUX);
                    else initTimelineUX();
                })();
            </script>

   
    <!-- OUR TEAM SECTION START HERE -->
    <section class="team-main-con w-100 float-left pt-100 padding-bottom">
        <div class="container">
            <div class="generic-title text-center wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
                <h2>Meet Our Team</h2>
            </div>
            <div class="team-inner-con wow fadeInUp d-flex justify-content-center flex-wrap" data-wow-duration="1s" data-wow-delay="0.3s" style="gap: 30px;">
                <div class="team-member-con">
                    <div class="team-top-con">
                        <figure class="mb-0">
                            <img src="<?= asset('images/team-member-img1.png') ?>" alt="team-member-img1">
                        </figure>
                    </div>
                    <div class="team-content-con">
                        <div class="team-content-inner-con plan1-flower">
                            <h5>Mohamed Dharvesh</h5>
                            <span class="d-block">Founder And CEO</span>
                           
                        </div>
                    </div>
                </div>
                <div class="team-member-con">
                    <div class="team-top-con">
                        <figure class="mb-0">
                            <img src="<?= asset('images/team-member-img3.png') ?>" alt="team-member-img2">
                        </figure>
                    </div>
                    <div class="team-content-con">
                        <div class="team-content-inner-con plan3-flower">
                            <h5>Sabareesh</h5>
                            <span class="d-block">Learning and Development Director</span>
                           
                        </div>
                    </div>
                </div>
                <div class="team-member-con">
                    <div class="team-top-con">
                        <figure class="mb-0">
                            <img src="<?= asset('images/team-member-img2.png') ?>" alt="team-member-img3">
                        </figure>
                    </div>
                    <div class="team-content-con">
                        <div class="team-content-inner-con plan1-flower">
                            <h5>Akila Jetkin</h5>
                            <span class="d-block">VP of Sales & Marketing</span>
                            
                        </div>
                    </div>
                </div>
                <!-- New Team Member 4 -->
                <div class="team-member-con">
                    <div class="team-top-con">
                        <figure class="mb-0">
                            <img src="<?= asset('images/team-member-img3.png') ?>" alt="team-member-img4">
                        </figure>
                    </div>
                    <div class="team-content-con">
                        <div class="team-content-inner-con plan3-flower">
                            <h5>Ashraf</h5>
                            <span class="d-block">Overseas Marketing Head.</span>
                           
                        </div>
                    </div>
                </div>
                <!-- New Team Member 5 -->
                <div class="team-member-con">
                    <div class="team-top-con">
                        <figure class="mb-0">
                            <img src="<?= asset('images/team-member-img3.png') ?>" alt="team-member-img5">
                        </figure>
                    </div>
                    <div class="team-content-con">
                        <div class="team-content-inner-con plan1-flower">
                            <h5>Sethupathi</h5>
                            <span class="d-block">Sales & Services Head</span>
                           
                        </div>
                    </div>
                </div>
                 <div class="team-member-con">
                    <div class="team-top-con">
                        <figure class="mb-0">
                            <img src="<?= asset('images/team-member-img2.png') ?>" alt="team-member-img5">
                        </figure>
                    </div>
                    <div class="team-content-con">
                        <div class="team-content-inner-con plan3-flower">
                            <h5>Deepa</h5>
                            <span class="d-block">Junior Developer</span>
                           
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- OUR TEAM SECTION END HERE -->
        <!-- js start -->

    <!-- Small UX enhancement: enable native smooth scrolling for anchor navigation -->
    <script>
        (function(){
            try{
                if('scrollBehavior' in document.documentElement.style){
                    document.documentElement.style.scrollBehavior = 'smooth';
                }

                // Smooth-anchor handler (fallback for in-page anchors that might be manually handled)
                document.addEventListener('click', function(e){
                    var a = e.target.closest && e.target.closest('a[href^="#"]');
                    if(!a) return;
                    var href = a.getAttribute('href');
                    if(!href || href === '#') return;
                    var target = document.querySelector(href);
                    if(!target) return;
                    e.preventDefault();
                    var offset = 80; // header offset (adjust if your header height is different)
                    var top = target.getBoundingClientRect().top + window.pageYOffset - offset;
                    window.scrollTo({ top: top, behavior: 'smooth' });
                    // update URL without jumping
                    history.replaceState && history.replaceState(null, '', href);
                }, false);
            }catch(err){
                // silent fail — keep page functional
                console && console.warn && console.warn('Smooth-scroll init failed', err);
            }
        })();
    </script>

    <script src="<?= asset('js/jquery.min.js') ?>"></script>
    <script src="<?= asset('js/popper.min.js') ?>"></script>
    <script src="<?= asset('js/bootstrap.min.js') ?>"></script>
    <script src="<?= asset('js/owl.carousel.js') ?>"></script>
    <script src="<?= asset('js/wow.js') ?>"></script>
    <script src="<?= asset('js/custom.js') ?>"></script>

    <!-- FOOTER SECTION START HERE -->
    <?php require_once BASE_PATH . '/partial/footer.php'; ?>
    <!-- Back-to-top removed -->
    <!-- FOOTER SECTION END HERE -->
