<?php 
require_once __DIR__ . '/../config.php';

// Set page-specific variables
$page_title = '403 Forbidden | WsplCloud - Web Hosting & Cloud Services';
$page_description = 'Access to this page is forbidden. You don\'t have permission to view this resource.';
$page_keywords = '403 error, forbidden, access denied, no permission';

// Set custom CSS for this page
$custom_css = [];

// Include header meta (DOCTYPE, <head>, opening <body> tag)
require_once BASE_PATH . '/partial/header_meta.php';

// Include the navigation header
require_once BASE_PATH . '/partial/header.php';
?>

<style>
    .error-page {
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        min-height: 70vh;
        text-align: center;
        padding: 2rem;
    }
    
    .error-code {
        font-size: 8rem;
        font-weight: bold;
        color: #f8546a;
        margin-bottom: 1rem;
    }
    
    .error-message {
        font-size: 2rem;
        margin-bottom: 2rem;
    }
    
    .error-description {
        max-width: 600px;
        margin-bottom: 2rem;
    }
</style>
    
    <div class="error-page">
        <div class="error-code">403</div>
        <div class="error-message">Access Forbidden</div>
        <div class="error-description">
            <p>You don't have permission to access this page.</p>
        </div>
        <div class="generic-btn">
            <a href="<?= url('') ?>">Go to Homepage <i class="fas fa-arrow-right"></i></a>
        </div>
    </div>
    
<!-- Include footer -->
<?php require_once BASE_PATH . '/partial/footer.php'; ?>

<!-- Include footer scripts -->
<?php 
// Add page-specific scripts if needed
$page_scripts = [];
require_once BASE_PATH . '/partial/footer_scripts.php'; 
?>