/**
 * Home page specific JavaScript for WsplCloud website
 */

document.addEventListener('DOMContentLoaded', function() {
    // Initialize the domain search form
    initDomainSearch();
    
    // Initialize testimonial carousel if it exists
    initTestimonialCarousel();
    
    // Initialize pricing toggle if it exists
    initPricingToggle();
});

/**
 * Initialize domain search functionality
 */
function initDomainSearch() {
    var domainForm = document.getElementById('domain-search-form');
    if (domainForm) {
        domainForm.addEventListener('submit', function(e) {
            e.preventDefault();
            
            var domainInput = document.getElementById('domain-input');
            if (domainInput && domainInput.value.trim() !== '') {
                // Here you would normally send an AJAX request to check domain availability
                // For demonstration, we'll just show a message
                var resultContainer = document.getElementById('domain-search-results');
                if (resultContainer) {
                    resultContainer.innerHTML = '<div class="alert alert-info">Checking availability for ' + domainInput.value + '...</div>';
                    
                    // Simulate API call with timeout
                    setTimeout(function() {
                        resultContainer.innerHTML = '<div class="alert alert-success">Congratulations! ' + domainInput.value + ' is available!</div>';
                    }, 1500);
                }
            }
        });
    }
}

/**
 * Initialize testimonial carousel
 */
function initTestimonialCarousel() {
    var testimonialCarousel = document.querySelector('.testimonial-carousel');
    if (testimonialCarousel && typeof $.fn.owlCarousel !== 'undefined') {
        $(testimonialCarousel).owlCarousel({
            loop: true,
            margin: 30,
            nav: true,
            dots: true,
            autoplay: true,
            autoplayTimeout: 5000,
            smartSpeed: 1000,
            navText: [
                '<i class="fas fa-chevron-left"></i>',
                '<i class="fas fa-chevron-right"></i>'
            ],
            responsive: {
                0: {
                    items: 1
                },
                576: {
                    items: 1
                },
                768: {
                    items: 2
                },
                992: {
                    items: 3
                }
            }
        });
    }
}

/**
 * Initialize pricing toggle between monthly and yearly
 */
function initPricingToggle() {
    var pricingToggle = document.getElementById('pricing-toggle');
    if (pricingToggle) {
        pricingToggle.addEventListener('change', function() {
            var monthlyPrices = document.querySelectorAll('.price-monthly');
            var yearlyPrices = document.querySelectorAll('.price-yearly');
            
            if (this.checked) {
                // Show yearly prices
                monthlyPrices.forEach(function(elem) {
                    elem.style.display = 'none';
                });
                yearlyPrices.forEach(function(elem) {
                    elem.style.display = 'block';
                });
            } else {
                // Show monthly prices
                monthlyPrices.forEach(function(elem) {
                    elem.style.display = 'block';
                });
                yearlyPrices.forEach(function(elem) {
                    elem.style.display = 'none';
                });
            }
        });
    }
}