<?php
require_once __DIR__ . '/db.php';

try {
    // Add profile_image column if not exists
    $db->exec("ALTER TABLE users ADD COLUMN profile_image VARCHAR(255) NULL AFTER role");
    echo "Added profile_image column successfully<br>";
} catch (PDOException $e) {
    if (strpos($e->getMessage(), 'Duplicate column name') !== false) {
        echo "profile_image column already exists<br>";
    } else {
        echo "Error adding profile_image: " . $e->getMessage() . "<br>";
    }
}

try {
    // Add full_name column if not exists
    $db->exec("ALTER TABLE users ADD COLUMN full_name VARCHAR(255) NULL AFTER username");
    echo "Added full_name column successfully<br>";
} catch (PDOException $e) {
    if (strpos($e->getMessage(), 'Duplicate column name') !== false) {
        echo "full_name column already exists<br>";
    } else {
        echo "Error adding full_name: " . $e->getMessage() . "<br>";
    }
}

echo "<br>Database schema update completed!";
?>
