<?php
function optimize_images($dir, $convertToWebP = true, $removeOriginal = false) {
    $imagick_exists = class_exists('Imagick');

    if (!$imagick_exists) {
        echo "Imagick is not installed. Please install it to optimize images.\n";
        return;
    }

    $iterator = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($dir));

    foreach ($iterator as $file) {
        if ($file->isDir()) {
            continue;
        }

        $ext = strtolower($file->getExtension());
        $pathname = $file->getPathname();

        if (in_array($ext, ['jpg', 'jpeg', 'png', 'gif'])) {
            try {
                $image = new Imagick($pathname);
                $image->setImageCompressionQuality(85);
                $image->stripImage();

                if ($convertToWebP) {
                    if (!Imagick::queryFormats('WEBP')) {
                        echo "Imagick does not support WebP. Skipping WebP conversion for: " . $pathname . "\n";
                    } else {
                        $webpPath = $file->getPathInfo()->getPathname() . '/' . $file->getBasename('.' . $ext) . '.webp';
                        $image->setImageFormat('webp');
                        $image->writeImage($webpPath);
                        echo "Optimized and converted to WebP: " . $webpPath . "\n";
                        if ($removeOriginal) {
                            unlink($pathname);
                            echo "Removed original: " . $pathname . "\n";
                        }
                    }
                } else {
                    $image->writeImage($pathname);
                    echo "Optimized: " . $pathname . "\n";
                }
                $image->clear();
                $image->destroy();
            } catch (ImagickException $e) {
                echo "Error optimizing " . $pathname . ": " . $e->getMessage() . "\n";
            }
        }
    }
}

// Example usage:
// optimize_images(__DIR__ . '/assets/images', true, false); // Optimize and convert to WebP, keep originals
// optimize_images(__DIR__ . '/assets/images', true, true);  // Optimize and convert to WebP, remove originals
// optimize_images(__DIR__ . '/assets/images', false, false); // Only optimize, keep original format

// For initial run, let's convert to WebP and keep originals for now.
optimize_images(__DIR__ . '/assets/images', true, false);
?>
