<?php
/**
 * Premium Hero Banner with Smooth Animations
 * Enhanced performance and better user experience
 */

// Get hero banner data from database
$db = get_db();
$hero_banner = null;
if ($db) {
    try {
        $stmt = $db->prepare("SELECT * FROM hero_banner WHERE status = 'active' LIMIT 1");
        $stmt->execute();
        $hero_banner = $stmt->fetch(PDO::FETCH_ASSOC);
    } catch (PDOException $e) {
        error_log('Hero banner error: ' . $e->getMessage());
    }
}

// Set defaults if no data in database
if (!$hero_banner) {
    $hero_banner = [
        'title' => 'Fast • Secure • Reliable<br><span class="highlight">Web Hosting in India</span>',
        'subtitle' => 'Empower your business with high-performance hosting, 24/7 expert support, and guaranteed 99.9% uptime. Scale effortlessly with our enterprise-grade infrastructure.',
        'button_text' => 'Get Started Now',
        'button_link' => 'shared-hosting.php',
        'image_path' => ''
    ];
}
?>

<style>
/* Professional Hero Banner - Matches Site Style */
.hero-banner {
    padding: 130px 0;
    display: flex;
    align-items: center;
    justify-content: center;
    min-height: 530px;
    position: relative;
    background: var(--accent) url(./assets/images/hero-banner-bg-pattern.png) repeat;
    border-bottom-left-radius: 100px;
    border-bottom-right-radius: 100px;
    overflow: hidden;
}

.hero-banner::before {
    content: "";
    background: url(./assets/images/sub-banner-bg-img.png) no-repeat center;
    background-size: cover;
    width: 100%;
    height: 453px;
    position: absolute;
    left: 0;
    bottom: 0;
    z-index: 1;
}

.hero-content {
    position: relative;
    z-index: 10;
}

.hero-title {
    font-size: 3.5rem;
    font-weight: 800;
    line-height: 1.15;
    margin-bottom: 1.2rem;
    color: var(--primary-color);
}

.hero-title .highlight {
    color: var(--yellow-color);
}

    .hero-subtitle {
    font-size: 1.2rem;
    color: rgba(255, 255, 255, 0.95);
    margin-bottom: 2rem;
    line-height: 1.6;
}/* CTA Buttons */
.hero-cta-group {
    display: flex;
    gap: 20px;
    margin-bottom: 2rem;
    flex-wrap: wrap;
}

.hero-btn {
    padding: 16px 40px;
    border-radius: 50px;
    font-weight: 700;
    font-size: 1.1rem;
    text-decoration: none;
    display: inline-flex;
    align-items: center;
    gap: 12px;
    transition: all 0.3s ease;
    position: relative;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.hero-btn-primary {
    background: var(--yellow-color);
    color: var(--secondary-color);
    border: 2px solid var(--yellow-color);
    box-shadow: 0 10px 30px rgba(255, 210, 0, 0.4);
}

.hero-btn-primary:hover {
    background: #ffc100;
    border-color: #ffc100;
    transform: translateY(-3px);
    box-shadow: 0 15px 40px rgba(255, 210, 0, 0.5);
    color: var(--secondary-color);
}

.hero-btn-primary i {
    font-size: 1.2rem;
    animation: rocketBounce 2s ease-in-out infinite;
}

@keyframes rocketBounce {
    0%, 100% {
        transform: translateY(0);
    }
    50% {
        transform: translateY(-4px);
    }
}

/* Hero Image */
.hero-image-wrapper {
    position: relative;
    animation: floatImage 6s ease-in-out infinite;
}

.hero-image {
    width: 100%;
    height: auto;
    border-radius: 20px;
    box-shadow: 0 20px 60px rgba(0,0,255,0.3);
    filter: drop-shadow(0 20px 60px rgba(0,0,255,0.3));
}

@keyframes floatImage {
    0%, 100% {
        transform: translateY(0);
    }
    50% {
        transform: translateY(-20px);
    }
}

/* Modern Offers Slider */
.offers-slider-wrapper {
    background: rgba(255, 255, 255, 0.08);
    backdrop-filter: blur(30px);
    border: 2px solid rgba(255, 255, 255, 0.15);
    border-radius: 30px;
    padding: 0;
    position: relative;
    overflow: hidden;
    box-shadow: 0 25px 70px rgba(0, 0, 0, 0.3);
}

.offers-slider-wrapper::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 5px;
    background: linear-gradient(90deg, var(--yellow-color), var(--accent), var(--yellow-color));
    background-size: 200% 100%;
}

.offers-title {
    color: white;
    font-size: 1.1rem;
    font-weight: 700;
    padding: 18px 25px 15px;
    text-align: left;
    display: flex;
    align-items: center;
    gap: 8px;
    background: rgba(255, 255, 255, 0.05);
    border-bottom: 1px solid rgba(255, 255, 255, 0.1);
}

.offers-title i {
    color: white;
    font-size: 1.2rem;
}

.offer-slide {
    transition: all 0.5s ease;
}

.offer-image {
    margin-bottom: 0;
    border-radius: 0;
    overflow: hidden;
    position: relative;
    box-shadow: none;
    height: 200px;
}

.offer-image img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    transition: transform 0.6s ease;
}

.offer-slide:hover .offer-image img {
    transform: scale(1.05);
}

.offer-badge {
    position: absolute;
    top: 15px;
    left: 15px;
    background: var(--yellow-color);
    color: var(--secondary-color);
    padding: 8px 18px;
    border-radius: 25px;
    font-weight: 800;
    font-size: 0.95rem;
    box-shadow: 0 6px 20px rgba(255, 210, 0, 0.5);
    z-index: 2;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.offer-content {
    color: white;
    padding: 18px 25px 20px;
    background: linear-gradient(to bottom, transparent, rgba(0, 0, 0, 0.3));
}

.offer-title {
    font-size: 1.15rem;
    font-weight: 700;
    margin-bottom: 8px;
    line-height: 1.3;
    min-height: auto;
}

.offer-description {
    font-size: 0.9rem;
    opacity: 0.95;
    line-height: 1.5;
    margin-bottom: 15px;
    display: -webkit-box;
    -webkit-line-clamp: 2;
    -webkit-box-orient: vertical;
    overflow: hidden;
    min-height: auto;
}

.offer-meta {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-top: 0;
    padding-top: 0;
    border-top: none;
}

.offer-validity {
    font-size: 0.8rem;
    opacity: 0.85;
    display: flex;
    align-items: center;
    gap: 5px;
    background: rgba(255, 255, 255, 0.1);
    padding: 6px 12px;
    border-radius: 15px;
}

.offer-cta {
    background: var(--yellow-color);
    color: var(--secondary-color);
    padding: 8px 20px;
    border-radius: 20px;
    text-decoration: none;
    font-weight: 700;
    font-size: 0.85rem;
    transition: all 0.3s ease;
    border: none;
    display: flex;
    align-items: center;
    gap: 6px;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.offer-cta:hover {
    background: #ffc100;
    color: var(--secondary-color);
    transform: translateY(-2px);
    box-shadow: 0 8px 20px rgba(255, 210, 0, 0.4);
}

/* Modern Slider Navigation */
.slider-nav {
    display: none;
}

.offers-empty {
    text-align: center;
    padding: 60px 40px;
    color: white;
}

.offers-empty i {
    font-size: 4rem;
    margin-bottom: 25px;
    opacity: 0.7;
    color: var(--yellow-color);
}

.offers-empty h4 {
    margin-bottom: 15px;
    font-weight: 700;
    font-size: 1.5rem;
}

.offers-empty p {
    opacity: 0.85;
    margin: 0 0 30px 0;
    font-size: 1.05rem;
}

/* Responsive Design */
@media (max-width: 1200px) {
    .hero-title {
        font-size: 3.2rem;
    }
}

@media (max-width: 992px) {
    .hero-banner {
        padding: 120px 0 80px;
        min-height: auto;
    }
    
    .hero-title {
        font-size: 2.8rem;
        text-align: center;
    }
    
    .hero-subtitle {
        text-align: center;
        margin-left: auto;
        margin-right: auto;
    }
    
    .hero-cta-group {
        justify-content: center;
    }
    
    .offers-slider-wrapper {
        margin-top: 50px;
    }
}

@media (max-width: 768px) {
    .hero-banner {
        padding: 100px 0 60px;
    }
    
    .hero-title {
        font-size: 2.4rem;
    }
    
    .hero-subtitle {
        font-size: 1.1rem;
    }
    
    .hero-btn {
        padding: 14px 30px;
        font-size: 1rem;
    }
    
    .trust-badges {
        gap: 15px;
    }
    
    .trust-badge {
        font-size: 0.9rem;
        padding: 10px 15px;
    }
}

@media (max-width: 576px) {
    .hero-title {
        font-size: 2rem;
    }
    
    .hero-subtitle {
        font-size: 1rem;
    }
    
    .hero-cta-group {
        flex-direction: column;
        align-items: center;
    }
    
    .hero-btn {
        width: 100%;
        max-width: 280px;
        justify-content: center;
    }
    
    .trust-badges {
        flex-direction: column;
        align-items: center;
        gap: 12px;
    }
    
    .offers-slider-wrapper {
        padding: 25px 20px;
    }
    
    .offer-title {
        font-size: 1.1rem;
    }
}

/* Performance Optimizations */
@media (prefers-reduced-motion: reduce) {
    .hero-banner,
    .hero-title,
    .hero-subtitle,
    .hero-cta-group,
    .offers-slider-wrapper,
    .offer-slide,
    .offer-image img,
    .offer-badge,
    .slider-btn,
    .dot {
        animation: none !important;
        transition: none !important;
    }
    
    .hero-banner::before {
        animation: none !important;
    }
}
</style>

<!-- PREMIUM HERO BANNER SECTION -->
<section class="hero-banner w-100" id="hero-banner" >
    <div class="container">
        <div class="hero-content">
            <div class="row align-items-center" style="margin-top: 50px;">
                <!-- Main Content -->
                 
                <div class="col-lg-<?= !empty($hero_banner['image_path']) ? '7' : '12' ?> col-md-<?= !empty($hero_banner['image_path']) ? '6' : '12' ?>">
                    <div style="<?= !empty($hero_banner['image_path']) ? '' : 'text-align: center;' ?>">
                        <h1 class="hero-title">
                            <?= $hero_banner['title'] ?>
                        </h1>
                        
                        <p class="hero-subtitle">
                            <?= htmlspecialchars($hero_banner['subtitle']) ?>
                        </p>
                        
                        <div class="hero-cta-group" style="<?= !empty($hero_banner['image_path']) ? '' : 'justify-content: center;' ?>">
                            <a href="<?= htmlspecialchars($hero_banner['button_link']) ?>" class="hero-btn hero-btn-primary">
                                <i class="fas fa-rocket"></i>
                                <?= htmlspecialchars($hero_banner['button_text']) ?>
                            </a>
                        </div>
                    </div>
                </div>
                
                <?php if (!empty($hero_banner['image_path'])): ?>
                <div class="col-lg-5 col-md-6">
                    <div class="hero-image-wrapper">
                        <img src="<?= url($hero_banner['image_path']) ?>" alt="Hero Banner" class="hero-image">
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>