<?php
// Use the global current_path if set, otherwise try to get from GET parameter
$current_path = $GLOBALS['current_path'] ?? (isset($_GET['path']) ? $_GET['path'] : '');
$current_path = trim($current_path, '/');
require_once BASE_PATH . '/partial/header_meta.php';
?>

<!-- HEADER SECTION START HERE -->
<header class="header-main-con w-100 float-left">
    <div class="container-fluid">
        <nav class="navbar navbar-expand-lg navbar-light p-0">
            <a class="navbar-brand p-0" href="<?= BASE_URL ?>">
                <figure class="mb-0">
                    <img src="<?= asset('images/WsplCloud.png') ?>" alt="WsplCloud Logo" loading="lazy" width="250">
                </figure>
            </a>
            <button class="navbar-toggler collapsed" type="button" data-toggle="collapse"
                data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false"
                aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
                <span class="navbar-toggler-icon"></span>
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarSupportedContent">
                <ul class="navbar-nav">
                    <li class="nav-item">
                        <a class="nav-link p-0 <?= ($current_path === '') ? 'active' : '' ?>" href="<?= BASE_URL ?>">Home</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link p-0 <?= ($current_path === 'about') ? 'active' : '' ?>" href="<?= BASE_URL ?>/about">About</a>
                    </li>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle p-0 <?= (in_array($current_path, ['shared-hosting','vps','wordpress','cloud-hosting','reseller'])) ? 'active' : '' ?>" href="#" id="navbarDropdown1" role="button"
                            data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            Hosting
                        </a>
                        <div class="dropdown-menu dropdown-menu-outer" aria-labelledby="navbarDropdown1">
                            <ul class="list-unstyled mb-0">
                                <li><a class="dropdown-item <?= ($current_path === 'shared-hosting') ? 'active' : '' ?>" href="<?= BASE_URL ?>/shared-hosting">Shared Hosting</a></li>
                                <li><a class="dropdown-item <?= ($current_path === 'vps') ? 'active' : '' ?>" href="<?= BASE_URL ?>/vps">VPS</a></li>
                                <li><a class="dropdown-item <?= ($current_path === 'wordpress') ? 'active' : '' ?>" href="<?= BASE_URL ?>/wordpress">Wordpress Hosting</a></li>
                                <li><a class="dropdown-item <?= ($current_path === 'cloud-hosting') ? 'active' : '' ?>" href="<?= BASE_URL ?>/cloud-hosting">Cloud Hosting</a></li>
                                <li><a class="dropdown-item <?= ($current_path === 'reseller') ? 'active' : '' ?>" href="<?= BASE_URL ?>/reseller">Reseller Hosting</a></li>
                            </ul>
                        </div>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link p-0 <?= ($current_path === 'domain') ? 'active' : '' ?>" href="<?= BASE_URL ?>/domain">Domain</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link p-0 <?= ($current_path === 'blog') ? 'active' : '' ?>" href="<?= BASE_URL ?>/blog">Blog</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link p-0 <?= ($current_path === 'contact') ? 'active' : '' ?>" href="<?= BASE_URL ?>/contact">Contact</a>
                    </li>
                </ul>
            </div>
           
        </nav>
    </div>
</header>
<!-- HEADER SECTION END HERE -->