<?php 
require_once __DIR__ . '/../config.php';

// Fetch WordPress hosting plans from database
$db = get_db();
$stmt = $db->prepare("SELECT * FROM hosting_plans WHERE plan_type = 'wordpress' AND status = 'active' ORDER BY display_order ASC");
$stmt->execute();
$wordpress_plans = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Set page-specific variables
$page_title = 'WordPress Hosting | WsplCloud - Web Hosting & Cloud Services';
$page_description = 'Optimized WordPress hosting with automatic updates, enhanced security, and fast loading speeds for your WordPress website.';
$page_keywords = 'wordpress hosting, managed wordpress, wordpress website, wordpress optimization, fast wordpress';
$custom_css = ['priceslider.css']; // Add pricing specific CSS

// Include header meta (DOCTYPE, <head>, opening <body> tag)
require_once BASE_PATH . '/partial/header_meta.php';

// Include the navigation header
require_once BASE_PATH . '/partial/header.php';
?>
    <style>

          .shared-hosting-intro {
        background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
        position: relative;
        overflow: hidden;
    }
    
    .shared-hosting-intro::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: #fff;
        z-index: 0;
    }
    
    .intro-content-con {
        position: relative;
        z-index: 1;
    }
    
    .intro-text-con h3 {
        color: #000fff;
        font-size: 2rem;
        margin-bottom: 1.5rem;
        font-weight: 700;
    }
    
    .intro-text-con p {
        font-size: 1.1rem;
        line-height: 1.7;
        margin-bottom: 2rem;
        color: #555;
    }
    
    .intro-features-list {
        margin-bottom: 2.5rem;
    }
    
    .intro-features-list li {
        padding: 0.5rem 0;
        font-size: 1.05rem;
        color: #444;
    }
    
    .intro-features-list i {
        color: #000fff;
        margin-right: 10px;
        font-size: 1.2rem;
    }
    
    .intro-stats-con {
        display: flex;
        justify-content: space-between;
        margin-top: 2rem;
        flex-wrap: wrap;
    }
    
    .stat-box {
        text-align: center;
        padding: 1rem;
        background: white;
        border-radius: 10px;
        box-shadow: 0 5px 15px rgba(0, 15, 255, 0.1);
        flex: 1;
        margin: 0 10px;
        min-width: 100px;
    }
    
    .stat-box h4 {
        color: #000fff;
        font-size: 2rem;
        margin-bottom: 0.5rem;
        font-weight: 700;
    }
    
    .stat-box span {
        font-size: 0.9rem;
        color: #666;
    }
    .gif-caption {
        margin-top: 1rem;
        font-style: italic;
        color: #666;
        font-size: 0.9rem;
    }
    
    /* Who Should Use Section */
    .who-should-use-con {
        margin-top: 4rem;
        padding-top: 3rem;
        border-top: 1px solid #ddd;
    }
    
    .user-type-box {
        text-align: center;
        padding: 2rem 1.5rem;
        background: white;
        border-radius: 10px;
        box-shadow: 0 5px 15px rgba(0, 15, 255, 0.1);
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        height: 100%;
    }
    
    .user-type-box:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 25px rgba(0, 15, 255, 0.15);
    }
    
    .user-icon {
        width: 80px;
        height: 80px;
        background: linear-gradient(135deg, #000fff, #4d5dfb);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        margin: 0 auto 1.5rem;
    }
    
    .user-icon i {
        font-size: 2rem;
        color: white;
    }
    
    .user-type-box h4 {
        color: #000fff;
        margin-bottom: 1rem;
        font-weight: 600;
    }
    
    .user-type-box p {
        color: #666;
        line-height: 1.6;
    }
    
       
    
    
    /* Responsive Styles */
    @media (max-width: 991px) {
        .intro-stats-con {
            justify-content: center;
        }
        
        .stat-box {
            margin: 10px;
            flex: 0 0 calc(50% - 20px);
        }
        
        .user-type-box {
            margin-bottom: 2rem;
        }
    }
    
    @media (max-width: 767px) {
        .intro-text-con h3 {
            font-size: 1.7rem;
        }
        
        .stat-box {
            flex: 0 0 100%;
            margin: 5px 0;
        }
        
        .intro-gif-con {
            margin-top: 2rem;
        }
    }
    .plan-icon{
        width: 38px;
        height: 38px;
    }

    /* Plan features list styling */
    .hosting-type-content-con ul {
        margin-top: 8px;
    }

    .hosting-type-content-con ul li {
        padding: 8px 0;
        font-size: 1.05rem;
        color: #444;
        display: flex;
        align-items: center;
    }

    .hosting-type-content-con ul li i {
        color: #000fff;
        margin-right: 10px;
        font-size: 0.9rem;
        width: 18px;
        text-align: center;
    }

    .hosting-type-content-con ul li span { color: inherit; }

    /* Plan features list styling to match other pages */
    .plan-features { margin-top: 12px; }
    .plan-features li { padding: 10px 0; color: #444; font-size: 1.05rem; }
    .plan-features li i { color: #000fff; margin-right: 10px; }

    /* view-more button removed - extra feature items are visible by default */

    /* Styles for the single 'View More Features' control */
    #view-more-features {
        display: inline-block;
        min-width: 160px;
        padding: 10px 18px;
        background: #000fff; /* site blue */
        color: #ffffff;
        border: none;
        border-radius: 6px;
        font-weight: 700;
        font-size: 0.95rem;
        line-height: 1;
        cursor: pointer;
        box-shadow: 0 6px 18px rgba(0,0,0,0.08);
        transition: background 160ms ease, transform 120ms ease, box-shadow 120ms ease;
        text-decoration: none;
        margin-top: 52px;
    }
    #view-more-features:hover { background: #0056d6; transform: translateY(-1px); }
    #view-more-features:active { transform: translateY(0); }
    #view-more-features[aria-expanded="true"] { background: #003d9a; }
    #view-more-features:focus {
        outline: 3px solid rgba(0,95,255,0.18);
        outline-offset: 2px;
    }
    @media (max-width: 576px) {
        #view-more-features { width: 100%; box-sizing: border-box; }
    }
        /* Toggle Switch Styles */
        .billing-toggle-container {
            display: flex;
            justify-content: center;
            align-items: center;
            margin-bottom: 40px;
        }
        
        .billing-toggle {
            display: flex;
            align-items: center;
            background-color: #f5f5f5;
            border-radius: 30px;
            padding: 5px;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        }
        
        .billing-option {
            padding: 10px 20px;
            cursor: pointer;
            border-radius: 25px;
            transition: all 0.3s ease;
            font-weight: 600;
        }
        
        .billing-option.active {
            background-color: #000fff;
            color: white;
        }
        
        .yearly-saving {
            color: #28a745;
            font-size: 14px;
            margin-left: 10px;
            font-weight: 600;
        }
        
        .plan-price {
            transition: all 0.3s ease;
        }
        /* Styles for the single 'View More Features' control to match shared-hosting */
        #view-more-features {
            display: inline-block;
            min-width: 160px;
            padding: 10px 18px;
            background: #000fff; /* site blue */
            color: #ffffff;
            border: none;
            border-radius: 6px;
            font-weight: 700;
            font-size: 0.95rem;
            line-height: 1;
            cursor: pointer;
            box-shadow: 0 6px 18px rgba(0,0,0,0.08);
            transition: background 160ms ease, transform 120ms ease, box-shadow 120ms ease;
            text-decoration: none;
            margin-top: 24px;
        }
        #view-more-features:hover { background: #0056d6; transform: translateY(-1px); }
        #view-more-features:active { transform: translateY(0); }
        #view-more-features[aria-expanded="true"] { background: #003d9a; }
        #view-more-features:focus { outline: 3px solid rgba(0,95,255,0.18); outline-offset: 2px; }
        @media (max-width: 576px) { #view-more-features { width: 100%; box-sizing: border-box; } }
    </style>
</head>

<body>
    <?php require_once BASE_PATH . '/partial/preloader.php'; ?>
    <!-- HEADER SECTION START HERE -->
    <?php require_once BASE_PATH . '/partial/header.php'; ?>
    <!-- HEADER SECTION END HERE -->
    <!-- BANNER SECTION START HERE -->
    <section class="hosting-pages-sub-banner sub-banner-main-con w-100 float-left">
        <div class="container">
            <div class="sub-banner-inner-con wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
                <h1>Wordpress Hosting</h1>
                  <span class="d-block position-relative"></span>
            <h6>
                <a href="<?= url('') ?>" style="color: #fff; transition: color 0.2s;" onmouseover="this.style.color='#FFD700'" onmouseout="this.style.color='#fff'">Home</a>
               
                <span style="color: #fff;"> 
                |</span>
                <a href="<?= url('wordpress') ?>" style="color: #fff; transition: color 0.2s;" onmouseover="this.style.color='#FFD700'" onmouseout="this.style.color='#fff'">Wordpress Hosting</a>
            </h6>
               
            </div>
        </div>
    </section>
    <!-- BANNER SECTION END HERE -->
<section class="vps-intro w-100 float-left padding-top padding-bottom">
    <div class="container">
        <div class="generic-title text-center wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
            <h2>What is WordPress Hosting?</h2>
            <p>Managed WordPress hosting optimized for speed, security, and ease — built specifically to run WordPress sites better.</p>
        </div>
        
        <div class="intro-content-con wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.5s">
            <div class="row align-items-center">
                <div class="col-lg-6 col-md-6">
                    <div class="intro-text-con">
                        <h3>Managed, Fast & Secure WordPress</h3>
                        <p>Our WordPress hosting includes one-click installs, automatic core and plugin updates, built-in caching and CDN integration, daily backups, malware scanning, and expert WordPress support so your site runs reliably and loads quickly.</p>
                        
                        <ul class="list-unstyled intro-features-list">
                            <li><i class="fab fa-wordpress"></i> One-click WordPress installs & staging</li>
                            <li><i class="fas fa-tachometer-alt"></i> Server-level caching & CDN for fast load times</li>
                            <li><i class="fas fa-sync-alt"></i> Automatic WordPress core & plugin updates</li>
                            <li><i class="fas fa-shield-alt"></i> Daily backups & malware scanning</li>
                            <li><i class="fas fa-database"></i> Optimized MySQL/MariaDB for WP performance</li>
                            <li><i class="fas fa-headset"></i> 24/7 WordPress-trained support</li>
                        </ul>
                        
                        <div class="intro-stats-con">
                            <div class="stat-box">
                                <h5 style="color:#0000ff;" >Optimized</h4>
                                <span>WordPress-tuned stack</span>
                            </div>
                            <div class="stat-box">
                                <h5 style="color:#0000ff;">Managed</h4>
                                <span>Backups & updates included</span>
                            </div>
                            <div class="stat-box">
                                <h5 style="color:#0000ff;">Secure</h4>
                                <span>Malware protection & SSL</span>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="col-lg-6 col-md-6">
                    <div class="intro-gif-con text-center">
                        <!-- Illustration showing WordPress hosting benefits -->
                        <img src="<?= asset('images/Untitled design.png') ?>" alt="WordPress Hosting Illustration" class="intro-gif" style="max-width: 100%; height: auto; border-radius: 12px;">
                        
                        <!-- Fallback static image if GIF doesn't load -->
                        <noscript>
                            <img src="<?= asset('images/wordpress-static.png') ?>" alt="WordPress Diagram" class="intro-static-img">
                        </noscript>
                        
                        <div class="gif-caption">
                            <p>Managed WordPress environment with performance and security optimizations out of the box.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Who Should Use WordPress Hosting -->
        <div class="who-should-use-con wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.7s">
            <div class="row">
                <div class="col-lg-4 col-md-4">
                    <div class="user-type-box">
                        <div class="user-icon">
                            <i class="fas fa-pen-nib"></i>
                        </div>
                        <h4>Bloggers & Creators</h4>
                        <p>Easy setup, fast delivery, and managed updates so you can focus on content, not maintenance.</p>
                    </div>
                </div>
                
                <div class="col-lg-4 col-md-4">
                    <div class="user-type-box">
                        <div class="user-icon">
                            <i class="fas fa-store"></i>
                        </div>
                        <h4>Small Businesses & Stores</h4>
                        <p>Reliable performance, secure checkout, and backups to keep your online store running smoothly.</p>
                    </div>
                </div>
                
                <div class="col-lg-4 col-md-4">
                    <div class="user-type-box">
                        <div class="user-icon">
                            <i class="fas fa-users-cog"></i>
                        </div>
                        <h4>Agencies & Developers</h4>
                        <p>Staging sites, WP-CLI, Git-friendly workflows and scalable resources for client projects.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
    <!-- DOMAINS SECTION SATRT HERE -->
     
    <div class="banner-sub-sec w-100 float-left ">
          
        <div class="container" style="margin-top: 140px;">
            <!-- Billing Toggle -->
          
            
            <div class="banner-sub-outer-con wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
                <div class="billing-toggle-container wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
                <div class="billing-toggle">
                    <div class="billing-option active" data-period="monthly">Monthly </div>
                    <div class="billing-option" data-period="yearly">Yearly </div>
                   
                </div>
            </div>
                <div class="hosting-types-inner-con web-hosting-inner-con" style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 20px;">
                    <?php if (!empty($wordpress_plans)): ?>
                        <?php 
                        $plan_classes = ['plan1-flower', 'plan2-flower', 'plan3-flower', 'plan4-flower'];
                        foreach ($wordpress_plans as $index => $plan): 
                            $features = json_decode($plan['features'], true) ?? [];
                            $developer_features = json_decode($plan['developer_features'], true) ?? [];
                            $technical_details = json_decode($plan['technical_details'], true) ?? [];
                            $plan_class = $plan_classes[$index % 4];
                            
                            $monthly = floatval($plan['monthly_price']);
                            $yearly = floatval($plan['yearly_price']);
                        ?>
                        <div class="hosting-type-box" style="height: 100%;">
                            <div class="hosting-type-content-con <?= htmlspecialchars($plan_class) ?>" style="height: 100%;">
                                <figure>
                                    <img src="<?= asset($plan['icon_image']) ?>" alt="<?= htmlspecialchars($plan['plan_name']) ?>">
                                </figure>
                                <h5><?= htmlspecialchars($plan['plan_name']) ?></h5>
                                <p><?= htmlspecialchars($plan['description']) ?></p>
                                <div class="hosting-price-box">
                                    <span class="dollar">₹</span>
                                    <span class="numeric1 plan-price" data-monthly="<?= number_format($monthly, 0) ?>" data-yearly="<?= number_format($yearly, 0) ?>"><?= number_format($monthly, 0) ?></span>
                                    <div class="month-title">
                                        <span id="point_val2" class="numeric2"></span>
                                        <br>
                                        <small class="billing-period">/month</small>
                                    </div>
                                </div>
                                <div class="primary-btn blue-btn">
                                    <a href="#">ORDER NOW <i class="fas fa-arrow-right"></i></a>
                                </div>
                                <ul class="mb-0 list-unstyled plan-features">
                                    <li class="position-relative"><i class="fas fa-check" style="color:#28a745"></i> <span>Domains</span> <?= htmlspecialchars($plan['domains']) ?></li>
                                    <li class="position-relative"><i class="fas fa-check" style="color:#28a745"></i> <span>Space</span> <?= htmlspecialchars($plan['storage']) ?></li>
                                    <li class="position-relative"><i class="fas fa-check" style="color:#28a745"></i> <span>Database</span> <?= htmlspecialchars($plan['databases']) ?></li>
                                    <li class="position-relative"><i class="fas fa-check" style="color:#28a745"></i> <span>Email</span> <?= htmlspecialchars($plan['emails']) ?></li>
                                    <li class="position-relative"><i class="fas fa-check" style="color:#28a745"></i> <span>Bandwidth</span> <?= htmlspecialchars($plan['bandwidth']) ?></li>
                                    <li class="position-relative"><i class="fas fa-check" style="color:#28a745"></i> <span>Backup</span> <?= htmlspecialchars($plan['backup']) ?></li>
                                    <li class="position-relative"><i class="fas fa-check" style="color:#28a745"></i> <span>Migration</span></li>
                                    <li class="position-relative"><i class="fas fa-check" style="color:#28a745"></i> <span>Support</span> 24/7/365</li>
                                    <li class="position-relative"><i class="fas fa-check" style="color:#28a745"></i> <span>Server Location</span> India</li>

                                    <!-- Developer Features (hidden by default) -->
                                    <li class="position-relative extra-item plan-subheading" style="margin-top:12px; font-weight:700;color:#0000ff;"><i class="fas fa-code" style="margin-right:10px"></i>Developer's Feature</li>
                                    <?php foreach ($developer_features as $dev_feature): ?>
                                        <li class="position-relative extra-item">
                                            <i class="<?= $dev_feature['available'] ? 'fas fa-check' : 'fas fa-times' ?>" style="color:<?= $dev_feature['available'] ? '#28a745' : '#dc3545' ?>"></i> 
                                            <span><?= htmlspecialchars($dev_feature['name']) ?></span>
                                        </li>
                                    <?php endforeach; ?>

                                    <!-- Technical Details (hidden by default) -->
                                    <li class="position-relative extra-item plan-subheading" style="margin-top:12px; font-weight:700;color:#0000ff;"><i class="fas fa-cogs" style="margin-right:10px"></i>Technical Details</li>
                                    <?php foreach ($technical_details as $tech_detail): ?>
                                        <li class="position-relative extra-item">
                                            <i class="<?= $tech_detail['available'] ? 'fas fa-check' : 'fas fa-times' ?>" style="color:<?= $tech_detail['available'] ? '#28a745' : '#dc3545' ?>"></i> 
                                            <span><?= htmlspecialchars($tech_detail['name']) ?></span>
                                            <?php if (!empty($tech_detail['value'])): ?>
                                                <?= htmlspecialchars($tech_detail['value']) ?>
                                            <?php endif; ?>
                                        </li>
                                    <?php endforeach; ?>
                                </ul>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <div class="col-12 text-center">
                            <p class="lead">No WordPress hosting plans available at the moment. Please check back soon!</p>
                        </div>
                    <?php endif; ?>
                </div>

                <!-- Control button: View More Features (reveal extra features) -->
                <div class="text-center mt-4">
                    <button id="view-more-features" type="button" class="primary-btn blue-btn" aria-expanded="false">View More Features</button>
                </div>
            </div>
        </div>
    </div>
    <!-- DOMAIN SECTION END HERE -->
    <!-- DEDICATED FEATURES SECTION START HERE -->
    <section class="dedicated-features-con advance-web-features-con w-100 float-left pt-100 padding-bottom">
        <div class="container">
            <div class="feature-main-con wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
                <div class="generic-title text-center">
                    <h2>Advanced Web Hosting Features</h2>
                    <p>Our web hosting solutions are an easy way to get a great website up and running, with so many robust featues we throw in a domain, <span class="d-inline-block">SSL Certificate, professional email address,</span> and privacy protection for free.</p>
                    <a class="arrow-btn" href="#">Explore all features <i class="fas fa-arrow-right"></i></a>
                </div>
                <div class="feature-inner-con">
                    <div class="feature-box">
                        <figure>
                            <img src="<?= asset('images/feature-img1.png') ?>" alt="feature-img1">
                        </figure>
                        <div class="feature-side-txt-con">
                            <h5>High-Speed Performance</h5>
                            <p>Experience high-speed performance tailored for WordPress — with optimized servers, built-in caching, and lightning-fast load times. Keep your visitors engaged and boost your SEO with a website that never slows down.
</p>
                            <a class="arrow-btn" href="#">Learn More <i class="fas fa-arrow-right"></i></a>
                        </div>
                    </div>
                    <div class="feature-box">
                        <figure>
                            <img src="<?= asset('images/feature-img2.png') ?>" alt="feature-img2">
                        </figure>
                        <div class="feature-side-txt-con">
                            <h5>Website Builder (Drag & Drop) </h5>
                            <p>Build stunning websites effortlessly using our drag-and-drop website builder — no coding skills needed. Choose from pre-designed templates, customize every section, and launch your site in minutes.</p>
                            <a class="arrow-btn" href="#">Learn More <i class="fas fa-arrow-right"></i></a>
                        </div>
                    </div>
                    <div class="feature-box">
                        <figure>
                            <img src="<?= asset('images/feature-img3.png') ?>" alt="feature-img3">
                        </figure>
                        <div class="feature-side-txt-con">
                            <h5>Email & DNS Management</h5>
                            <p> Simplify your workflow with integrated email and DNS management — set up custom email addresses, configure domain records, and keep your WordPress site running smoothly, all in one place.
</p>
                            <a class="arrow-btn" href="#">Learn More <i class="fas fa-arrow-right"></i></a>
                        </div>
                    </div>
                    <div class="feature-box">
                        <figure>
                            <img src="<?= asset('images/feature-img4.png') ?>" alt="feature-img4">
                        </figure>
                        <div class="feature-side-txt-con">
                            <h5> 24/7 Premium Support</h5>
                            <p>Enjoy expert assistance anytime with our 24/7 premium support — real humans, real solutions, always ready. Whether it's day or night, our support team is here to keep your site running smoothly.
</p>
                            <a class="arrow-btn" href="#">Learn More <i class="fas fa-arrow-right"></i></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- DEDICATED FEATURES SECTION END HERE -->
    <!-- SECURITY FEATURES SECTION START HERE -->
    <section class="shared-hosting-content w-100 float-left padding-top padding-bottom bg-shape">
        <div class="container">
            <div class="generic-title text-center wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
                <h2>So what's in Wordpress Hosting?</h2>
                <p>Performance that exceeds your expectations and features you are about to fall in love with</p>
            </div>
            <div class="shared-hosting-content-inner-con wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
                <div class="shared-hosting-content-left-con">
                    <figure class="mb-0">
                        <img src="<?= asset('images/shared-hosting-left-img.png') ?>" alt="shared-hosting-left-img">
                    </figure>
                </div>
                <div class="shared-hosting-content-right-con">
                    <h5>Included in Wordpress Hosting Plans</h5>
                    <ul class="mb-0 list-unstyled">
                        <li><i class="fas fa-check-circle circle-chk"></i>1 Year Domain Registration <i class="fas fa-check"></i></li>
                        <li><i class="fas fa-check-circle circle-chk"></i><span class="d-inline-block"><small class="free-item d-inline-block">FREE</small> Domain Transfers</span> <i class="fas fa-check"></i></li>
                        <li><i class="fas fa-check-circle circle-chk"></i>₹100 Microsoft Advertising credit <i class="fas fa-info-circle"></i> <i class="fas fa-check"></i></li>
                        <li><i class="fas fa-check-circle circle-chk"></i>₹500 Google Ads spend match credit <i class="fas fa-check"></i></li>
                        <li><i class="fas fa-check-circle circle-chk"></i><span class="d-inline-block"><small class="free-item d-inline-block">30-day</small> money back guarantee</span> <i class="fas fa-check"></i></li>
                        <li><i class="fas fa-check-circle circle-chk"></i>One-click WordPress Installs <i class="fas fa-check"></i></li>
                    </ul>
                </div>
            </div>
        </div>
    </section>
    <!-- SECURITY FEATURES SECTION END HERE -->
    <!-- FAQ SECTION START HERE -->
    <section class="faq-main-con w-100 float-left padding-bottom pt-100">
        <div class="container">
            <div class="generic-title text-center wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
                <h2>Frequently Asked Questions</h2>
                <p>Do you have any questions? We have your answers!</p>
            </div>
            <div class="faq-inner-con wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
                <div id="accordion1">
                    <div class="card">
                        <div class="card-header" id="headingOne">
                            <h5 class="mb-0">
                                <button class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapseOne" aria-expanded="false" aria-controls="collapseOne">
                                    <i class="fas fa-question-circle mr-2"></i>what is Wordpress Hosting?
                                </button>
                            </h5>
                        </div>
                        <div id="collapseOne" class="collapse" aria-labelledby="headingOne" data-parent="#accordion1">
                            <div class="card-body">"WordPress Hosting is hosting that is built specifically for websites made with WordPress. It comes pre-installed with WordPress, is faster and more secure, and usually includes tools like automatic updates, backups, and support that are designed for WordPress websites."
</div>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-header" id="headingTwo">
                            <h5 class="mb-0">
                                <button class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                   <i class="fas fa-exchange-alt mr-2"></i>Can I Transfer My Domain Over to Wsplcloud?
                                </button>
                            </h5>
                        </div>
                        <div id="collapseTwo" class="collapse" aria-labelledby="headingTwo" data-parent="#accordion1">
                            <div class="card-body">Transferring your domain is quick and hassle-free. All you need is your domain's EPP/Auth code from your current registrar, and make sure the domain is unlocked.</div>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-header" id="headingThree">
                            <h5 class="mb-0">
                                <button class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                                    <i class="fas fa-server mr-2"></i>How are servers shared?
                                </button>
                            </h5>
                        </div>
                        <div id="collapseThree" class="collapse" aria-labelledby="headingThree" data-parent="#accordion1">
                            <div class="card-body">In shared hosting, one physical server is shared by multiple users.
Each user gets their own separate hosting account, but all accounts share the same CPU, RAM, storage, and bandwidth. Think of it like living in an apartment building — everyone has their own space, but shares the building's main utilities.
</div>
                        </div>
                    </div>
                </div>
                <div id="accordion2">
                    <div class="card">
                        <div class="card-header" id="headingfour">
                            <h5 class="mb-0">
                                <button class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapsefour" aria-expanded="false" aria-controls="collapsefour">
                                    <i class="fas fa-rupee-sign mr-2"></i>What is the least expensive type of hosting?
                                </button>
                            </h5>
                        </div>
                        <div id="collapsefour" class="collapse" aria-labelledby="headingfour" data-parent="#accordion2">
                            <div class="card-body">The least expensive type of hosting is Shared Hosting. <br>
In Shared Hosting, multiple websites share the same server and resources, which significantly lowers the cost. It's an ideal option for beginners, small businesses, or personal websites that don't need high performance or advanced features.
</div>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-header" id="headingfive">
                            <h5 class="mb-0">
                                <button class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapsefive" aria-expanded="false" aria-controls="collapsefive">
                                   <i class="fas fa-truck-moving mr-2"></i>Can I Move My Website to Wsplcloud?
                                </button>
                            </h5>
                        </div>
                        <div id="collapsefive" class="collapse" aria-labelledby="headingfive" data-parent="#accordion2">
                            <div class="card-body">Yes, you can absolutely move your website to Wsplcloud. <br>
Wsplcloud supports website migration, and depending on your current setup, we can assist you with transferring your files, databases, emails, and even domains.
</div>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-header" id="headingsix">
                            <h5 class="mb-0">
                                <button class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapsesix" aria-expanded="false" aria-controls="collapsesix">
                                    <i class="fas fa-globe mr-2"></i>What Is Domain Hosting?
                                </button>
                            </h5>
                        </div>
                        <div id="collapsesix" class="collapse" aria-labelledby="headingsix" data-parent="#accordion2">
                            <div class="card-body">Domain hosting refers to the service that manages your website's domain name—like yoursite.com.
When you register a domain, you're reserving that name for your website. Domain hosting providers store your domain name in a DNS (Domain Name System) server, which connects your domain name to the server where your website files are hosted.
</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section> 
    <!-- FAQ SECTION END HERE -->
    <!-- FOOTER SECTION START HERE -->
    
    <!-- FOOTER SECTION END HERE -->
     
    <!-- js start -->
    <script src="<?= asset('js/jquery.min.js') ?>"></script>
    <script src="<?= asset('js/popper.min.js') ?>"></script>
    <script src="<?= asset('js/bootstrap.min.js') ?>"></script>
    <script src="<?= asset('js/owl.carousel.js') ?>"></script>
    <script src="<?= asset('js/wow.js') ?>"></script>
    <script src="<?= asset('js/custom.js') ?>"></script>
    
    <script>
        $(document).ready(function() {
            // Billing toggle functionality
            $('.billing-option').click(function() {
                // Remove active class from all options
                $('.billing-option').removeClass('active');

                // Add active class to clicked option
                $(this).addClass('active');

                // Get the selected period
                var period = $(this).data('period');

                // Update all plan prices
                $('.plan-price').each(function() {
                    var monthlyPrice = $(this).data('monthly');
                    var yearlyPrice = $(this).data('yearly');

                    if (period === 'monthly') {
                        $(this).text(monthlyPrice);
                        $('.billing-period').text('/month');
                    } else {
                        $(this).text(yearlyPrice);
                        $('.billing-period').text('/year');
                    }
                });
            });

            // Hide extra feature items on load and wire the View More Features button
            var $extras = $('.plan-features li.extra-item');
            $extras.hide();

            var $btn = $('#view-more-features');
            $btn.on('click', function(e){
                e.preventDefault();
                var isOpen = $btn.attr('aria-expanded') === 'true';
                if(isOpen){
                    $extras.slideUp(250);
                    $btn.attr('aria-expanded','false').text('View More Features');
                    $('html, body').animate({ scrollTop: $btn.offset().top - 20 }, 300);
                } else {
                    $extras.slideDown(300);
                    $btn.attr('aria-expanded','true').text('Show Less Features');
                    var $firstExtra = $extras.first();
                    if($firstExtra.length){
                        var top = $firstExtra.closest('.hosting-type-content-con').offset().top - 20;
                        $('html, body').animate({ scrollTop: top }, 350);
                    }
                }
            });
        });
    </script>
    
<!-- Include footer -->
<?php require_once BASE_PATH . '/partial/footer.php'; ?>

<!-- Include footer scripts -->
<?php 
// Add page-specific scripts if needed
$page_scripts = [];
require_once BASE_PATH . '/partial/footer_scripts.php'; 
?>