<?php 
require_once __DIR__ . '/../config.php';

// Fetch blog post by slug or ID
$post = null;
$post_id = null;
$slug = isset($_GET['slug']) ? $_GET['slug'] : (isset($_GET['id']) ? $_GET['id'] : null);

if (!$slug) {
    header('Location: ' . url('blog'));
    exit;
}

try {
    $db = get_db();
    if ($db) {
        // Try to fetch by slug first, then by ID
        if (is_numeric($slug)) {
            $stmt = $db->prepare('SELECT id, uuid, title, slug, content, excerpt, category, tags, author, meta_description, meta_keywords, image, status, featured, views, created, updated 
                                  FROM blogs WHERE id = :id AND status = "published"');
            $stmt->execute(['id' => $slug]);
        } else {
            $stmt = $db->prepare('SELECT id, uuid, title, slug, content, excerpt, category, tags, author, meta_description, meta_keywords, image, status, featured, views, created, updated 
                                  FROM blogs WHERE slug = :slug AND status = "published"');
            $stmt->execute(['slug' => $slug]);
        }
        
        $post = $stmt->fetch();
        
        if ($post) {
            $post_id = $post['id'];
            
            // Increment view counter
            $update_views = $db->prepare('UPDATE blogs SET views = views + 1 WHERE id = :id');
            $update_views->execute(['id' => $post_id]);
            
            // Fetch related posts (same category, exclude current post)
            $related_posts = [];
            if (!empty($post['category'])) {
                $related_stmt = $db->prepare('SELECT id, uuid, title, slug, excerpt, image, category, created 
                                               FROM blogs 
                                               WHERE category = :category AND id != :id AND status = "published" 
                                               ORDER BY created DESC LIMIT 3');
                $related_stmt->execute(['category' => $post['category'], 'id' => $post_id]);
                $related_posts = $related_stmt->fetchAll();
            }
        }
    }
} catch (Exception $e) {
    error_log('Single blog fetch error: ' . $e->getMessage());
}

if (!$post) {
    header('Location: ' . url('blog'));
    exit;
}

// Set page-specific SEO variables
$page_title = htmlspecialchars($post['title']) . ' - WsplCloud Blog';
$page_description = !empty($post['meta_description']) ? $post['meta_description'] : (!empty($post['excerpt']) ? $post['excerpt'] : substr(strip_tags($post['content']), 0, 160));
$page_keywords = !empty($post['meta_keywords']) ? $post['meta_keywords'] : 'blog, ' . (!empty($post['category']) ? strtolower($post['category']) . ', ' : '') . 'web hosting, cloud technology';
$custom_css = ['blog.css'];

// Include header meta (DOCTYPE, <head>, opening <body> tag)
require_once BASE_PATH . '/partial/header_meta.php';

// Include the navigation header
require_once BASE_PATH . '/partial/header.php';
?>
    <!-- HEADER SECTION END HERE -->
    <!-- BANNER SECTION START HERE -->
    <section class="sub-banner-main-con w-100 float-left">
        <div class="container">
            <div class="sub-banner-inner-con wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
                <h1><?= htmlspecialchars($post['title']) ?></h1>
                <span class="d-block position-relative"></span>
                <h6>
                    <a href="<?= url('') ?>" style="color: #fff; transition: color 0.2s;" onmouseover="this.style.color='#FFD700'" onmouseout="this.style.color='#fff'">Home</a>
                    <span style="color: #fff;"> | </span>
                    <a href="<?= url('blog') ?>" style="color: #fff; transition: color 0.2s;" onmouseover="this.style.color='#FFD700'" onmouseout="this.style.color='#fff'">Blog</a>
                    <span style="color: #fff;"> | </span>
                    <span style="color: #FFD700;"><?= htmlspecialchars($post['title']) ?></span>
                </h6>
            </div>
        </div>
    </section>
    <!-- BANNER SECTION END HERE -->
    
    <!-- SINGLE BLOG SECTION START HERE -->
    <section class="single-blog-section w-100 float-left padding-top padding-bottom">
        <div class="container">
            <div class="row">
                <div class="col-lg-8">
                    <div class="single-blog-content">
                        <?php if (!empty($post['featured']) && $post['featured'] == 1): ?>
                            <div class="featured-badge" style="display: inline-block; background: #ffd200; color: #000; padding: 8px 20px; border-radius: 25px; font-weight: bold; font-size: 14px; margin-bottom: 20px;">
                                <i class="fas fa-star"></i> FEATURED POST
                            </div>
                        <?php endif; ?>
                        
                        <?php if (!empty($post['image'])): ?>
                            <figure class="mb-4">
                                <img src="<?= htmlspecialchars(BASE_URL . '/' . $post['image']) ?>" alt="<?= htmlspecialchars($post['title']) ?>" class="img-fluid" style="border-radius: 8px; width: 100%;">
                            </figure>
                        <?php endif; ?>
                        
                        <div class="blog-meta mb-4">
                            <ul class="list-unstyled d-flex flex-wrap" style="gap: 20px; color: #666;">
                                <li>
                                    <i class="fas fa-user" style="color: #0000ff; margin-right: 5px;"></i>
                                    <strong>By:</strong> <?= htmlspecialchars(!empty($post['author']) ? $post['author'] : 'Admin') ?>
                                </li>
                                <li>
                                    <i class="fas fa-calendar-alt" style="color: #0000ff; margin-right: 5px;"></i>
                                    <strong>Date:</strong> <?= htmlspecialchars(date('F j, Y', strtotime($post['created']))) ?>
                                </li>
                                <?php if (!empty($post['category'])): ?>
                                    <li>
                                        <i class="fas fa-folder" style="color: #0000ff; margin-right: 5px;"></i>
                                        <strong>Category:</strong> <a href="<?= url('blog?category=' . urlencode($post['category'])) ?>" style="color: #0000ff;"><?= htmlspecialchars($post['category']) ?></a>
                                    </li>
                                <?php endif; ?>
                                <?php if (!empty($post['views'])): ?>
                                    <li>
                                        <i class="fas fa-eye" style="color: #0000ff; margin-right: 5px;"></i>
                                        <strong>Views:</strong> <?= number_format($post['views']) ?>
                                    </li>
                                <?php endif; ?>
                            </ul>
                        </div>
                        
                        <?php if (!empty($post['excerpt'])): ?>
                            <div class="blog-excerpt" style="background: #f8f9fa; padding: 20px; border-left: 4px solid #0000ff; border-radius: 4px; margin-bottom: 30px;">
                                <p style="font-size: 18px; font-weight: 500; margin: 0; color: #333;">
                                    <?= htmlspecialchars($post['excerpt']) ?>
                                </p>
                            </div>
                        <?php endif; ?>
                        
                        <div class="blog-content" style="font-size: 16px; line-height: 1.8; color: #444;">
                            <?= $post['content'] ?>
                        </div>
                        
                        <?php if (!empty($post['tags'])): ?>
                            <div class="blog-tags mt-5" style="padding-top: 30px; border-top: 2px solid #f0f0f0;">
                                <h5 style="margin-bottom: 15px; color: #333;">
                                    <i class="fas fa-tags" style="color: #0000ff; margin-right: 10px;"></i>Tags:
                                </h5>
                                <div style="display: flex; flex-wrap: wrap; gap: 10px;">
                                    <?php 
                                        $tags = array_map('trim', explode(',', $post['tags']));
                                        foreach ($tags as $tag): 
                                            if (!empty($tag)):
                                    ?>
                                        <a href="<?= url('blog?search=' . urlencode($tag)) ?>" style="background: #0000ff; color: #fff; padding: 8px 18px; border-radius: 20px; font-size: 14px; text-decoration: none; transition: all 0.3s;" onmouseover="this.style.background='#ffd200'; this.style.color='#000';" onmouseout="this.style.background='#0000ff'; this.style.color='#fff';">
                                            <i class="fas fa-tag"></i> <?= htmlspecialchars($tag) ?>
                                        </a>
                                    <?php 
                                            endif;
                                        endforeach; 
                                    ?>
                                </div>
                            </div>
                        <?php endif; ?>
                        
                        <!-- Social Share Buttons -->
                        <div class="blog-share mt-4" style="padding-top: 30px; border-top: 2px solid #f0f0f0;">
                            <h5 style="margin-bottom: 15px; color: #333;">
                                <i class="fas fa-share-alt" style="color: #0000ff; margin-right: 10px;"></i>Share this post:
                            </h5>
                            <div style="display: flex; gap: 10px;">
                                <a href="https://www.facebook.com/sharer/sharer.php?u=<?= urlencode(url('single-blog.php?slug=' . $post['slug'])) ?>" target="_blank" style="background: #3b5998; color: #fff; padding: 10px 20px; border-radius: 5px; text-decoration: none; transition: opacity 0.3s;" onmouseover="this.style.opacity='0.8'" onmouseout="this.style.opacity='1'">
                                    <i class="fab fa-facebook-f"></i> Facebook
                                </a>
                                <a href="https://twitter.com/intent/tweet?url=<?= urlencode(url('single-blog.php?slug=' . $post['slug'])) ?>&text=<?= urlencode($post['title']) ?>" target="_blank" style="background: #1da1f2; color: #fff; padding: 10px 20px; border-radius: 5px; text-decoration: none; transition: opacity 0.3s;" onmouseover="this.style.opacity='0.8'" onmouseout="this.style.opacity='1'">
                                    <i class="fab fa-twitter"></i> Twitter
                                </a>
                                <a href="https://www.linkedin.com/shareArticle?mini=true&url=<?= urlencode(url('single-blog.php?slug=' . $post['slug'])) ?>&title=<?= urlencode($post['title']) ?>" target="_blank" style="background: #0077b5; color: #fff; padding: 10px 20px; border-radius: 5px; text-decoration: none; transition: opacity 0.3s;" onmouseover="this.style.opacity='0.8'" onmouseout="this.style.opacity='1'">
                                    <i class="fab fa-linkedin-in"></i> LinkedIn
                                </a>
                            </div>
                        </div>
                    </div>
                    
                    <?php if (!empty($related_posts)): ?>
                        <!-- Related Posts Section -->
                        <div class="related-posts mt-5" style="padding-top: 40px; border-top: 3px solid #0000ff;">
                            <h3 style="margin-bottom: 30px; color: #333;">
                                <i class="fas fa-newspaper" style="color: #0000ff; margin-right: 10px;"></i>Related Posts
                            </h3>
                            <div class="row">
                                <?php foreach ($related_posts as $related): ?>
                                    <div class="col-md-4 mb-4">
                                        <div class="related-post-card" style="border: 1px solid #e0e0e0; border-radius: 8px; overflow: hidden; transition: transform 0.3s;" onmouseover="this.style.transform='translateY(-5px)'" onmouseout="this.style.transform='translateY(0)'">
                                            <?php if (!empty($related['image'])): ?>
                                                <img src="<?= htmlspecialchars(BASE_URL . '/' . $related['image']) ?>" alt="<?= htmlspecialchars($related['title']) ?>" class="img-fluid" style="width: 100%; height: 180px; object-fit: cover;">
                                            <?php endif; ?>
                                            <div style="padding: 15px;">
                                                <h5 style="font-size: 16px; margin-bottom: 10px;">
                                                    <a href="<?= url('single-blog.php?slug=' . ($related['slug'] ?? $related['id'])) ?>" style="color: #333; text-decoration: none;">
                                                        <?= htmlspecialchars($related['title']) ?>
                                                    </a>
                                                </h5>
                                                <?php if (!empty($related['excerpt'])): ?>
                                                    <p style="font-size: 14px; color: #666; margin-bottom: 10px;">
                                                        <?= htmlspecialchars(substr($related['excerpt'], 0, 80)) ?>...
                                                    </p>
                                                <?php endif; ?>
                                                <a href="<?= url('single-blog.php?slug=' . ($related['slug'] ?? $related['id'])) ?>" style="color: #0000ff; font-size: 14px; font-weight: 600;">
                                                    Read More <i class="fas fa-arrow-right"></i>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
                
                <!-- Sidebar -->
                <div class="col-lg-4">
                    <aside class="blog-sidebar">
                        <!-- Back to Blog Button -->
                        <div class="sidebar-widget mb-4">
                            <a href="<?= url('blog') ?>" class="btn" style="background: #0000ff; color: #fff; width: 100%; padding: 12px; border-radius: 5px; text-decoration: none; display: block; text-align: center; font-weight: 600;">
                                <i class="fas fa-arrow-left"></i> Back to Blog
                            </a>
                        </div>
                        
                        <?php if (!empty($post['category'])): ?>
                            <!-- Category Widget -->
                            <div class="sidebar-widget mb-4" style="background: #f8f9fa; padding: 25px; border-radius: 8px;">
                                <h4 style="margin-bottom: 20px; color: #333; border-bottom: 2px solid #0000ff; padding-bottom: 10px;">
                                    <i class="fas fa-folder" style="color: #0000ff;"></i> Category
                                </h4>
                                <a href="<?= url('blog?category=' . urlencode($post['category'])) ?>" style="background: #0000ff; color: #fff; padding: 10px 20px; border-radius: 20px; text-decoration: none; display: inline-block; font-weight: 600;">
                                    <?= htmlspecialchars($post['category']) ?>
                                </a>
                            </div>
                        <?php endif; ?>
                        
                        <!-- Post Info Widget -->
                        <div class="sidebar-widget mb-4" style="background: #f8f9fa; padding: 25px; border-radius: 8px;">
                            <h4 style="margin-bottom: 20px; color: #333; border-bottom: 2px solid #0000ff; padding-bottom: 10px;">
                                <i class="fas fa-info-circle" style="color: #0000ff;"></i> Post Information
                            </h4>
                            <ul class="list-unstyled" style="line-height: 2;">
                                <li><strong>Published:</strong><br><?= date('F j, Y', strtotime($post['created'])) ?></li>
                                <?php if (!empty($post['updated']) && $post['updated'] != $post['created']): ?>
                                    <li><strong>Updated:</strong><br><?= date('F j, Y', strtotime($post['updated'])) ?></li>
                                <?php endif; ?>
                                <?php if (!empty($post['author'])): ?>
                                    <li><strong>Author:</strong><br><?= htmlspecialchars($post['author']) ?></li>
                                <?php endif; ?>
                                <?php if (!empty($post['views'])): ?>
                                    <li><strong>Total Views:</strong><br><?= number_format($post['views']) ?></li>
                                <?php endif; ?>
                            </ul>
                        </div>
                    </aside>
                </div>
            </div>
        </div>
    </section>
    <!-- SINGLE BLOG SECTION END HERE -->

<?php
// Include footer
require_once BASE_PATH . '/partial/footer.php';
// Include footer scripts
require_once BASE_PATH . '/partial/footer_scripts.php';
?>
