<?php 
require_once __DIR__ . '/../config.php';

// Fetch shared hosting plans from database
$shared_plans = [];
try {
    $db = get_db();
    $stmt = $db->prepare("SELECT * FROM hosting_plans WHERE plan_type = 'shared' AND status = 'active' ORDER BY display_order ASC, monthly_price ASC");
    $stmt->execute();
    $shared_plans = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    error_log('Error fetching shared hosting plans: ' . $e->getMessage());
    // Continue with empty array - will show fallback if no plans
}
                
$page_title = 'Affordable Shared Hosting | Fast SSD, 99.9% Uptime | WsplCloud';
$page_description = 'Get reliable & affordable shared hosting from WsplCloud. Features include 1GB SSD, 100GB Bandwidth, Free SSL & 24/7 support. Perfect for small businesses & personal sites. Start your website today!';
$page_keywords = 'shared hosting, web hosting, affordable hosting, cheap hosting, SSD hosting, business hosting, personal website hosting, WsplCloud, 99.9% uptime, free SSL, 24/7 support';
$custom_css = ['priceslider.css']; // Add pricing specific CSS

// Include header meta (DOCTYPE, <head>, opening <body> tag)
require_once BASE_PATH . '/partial/header_meta.php';
?>
    <!-- Additional CSS files if needed -->
    <link rel="stylesheet" href="<?= asset('css/custom.css') ?>">
    <link rel="stylesheet" href="<?= asset('css/mobile.css') ?>">
    
    <style>
        /* Toggle Switch Styles */
        .billing-toggle-container {
            display: flex;
            justify-content: center;
            align-items: center;
            margin-bottom: 40px;
        }
        
        .billing-toggle {
            display: flex;
            align-items: center;
            background-color: #f5f5f5;
            border-radius: 30px;
            padding: 5px;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        }
        
        .billing-option {
            padding: 10px 20px;
            cursor: pointer;
            border-radius: 25px;
            transition: all 0.3s ease;
            font-weight: 600;
        }
        
        .billing-option.active {
            background-color: #000fff;
            color: white;
        }
        
        .yearly-saving {
            color: #28a745;
            font-size: 14px;
            margin-left: 10px;
            font-weight: 600;
        }
        
        .plan-price {
            transition: all 0.3s ease;
        }
        
    /* Introduction Section Styles */
    .shared-hosting-intro {
        background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
        position: relative;
        overflow: hidden;
    }
    
    .shared-hosting-intro::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: #ffffff;
        z-index: 0;
    }
    
    .intro-content-con {
        position: relative;
        z-index: 1;
    }
    
    .intro-text-con h3 {
        color: #000fff;
        font-size: 2rem;
        margin-bottom: 1.5rem;
        font-weight: 700;
    }
    
    .intro-text-con p {
        font-size: 1.1rem;
        line-height: 1.7;
        margin-bottom: 2rem;
        color: #555;
    }
    
    .intro-features-list {
        margin-bottom: 2.5rem;
    }
    
    .intro-features-list li {
        padding: 0.5rem 0;
        font-size: 1.05rem;
        color: #444;
    }
    
    .intro-features-list i {
        color: #000fff;
        margin-right: 10px;
        font-size: 1.2rem;
    }
    
    .intro-stats-con {
        display: flex;
        justify-content: space-between;
        margin-top: 2rem;
        flex-wrap: wrap;
    }
    
    .stat-box {
        text-align: center;
        padding: 1rem;
        background: white;
        border-radius: 10px;
        box-shadow: 0 5px 15px rgba(0, 15, 255, 0.1);
        flex: 1;
        margin: 0 10px;
        min-width: 100px;
    }
    
    .stat-box h4 {
        color: #000fff;
        font-size: 2rem;
        margin-bottom: 0.5rem;
        font-weight: 700;
    }
    
    .stat-box span {
        font-size: 0.9rem;
        color: #666;
    }
    .gif-caption {
        margin-top: 1rem;
        font-style: italic;
        color: #666;
        font-size: 0.9rem;
    }
    
    /* Who Should Use Section */
    .who-should-use-con {
        margin-top: 4rem;
        padding-top: 3rem;
        border-top: 1px solid #ddd;
    }
    
    .user-type-box {
        text-align: center;
        padding: 2rem 1.5rem;
        background: white;
        border-radius: 10px;
        box-shadow: 0 5px 15px rgba(0, 15, 255, 0.1);
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        height: 100%;
    }
    
    .user-type-box:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 25px rgba(0, 15, 255, 0.15);
    }
    
    .user-icon {
        width: 80px;
        height: 80px;
        background: linear-gradient(135deg, #000fff, #4d5dfb);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        margin: 0 auto 1.5rem;
    }
    
    .user-icon i {
        font-size: 2rem;
        color: white;
    }
    
    .user-type-box h4 {
        color: #000fff;
        margin-bottom: 1rem;
        font-weight: 600;
    }
    
    .user-type-box p {
        color: #666;
        line-height: 1.6;
    }
    
       
    
    
    /* Responsive Styles */
    @media (max-width: 991px) {
        .intro-stats-con {
            justify-content: center;
        }
        
        .stat-box {
            margin: 10px;
            flex: 0 0 calc(50% - 20px);
        }
        
        .user-type-box {
            margin-bottom: 2rem;
        }
    }
    
    @media (max-width: 767px) {
        .intro-text-con h3 {
            font-size: 1.7rem;
        }
        
        .stat-box {
            flex: 0 0 100%;
            margin: 5px 0;
        }
        
        .intro-gif-con {
            margin-top: 2rem;
        }
    }
    .plan-icon{
        width: 38px;
        height: 38px;
    }

    /* Plan features list styling */
    .hosting-type-content-con ul {
        margin-top: 8px;
    }

    .hosting-type-content-con ul li {
        padding: 8px 0;
        font-size: 1.05rem;
        color: #444;
        display: flex;
        align-items: center;
    }

    .hosting-type-content-con ul li i {
        color: #000fff;
        margin-right: 10px;
        font-size: 0.9rem;
        width: 18px;
        text-align: center;
    }

    .hosting-type-content-con ul li span { color: inherit; }

    /* Plan features list styling to match other pages */
    .plan-features { margin-top: 12px; }
    .plan-features li { padding: 10px 0; color: #444; font-size: 1.05rem; }
    .plan-features li i { color: #000fff; margin-right: 10px; }

    /* view-more button removed - extra feature items are visible by default */

    /* Styles for the single 'View More Features' control */
    #view-more-features {
        display: inline-block;
        min-width: 160px;
        padding: 10px 18px;
        background: #000fff; /* site blue */
        color: #ffffff;
        border: none;
        border-radius: 6px;
        font-weight: 700;
        font-size: 0.95rem;
        line-height: 1;
        cursor: pointer;
        box-shadow: 0 6px 18px rgba(0,0,0,0.08);
        transition: background 160ms ease, transform 120ms ease, box-shadow 120ms ease;
        text-decoration: none;
        margin-top: 52px;
    }
    #view-more-features:hover { background: #0056d6; transform: translateY(-1px); }
    #view-more-features:active { transform: translateY(0); }
    #view-more-features[aria-expanded="true"] { background: #003d9a; }
    #view-more-features:focus {
        outline: 3px solid rgba(0,95,255,0.18);
        outline-offset: 2px;
    }
    @media (max-width: 576px) {
        #view-more-features { width: 100%; box-sizing: border-box; }
    }

    </style>
</head>

<body>
    <?php require_once BASE_PATH . '/partial/preloader.php'; ?>
    <!-- HEADER SECTION START HERE -->
    <?php require_once BASE_PATH . '/partial/header.php'; ?>
    <!-- HEADER SECTION END HERE -->
    
    <!-- BANNER SECTION START HERE -->
    <section class="hosting-pages-sub-banner sub-banner-main-con w-100 float-left">
        <div class="container">
            <div class="sub-banner-inner-con wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
                <h1>Shared Hosting</h1>
                     <span class="d-block position-relative"></span>
            <h6>
                <a href="<?= url('') ?>" style="color: #fff; transition: color 0.2s;" onmouseover="this.style.color='#FFD700'" onmouseout="this.style.color='#fff'">Home</a>
               <span style="color: #fff;"> | </span>
                <a href="<?= url('pages/shared-hosting') ?>" style="color: #fff; transition: color 0.2s;" onmouseover="this.style.color='#FFD700'" onmouseout="this.style.color='#fff'">Shared Hosting</a>
            
                </h6>
                </div>
        </div>
    </section>
    <!-- BANNER SECTION END HERE -->
    <!-- DOMAINS SECTION START HERE -->
     <!-- Add this section right after the BANNER SECTION END HERE -->
<!-- INTRODUCTION SECTION START HERE -->
<section class="shared-hosting-intro w-100 float-left padding-top padding-bottom">
    <div class="container">
        <div class="generic-title text-center wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
            <h2>What is Shared Hosting?</h2>
            <p>Perfect for beginners and small businesses - understand how shared hosting works</p>
        </div>
        
        <div class="intro-content-con wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.5s">
            <div class="row align-items-center">
                <div class="col-lg-6 col-md-6">
                    <div class="intro-text-con">
                        <h3>Affordable Web Hosting Solution</h3>
                        <p>Shared hosting is the most budget-friendly and beginner-friendly hosting option where multiple websites share resources on a single server. It's ideal for:</p>
                        
                        <ul class="list-unstyled intro-features-list">
                            <li><i class="fas fa-check-circle"></i> Personal blogs and portfolios</li>
                            <li><i class="fas fa-check-circle"></i> Small business websites</li>
                            <li><i class="fas fa-check-circle"></i> Startup company sites</li>
                            <li><i class="fas fa-check-circle"></i> Non-profit organizations</li>
                            <li><i class="fas fa-check-circle"></i> E-commerce stores (small scale)</li>
                            <li><i class="fas fa-check-circle"></i> Testing and development sites</li>
                        </ul>
                        
                        <div class="intro-stats-con">
                            <div class="stat-box">
                                <h4>99.9%</h4>
                                <span>Uptime Guarantee</span>
                            </div>
                            <div class="stat-box">
                                <h4>24/7</h4>
                                <span>Support Available</span>
                            </div>
                            <div class="stat-box">
                                <h4>30-Day</h4>
                                <span>Money Back</span>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="col-lg-6 col-md-6">
                    <div class="intro-gif-con text-center">
                        <!-- Animated GIF showing shared hosting concept -->
                        <img src="<?= asset('images/dol.gif') ?>" alt="Shared Hosting Animation" class="intro-gif">
                        
                        <!-- Fallback static image if GIF doesn't load -->
                        <noscript>
                            <img src="<?= asset('images/shared-hosting-static.png') ?>" alt="Shared Hosting Diagram" class="intro-static-img">
                        </noscript>
                        
                        <div class="gif-caption">
                            <p>Visual representation of how multiple websites share server resources</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Who Should Use Shared Hosting Section -->
        <div class="who-should-use-con wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.7s">
            <div class="row">
                <div class="col-lg-4 col-md-4">
                    <div class="user-type-box">
                        <div class="user-icon">
                            <i class="fas fa-user-graduate"></i>
                        </div>
                        <h4>Beginners</h4>
                        <p>Perfect for those new to web hosting with easy-to-use control panels and managed services.</p>
                    </div>
                </div>
                
                <div class="col-lg-4 col-md-4">
                    <div class="user-type-box">
                        <div class="user-icon">
                            <i class="fas fa-briefcase"></i>
                        </div>
                        <h4>Small Businesses</h4>
                        <p>Ideal for small to medium businesses needing reliable hosting without high costs.</p>
                    </div>
                </div>
                
                <div class="col-lg-4 col-md-4">
                    <div class="user-type-box">
                        <div class="user-icon">
                            <i class="fas fa-rocket"></i>
                        </div>
                        <h4>Startups</h4>
                        <p>Great for startups looking to establish an online presence quickly and affordably.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- INTRODUCTION SECTION END HERE -->


     <!-- plan section-->
 <div style="margin-top:50px;"class="banner-sub-sec w-100 float-left">
          <div class="billing-toggle-container wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s" style="margin-bottom: 200px;">
                <div class="billing-toggle">
                    <div class="billing-option active" data-period="monthly">Monthly </div>
                    <div class="billing-option" data-period="yearly">Yearly </div>
                 
                </div>
            </div>
            <br>
        <div class="container">
            <div class="banner-sub-outer-con wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
            <div class="hosting-types-inner-con web-hosting-inner-con" style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 20px;">
                
                <?php if (!empty($shared_plans)): ?>
                    <?php 
                    $plan_colors = ['plan1-flower', 'plan2-flower', 'plan3-flower', 'plan1-flower'];
                    foreach ($shared_plans as $index => $plan): 
                        $plan_color = $plan_colors[$index % count($plan_colors)];
                        
                        // Parse JSON fields
                        $features = json_decode($plan['features'] ?? '[]', true) ?: [];
                        $developer_features = json_decode($plan['developer_features'] ?? '[]', true) ?: [];
                        $technical_details = json_decode($plan['technical_details'] ?? '[]', true) ?: [];
                    ?>
                    <div class="hosting-type-box" style="height: 100%;">
                        <div class="hosting-type-content-con <?php echo $plan_color; ?>" style="height: 100%;">
                            <figure>
                                <?php if (!empty($plan['icon_image'])): ?>
                                    <img class="plan-icon" src="<?= asset($plan['icon_image']) ?>" alt="<?= htmlspecialchars($plan['plan_name']) ?>">
                                <?php else: ?>
                                    <img class="plan-icon" src="<?= asset('images/icons/shared-hosting/default.png') ?>" alt="<?= htmlspecialchars($plan['plan_name']) ?>">
                                <?php endif; ?>
                            </figure>
                            <h5><?= htmlspecialchars($plan['plan_name']) ?></h5>
                            <p><?= htmlspecialchars($plan['description']) ?></p>
                            <div class="hosting-price-box">
                                <span class="dollar">₹</span>
                                <span class="numeric1 plan-price" data-monthly="<?= number_format($plan['monthly_price'], 0) ?>" data-yearly="<?= number_format($plan['yearly_price'], 0) ?>"><?= number_format($plan['monthly_price'], 0) ?></span>
                                <div class="month-title">
                                    <span id="point_val2" class="numeric2"></span>
                                    <br>
                                    <small class="billing-period">/month</small>
                                </div>
                            </div>
                            <div class="primary-btn blue-btn">
                                <a href="<?= url('pages/contact.php?intent=order_shared_hosting') ?>">ORDER NOW <i class="fas fa-arrow-right"></i></a>
                            </div>
                            <ul class="list-unstyled plan-features">
                                <!-- Main Features -->
                                <?php if (!empty($plan['storage'])): ?>
                                    <li class="position-relative"><i class="fas fa-check" style="color: #28a745;"></i> <span><?= htmlspecialchars($plan['storage']) ?></span> Web Space</li>
                                <?php endif; ?>
                                <?php if (!empty($plan['bandwidth'])): ?>
                                    <li class="position-relative"><i class="fas fa-check" style="color: #28a745;"></i> <span><?= htmlspecialchars($plan['bandwidth']) ?></span> Bandwidth</li>
                                <?php endif; ?>
                                <?php if (!empty($plan['domains'])): ?>
                                    <li class="position-relative"><i class="fas fa-check" style="color: #28a745;"></i> <span class="free-item"><?= htmlspecialchars($plan['domains']) ?></span> Domain</li>
                                <?php endif; ?>
                                <?php if (!empty($plan['databases'])): ?>
                                    <li class="position-relative"><i class="fas fa-check" style="color: #28a745;"></i> <span><?= htmlspecialchars($plan['databases']) ?></span> Databases</li>
                                <?php endif; ?>
                                <?php if (!empty($plan['emails'])): ?>
                                    <li class="position-relative"><i class="fas fa-check" style="color: #28a745;"></i> <span><?= htmlspecialchars($plan['emails']) ?></span> Emails</li>
                                <?php endif; ?>
                                <?php if (!empty($plan['backup'])): ?>
                                    <?php if (strtolower($plan['backup']) === 'no' || strpos(strtolower($plan['backup']), 'no') !== false): ?>
                                        <li class="position-relative"><i class="fas fa-times" style="color: #dc3545;"></i> <span class="free-item">Extra</span> Backup</li>
                                    <?php else: ?>
                                        <li class="position-relative"><i class="fas fa-check" style="color: #28a745;"></i> <span class="free-item"><?= htmlspecialchars($plan['backup']) ?></span> Backup</li>
                                    <?php endif; ?>
                                <?php endif; ?>

                                <!-- Developer Features Section -->
                                <?php if (!empty($developer_features)): ?>
                                    <li class="position-relative extra-item plan-subheading" style="margin-top:12px; font-weight:700;color:#0000ff;">
                                        <i class="fas fa-code" style="color:#0000ff; margin-right:10px; width:18px; text-align:center;"></i>
                                        Developer Features
                                    </li>
                                    <?php foreach ($developer_features as $dev_feature): ?>
                                        <?php if (is_array($dev_feature)): ?>
                                            <li class="position-relative extra-item <?= !empty($dev_feature['available']) ? 'supported' : 'unsupported' ?>">
                                                <i class="fas <?= !empty($dev_feature['available']) ? 'fa-check' : 'fa-times' ?>" style="color: <?= !empty($dev_feature['available']) ? '#28a745' : '#dc3545' ?>;"></i>
                                                <span><?= htmlspecialchars($dev_feature['name'] ?? '') ?></span>
                                            </li>
                                        <?php endif; ?>
                                    <?php endforeach; ?>
                                <?php endif; ?>

                                <!-- Technical Details Section -->
                                <?php if (!empty($technical_details)): ?>
                                    <li class="position-relative extra-item plan-subheading" style="margin-top:12px; font-weight:700;color:#0000ff;">
                                        <i class="fas fa-cog" style="color:#0000ff; margin-right:10px; width:18px; text-align:center;"></i>
                                        Technical Details
                                    </li>
                                    <?php foreach ($technical_details as $tech_detail): ?>
                                        <?php if (is_array($tech_detail)): ?>
                                            <li class="position-relative extra-item">
                                                <i class="fas <?= !empty($tech_detail['available']) ? 'fa-check' : 'fa-times' ?>" style="color: <?= !empty($tech_detail['available']) ? '#28a745' : '#dc3545' ?>;"></i>
                                                <?php if (!empty($tech_detail['value'])): ?>
                                                    <span><?= htmlspecialchars($tech_detail['value']) ?></span>
                                                <?php endif; ?>
                                                <?= htmlspecialchars($tech_detail['name'] ?? '') ?>
                                            </li>
                                        <?php endif; ?>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </ul>
                        </div>
                    </div>
                    <?php endforeach; ?>
                    
                <?php else: ?>
                    <!-- Fallback: Show message if no plans in database -->
                    <div style="grid-column: 1 / -1; text-align: center; padding: 3rem;">
                        <p style="color: #7f8c8d; font-size: 1.1rem;">
                            <i class="fas fa-info-circle" style="color: #3498db;"></i>
                            Plans are currently being updated. Please check back soon or <a href="<?= url('pages/contact.php') ?>" style="color: #0000ff;">contact us</a> for more information.
                        </p>
                    </div>
                <?php endif; ?>
                
            </div>

            <!-- Control button: View More Features (reveal extra features) -->
            <?php if (!empty($shared_plans)): ?>
            <div class="text-center mt-4">
                <button id="view-more-features" type="button" class="primary-btn blue-btn" aria-expanded="false">View More Features</button>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>
    <!-- DOMAIN SECTION END HERE -->
    <!-- DEDICATED FEATURES SECTION START HERE -->
<section class="dedicated-features-con advance-web-features-con w-100 float-left pt-100 padding-bottom">
        <div class="container">
            <div class="feature-main-con wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
                <div class="generic-title text-center">
                    <h2>Why Choose Our Shared Hosting?</h2>
                    <p>From beginner-friendly features to enterprise-grade performance, our shared hosting plans deliver everything you need to succeed online. <span class="d-inline-block">Fast SSD storage, free SSL certificates, one-click installations,</span> and 24/7 expert support - all included.</p>
<a class="arrow-btn" href="<?= url('pages/contact.php?intent=get_started_shared_hosting') ?>">Get Started Today <i class="fas fa-arrow-right"></i></a>
                </div>
                <div class="feature-inner-con">
                    <div class="feature-box">
                        <figure>
                            <img src="<?= asset('images/feature-img1.png') ?>" alt="SSD Performance">
                        </figure>
                        <div class="feature-side-txt-con">
                            <h5>Lightning-Fast SSD Storage</h5>
                            <p>All our shared hosting plans come with high-speed SSD storage that's up to 20x faster than traditional hard drives. From 1GB to 10GB across our plans, your website loads quickly and performs smoothly, giving your visitors the best experience.</p>
                            <a class="arrow-btn" href="<?= url('pages/contact') ?>">Learn More <i class="fas fa-arrow-right"></i></a>
                        </div>
                    </div>
                    <div class="feature-box">
                        <figure>
                            <img src="<?= asset('images/feature-img2.png') ?>" alt="One-Click Installation">
                        </figure>
                        <div class="feature-side-txt-con">
                            <h5>One-Click Website Builder</h5>
                            <p>Get your website online in minutes with our one-click WordPress installation and website builder tools. Choose from hundreds of professional themes and start building your online presence immediately - no technical skills required.</p>
                            <a class="arrow-btn" href="<?= url('pages/contact') ?>">Learn More <i class="fas fa-arrow-right"></i></a>
                        </div>
                    </div>
                    <div class="feature-box">
                        <figure>
                            <img src="<?= asset('images/feature-img3.png') ?>" alt="Free SSL Security">
                        </figure>
                        <div class="feature-side-txt-con">
                            <h5>Free SSL Certificate & Security</h5>
                            <p>Every shared hosting plan includes a free SSL certificate to encrypt your website and protect your visitors' data. Boost your search rankings and build trust with the green padlock in browsers - all at no extra cost.</p>
                            <a class="arrow-btn" href="<?= url('pages/contact') ?>">Learn More <i class="fas fa-arrow-right"></i></a>
                        </div>
                    </div>
                    <div class="feature-box">
                        <figure>
                            <img src="<?= asset('images/feature-img4.png') ?>" alt="24/7 Support">
                        </figure>
                        <div class="feature-side-txt-con">
                            <h5>24/7 Expert Support</h5>
                            <p>Our friendly support team is available around the clock to help you succeed. Whether you need help with setup, have technical questions, or want advice on growing your website, we're here to support your journey every step of the way.</p>
                            <a class="arrow-btn" href="<?= url('pages/contact') ?>">Get Support <i class="fas fa-arrow-right"></i></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- DEDICATED FEATURES SECTION END HERE -->
    <!-- SECURITY FEATURES SECTION START HERE -->
    <section class="shared-hosting-content w-100 float-left padding-top padding-bottom bg-shape">
        <div class="container">
            <div class="generic-title text-center wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
                <h2>So what's in Shared Hosting?</h2>
                <p>Comprehensive features across all our shared hosting plans - from Pearl to Wave</p>
            </div>
            <div class="shared-hosting-content-inner-con wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
                <div class="shared-hosting-content-left-con">
                        <figure class="mb-0">
                        <img src="<?= asset('images/shared-hosting-left-img.png') ?>" alt="shared-hosting-left-img">
                    </figure>
                </div>
                <div class="shared-hosting-content-right-con">
                    <h5>Included in Shared Hosting Plans</h5>
                    <ul class="mb-0 list-unstyled">
                        <li><i class="fas fa-check-circle circle-chk"></i>SSD Web Space (1GB to 10GB) <i class="fas fa-check"></i></li>
                        <li><i class="fas fa-check-circle circle-chk"></i><span class="d-inline-block">Unlimited Bandwidth</span> (Starfish & above) <i class="fas fa-check"></i></li>
                        <li><i class="fas fa-check-circle circle-chk"></i>Multiple Domain Support (Up to 5) <i class="fas fa-check"></i></li>
                        <li><i class="fas fa-check-circle circle-chk"></i>Unlimited Databases & Emails <i class="fas fa-check"></i></li>
                        <li><i class="fas fa-check-circle circle-chk"></i><span class="d-inline-block"><small class="free-item d-inline-block">FREE</small> Weekly Backups</span> <i class="fas fa-check"></i></li>
                        <li><i class="fas fa-check-circle circle-chk"></i><span class="d-inline-block"><small class="free-item d-inline-block">24/7</small> Technical Support</span> <i class="fas fa-check"></i></li>
                        <li><i class="fas fa-check-circle circle-chk"></i>99.9% Uptime Guarantee <i class="fas fa-check"></i></li>
                    
                    </ul>
                </div>
            </div>
        </div>
    </section>
    <!-- SECURITY FEATURES SECTION END HERE -->
    <!-- FAQ SECTION START HERE -->
    <section class="faq-main-con w-100 float-left padding-bottom pt-100">
        <div class="container">
            <div class="generic-title text-center wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
                <h2>Frequently Asked Questions</h2>
                <p>Do you have any questions? We have your answers!</p>
            </div>
            <div class="faq-inner-con wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
                <div id="accordion1">
                    <div class="card">
                        <div class="card-header" id="headingOne">
                            <h5 class="mb-0">
                                <button class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapseOne" aria-expanded="false" aria-controls="collapseOne">
                                 Which shared hosting plan is right for me?
                                </button>
                            </h5>
                        </div>
                        <div id="collapseOne" class="collapse" aria-labelledby="headingOne" data-parent="#accordion1">
                            <div class="card-body">
                                <strong>Pearl (₹30/month):</strong> Perfect for personal blogs, portfolios, or small websites with single domain needs.<br>
                                <strong>Starfish (₹79/month):</strong> Ideal for small businesses with unlimited bandwidth and databases.<br>
                                <strong>Seashell (₹149/month):</strong> Great for growing businesses needing up to 3 domains and 5GB storage.<br>
                                <strong>Wave (₹199/month):</strong> Best for established businesses managing up to 5 domains with 10GB storage.
                            </div>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-header" id="headingTwo">
                            <h5 class="mb-0">
                                <button class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                    How fast can I get my website online?
                                </button>
                            </h5>
                        </div>
                        <div id="collapseTwo" class="collapse" aria-labelledby="headingTwo" data-parent="#accordion1">
                            <div class="card-body">Your hosting account is activated instantly after payment confirmation. With our one-click WordPress installation, you can have your website up and running within minutes. Domain propagation may take up to 24 hours if you're using a new domain.</div>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-header" id="headingThree">
                            <h5 class="mb-0">
                                <button class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                                   Can I upgrade my plan later?
                                </button>
                            </h5>
                        </div>
                        <div id="collapseThree" class="collapse" aria-labelledby="headingThree" data-parent="#accordion1">
                            <div class="card-body">Absolutely! You can upgrade from Pearl to Starfish, Seashell, or Wave at any time. The upgrade is seamless, and you'll only pay the pro-rated difference. Your website will continue running without any downtime during the upgrade process.
                            </div>
                        </div>
                    </div>
                </div>
                <div id="accordion2">
                    <div class="card">
                        <div class="card-header" id="headingfour">
                            <h5 class="mb-0">
                                <button class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapsefour" aria-expanded="false" aria-controls="collapsefour">
                                     What if my website exceeds the resource limits?
                                </button>
                            </h5>
                        </div>
                        <div id="collapsefour" class="collapse" aria-labelledby="headingfour" data-parent="#accordion2">
                            <div class="card-body">Our system monitors resource usage automatically. If you approach your limits, we'll notify you via email with upgrade recommendations. Your website won't go offline - we'll work with you to find the best solution, whether that's optimizing your site or upgrading to a higher plan.</div>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-header" id="headingfive">
                            <h5 class="mb-0">
                                <button class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapsefive" aria-expanded="false" aria-controls="collapsefive">
                                    Do you provide website migration service?
                                </button>
                            </h5>
                        </div>
                        <div id="collapsefive" class="collapse" aria-labelledby="headingfive" data-parent="#accordion2">
                            <div class="card-body">Yes! We offer free website migration for all our shared hosting plans. Our technical team will transfer your website, databases, and email accounts from your previous host. The migration typically takes 24-48 hours, and we ensure zero data loss during the process.</div>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-header" id="headingsix">
                            <h5 class="mb-0">
                                <button class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapsesix" aria-expanded="false" aria-controls="collapsesix">
                                    What happens if I'm not satisfied with the service?
                                </button>
                            </h5>
                        </div>
                        <div id="collapsesix" class="collapse" aria-labelledby="headingsix" data-parent="#accordion2">
                            <div class="card-body">We offer a 30-day money-back guarantee on all shared hosting plans. If you're not completely satisfied within the first 30 days, simply contact our support team and we'll provide a full refund, no questions asked. This gives you plenty of time to test our service risk-free.</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- FAQ SECTION END HERE -->
     
    <!-- In-page behavioral scripts are moved into $page_scripts below so they run after global scripts (jQuery) -->
    
    <!-- Back-to-top removed -->

<?php 
// Add page-specific scripts
$page_scripts = [<<<'JS'
<script>
$(document).ready(function() {
    // Billing toggle functionality
    $('.billing-option').click(function() {
        // Remove active class from all options
        $('.billing-option').removeClass('active');

        // Add active class to clicked option
        $(this).addClass('active');

        // Get the selected period
        var period = $(this).data('period');

        // Update all plan prices
        $('.plan-price').each(function() {
            var monthlyPrice = $(this).data('monthly');
            var yearlyPrice = $(this).data('yearly');

            if (period === 'monthly') {
                $(this).text(monthlyPrice);
                $('.billing-period').text('/month');
            } else {
                $(this).text(yearlyPrice);
                $('.billing-period').text('/year');
            }
        });
    });

    // Hide extra feature items on load
    var $extras = $('.plan-features li.extra-item');
    $extras.hide();

    var $btn = $('#view-more-features');
    $btn.on('click', function(e){
        e.preventDefault();
        var isOpen = $btn.attr('aria-expanded') === 'true';
        if(isOpen){
            // collapse: hide all extras
            $extras.slideUp(250);
            $btn.attr('aria-expanded','false').text('View More Features');
            // scroll back to button
            $('html, body').animate({ scrollTop: $btn.offset().top - 20 }, 300);
        } else {
            // expand: show all extras smoothly
            $extras.slideDown(300);
            $btn.attr('aria-expanded','true').text('Show Less Features');
            // Optional: scroll to first plan's extra section
            var $firstExtra = $extras.first();
            if($firstExtra.length){
                var top = $firstExtra.closest('.hosting-type-content-con').offset().top - 20;
                $('html, body').animate({ scrollTop: top }, 350);
            }
        }
    });

    // IntersectionObserver animation for stat boxes
    var statBoxes = document.querySelectorAll('.stat-box');
    if('IntersectionObserver' in window){
        var observer = new IntersectionObserver(function(entries){
            entries.forEach(function(entry){
                if(entry.isIntersecting){
                    entry.target.style.opacity = '1';
                    entry.target.style.transform = 'translateY(0)';
                }
            });
        }, { threshold: 0.1 });

        statBoxes.forEach(function(box){
            box.style.opacity = '0';
            box.style.transform = 'translateY(20px)';
            box.style.transition = 'opacity 0.5s ease, transform 0.5s ease';
            observer.observe(box);
        });
    }

    // Hover effects for user type boxes
    $('.user-type-box').on('mouseenter', function(){
        $(this).find('.user-icon').css('transform', 'scale(1.1)');
    }).on('mouseleave', function(){
        $(this).find('.user-icon').css('transform', 'scale(1)');
    });

});
</script>
JS
];

// Include footer and scripts
require_once BASE_PATH . '/partial/footer.php';
require_once BASE_PATH . '/partial/footer_scripts.php';
?>
