<?php 
require_once __DIR__ . '/../config.php';

// Set page-specific variables
$page_title = 'FAQ | WsplCloud - Web Hosting & Cloud Services';
$page_description = 'Find answers to frequently asked questions about our web hosting services, domain registration, technical support, and billing.';
$page_keywords = 'web hosting faq, domain registration questions, hosting support, billing questions, technical faq';

// Include header meta (DOCTYPE, <head>, opening <body> tag)
require_once BASE_PATH . '/partial/header_meta.php';
?>
    <!-- Additional CSS files if needed -->
    <link rel="stylesheet" href="<?= asset('css/custom.css') ?>">
    <link rel="stylesheet" href="<?= asset('css/mobile.css') ?>">
    <style>
        .breadcrumb-list {
            margin-top: 15px;
        }
        .breadcrumb-link {
            color: #fff;
            transition: color 0.2s;
        }
        .breadcrumb-link:hover {
            color: #FFD700;
            text-decoration: none;
        }
        .breadcrumb-separator {
            color: #fff;
            margin: 0 5px;
        }
        .breadcrumb-current {
            color: #FFD700;
        }
        .faq-section {
            padding: 80px 0;
        }
        
        /* Enhanced FAQ Styles */
        .faq-search-box {
            max-width: 600px;
            margin: 0 auto 40px;
            position: relative;
        }
        
        .faq-search-box input {
            width: 100%;
            padding: 15px 20px;
            border: 2px solid #e9ecef;
            border-radius: 50px;
            font-size: 16px;
            transition: all 0.3s ease;
            box-shadow: 0 4px 15px rgba(0,0,0,0.05);
        }
        
        .faq-search-box input:focus {
            border-color: #007bff;
            box-shadow: 0 4px 20px rgba(0,123,255,0.15);
            outline: none;
        }
        
        .faq-search-box i {
            position: absolute;
            right: 20px;
            top: 50%;
            transform: translateY(-50%);
            color: #6c757d;
        }
        
        .faq-categories {
            display: flex;
            justify-content: center;
            flex-wrap: wrap;
            gap: 10px;
            margin-bottom: 40px;
        }
        
        .faq-category-btn {
            padding: 10px 20px;
            border: 2px solid #007bff;
            border-radius: 25px;
            background: white;
            color: #007bff;
            cursor: pointer;
            transition: all 0.3s ease;
            font-weight: 500;
        }
        
        .faq-category-btn:hover,
        .faq-category-btn.active {
            background: #007bff;
            color: white;
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(0,123,255,0.3);
        }
        
        .faq-card {
            margin-bottom: 15px;
            border-radius: 10px;
            border: 1px solid #e9ecef;
            overflow: hidden;
            transition: all 0.3s ease;
            box-shadow: 0 2px 8px rgba(0,0,0,0.05);
        }
        
        .faq-card:hover {
            box-shadow: 0 5px 20px rgba(0,0,0,0.1);
            transform: translateY(-2px);
        }
        
        .faq-card-header {
            background: white;
            padding: 20px;
            cursor: pointer;
            display: flex;
            justify-content: between;
            align-items: center;
            transition: background 0.3s ease;
        }
        
        .faq-card-header:hover {
            background: #f8f9fa;
        }
        
        .faq-card-header h5 {
            margin: 0;
            flex: 1;
            font-weight: 600;
            color: #2c3e50;
        }
        
        .faq-icon {
            margin-left: 15px;
            transition: transform 0.3s ease;
            color: #007bff;
        }
        
        .faq-card-header.collapsed .faq-icon {
            transform: rotate(0deg);
        }
        
        .faq-card-header:not(.collapsed) .faq-icon {
            transform: rotate(180deg);
        }
        
        .faq-card-body {
            padding: 20px;
            background: #f8f9fa;
            border-top: 1px solid #e9ecef;
            color: #495057;
            line-height: 1.6;
        }
        
        .no-results {
            text-align: center;
            padding: 40px;
            color: #6c757d;
            display: none;
        }
        
        .faq-contact-cta {
            background: linear-gradient(135deg, #007bff 0%, #0056b3 100%);
            color: white;
            padding: 40px;
            border-radius: 15px;
            text-align: center;
            margin-top: 50px;
        }
        
        .faq-contact-cta h3 {
            margin-bottom: 20px;
            font-weight: 600;
        }
        
        .faq-stats {
            display: flex;
            justify-content: center;
            gap: 30px;
            margin: 30px 0;
            flex-wrap: wrap;
        }
        
        .stat-item {
            text-align: center;
            padding: 20px;
        }
        
        .stat-number {
            font-size: 2.5rem;
            font-weight: bold;
            color: #007bff;
            margin-bottom: 5px;
        }
        
        .stat-label {
            color: #6c757d;
            font-weight: 500;
        }
        
        @media (max-width: 768px) {
            .faq-categories {
                flex-direction: column;
                align-items: center;
            }
            
            .faq-category-btn {
                width: 200px;
            }
            
            .faq-stats {
                flex-direction: column;
                gap: 15px;
            }
        }
    </style>
</head>

<body>
    <?php require_once BASE_PATH . '/partial/preloader.php'; ?>
    <!-- HEADER SECTION START HERE -->
    <?php require_once BASE_PATH . '/partial/header.php'; ?>
    <!-- HEADER SECTION END HERE -->

    <!-- BANNER SECTION START HERE -->
    <section class="hosting-pages-sub-banner sub-banner-main-con w-100 float-left">
        <div class="container">
            <div class="sub-banner-inner-con wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
                <h1>Frequently Asked Questions</h1>
                <span class="d-block position-relative"></span>
                <h6>
                    <a href="<?= url('') ?>" style="color: #fff; transition: color 0.2s;" onmouseover="this.style.color='#FFD700'" onmouseout="this.style.color='#fff'">Home</a>
                    <span style="color: #fff;"> / </span>
                    <a href="<?= url('faq') ?>" style="color: #fff; transition: color 0.2s;" onmouseover="this.style.color='#FFD700'" onmouseout="this.style.color='#fff'">FAQ</a>
                </h6>
            </div>
        </div>
    </section>
    <!-- BANNER SECTION END HERE -->

    <!-- FAQ SECTION START HERE -->
    <section class="faq-main-con w-100 float-left padding-bottom pt-100">
        <div class="container">
            <div class="generic-title text-center wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
                <h2>Frequently Asked Questions</h2>
                <p>Find quick answers to common questions about our hosting services</p>
            </div>

            <!-- FAQ Stats -->
            <div class="faq-stats wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.4s">
                <div class="stat-item">
                    <div class="stat-number">50+</div>
                    <div class="stat-label">Questions Answered</div>
                </div>
                <div class="stat-item">
                    <div class="stat-number">24/7</div>
                    <div class="stat-label">Support Available</div>
                </div>
                <div class="stat-item">
                    <div class="stat-number">99.9%</div>
                    <div class="stat-label">Satisfaction Rate</div>
                </div>
            </div>

            <!-- Search Box -->
            <div class="faq-search-box wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.5s">
                <input type="text" id="faqSearch" placeholder="Search for questions or topics...">
                <i class="fas fa-search"></i>
            </div>

            <!-- Categories -->
            <div class="faq-categories wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.6s">
                <button class="faq-category-btn active" data-category="all">All Questions</button>
                <button class="faq-category-btn" data-category="hosting">Hosting</button>
                <button class="faq-category-btn" data-category="domain">Domains</button>
                <button class="faq-category-btn" data-category="technical">Technical</button>
                <button class="faq-category-btn" data-category="billing">Billing</button>
            </div>

            <div class="faq-inner-con wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.7s">
                <!-- No Results Message -->
                <div class="no-results" id="noResults">
                    <i class="fas fa-search fa-3x mb-3"></i>
                    <h4>No results found</h4>
                    <p>Try different keywords or browse by category</p>
                </div>

                <!-- FAQ Accordion -->
                <div class="accordion" id="faqAccordion">
                    <!-- Hosting Category -->
                    <div class="faq-card" data-category="hosting">
                        <div class="faq-card-header collapsed" data-toggle="collapse" data-target="#collapseOne">
                            <h5>What is shared hosting?</h5>
                            <i class="fas fa-chevron-down faq-icon"></i>
                        </div>
                        <div id="collapseOne" class="collapse" data-parent="#faqAccordion">
                            <div class="faq-card-body">
                                Shared hosting is a type of web hosting where multiple websites share the same server resources, such as CPU, memory, and storage. This makes it an affordable and beginner-friendly option, ideal for small to medium websites or blogs.
                            </div>
                        </div>
                    </div>

                    <div class="faq-card" data-category="hosting">
                        <div class="faq-card-header collapsed" data-toggle="collapse" data-target="#collapseTwo">
                            <h5>How are servers shared?</h5>
                            <i class="fas fa-chevron-down faq-icon"></i>
                        </div>
                        <div id="collapseTwo" class="collapse" data-parent="#faqAccordion">
                            <div class="faq-card-body">
                                In shared hosting, one physical server is divided among multiple users. Each website gets its own section of storage and resources, but all sites use the same CPU, RAM, and bandwidth. Think of it like living in an apartment building where everyone has their own room but shares the same water, electricity, and building space.
                            </div>
                        </div>
                    </div>

                    <div class="faq-card" data-category="hosting">
                        <div class="faq-card-header collapsed" data-toggle="collapse" data-target="#collapseThree">
                            <h5>What is the least expensive type of hosting?</h5>
                            <i class="fas fa-chevron-down faq-icon"></i>
                        </div>
                        <div id="collapseThree" class="collapse" data-parent="#faqAccordion">
                            <div class="faq-card-body">
                                The least expensive type of hosting is Shared Hosting. Shared hosting is the most budget-friendly option because multiple websites share the same server and resources, which keeps costs low. It's perfect for beginners, personal blogs, small business sites, or anyone just getting started online.
                            </div>
                        </div>
                    </div>

                    <div class="faq-card" data-category="hosting">
                        <div class="faq-card-header collapsed" data-toggle="collapse" data-target="#collapseFour">
                            <h5>What are the advantages of shared hosting?</h5>
                            <i class="fas fa-chevron-down faq-icon"></i>
                        </div>
                        <div id="collapseFour" class="collapse" data-parent="#faqAccordion">
                            <div class="faq-card-body">
                                Shared hosting is a great starting point — it's affordable, easy to use, and fully managed. You can focus on your website, while we take care of the technical stuff.
                            </div>
                        </div>
                    </div>

                    <!-- Domain Category -->
                    <div class="faq-card" data-category="domain">
                        <div class="faq-card-header collapsed" data-toggle="collapse" data-target="#collapseFive">
                            <h5>What Is Domain Hosting?</h5>
                            <i class="fas fa-chevron-down faq-icon"></i>
                        </div>
                        <div id="collapseFive" class="collapse" data-parent="#faqAccordion">
                            <div class="faq-card-body">
                                Domain hosting is the service that manages your domain name — like yourwebsite.com — and connects it to your website or email. It makes sure that when someone types your domain into a browser, they're taken to the correct website.
                            </div>
                        </div>
                    </div>

                    <!-- Technical Category -->
                    <div class="faq-card" data-category="technical">
                        <div class="faq-card-header collapsed" data-toggle="collapse" data-target="#collapseSix">
                            <h5>What is uptime?</h5>
                            <i class="fas fa-chevron-down faq-icon"></i>
                        </div>
                        <div id="collapseSix" class="collapse" data-parent="#faqAccordion">
                            <div class="faq-card-body">
                                Uptime is the percentage of time your website is online and accessible. Most hosts guarantee 99.9% uptime, meaning your site will be available almost all the time.
                            </div>
                        </div>
                    </div>

                    <div class="faq-card" data-category="technical">
                        <div class="faq-card-header collapsed" data-toggle="collapse" data-target="#collapseSeven">
                            <h5>What is bandwidth?</h5>
                            <i class="fas fa-chevron-down faq-icon"></i>
                        </div>
                        <div id="collapseSeven" class="collapse" data-parent="#faqAccordion">
                            <div class="faq-card-body">
                                Bandwidth is the amount of data transferred between your website and its visitors. Higher bandwidth allows more visitors and faster loading times.
                            </div>
                        </div>
                    </div>

                    <div class="faq-card" data-category="technical">
                        <div class="faq-card-header collapsed" data-toggle="collapse" data-target="#collapseEight">
                            <h5>What is an SSL certificate?</h5>
                            <i class="fas fa-chevron-down faq-icon"></i>
                        </div>
                        <div id="collapseEight" class="collapse" data-parent="#faqAccordion">
                            <div class="faq-card-body">
                                An SSL certificate encrypts data between your website and visitors, making it secure. It's essential for protecting sensitive information and improving SEO.
                            </div>
                        </div>
                    </div>

                    <div class="faq-card" data-category="technical">
                        <div class="faq-card-header collapsed" data-toggle="collapse" data-target="#collapseNine">
                            <h5>What is a control panel?</h5>
                            <i class="fas fa-chevron-down faq-icon"></i>
                        </div>
                        <div id="collapseNine" class="collapse" data-parent="#faqAccordion">
                            <div class="faq-card-body">
                                A control panel is a web-based dashboard that lets you manage your hosting account, domains, emails, files, and more. cPanel is the most popular control panel.
                            </div>
                        </div>
                    </div>

                    <!-- Billing Category -->
                    <div class="faq-card" data-category="billing">
                        <div class="faq-card-header collapsed" data-toggle="collapse" data-target="#collapseTen">
                            <h5>Can I upgrade my hosting plan later?</h5>
                            <i class="fas fa-chevron-down faq-icon"></i>
                        </div>
                        <div id="collapseTen" class="collapse" data-parent="#faqAccordion">
                            <div class="faq-card-body">
                                Yes, you can upgrade your hosting plan at any time as your website grows and needs more resources.
                            </div>
                        </div>
                    </div>

                    <!-- Add more FAQ items following the same pattern -->
                    <!-- ... (include all your other FAQ items here with appropriate categories) ... -->

                </div>

                <!-- Contact CTA -->
                <div class="faq-contact-cta wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.8s" style="box-shadow: 0 8px 32px rgba(0,123,255,0.15); border: 2px solid #fff; position: relative; overflow: hidden;">
                    <div style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; background: url('<?= asset('images/faq-bg.jpg') ?>') no-repeat center center / cover; opacity: 0.08; pointer-events: none;"></div>
                    <h3 style="font-size: 2.2rem; letter-spacing: 1px;">Still have questions?</h3>
                    <p style="font-size: 1.15rem; margin-bottom: 30px;">Our support team is available <span style="font-weight:600; color:#FFD700;">24/7</span> to help you with any questions or issues</p>
                    <a href="<?= url('contact') ?>" class="btn btn-light btn-lg" style="color: #007bff; font-weight: 600; border-radius: 30px; box-shadow: 0 2px 8px rgba(0,123,255,0.10); transition: background 0.2s, color 0.2s;">
                        Contact Support
                    </a>
                </div>
            </div>
        </div>
    </section>
    <!-- FAQ SECTION END HERE -->

<?php
// Add page-specific scripts
$page_scripts = ['<script>
    $(document).ready(function() {
        // FAQ Search Functionality
        $("#faqSearch").on("keyup", function() {
            var value = $(this).val().toLowerCase();
            var visibleItems = 0;
            
            $(".faq-card").each(function() {
                var question = $(this).find("h5").text().toLowerCase();
                var answer = $(this).find(".faq-card-body").text().toLowerCase();
                
                if (question.indexOf(value) > -1 || answer.indexOf(value) > -1) {
                    $(this).show();
                    visibleItems++;
                } else {
                    $(this).hide();
                }
            });
            
            // Show/hide no results message
            if (visibleItems === 0) {
                $("#noResults").show();
            } else {
                $("#noResults").hide();
            }
            
            // Update category filter
            updateCategoryFilter();
        });
        
        // Category Filter
        $(".faq-category-btn").click(function() {
            $(".faq-category-btn").removeClass("active");
            $(this).addClass("active");
            
            var category = $(this).data("category");
            
            if (category === "all") {
                $(".faq-card").show();
                $("#noResults").hide();
            } else {
                var visibleItems = 0;
                
                $(".faq-card").each(function() {
                    if ($(this).data("category") === category) {
                        $(this).show();
                        visibleItems++;
                    } else {
                        $(this).hide();
                    }
                });
                
                if (visibleItems === 0) {
                    $("#noResults").show();
                } else {
                    $("#noResults").hide();
                }
            }
        });
        
        // Function to update category filter based on search
        function updateCategoryFilter() {
            var activeCategory = $(".faq-category-btn.active").data("category");
            if (activeCategory !== "all") {
                $(".faq-category-btn[data-category=\'all\']").click();
            }
        }
        
        // Smooth scroll to FAQ section when coming from another page with hash
        if (window.location.hash) {
            var target = $(window.location.hash);
            if (target.length) {
                $("html, body").animate({
                    scrollTop: target.offset().top - 100
                }, 1000);
                
                // Open the target FAQ item
                target.collapse("show");
            }
        }
        
        // Add animation to FAQ items when they come into view
        function animateFAQItems() {
            $(".faq-card").each(function() {
                if ($(this).is(":visible")) {
                    $(this).addClass("animated fadeIn");
                }
            });
        }
        
        // Initial animation
        animateFAQItems();
        
        // Re-animate when filtering
        $(".faq-category-btn, #faqSearch").on("click keyup", function() {
            setTimeout(animateFAQItems, 300);
        });
    });
</script>'];

// Include footer and scripts
require_once BASE_PATH . '/partial/footer.php';
require_once BASE_PATH . '/partial/footer_scripts.php';
?>