<?php 
require_once __DIR__ . '/../config.php';

// Fetch Cloud hosting plans from database
$db = get_db();
$stmt = $db->prepare("SELECT * FROM hosting_plans WHERE plan_type = 'cloud' AND status = 'active' ORDER BY display_order ASC");
$stmt->execute();
$cloud_plans = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Set page-specific variables
$page_title = 'Scalable Cloud Hosting | High Performance & Reliability | WsplCloud';
$page_description = 'Discover powerful, scalable, and reliable cloud hosting solutions from WsplCloud. High performance, security, and 24/7 support for businesses of all sizes.';
$page_keywords = 'cloud hosting, cloud servers, scalable hosting, business cloud hosting, WsplCloud cloud, high performance hosting, reliable cloud, secure hosting, VPS hosting, enterprise cloud';
$custom_css = ['priceslider.css']; // Add pricing specific CSS

// Include header meta (DOCTYPE, <head>, opening <body> tag)
require_once BASE_PATH . '/partial/header_meta.php';

// Include the navigation header
require_once BASE_PATH . '/partial/header.php';
?>
 <style>
      .shared-hosting-intro {
        background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
        position: relative;
        overflow: hidden;
    }
    
    .shared-hosting-intro::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: #fff;
        z-index: 0;
    }
    
    .intro-content-con {
        position: relative;
        z-index: 1;
    }
    
    .intro-text-con h3 {
        color: #000fff;
        font-size: 2rem;
        margin-bottom: 1.5rem;
        font-weight: 700;
    }
    
    .intro-text-con p {
        font-size: 1.1rem;
        line-height: 1.7;
        margin-bottom: 2rem;
        color: #555;
    }
    
    .intro-features-list {
        margin-bottom: 2.5rem;
    }
    
    .intro-features-list li {
        padding: 0.5rem 0;
        font-size: 1.05rem;
        color: #444;
    }
    
    .intro-features-list i {
        color: #000fff;
        margin-right: 10px;
        font-size: 1.2rem;
    }
    
    .intro-stats-con {
        display: flex;
        justify-content: space-between;
        margin-top: 2rem;
        flex-wrap: wrap;
    }
    
    .stat-box {
        text-align: center;
        padding: 1rem;
        background: white;
        border-radius: 10px;
        box-shadow: 0 5px 15px rgba(0, 15, 255, 0.1);
        flex: 1;
        margin: 0 10px;
        min-width: 100px;
    }
    
    .stat-box h4 {
        color: #000fff;
        font-size: 2rem;
        margin-bottom: 0.5rem;
        font-weight: 700;
    }
    
    .stat-box span {
        font-size: 0.9rem;
        color: #666;
    }
    .gif-caption {
        margin-top: 1rem;
        font-style: italic;
        color: #666;
        font-size: 0.9rem;
    }
    
    /* Who Should Use Section */
    .who-should-use-con {
        margin-top: 4rem;
        padding-top: 3rem;
        border-top: 1px solid #ddd;
    }
    
    .user-type-box {
        text-align: center;
        padding: 2rem 1.5rem;
        background: white;
        border-radius: 10px;
        box-shadow: 0 5px 15px rgba(0, 15, 255, 0.1);
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        height: 100%;
    }
    
    .user-type-box:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 25px rgba(0, 15, 255, 0.15);
    }
    
    .user-icon {
        width: 80px;
        height: 80px;
        background: linear-gradient(135deg, #000fff, #4d5dfb);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        margin: 0 auto 1.5rem;
    }
    
    .user-icon i {
        font-size: 2rem;
        color: white;
    }
    
    .user-type-box h4 {
        color: #000fff;
        margin-bottom: 1rem;
        font-weight: 600;
    }
    
    .user-type-box p {
        color: #666;
        line-height: 1.6;
    }
    
       
    
    
    /* Responsive Styles */
    @media (max-width: 991px) {
        .intro-stats-con {
            justify-content: center;
        }
        
        .stat-box {
            margin: 10px;
            flex: 0 0 calc(50% - 20px);
        }
        
        .user-type-box {
            margin-bottom: 2rem;
        }
    }
    
    @media (max-width: 767px) {
        .intro-text-con h3 {
            font-size: 1.7rem;
        }
        
        .stat-box {
            flex: 0 0 100%;
            margin: 5px 0;
        }
        
        .intro-gif-con {
            margin-top: 2rem;
        }
    }
    .plan-icon{
        width: 38px;
        height: 38px;
    }

    /* Plan features list styling */
    .hosting-type-content-con ul {
        margin-top: 8px;
    }

    .hosting-type-content-con ul li {
        padding: 8px 0;
        font-size: 1.05rem;
        color: #444;
        display: flex;
        align-items: center;
    }

    .hosting-type-content-con ul li i {
        color: #000fff;
        margin-right: 10px;
        font-size: 0.9rem;
        width: 18px;
        text-align: center;
    }

    .hosting-type-content-con ul li span { color: inherit; }

    /* Plan features list styling to match other pages */
    .plan-features { margin-top: 12px; }
    .plan-features li { padding: 10px 0; color: #444; font-size: 1.05rem; }
    .plan-features li i { color: #000fff; margin-right: 10px; }

    /* view-more button removed - extra feature items are visible by default */

    /* Styles for the single 'View More Features' control */
    #view-more-features {
        display: inline-block;
        min-width: 160px;
        padding: 10px 18px;
        background: #000fff; /* site blue */
        color: #ffffff;
        border: none;
        border-radius: 6px;
        font-weight: 700;
        font-size: 0.95rem;
        line-height: 1;
        cursor: pointer;
        box-shadow: 0 6px 18px rgba(0,0,0,0.08);
        transition: background 160ms ease, transform 120ms ease, box-shadow 120ms ease;
        text-decoration: none;
        margin-top: 52px;
    }
    #view-more-features:hover { background: #0056d6; transform: translateY(-1px); }
    #view-more-features:active { transform: translateY(0); }
    #view-more-features[aria-expanded="true"] { background: #003d9a; }
    #view-more-features:focus {
        outline: 3px solid rgba(0,95,255,0.18);
        outline-offset: 2px;
    }
    @media (max-width: 576px) {
        #view-more-features { width: 100%; box-sizing: border-box; }
    }


        @media only screen and (max-width: 767px) {
    .banner-main-con,
    .sub-banner-main-con,
    .hosting-pages-sub-banner,
    .banner-main-con .sub-banner-inner-con,
    .sub-banner-main-con .container {
        padding-top: 100px !important;
        padding-bottom: 100px !important;
        max-height: 400px !important;
        display: flex !important;
        align-items: center !important;
        justify-content: center !important;
        text-align: center !important;
    }
    /* Ensure headings remain readable and centered */
    .banner-main-con h1,
    .sub-banner-main-con h1,
    .hosting-pages-sub-banner h1 {
        font-size: 28px !important;
        line-height: 1.15 !important;
        margin: 0 auto !important;
        max-width: 92% !important;
    }
 }
        /* Toggle Switch Styles */
        .pricing-toggle {
            display: flex;
            justify-content: center;
            align-items: center;
            margin: 30px 0;
        }
        
        .toggle-text {
            margin: 0 15px;
            font-weight: 500;
            color: #ffffffff;
        }
        
        .toggle-text.active {
            color: #6cd2ebff;
            font-weight: 600;
        }
        
        .toggle-switch {
            position: relative;
            display: inline-block;
            width: 60px;
            height: 30px;
        }
        
        .toggle-switch input {
            opacity: 0;
            width: 0;
            height: 0;
        }
        
        .toggle-slider {
            position: absolute;
            cursor: pointer;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: #ccc;
            transition: .4s;
            border-radius: 34px;
        }
        
        .toggle-slider:before {
            position: absolute;
            content: "";
            height: 22px;
            width: 22px;
            left: 4px;
            bottom: 4px;
            background-color: white;
            transition: .4s;
            border-radius: 50%;
        }
        
        input:checked + .toggle-slider {
            background-color: #007bff;
        }
        
        input:checked + .toggle-slider:before {
            transform: translateX(30px);
        }
        
        .yearly-saving {
            background-color: #f8f9fa;
            padding: 2px 8px;
            border-radius: 4px;
            font-size: 12px;
            margin-left: 5px;
            color: #28a745;
            font-weight: 600;
        }
    </style>

    <?php require_once BASE_PATH . '/partial/preloader.php'; ?>
    
    <!-- HEADER SECTION START HERE -->
    <?php require_once BASE_PATH . '/partial/header.php'; ?>
    <!-- HEADER SECTION END HERE -->
    <!-- BANNER SECTION START HERE -->
    <section class="hosting-pages-sub-banner sub-banner-main-con w-100 float-left">
        <div class="container">
            <div class="sub-banner-inner-con wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
                
                <h1>Cloud Hosting</h1>
                  <span class="d-block position-relative"></span>
            <h6>
                <a href="<?= url('') ?>" style="color: #fff; transition: color 0.2s;" onmouseover="this.style.color='#FFD700'" onmouseout="this.style.color='#fff'">Home</a>
        
                <span style="color: #fff;"> | </span>
                <a href="<?= url('cloud-hosting') ?>" style="color: #fff; transition: color 0.2s;" onmouseover="this.style.color='#FFD700'" onmouseout="this.style.color='#fff'">Cloud Hosting</a>
            </h6>
            </div>
        </div>
    </section>
    <!-- BANNER SECTION END HERE -->
<section class="vps-intro w-100 float-left padding-top padding-bottom">
    <div class="container">
        <div class="generic-title text-center wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
            <h2>What is Cloud Hosting?</h2>
            <p>Cloud hosting runs your websites and apps on a distributed, redundant infrastructure — giving you elastic scalability, higher availability, and predictable performance.</p>
        </div>
        
        <div class="intro-content-con wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.5s">
            <div class="row align-items-center">
                <div class="col-lg-6 col-md-6">
                    <div class="intro-text-con">
                        <h3>Scalable, Reliable & Secure Cloud Hosting</h3>
                        <p>Our cloud hosting platform delivers on-demand resources, automated failover, global CDN integration, built-in DDoS protection, automated backups, and 24/7 infrastructure monitoring so your services stay fast and available.</p>
                        
                        <ul class="list-unstyled intro-features-list">
                            <li><i class="fas fa-cloud"></i> Cloud-native infrastructure with instant provisioning</li>
                            <li><i class="fas fa-sync-alt"></i> Auto-scaling resources for traffic spikes</li>
                            <li><i class="fas fa-hdd"></i> NVMe/SSD storage with redundancy and snapshots</li>
                            <li><i class="fas fa-network-wired"></i> Load balancing & global CDN for low latency</li>
                            <li><i class="fas fa-shield-alt"></i> DDoS protection, firewall & automated backups</li>
                            <li><i class="fas fa-headset"></i> 24/7 cloud infrastructure support</li>
                        </ul>
                        
                        <div class="intro-stats-con">
                            <div class="stat-box">
                                <h5 style="color:#0000ff;">Scalable</h4>
                                <span>Easy vertical & horizontal scaling</span>
                            </div>
                            <div class="stat-box">
                                <h5 style="color:#0000ff;">Redundant</h4>
                                <span>Multi-node failover & backups</span>
                            </div>
                            <div class="stat-box">
                                <h5 style="color:#0000ff;">99.99%</h4>
                                <span>SLA-driven uptime</span>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="col-lg-6 col-md-6">
                    <div class="intro-gif-con text-center">
                        <!-- Illustration showing Cloud hosting benefits -->
                        <img src="<?= asset('images/cloud-hosting.jpg') ?>" alt="Cloud Hosting Illustration" class="intro-gif" style="max-width: 100%; height: auto; border-radius: 12px;">
                        
                        <!-- Fallback static image if GIF doesn't load -->
                        <noscript>
                            <img src="<?= asset('images/cloud-hosting-static.png') ?>" alt="Cloud Hosting Diagram" class="intro-static-img">
                        </noscript>
                        
                        <div class="gif-caption">
                            <p>Enterprise-grade cloud platform with automatic scaling, redundancy, and global delivery.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Who Should Use Cloud Hosting -->
        <div class="who-should-use-con wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.7s">
            <div class="row">
                <div class="col-lg-4 col-md-4">
                    <div class="user-type-box">
                        <div class="user-icon">
                            <i class="fas fa-rocket"></i>
                        </div>
                        <h4>Startups & Growing Apps</h4>
                        <p>Start small and scale instantly as traffic and demand increase — pay for what you use and avoid costly overprovisioning.</p>
                    </div>
                </div>
                
                <div class="col-lg-4 col-md-4">
                    <div class="user-type-box">
                        <div class="user-icon">
                            <i class="fas fa-shopping-cart"></i>
                        </div>
                        <h4>eCommerce & High-Traffic Sites</h4>
                        <p>Handle flash sales, peak traffic, and payment reliability with redundant nodes, load balancing, and global CDN acceleration.</p>
                    </div>
                </div>
                
                <div class="col-lg-4 col-md-4">
                    <div class="user-type-box">
                        <div class="user-icon">
                            <i class="fas fa-building"></i>
                        </div>
                        <h4>Enterprises & SaaS Providers</h4>
                        <p>Compliant, resilient infrastructure with private networking options, automated backups, and SLA-backed support for mission-critical workloads.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
    <!-- Pricing Toggle -->
  
    <br>
    <!-- DOMAINS SECTION SATRT HERE -->
    <div class="banner-sub-sec w-100 float-left">
        <div class="container" style="margin-top:100px">
            <div class="banner-sub-outer-con wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
                  <div class="pricing-toggle wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
        <div class="container text-center">
            <div class="d-flex justify-content-center align-items-center">
                <span class="toggle-text monthly active">Monthly</span>
                <label class="toggle-switch">
                    <input type="checkbox" id="pricingToggle">
                    <span class="toggle-slider"></span>
                </label>
                <span class="toggle-text yearly">Yearly</span>
            </div>
        </div>
    </div> 
                <div class="dedicated-pricing-inner-con">
                    <?php if (!empty($cloud_plans)): ?>
                        <?php foreach ($cloud_plans as $plan): 
                            $monthly = floatval($plan['monthly_price']);
                            $yearly = floatval($plan['yearly_price']);
                        ?>
                        <div class="dedicated-price-box">
                            <div class="dedicated-plan-title">
                                <h5><?= htmlspecialchars($plan['plan_name']) ?></h5>
                            </div>
                            <div class="dedicated-price-con">
                                <div class="dedicated-category">
                                    <small class="d-block">Domains</small>
                                    <span class="d-block"><?= htmlspecialchars($plan['domains']) ?></span>
                                </div>
                                <div class="dedicated-category">
                                    <small class="d-block">Storage</small>
                                    <span class="d-block"><?= htmlspecialchars($plan['storage']) ?></span>
                                </div>
                                <div class="dedicated-category">
                                    <small class="d-block">Bandwidth</small>
                                    <span class="d-block"><?= htmlspecialchars($plan['bandwidth']) ?></span>
                                </div>
                                
                                <div class="hosting-price-box">
                                    <span class="dollar">₹</span>
                                    <span class="numeric1 plan-price" data-monthly="<?= number_format($monthly, 0) ?>" data-yearly="<?= number_format($yearly, 0) ?>"><?= number_format($monthly, 0) ?></span>
                                    <div class="month-title">
                                        <br>
                                        <small class="billing-period">/month</small>
                                    </div>
                                </div>
                            </div>
                            <div class="primary-btn">
                                <a href="#">CONFIGURE <i class="fas fa-arrow-right"></i></a>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <div class="col-12 text-center">
                            <p class="lead">No cloud hosting plans available at the moment. Please check back soon!</p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    <!-- DOMAIN SECTION END HERE -->
    
    <!-- Rest of the content remains the same -->
    <!-- DEDICATED FEATURES SECTION START HERE -->
    <section class="dedicated-features-con w-100 float-left p-100">
        <div class="container">
            <div class="generic-title text-center wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
                <h2>Cloud Hosting Features</h2>
                <p>Proactively architect cloud-native infrastructures that empower frictionless scalability and SLA-driven performance.</p>
            </div>
            <div class="dedicated-features-inner-con wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
                <div class="dedicated-features-box">
                    <figure>
                        <img src="<?= asset('images/reason-img1.png') ?>" alt="reason-img1">
                    </figure>
                    <h5>Turbocharged<br> Performance</h5>
                    <p>Fast doesn't mean risky. Every cloud plan includes DDoS protection, SSL certificates, daily backups, and real-time monitoring — so your site is always secure and running at peak performance.</p>
                </div>
                <div class="dedicated-features-box">
                    <figure>
                        <img src="<?= asset('images/reason-img2.png') ?>" alt="reason-img2">
                    </figure>
                    <h5>Redundant <br>Infrastructure</h5>
                    <p>Stay online and protected with redundant infrastructure that eliminates single points of failure. Our multi-layered system ensures maximum uptime, data integrity, and business continuity—no matter what.</p>
                </div>
                <div class="dedicated-features-box">
                    <figure>
                        <img src="<?= asset('images/reason-img3.png') ?>" alt="reason-img3">
                    </figure>
                    <h5>24/7 Technical <br>Support</h5>
                    <p>Round-the-clock technical support from real experts — available any time, every day. From quick fixes to complex issues, we’re here to keep your website stress-free and running strong.</p>
                </div>
                <div class="dedicated-features-box">
                    <figure>
                        <img src="<?= asset('images/reason-img4.png') ?>" alt="reason-img4">
                    </figure>
                    <h5>Easy Management Panel</h5>
                    <p>Simplify your hosting experience with an easy-to-use management panel. Control your websites, emails, domains, and backups effortlessly — all from one intuitive dashboard.</p>
                </div>
            </div>
        </div>
    </section>
    <!-- DEDICATED FEATURES SECTION END HERE -->
    <!-- SECURITY FEATURES SECTION START HERE -->
    <section class="dedicated-security-feature-main-con security-feature-main-con w-100 float-left padding-top padding-bottom bg-shape">
        <div class="container">
            <div class="security-feature-inner-con wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
                <div class="security-feature-left-con">
                    <h2>Compare Our Cloud Hosting Solutions</h2>
                    <p>Unlock unmatched performance, data security, and high availability with our cloud hosting — designed to support websites, apps, and businesses of all sizes.</p>
                    <div class="secondary-btn">
                        <a href="<?= BASE_URL ?>/about">GET STARTED <i class="fas fa-arrow-right"></i></a>
                    </div>
                </div>
                <div class="security-feature-video-outer-con">
                    <div class="security-feature-video-con">
                        <h5>Included in Cloud Hosting Plans</h5>
                    </div>
                    <div class="dedicated-security-features-list">
                        <ul class="list-unstyled mb-0">
                            <li>Free SSL Certificate</li>
                            <li>Automated Daily Cloud Backups</li>
                            <li>Free Domain, SSL & CDN</li>
                            <li>Unlimited Cloud Bandwidth</li>
                            <li>Upto 200 GB NVMe SSD Cloud</li>
                            <li>Optimized for Performance, Uptime & Scalability</li>
                        </ul>
                    </div>
                    <div class="security-shape1">
                        <figure class="mb-0">
                            <img src="<?= asset('images/security-feature-shape1.png') ?>" alt="security-feature-shape1">
                        </figure>
                    </div>
                    <div class="security-shape2">
                        <figure class="mb-0">
                            <img src="<?= asset('images/security-feature-shape2.png') ?>" alt="security-feature-shape2">
                        </figure>
                    </div>
                    <div class="security-shape3">
                        <figure class="mb-0">
                            <img src="<?= asset('images/security-feature-shape3.png') ?>" alt="security-feature-shape3">
                        </figure>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- SECURITY FEATURES SECTION END HERE -->
    <!-- FAQ SECTION START HERE -->
    <section class="faq-main-con w-100 float-left padding-bottom pt-100">
        <div class="container">
            <div class="generic-title text-center wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
                <h2>Frequently Asked Questions</h2>
                <p>Do you have any questions? We have your answers!</p>
            </div>
            <div class="faq-inner-con wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
                <div id="accordion1">
                    <div class="card">
                        <div class="card-header" id="headingOne">
                            <h5 class="mb-0">
                                <button class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapseOne" aria-expanded="false" aria-controls="collapseOne">
                                   What is a cloud hosting?
                                </button>
                            </h5>
                        </div>
                        <div id="collapseOne" class="collapse" aria-labelledby="headingOne" data-parent="#accordion1">
                            <div class="card-body">Cloud hosting is a type of web hosting that uses multiple connected servers (a cloud) to host your website. Instead of relying on just one physical server, your site uses resources from several servers — which makes it more reliable, flexible, and scalable.</div>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-header" id="headingTwo">
                            <h5 class="mb-0">
                                <button class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                    Who needs a Cloud hosting?
                                </button>
                            </h5>
                        </div>
                        <div id="collapseTwo" class="collapse" aria-labelledby="headingTwo" data-parent="#accordion1">
                            <div class="card-body">Cloud hosting is ideal for businesses or websites that need high reliability, fast performance, and flexibility. If your website gets a lot of traffic, grows quickly, or must stay online all the time — cloud hosting is the right choice.</div>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-header" id="headingThree">
                            <h5 class="mb-0">
                                <button class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                                    Why Cloud hosting is the best option?
                                </button>
                            </h5>
                        </div>
                        <div id="collapseThree" class="collapse" aria-labelledby="headingThree" data-parent="#accordion1">
                            <div class="card-body">Cloud hosting is the best option for websites that need high speed, reliability, and the ability to grow quickly. Since your website uses a network of servers instead of just one, it stays online even if one server fails — and can handle large traffic without slowing down.</div>
                        </div>
                    </div>
                </div>
                <div id="accordion2">
                    <div class="card">
                        <div class="card-header" id="headingfour">
                            <h5 class="mb-0">
                                <button class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapsefour" aria-expanded="false" aria-controls="collapsefour">
                                    What are the advantages of Cloud hosting?
                                </button>
                            </h5>
                        </div>
                        <div id="collapsefour" class="collapse" aria-labelledby="headingfour" data-parent="#accordion2">
                            <div class="card-body">Cloud hosting gives you speed, uptime, and flexibility — everything you need to grow your website without worrying about crashes or slowdowns.</div>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-header" id="headingfive">
                            <h5 class="mb-0">
                                <button class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapsefive" aria-expanded="false" aria-controls="collapsefive">
                                    How much does Cloud hosting cost?
                                </button>
                            </h5> 
                        </div>
                        <div id="collapsefive" class="collapse" aria-labelledby="headingfive" data-parent="#accordion2">
                            <div class="card-body">Cloud hosting costs vary depending on how many resources your website uses — like CPU, RAM, storage, and bandwidth.</div>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-header" id="headingsix">
                            <h5 class="mb-0">
                                <button class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapsesix" aria-expanded="false" aria-controls="collapsesix">
                                 Is cloud hosting secure for my business website?
                                </button>
                            </h5>
                        </div>
                        <div id="collapsesix" class="collapse" aria-labelledby="headingsix" data-parent="#accordion2">
                            <div class="card-body">Yes, cloud hosting is very secure for business websites — in fact, it's often more secure than traditional hosting. It includes multiple layers of protection like data encryption, firewalls, regular backups, and automatic failover systems. Your data is also stored across multiple servers, reducing the risk of total data loss.</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- FAQ SECTION END HERE -->
    <!-- FOOTER SECTION START HERE -->
    <?php require_once BASE_PATH . '/partial/footer.php'; ?>
    <!-- FOOTER SECTION END HERE -->
    <!-- Back-to-top removed -->

<!-- Include footer scripts -->
<?php 
// Add page-specific scripts if needed
$page_scripts = [];
require_once BASE_PATH . '/partial/footer_scripts.php'; 
?>
    
<script>
    $(document).ready(function() {
        // Pricing toggle functionality
        $('#pricingToggle').change(function() {
            if ($(this).is(':checked')) {
                // Switch to yearly pricing
                $('.monthly-price').hide();
                $('.yearly-price').show();
                $('.plan-price').each(function() {
                    $(this).text($(this).data('yearly'));
                });
                $('.numeric2').text('');
                $('.toggle-text.monthly').removeClass('active');
                $('.toggle-text.yearly').addClass('active');
                $('.billing-cycle, .billing-period').text('/year');
            } else {
                // Switch to monthly pricing
                $('.yearly-price').hide();
                $('.monthly-price').show();
                $('.plan-price').each(function() {
                    $(this).text($(this).data('monthly'));
                });
                $('.numeric2').text('.00');
                $('.toggle-text.yearly').removeClass('active');
                $('.toggle-text.monthly').addClass('active');
                $('.billing-cycle, .billing-period').text('/month');
            }
        });
    });
</script>
