<?php 
require_once __DIR__ . '/../config.php';

// Set page-specific variables
$page_title = 'Privacy Policy | WsplCloud - Web Hosting & Cloud Services';
$page_description = 'Our privacy policy outlines how we collect, use, and protect your personal information. Learn about your data rights when using our services.';
$page_keywords = 'privacy policy, data protection, personal information, data security, GDPR compliance, cookie policy';

// Set custom CSS for this page
$custom_css = ['breadcrumbs.css'];

// Include header meta (DOCTYPE, <head>, opening <body> tag)
require_once BASE_PATH . '/partial/header_meta.php';

// Include the navigation header
require_once BASE_PATH . '/partial/header.php';
?>
    <!-- BANNER SECTION START HERE -->
    <section class="sub-banner-main-con w-100 float-left">
        <div class="container">
            <div class="sub-banner-inner-con wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
               
                <h1>Privacy Policy</h1>
                  <span class="d-block position-relative"></span>
            <h6>
                <a href="<?= url('') ?>" style="color: #fff; transition: color 0.2s;" onmouseover="this.style.color='#FFD700'" onmouseout="this.style.color='#fff'">Home</a>
                <span style="color: #fff;"> / </span>
                <a href="<?= url('Policy') ?>" style="color: #fff; transition: color 0.2s;" onmouseover="this.style.color='#FFD700'" onmouseout="this.style.color='#fff'">Privacy Policy</a>
            </h6>
            </div>
        </div>
    </section>
    <!-- BANNER SECTION END HERE -->
    <!-- SUPPORT BOXES START -->
     <!-- PRIVACY POLICY START -->


  <!-- Header -->
   <div class="container">

<!-- Table of Contents -->
<div class="support-boxes-main-con w-100 float-left p-100">
    <div class="container">
        <div class="support-boxes-inner-con wow fadeInUp" data-wow-duration="1s" data-wow-delay="0.3s">
            
            <div class="support-box" 
                 onmouseover="this.querySelector('i').style.color='blue'" 
                 onmouseout="this.querySelector('i').style.color='white'">
                <figure class="mb-3">
                    <i class="fas fa-user-shield fa-2x" style="color:white;"></i>
                </figure>
                <span class="d-block">Personal information we collect</span>
            </div>

            <div class="support-box" 
                 onmouseover="this.querySelector('i').style.color='blue'" 
                 onmouseout="this.querySelector('i').style.color='white'">
                <figure class="mb-3">
                    <i class="fas fa-cogs fa-2x" style="color:white;"></i>
                </figure>
                <span class="d-block">Why do we process your data?</span>
            </div>

            <div class="support-box" 
                 onmouseover="this.querySelector('i').style.color='blue'" 
                 onmouseout="this.querySelector('i').style.color='white'">
                <figure class="mb-3">
                    <i class="fas fa-balance-scale fa-2x" style="color:white;"></i>
                </figure>
                <span class="d-block">Your rights</span>
            </div>

            <div class="support-box" 
                 onmouseover="this.querySelector('i').style.color='blue'" 
                 onmouseout="this.querySelector('i').style.color='white'">
                <figure class="mb-3">
                    <i class="fas fa-external-link-alt fa-2x" style="color:white;"></i>
                </figure>
                <span class="d-block">Links to other websites</span>
            </div>

            <div class="support-box" 
                 onmouseover="this.querySelector('i').style.color='blue'" 
                 onmouseout="this.querySelector('i').style.color='white'">
                <figure class="mb-3">
                    <i class="fas fa-lock fa-2x" style="color:white;"></i>
                </figure>
                <span class="d-block">Information security</span>
            </div>

            <div class="support-box" 
                 onmouseover="this.querySelector('i').style.color='blue'" 
                 onmouseout="this.querySelector('i').style.color='white'">
                <figure class="mb-3">
                    <i class="fas fa-gavel fa-2x" style="color:white;"></i>
                </figure>
                <span class="d-block">Legal disclosure</span>
            </div>

            <div class="support-box" 
                 onmouseover="this.querySelector('i').style.color='blue'" 
                 onmouseout="this.querySelector('i').style.color='white'">
                <figure class="mb-3">
                    <i class="fas fa-envelope fa-2x" style="color:white;"></i>
                </figure>
                <span class="d-block">Updates To This Policy</span>
            </div>

            <div class="support-box">
                <figure>
                    <img src="<?= asset('images/support-img4.png') ?>" alt="support-img4">
                </figure>
                <span class="d-block">Contact information</span>
            </div>
        </div>
    </div>
</div>

  <!-- Policy Sections -->
  <main class="row g-4">

    <div class="col-12">
      <div class="card border-0 shadow">
        <div class="card-body">
          <h5 id="info" class="fw-bold text-primary">1. Personal information we collect</h5>
          <p>
           When you visit the https://wsplcloud.com, we automatically collect certain information about your device, 
           including information about your web browser, IP address, time zone, and some of the installed cookies on your device.
            Additionally, as you browse the Site, we collect information about the individual web pages or products you view,
             what websites or search terms referred you to the Site, and how you interact with the Site. We refer to
              this automatically-collected information as “Device Information.” Moreover, we might collect the personal data 
              you provide to us (including but not limited to Name, Surname, Address, payment information, etc.) during registration 
              to be able to fulfill the agreement.
          </p>
        </div>
      </div>
    </div>

    <div class="col-12">
      <div class="card border-0 shadow">
        <div class="card-body">
          <h5 id="info-we-collect" class="fw-bold text-primary">2. Why do we process your data?</h5>
          <p>
            We may collect different data from or about you depending on how you use the Services. Below are some examples to help you
             better understand the data we collect.
          </p>
          <p>You can visit the website without telling us who you are or revealing any information, by which someone could identify you
             as a specific, identifiable individual. If, however, you wish to use some of the website’s features, or you wish to receive
              our newsletter or provide other details by filling a form, you may provide personal data to us, such as your email, first name,
               last name, city of residence, organization, telephone number. You can choose not to provide us with your personal data, but then
                you may not be able to take advantage of some of the website’s features. For example, you won’t be able to receive our Newsletter 
                or contact us directly from the website. Users who are uncertain about what information is mandatory are welcome to contact us 
                via support@wsplhosting.com.
          </p>
        </div>
      </div>
    </div>

    <div class="col-12">
      <div class="card border-0 shadow">
        <div class="card-body">
          <h5 id="how-we-use" class="fw-bold text-primary">3. Your rights</h5>
          <p>If you are a European resident, you have the following rights related to your personal data:</p>
          <ul class="mb-0">
            <li>The right to be informed</li>
            <li>The right of access</li>
            <li>The right to rectification</li>
            <li>The right to erasure</li>
            <li>The right to restrict processing</li>
            <li>The right to data portability</li>
            <li>The right to object</li>
            <li>Rights in relation to automated decision-making & profiling</li>
          </ul>
          <br>
          <p>If you would like to exercise this right, please contact us through the contact information below.</p>
          <p>Additionally, if you are a European resident, we note that we are processing your information in order to fulfill
             contracts we might have with you (for example, if you make an order through the Site), or otherwise to pursue our 
             legitimate business interests listed above. Additionally, please note that your information might be transferred outside of 
             Europe, including Canada and the United States.</p>
        </div>
      </div>
    </div>

    <div class="col-12">
      <div class="card border-0 shadow">
        <div class="card-body">
          <h5 id="legal-bases" class="fw-bold text-primary">4. Links to other websites</h5>
          <p>
           Our website may contain links to other websites that are not owned or controlled by us. Please be aware that we are not responsible 
           for such other websites or third parties' privacy practices. We encourage you to be aware when you leave our website and read the 
           privacy statements of each website that may collect personal information.
          </p>
        </div>
      </div>
    </div>

    <div class="col-12">
      <div class="card border-0 shadow">
        <div class="card-body">
          <h5 id="cookies" class="fw-bold text-primary">5. Information security</h5>
          <p>
           We secure information you provide on computer servers in a controlled, secure environment, protected from unauthorized access, use, 
           or disclosure. We keep reasonable administrative, technical, and physical safeguards to protect against unauthorized access, use, 
           modification, and personal data disclosure in its control and custody. However, no data transmission over the Internet or wireless 
           network can be guaranteed.
          </p>
        </div>
      </div>
    </div>

    <div class="col-12">
      <div class="card border-0 shadow">
        <div class="card-body">
          <h5 id="sharing" class="fw-bold text-primary">6. Legal disclosure</h5>
          <p>
            We will disclose any information we collect, use or receive if required or permitted by law, such as to comply with a subpoena 
            or similar legal process, and when we believe in good faith that disclosure is necessary to protect our rights, protect your 
            safety or the safety of others, investigate fraud, or respond to a government request.
          </p>
        </div>
      </div>
    </div>

    <div class="col-12">
      <div class="card border-0 shadow">
        <div class="card-body">
          <h5 id="retention" class="fw-bold text-primary">7. Contact information</h5>
          <p>
           If you would like to contact us to understand more about this Policy or wish to contact us concerning any matter relating to 
           individual rights and your Personal Information, you may send an email to 
            <strong>support@wsplhosting.com</strong>.
          </p>
        </div>
      </div>
    </div>

</div>
</div>
<br>
<!-- PRIVACY POLICY END -->

   <br><br>
    <!-- OUR TEAM SECTION END HERE -->
    <!-- FOOTER SECTION START HERE -->
<!-- Include footer -->
<?php require_once BASE_PATH . '/partial/footer.php'; ?>

<!-- Include footer scripts -->
<?php 
// Add page-specific scripts if needed
$page_scripts = [];
require_once BASE_PATH . '/partial/footer_scripts.php'; 
?>