<?php
/**
 * WsplCloud - Main Index File
 * 
 * This is the main entry point for the WsplCloud website.
 * It handles routing and loads the appropriate page templates.
 */

// Set SEO meta tags for the homepage
$page_title = 'WsplCloud: Leading Web Hosting & Cloud Services Provider';
$page_description = 'Discover affordable and reliable web hosting, cloud solutions, VPS, and domain registration from WsplCloud. Fast, secure, and 24/7 support.';
$page_keywords = 'web hosting, cloud hosting, VPS hosting, domain registration, affordable hosting, WsplCloud, SSD hosting, website builder, 24/7 support';

// Load configuration
require_once __DIR__ . '/config.php';

// Define routes
$routes = [
    '' => 'index',
    'home' => 'index',
    'about-us' => 'about',
    'contact-us' => 'contact',
    'hosting/shared' => 'shared-hosting',
    'hosting/vps' => 'vps',
    'hosting/cloud' => 'cloud-hosting',
    'hosting/wordpress' => 'wordpress',
    'hosting/reseller' => 'reseller',
    'privacy-policy' => 'Policy',
    'terms-of-service' => 'term',
    // Add more custom routes as needed
];

// Determine which page to load based on the current path
$path = $GLOBALS['current_path'];
$page = '404'; // Default to 404 page

// Remove file extension if present
$clean_path = preg_replace('/\.php$/', '', $path);

if (isset($routes[$clean_path])) {
    $page = $routes[$clean_path];
} elseif (file_exists(PAGES_PATH . DS . $clean_path . '.php')) {
    // Direct page request if a file exists for the clean path
    $page = $clean_path;
}

// Include appropriate page file
$page_file = PAGES_PATH . DS . $page . '.php';

if (file_exists($page_file)) {
    include $page_file;
} else {
    // Page not found - show 404 error
    http_response_code(404);
    include PAGES_PATH . DS . '404.php';
}
