<?php
/**
 * Admin Panel - Logout Script
 * Destroys the session and redirects to the login page.
 */

require_once __DIR__ . '/../config.php'; // Adjust path to config.php

// Start session if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Unset all of the session variables
$_SESSION = array();

// If it's desired to kill the session, also delete the session cookie.
// Note: This will destroy the session, and not just the session data!
if (ini_get("session.use_cookies")) {
    $params = session_get_cookie_params();
    setcookie(session_name(), '', time() - 42000,
        $params["path"], $params["domain"],
        $params["secure"], $params["httponly"]
    );
}

// Finally, destroy the session.
session_destroy();

// Redirect to the login page
header('Location: ' . (function_exists('url') ? url('admin/login.php') : SITE_ROOT . '/admin/login.php'));
exit;
?>
