<?php
// Ensure secure access and session start
if (!defined('SECURE_ACCESS')) {
    define('SECURE_ACCESS', true);
}
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Redirect to login if not authenticated
if (!isset($_SESSION['admin_user'])) {
    header('Location: ' . SITE_ROOT . '/admin/login.php');
    exit;
}

// Get current page for active sidebar link
$current_page = basename($_SERVER['PHP_SELF']);

// Load admin user profile from database
$admin_name = 'Admin';
$admin_email = '';
$admin_profile_image = '';
$admin_role = 'Administrator';

if (isset($_SESSION['admin_user']['id'])) {
    try {
        // Check if db.php is already loaded
        if (!isset($db) || !$db) {
            require_once __DIR__ . '/../db.php';
        }
        
        $user_id = $_SESSION['admin_user']['id'];
        $stmt_profile = $db->prepare("SELECT username, full_name, email, profile_image, role FROM users WHERE id = :id LIMIT 1");
        $stmt_profile->bindParam(':id', $user_id, PDO::PARAM_INT);
        $stmt_profile->execute();
        $profile_data = $stmt_profile->fetch(PDO::FETCH_ASSOC);
        
        if ($profile_data) {
            $admin_name = $profile_data['full_name'] ?: $profile_data['username'];
            $admin_email = $profile_data['email'] ?? '';
            $admin_profile_image = $profile_data['profile_image'] ?? '';
            $admin_role = $profile_data['role'] ?? 'Administrator';
            
            // Update session with fresh data
            $_SESSION['admin_user']['name'] = $admin_name;
            $_SESSION['admin_user']['email'] = $admin_email;
            $_SESSION['admin_user']['profile_image'] = $admin_profile_image;
            $_SESSION['admin_user']['role'] = $admin_role;
        }
    } catch (Exception $e) {
        error_log('Header profile load error: ' . $e->getMessage());
        // Fallback to session data if DB fails
        $admin_name = $_SESSION['admin_user']['name'] ?? 'Admin';
        $admin_email = $_SESSION['admin_user']['email'] ?? '';
        $admin_profile_image = $_SESSION['admin_user']['profile_image'] ?? '';
        $admin_role = $_SESSION['admin_user']['role'] ?? 'Administrator';
    }
} else {
    // Fallback to session data
    $admin_name = $_SESSION['admin_user']['name'] ?? 'Admin';
    $admin_email = $_SESSION['admin_user']['email'] ?? '';
    $admin_profile_image = $_SESSION['admin_user']['profile_image'] ?? '';
    $admin_role = $_SESSION['admin_user']['role'] ?? 'Administrator';
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Panel - <?php echo htmlspecialchars(SITE_NAME); ?> | <?php echo ucfirst(str_replace(['.php', '-'], ['', ' '], $current_page)); ?></title>
    
    <!-- Favicon -->
    <link rel="icon" type="image/png" href="<?php echo url('/assets/favicon_io/fav.png'); ?>">
    <link rel="apple-touch-icon" href="<?php echo url('/assets/favicon_io/fav.png'); ?>">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-T3c6CoIi6uLrA9TneNEoa7RxnatzjcDSCmG1MXxSR1GAsXEV/Dwwykc2MPK8M2HN" crossorigin="anonymous">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <!-- Admin Custom Styles -->
    <link rel="stylesheet" href="<?php echo url('/assets/css/admin-style.css'); ?>">
    
    <style>
        :root {
            --primary-color: #0000ff;
            --primary-dark: #0000cc;
            --secondary-color: #64748b;
            --success-color: #10b981;
            --warning-color: #f59e0b;
            --danger-color: #ef4444;
            --dark-color: #1e293b;
            --light-color: #f8fafc;
            --sidebar-width: 280px;
            --header-height: 70px;
            --border-radius: 12px;
            --shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
            --transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', sans-serif;
            background-color: #f1f5f9;
            color: #334155;
            line-height: 1.6;
            overflow-x: hidden;
        }

        /* Modern Header */
        .admin-header {
            background: linear-gradient(135deg, var(--primary-color), var(--primary-dark));
            height: var(--header-height);
            box-shadow: var(--shadow);
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            z-index: 1030;
            backdrop-filter: blur(10px);
        }

        .navbar-brand {
            font-weight: 700;
            font-size: 1.5rem;
            background: linear-gradient(45deg, #fff, #e2e8f0);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            transition: var(--transition);
        }

        .navbar-brand:hover {
            transform: translateY(-1px);
        }

        .admin-user-info {
            display: flex;
            align-items: center;
            gap: 12px;
            color: white;
        }

        .user-avatar {
            width: 40px;
            height: 40px;
            background: rgba(255, 255, 255, 0.2);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 600;
            border: 2px solid rgba(255, 255, 255, 0.3);
            transition: var(--transition);
        }

        .user-avatar:hover {
            background: rgba(255, 255, 255, 0.3);
            transform: scale(1.05);
        }

        .user-details {
            display: flex;
            flex-direction: column;
        }

        .user-name {
            font-weight: 600;
            font-size: 0.9rem;
        }

        .user-role {
            font-size: 0.75rem;
            opacity: 0.8;
        }

        /* Modern Sidebar */
        .admin-sidebar {
            width: var(--sidebar-width);
            background: white;
            position: fixed;
            left: 0;
            top: var(--header-height);
            height: calc(100vh - var(--header-height));
            overflow-y: auto;
            box-shadow: var(--shadow);
            z-index: 1020;
            transition: var(--transition);
        }

        .sidebar-header {
            padding: 1.5rem;
            border-bottom: 1px solid #e2e8f0;
            background: linear-gradient(135deg, #f8fafc, #f1f5f9);
        }

        .sidebar-title {
            font-weight: 700;
            color: var(--dark-color);
            font-size: 1.1rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .nav-group {
            margin-bottom: 1rem;
        }

        .nav-group-title {
            font-size: 0.75rem;
            font-weight: 600;
            text-transform: uppercase;
            color: var(--secondary-color);
            padding: 0.75rem 1.5rem;
            letter-spacing: 0.5px;
        }

        .nav-item {
            margin: 0.25rem 0.75rem;
        }

        .nav-link {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            padding: 0.75rem 1rem;
            color: var(--secondary-color);
            text-decoration: none;
            border-radius: var(--border-radius);
            transition: var(--transition);
            font-weight: 500;
            position: relative;
            overflow: hidden;
        }

        .nav-link::before {
            content: '';
            position: absolute;
            left: 0;
            top: 0;
            height: 100%;
            width: 3px;
            background: var(--primary-color);
            transform: scaleY(0);
            transition: var(--transition);
        }

        .nav-link:hover {
            color: var(--primary-color);
            background: #f8fafc;
            transform: translateX(5px);
        }

        .nav-link:hover::before {
            transform: scaleY(1);
        }

        .nav-link.active {
            color: var(--primary-color);
            background: linear-gradient(135deg, #eef2ff, #f0f9ff);
            font-weight: 600;
            box-shadow: 0 2px 8px rgba(99, 102, 241, 0.15);
        }

        .nav-link.active::before {
            transform: scaleY(1);
        }

        .nav-link i {
            width: 20px;
            text-align: center;
            font-size: 1.1rem;
        }

        .nav-badge {
            margin-left: auto;
            background: var(--primary-color);
            color: white;
            padding: 0.25rem 0.5rem;
            border-radius: 20px;
            font-size: 0.7rem;
            font-weight: 600;
        }

        /* Main Content Area */
        .main-content {
            margin-left: var(--sidebar-width);
            margin-top: var(--header-height);
            padding: 2rem;
            min-height: calc(100vh - var(--header-height));
            transition: var(--transition);
        }

        .page-header {
            display: flex;
            justify-content: between;
            align-items: center;
            margin-bottom: 2rem;
            padding-bottom: 1rem;
            border-bottom: 2px solid #e2e8f0;
        }

        .page-title {
            font-weight: 700;
            color: var(--dark-color);
            font-size: 2rem;
            background: linear-gradient(135deg, var(--primary-color), var(--primary-dark));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }

        .breadcrumb {
            background: transparent;
            padding: 0;
            margin: 0;
        }

        .breadcrumb-item a {
            color: var(--secondary-color);
            text-decoration: none;
            transition: var(--transition);
        }

        .breadcrumb-item a:hover {
            color: var(--primary-color);
        }

        /* Mobile Responsive */
        @media (max-width: 768px) {
            .admin-sidebar {
                transform: translateX(-100%);
            }

            .admin-sidebar.mobile-open {
                transform: translateX(0);
            }

            .main-content {
                margin-left: 0;
            }

            .sidebar-overlay {
                position: fixed;
                top: 0;
                left: 0;
                right: 0;
                bottom: 0;
                background: rgba(0, 0, 0, 0.5);
                z-index: 1019;
                display: none;
            }

            .sidebar-overlay.mobile-open {
                display: block;
            }
        }

        /* Custom Scrollbar */
        .admin-sidebar::-webkit-scrollbar {
            width: 6px;
        }

        .admin-sidebar::-webkit-scrollbar-track {
            background: #f1f1f1;
        }

        .admin-sidebar::-webkit-scrollbar-thumb {
            background: var(--primary-color);
            border-radius: 3px;
        }

        .admin-sidebar::-webkit-scrollbar-thumb:hover {
            background: var(--primary-dark);
        }

        /* Notification Badge */
        .notification-badge {
            position: absolute;
            top: -5px;
            right: -5px;
            background: var(--danger-color);
            color: white;
            border-radius: 50%;
            width: 18px;
            height: 18px;
            font-size: 0.7rem;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        /* Dropdown Menu */
        .dropdown-menu {
            border: none;
            box-shadow: var(--shadow);
            border-radius: var(--border-radius);
            padding: 0.5rem;
        }

        .dropdown-item {
            border-radius: 8px;
            padding: 0.75rem 1rem;
            transition: var(--transition);
        }

        .dropdown-item:hover {
            background: #f8fafc;
            color: var(--primary-color);
        }

        /* Mobile Menu Button */
        .mobile-menu-btn {
            background: rgba(255, 255, 255, 0.2);
            border: none;
            color: white;
            border-radius: var(--border-radius);
            padding: 0.5rem;
            transition: var(--transition);
        }

        .mobile-menu-btn:hover {
            background: rgba(255, 255, 255, 0.3);
        }
    </style>
</head>
<body>
    <!-- Header -->
    <header class="admin-header">
        <nav class="navbar navbar-expand-lg navbar-dark">
            <div class="container-fluid">
                <!-- Mobile Menu Button -->
                <button class="mobile-menu-btn d-md-none me-2" type="button" onclick="toggleSidebar()">
                    <i class="fas fa-bars"></i>
                </button>

                <!-- Brand -->
                <img src="<?php echo url('assets/images/WsplCloud.png'); ?>" alt="<?php echo htmlspecialchars(SITE_NAME); ?> Admin" style="height:40px; object-fit:contain;">

                <!-- User Menu -->
                <div class="navbar-nav ms-auto">
                    <div class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle d-flex align-items-center" href="#" role="button" data-bs-toggle="dropdown">
                            <div class="admin-user-info">
                                <div class="user-avatar">
                                    <?php if (!empty($admin_profile_image) && file_exists(dirname(__DIR__, 2) . '/' . $admin_profile_image)): ?>
                                        <img src="<?php echo url($admin_profile_image); ?>" alt="<?php echo htmlspecialchars($admin_name); ?>" style="width: 100%; height: 100%; object-fit: cover; border-radius: 50%;">
                                    <?php else: ?>
                                        <?php echo strtoupper(substr($admin_name, 0, 1)); ?>
                                    <?php endif; ?>
                                </div>
                                <div class="user-details d-none d-md-block">
                                    <span class="user-name"><?php echo htmlspecialchars($admin_name); ?></span>
                                    <span class="user-role"><?php echo htmlspecialchars($admin_role); ?></span>
                                </div>
                            </div>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-end">
                            <li>
                                <a class="dropdown-item" href="<?php echo url('/admin/profile.php'); ?>">
                                    <i class="fas fa-user me-2"></i>Profile
                                </a>
                            </li>
                            <li>
                                <a class="dropdown-item" href="<?php echo url('/'); ?>" target="_blank">
                                    <i class="fas fa-external-link-alt me-2"></i>View Site
                                </a>
                            </li>
                            <li><hr class="dropdown-divider"></li>
                            <li>
                                <a class="dropdown-item text-danger" href="<?php echo url('/admin/logout.php'); ?>">
                                    <i class="fas fa-sign-out-alt me-2"></i>Logout
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </nav>
    </header>

    <!-- Sidebar Overlay for Mobile -->
    <div class="sidebar-overlay" id="sidebarOverlay" onclick="toggleSidebar()"></div>

    <!-- Sidebar -->
    <aside class="admin-sidebar" id="adminSidebar">
        <div class="sidebar-header">
            <div class="sidebar-title">
                <i class="fas fa-th-large"></i>
                Navigation Menu
            </div>
        </div>

        <nav class="nav flex-column">
            <!-- Dashboard Group -->
            <div class="nav-group">
                <div class="nav-item">
                    <a class="nav-link <?php echo ($current_page === 'index.php' || $current_page === 'dashboard.php') ? 'active' : ''; ?>" href="<?php echo url('/admin/index.php'); ?>">
                        <i class="fas fa-home"></i>
                        Dashboard
                    </a>
                </div>
                <div class="nav-item">
                    <a class="nav-link <?php echo ($current_page === 'hero_banner.php') ? 'active' : ''; ?>" href="<?php echo url('/admin/hero_banner.php'); ?>">
                        <i class="fas fa-star"></i>
                        Hero Banner
                    </a>
                </div>
            </div>

            <!-- Content Management Group -->
            <div class="nav-group">
                <div class="nav-item">
                    <a class="nav-link <?php echo ($current_page === 'blogs.php') ? 'active' : ''; ?>" href="<?php echo url('/admin/blogs.php'); ?>">
                        <i class="fas fa-blog"></i>
                        Blog Posts
                    </a>
                </div>
                <div class="nav-item">
                    <a class="nav-link <?php echo ($current_page === 'offers.php') ? 'active' : ''; ?>" href="<?php echo url('/admin/offers.php'); ?>">
                        <i class="fas fa-tags"></i>
                        Offers
                    </a>
                </div>
            </div>

            <!-- Services Group -->
            <div class="nav-group">
                <div class="nav-item">
                    <a class="nav-link <?php echo ($current_page === 'domains.php') ? 'active' : ''; ?>" href="<?php echo url('/admin/domains.php'); ?>">
                        <i class="fas fa-globe"></i>
                        Domains
                    </a>
                </div>
                <div class="nav-item">
                    <a class="nav-link <?php echo ($current_page === 'hosting_plans.php') ? 'active' : ''; ?>" href="<?php echo url('/admin/hosting_plans.php'); ?>">
                        <i class="fas fa-server"></i>
                        Hosting Plans
                    </a>
                </div>
            </div>

            <!-- Communication Group -->
            <div class="nav-group">
                <div class="nav-item">
                    <a class="nav-link <?php echo ($current_page === 'contacts.php') ? 'active' : ''; ?>" href="<?php echo url('/admin/contacts.php'); ?>">
                        <i class="fas fa-envelope"></i>
                        Contact Requests
                    </a>
                </div>
                <div class="nav-item">
                    <a class="nav-link <?php echo ($current_page === 'newsletter.php') ? 'active' : ''; ?>" href="<?php echo url('/admin/newsletter.php'); ?>">
                        <i class="fas fa-paper-plane"></i>
                        Newsletter
                    </a>
                </div>
                <div class="nav-item">
                    <a class="nav-link <?php echo ($current_page === 'send_campaign.php') ? 'active' : ''; ?>" href="<?php echo url('/admin/send_campaign.php'); ?>">
                        <i class="fas fa-envelope-open-text"></i>
                        Send Campaign
                    </a>
                </div>
                <div class="nav-item">
                    <a class="nav-link <?php echo ($current_page === 'email_settings.php') ? 'active' : ''; ?>" href="<?php echo url('/admin/email_settings.php'); ?>">
                        <i class="fas fa-cogs"></i>
                        Email Settings
                    </a>
                </div>
            </div>

            <!-- User Management Group -->
            <div class="nav-group">
                <div class="nav-item">
                    <a class="nav-link <?php echo ($current_page === 'users.php') ? 'active' : ''; ?>" href="<?php echo url('/admin/users.php'); ?>">
                        <i class="fas fa-users"></i>
                        Users
                    </a>
                </div>
            </div>
        </nav>
    </aside>

    <!-- Main Content -->
    <main class="main-content" id="mainContent">
        <div class="page-header">
            <div>
                <h1 class="page-title">
                    <?php echo ucfirst(str_replace(['.php', '-'], ['', ' '], $current_page)); ?>
                </h1>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="<?php echo url('/admin'); ?>">Home</a></li>
                        <li class="breadcrumb-item active"><?php echo ucfirst(str_replace(['.php', '-'], ['', ' '], $current_page)); ?></li>
                    </ol>
                </nav>
            </div>
            <div class="page-actions">
                <!-- Page-specific actions can go here -->
            </div>
        </div>

        <script>
            // Mobile sidebar toggle
            function toggleSidebar() {
                const sidebar = document.getElementById('adminSidebar');
                const overlay = document.getElementById('sidebarOverlay');
                const mainContent = document.getElementById('mainContent');
                
                sidebar.classList.toggle('mobile-open');
                overlay.classList.toggle('mobile-open');
                
                if (window.innerWidth < 768) {
                    if (sidebar.classList.contains('mobile-open')) {
                        mainContent.style.marginLeft = '0';
                    } else {
                        mainContent.style.marginLeft = '0';
                    }
                }
            }

            // Auto-close sidebar on mobile when clicking a link
            document.querySelectorAll('.nav-link').forEach(link => {
                link.addEventListener('click', () => {
                    if (window.innerWidth < 768) {
                        toggleSidebar();
                    }
                });
            });

            // Close sidebar when pressing escape key
            document.addEventListener('keydown', (e) => {
                if (e.key === 'Escape') {
                    const sidebar = document.getElementById('adminSidebar');
                    if (sidebar.classList.contains('mobile-open')) {
                        toggleSidebar();
                    }
                }
            });
        </script>